/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.FakeTupleSource;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.proc.CreateCursorResultSetInstruction;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.proc.TestProcedureProcessor;
import org.teiid.query.processor.relational.DependentProcedureExecutionNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.unittest.FakeMetadataObject;
import org.teiid.query.unittest.FakeMetadataStore;
import org.teiid.query.util.CommandContext;

public class TestProcedureRelational {
    @Test
    public void testProcInExistsSubquery() throws Exception {
        String sql = "select pm1.g1.e1 from pm1.g1 where exists (select * from (EXEC pm1.vsp9(pm1.g1.e2 + 1)) x where x.e1 = pm1.g1.e1)";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcInSelectScalarSubquery() throws Exception {
        String sql = "select (EXEC pm1.vsp36(pm1.g1.e2)) from pm1.g1 where pm1.g1.e1 = 'a'";
        List[] expected = new List[]{Arrays.asList(new Integer(0)), Arrays.asList(new Integer(6)), Arrays.asList(new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsTable() {
        String sql = "select param1, param2, e1, e2 from pm1.vsp26 where param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList(new Integer(1), "a", "a", new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testAliasedProcAsTable() {
        String sql = "select param1, param2, e1, e2 from pm1.vsp26 as x where param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList(new Integer(1), "a", "a", new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testAliasedJoin() {
        String sql = "select x.param1, x.param2, y.param1, y.param2, x.e1 from pm1.vsp26 as x, pm1.vsp26 as y where x.param1=1 and x.param2='a' and y.param1 = 2 and y.param2 = 'b'";
        List[] expected = new List[]{Arrays.asList(new Integer(1), "a", new Integer(2), "b", "a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testAliasedJoin1() {
        String sql = "select x.param1, x.param2, y.param1, y.param2, x.e1 from pm1.vsp26 as x, pm1.vsp26 as y where x.param1=1 and x.param2='a' and y.param1 = x.param1 and y.param2 = x.param2";
        List[] expected = new List[]{Arrays.asList(new Integer(1), "a", new Integer(1), "a", "a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsTable1() {
        String sql = "select param1, param2, e1, e2 from pm1.vsp26 where param1=1";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(), null, false);
    }

    @Test
    public void testProcAsTable2() {
        String sql = "select param1, param2, e1, e2 from pm1.vsp26 where param1<1 and param2='a'";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(), null, false);
    }

    @Test
    public void testProcAsTable3() {
        String sql = "select param1, param2, e1, e2 from pm1.vsp26 where param1 in (1,2,3) and param2 in ('a', 'b') order by param1, param2";
        List[] expected = new List[]{Arrays.asList(new Integer(1), "a", "a", new Integer(3)), Arrays.asList(new Integer(1), "b", "b", new Integer(2)), Arrays.asList(new Integer(2), "a", "a", new Integer(3)), Arrays.asList(new Integer(2), "b", "b", new Integer(2)), Arrays.asList(new Integer(3), "a", "a", new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsTable4() {
        String sql = "select param1, param2, e1, e2 from pm1.vsp26 where param1=1 and not(param2 = 'a')";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(), null, false);
    }

    @Test
    public void testProcAsTable5() {
        String sql = "select param1, param2, e1, e2 from pm1.vsp26 where param1=e2 and param2 = 'a'";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(), null, false);
    }

    @Test
    public void testProcAsTableInJoin() {
        String sql = "select param1, param2, pm1.vsp26.e2 from pm1.vsp26, pm1.g1 where param1 = pm1.g1.e2 and param2 = pm1.g1.e1 order by param1, param2, e2";
        List[] expected = new List[]{Arrays.asList(new Integer(0), "a", new Integer(0)), Arrays.asList(new Integer(0), "a", new Integer(0)), Arrays.asList(new Integer(0), "a", new Integer(0)), Arrays.asList(new Integer(0), "a", new Integer(0)), Arrays.asList(new Integer(0), "a", new Integer(3)), Arrays.asList(new Integer(0), "a", new Integer(3)), Arrays.asList(new Integer(1), "c", new Integer(1)), Arrays.asList(new Integer(2), "b", new Integer(2)), Arrays.asList(new Integer(3), "a", new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsTableInSubquery() {
        String sql = "select param1, param2, pm1.vsp26.e2, (select count(e1) from pm1.vsp26 where param1 = 1 and param2 = 'a') x from pm1.vsp26, pm1.g1 where param1 = pm1.g1.e2 and param2 = pm1.g1.e1 order by param1, param2, e2";
        List[] expected = new List[]{Arrays.asList(new Integer(0), "a", new Integer(0), new Integer(1)), Arrays.asList(new Integer(0), "a", new Integer(0), new Integer(1)), Arrays.asList(new Integer(0), "a", new Integer(0), new Integer(1)), Arrays.asList(new Integer(0), "a", new Integer(0), new Integer(1)), Arrays.asList(new Integer(0), "a", new Integer(3), new Integer(1)), Arrays.asList(new Integer(0), "a", new Integer(3), new Integer(1)), Arrays.asList(new Integer(1), "c", new Integer(1), new Integer(1)), Arrays.asList(new Integer(2), "b", new Integer(2), new Integer(1)), Arrays.asList(new Integer(3), "a", new Integer(3), new Integer(1))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    private void helpTestProcRelational(String userQuery, String inputCriteria, String atomicQuery) {
        ProcessorPlan plan = TestOptimizer.helpPlan(userQuery, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), new String[0]);
        RelationalPlan rplan = (RelationalPlan)plan;
        RelationalNode root = rplan.getRootNode();
        while (root.getChildren() != null && !((root = root.getChildren()[0]) instanceof DependentProcedureExecutionNode)) {
        }
        DependentProcedureExecutionNode dep = (DependentProcedureExecutionNode)root;
        Assert.assertEquals((Object)inputCriteria, (Object)dep.getInputCriteria().toString());
        ProcedurePlan pp = (ProcedurePlan)dep.getProcessorPlan();
        CreateCursorResultSetInstruction ccrsi = (CreateCursorResultSetInstruction)pp.getOriginalProgram().getInstructionAt(0);
        plan = ccrsi.getCommand();
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
        TestOptimizer.checkAtomicQueries(new String[]{atomicQuery}, plan);
    }

    @Test
    public void testProcInVirtualGroup1() {
        String userQuery = "select e1 from pm1.vsp26 where param1=1 and param2='a'";
        String inputCriteria = "(pm1.vsp26.param1 = 1) AND (pm1.vsp26.param2 = 'a')";
        String atomicQuery = "SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0 WHERE (g_0.e2 >= pm1.vsp26.param1) AND (g_0.e1 = pm1.vsp26.param2)";
        this.helpTestProcRelational(userQuery, inputCriteria, atomicQuery);
    }

    @Test
    public void testCase3403() {
        String userQuery = "select e1 from pm1.vsp26 where param1=2 and param2='a' and 'x'='x'";
        String inputCriteria = "(pm1.vsp26.param1 = 2) AND (pm1.vsp26.param2 = 'a')";
        String atomicQuery = "SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0 WHERE (g_0.e2 >= pm1.vsp26.param1) AND (g_0.e1 = pm1.vsp26.param2)";
        this.helpTestProcRelational(userQuery, inputCriteria, atomicQuery);
    }

    @Test
    public void testCase3448() {
        String userQuery = "select e1 from pm1.vsp26 where (param1=1 and e2=2) and param2='a'";
        String inputCriteria = "(pm1.vsp26.param1 = 1) AND (pm1.vsp26.param2 = 'a')";
        String atomicQuery = "SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0 WHERE (g_0.e2 >= pm1.vsp26.param1) AND (g_0.e1 = pm1.vsp26.param2)";
        this.helpTestProcRelational(userQuery, inputCriteria, atomicQuery);
    }

    @Test
    public void testProcAsVirtualGroup2() {
        String sql = "select e1 from (SELECT * FROM pm1.vsp26 as P where P.e1='a') x where param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup3() {
        String sql = "select e1 from (SELECT * FROM pm1.vsp26 as P where P.e1='a') x where param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup4() {
        String sql = "SELECT P.e1 as ve3 FROM pm1.vsp26 as P, pm1.g2 where P.e1=g2.e1 and param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup5() {
        String sql = "select e1 from (SELECT * FROM pm1.vsp26 as P where P.e1='a') x where param1=1 and param2='a' and e1='a'";
        List[] expected = new List[]{Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup6() {
        String sql = "SELECT P.e1 as ve3 FROM pm1.vsp26 as P, vm1.g1 where P.e1=g1.e1 and param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup7() {
        String sql = "SELECT e1 FROM (SELECT p.e1, param1, param2 FROM pm1.vsp26 as P, vm1.g1 where P.e1=g1.e1) x where param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup10_Defect20164() {
        String sql = "select e1 from (SELECT * FROM pm1.vsp26 as P where P.e1='a') x where (param1=1 and param2='a') and e1='c'";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup8() {
        String sql = "SELECT P.e1 as ve3, P.e2 as ve4 FROM pm1.vsp26 as P where param1=1 and param2='a' and e2=3";
        List[] expected = new List[]{Arrays.asList("a", new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup9() {
        String sql = "SELECT P.e2 as ve3, P.e1 as ve4 FROM pm1.vsp47 as P where param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList(new Integer(1), "FOO")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    public void defer_testProcAsVirtualGroup9a() {
        String sql = "SELECT P.e2 as ve3, P.e1 as ve4 FROM pm1.vsp47 as P where param2='a'";
        List[] expected = new List[]{Arrays.asList(new Integer(2112), "a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    public void defer_testProcAsVirtualGroup9b() {
        String sql = "SELECT P.e2 as ve3, P.e1 as ve4 FROM pm1.vsp47 as P";
        List[] expected = new List[]{Arrays.asList(new Integer(2112), null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testParameterPassing() throws Exception {
        FakeMetadataObject v1 = FakeMetadataFactory.createVirtualModel("v1");
        FakeMetadataObject rs1 = FakeMetadataFactory.createResultSet("v1.rs1", v1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs1p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs1);
        QueryNode n1 = new QueryNode("v1.vp1", "CREATE VIRTUAL PROCEDURE BEGIN declare string VARIABLES.x = '1'; SELECT e1 FROM v1.vp2 where v1.vp2.in = VARIABLES.x; END");
        FakeMetadataObject vt1 = FakeMetadataFactory.createVirtualProcedure("v1.vp1", v1, Arrays.asList(rs1p1), n1);
        FakeMetadataObject p1 = FakeMetadataFactory.createParameter("v1.vp2.in", 2, 1, "string", null);
        QueryNode n2 = new QueryNode("v1.vp2", "CREATE VIRTUAL PROCEDURE BEGIN declare string VARIABLES.x; declare string VARIABLES.y; VARIABLES.x = '2'; VARIABLES.y = v1.vp2.in; select VARIABLES.y; end");
        FakeMetadataObject vt2 = FakeMetadataFactory.createVirtualProcedure("v1.vp2", v1, Arrays.asList(rs1p1, p1), n2);
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(v1);
        store.addObject(rs1);
        store.addObject(vt1);
        store.addObject(vt2);
        store.addObject(vt2);
        String sql = "select * from (exec v1.vp1()) foo";
        List[] expected = new List[]{Arrays.asList("1")};
        FakeMetadataFacade metadata = new FakeMetadataFacade(store);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, metadata);
        TestProcedureProcessor.helpTestProcess(plan, expected, new FakeDataManager(), (QueryMetadataInterface)metadata);
    }

    @Test
    public void testCase6395ProcAsVirtualGroup9() {
        String sql = "SELECT P.e2 as ve3, P.e1 as ve4 FROM pm1.vsp47 as P where param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList(new Integer(1), "FOO")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup2WithNull() throws Exception {
        String sql = "select e1 from (SELECT * FROM pm1.vsp26 as P where P.e1='a') x where param1=1 and param2 is null";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        try {
            ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
            TestProcessor.doProcess(plan, dataManager, expected, TestProcessor.createCommandContext());
            Assert.fail((String)"QueryPlannerException was expected.");
        }
        catch (QueryValidatorException e) {
            Assert.assertEquals((Object)"The procedure parameter is not nullable, but is set to null: pm1.vsp26.param2", (Object)e.getMessage());
        }
    }

    @Test
    public void testProcAsVirtualGroup2WithNull2() throws Exception {
        String sql = "select * from pm1.vsp47 where param1 is null and param2 is null";
        List[] expected = new List[]{Arrays.asList(null, new Integer(2112), null, null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup2WithNull3() throws Exception {
        String sql = "select e1 from (SELECT * FROM pm1.vsp26 as P where P.e1='a') x where param1=1 and param2 = commandpayload()";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testIssue119() throws Exception {
        FakeMetadataObject v1 = FakeMetadataFactory.createVirtualModel("v1");
        FakeMetadataObject pm1 = FakeMetadataFactory.createPhysicalModel("pm1");
        FakeMetadataObject in = FakeMetadataFactory.createParameter("v1.vp1.in1", 2, 1, "integer", null);
        FakeMetadataObject rs1 = FakeMetadataFactory.createResultSet("v1.vp1.rs1", v1, new String[]{"e1", "e2", "e3", "e4", "e5"}, new String[]{"integer", "integer", "integer", "integer", "integer"});
        FakeMetadataObject rs1p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs1);
        QueryNode n1 = new QueryNode("v1.vp1", "CREATE VIRTUAL PROCEDURE BEGIN SELECT vp1.in1 e1, x.in1 e2, x.e1 e3, y.in1 e4, y.e1 e5 FROM pm1.sp119 x, pm1.sp119 y where x.in1 = vp1.in1 and y.in1 = x.e1; END");
        FakeMetadataObject vt1 = FakeMetadataFactory.createVirtualProcedure("v1.vp1", v1, Arrays.asList(rs1p1, in), n1);
        FakeMetadataObject in1 = FakeMetadataFactory.createParameter("pm1.sp119.in1", 2, 1, "integer", null);
        FakeMetadataObject rs3 = FakeMetadataFactory.createResultSet("pm1.sp119.rs1", pm1, new String[]{"e1"}, new String[]{"integer"});
        FakeMetadataObject rs3p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs3);
        FakeMetadataObject sp1 = FakeMetadataFactory.createStoredProcedure("pm1.sp119", pm1, Arrays.asList(rs3p1, in1), "pm1.sp119");
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(pm1);
        store.addObject(v1);
        store.addObject(rs1);
        store.addObject(vt1);
        store.addObject(sp1);
        String sql = "select * from (exec v1.vp1(1)) foo order by e4, e5";
        List[] expected = new List[]{Arrays.asList(1, 1, 3, 3, 5), Arrays.asList(1, 1, 3, 3, 8), Arrays.asList(1, 1, 6, 6, 8), Arrays.asList(1, 1, 6, 6, 11)};
        FakeMetadataFacade metadata = new FakeMetadataFacade(store);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, metadata);
        HardcodedDataManager dataManager = new HardcodedDataManager(){

            @Override
            public TupleSource registerRequest(CommandContext context, Command command, String modelName, String connectorBindingId, int nodeID) throws TeiidComponentException {
                if (command instanceof StoredProcedure) {
                    StoredProcedure proc = (StoredProcedure)command;
                    List params = proc.getInputParameters();
                    Assert.assertEquals((long)1L, (long)params.size());
                    int value = (Integer)((Constant)((SPParameter)params.get(0)).getExpression()).getValue();
                    return new FakeTupleSource(command.getProjectedSymbols(), new List[]{Arrays.asList(value + 2), Arrays.asList(value + 5)});
                }
                return super.registerRequest(context, command, modelName, connectorBindingId, nodeID);
            }
        };
        TestProcedureProcessor.helpTestProcess(plan, expected, dataManager, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testProcRelationalWithNoInputs() {
        String sql = "select e1 from pm1.vsp2 order by e1 desc limit 1";
        List[] expected = new List[]{Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }
}

