/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.function.aggregate.AggregateFunction;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.FakeTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.FakeRelationalNode;
import org.teiid.query.processor.relational.GroupingNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SortingFilter;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.util.CommandContext;

public class TestGroupingNode {
    public static FakeTupleSource createTupleSource1() {
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
        symbols.add(new ElementSymbol("col1"));
        ((ElementSymbol)symbols.get(0)).setType(DataTypeManager.DefaultDataClasses.INTEGER);
        symbols.add(new ElementSymbol("col2"));
        ((ElementSymbol)symbols.get(1)).setType(DataTypeManager.DefaultDataClasses.INTEGER);
        List[] tuples = new List[]{Arrays.asList(new Integer(5), new Integer(3)), Arrays.asList(new Integer(2), new Integer(1)), Arrays.asList(new Integer(4), null), Arrays.asList(null, new Integer(3)), Arrays.asList(new Integer(0), new Integer(4)), Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(4), new Integer(2)), Arrays.asList(new Integer(6), new Integer(4)), Arrays.asList(new Integer(6), new Integer(3)), Arrays.asList(new Integer(3), new Integer(0)), Arrays.asList(new Integer(4), new Integer(3)), Arrays.asList(new Integer(2), new Integer(1)), Arrays.asList(new Integer(2), new Integer(1)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(null, null)};
        return new FakeTupleSource(symbols, tuples);
    }

    private void helpProcess(BufferManager mgr, GroupingNode node, CommandContext context, List[] expected, ProcessorDataManager dataMgr) throws TeiidComponentException, BlockedException, TeiidProcessingException {
        FakeTupleSource dataSource = TestGroupingNode.createTupleSource1();
        this.helpProcess(mgr, node, context, expected, dataSource, dataMgr);
    }

    private void helpProcess(BufferManager mgr, GroupingNode node, CommandContext context, List[] expected, FakeTupleSource dataSource, ProcessorDataManager dataMgr) throws TeiidComponentException, BlockedException, TeiidProcessingException {
        FakeRelationalNode dataNode = new FakeRelationalNode(0, dataSource, mgr.getProcessorBatchSize());
        dataNode.setElements(dataSource.getSchema());
        node.addChild((RelationalNode)dataNode);
        node.initialize(context, mgr, dataMgr);
        node.open();
        int currentRow = 1;
        while (true) {
            try {
                TupleBatch batch;
                do {
                    batch = node.nextBatch();
                    for (int row = currentRow; row <= batch.getEndRow(); ++row) {
                        List tuple = batch.getTuple(row);
                        Assert.assertEquals((String)("Rows don't match at " + row), (Object)expected[row - 1], (Object)tuple);
                    }
                    currentRow += batch.getRowCount();
                } while (!batch.getTerminationFlag());
            }
            catch (BlockedException e) {
                continue;
            }
            break;
        }
        Assert.assertEquals((long)expected.length, (long)(currentRow - 1));
    }

    @Test
    public void test1() throws Exception {
        BufferManager mgr = BufferManagerFactory.getStandaloneBufferManager();
        GroupingNode node = new GroupingNode(1);
        ArrayList<Object> outputElements = new ArrayList<Object>();
        ElementSymbol col1 = new ElementSymbol("col1");
        col1.setType(Integer.class);
        ElementSymbol col2 = new ElementSymbol("col2");
        col2.setType(Integer.class);
        outputElements.add(col1);
        outputElements.add(new AggregateSymbol("countAll", "COUNT", false, null));
        outputElements.add(new AggregateSymbol("count", "COUNT", false, (Expression)col2));
        outputElements.add(new AggregateSymbol("countDist", "COUNT", true, (Expression)col2));
        outputElements.add(new AggregateSymbol("sum", "SUM", false, (Expression)col2));
        outputElements.add(new AggregateSymbol("sumDist", "SUM", true, (Expression)col2));
        outputElements.add(new AggregateSymbol("avg", "AVG", false, (Expression)col2));
        outputElements.add(new AggregateSymbol("avgDist", "AVG", true, (Expression)col2));
        outputElements.add(new AggregateSymbol("min", "MIN", false, (Expression)col2));
        outputElements.add(new AggregateSymbol("minDist", "MIN", true, (Expression)col2));
        outputElements.add(new AggregateSymbol("max", "MAX", false, (Expression)col2));
        outputElements.add(new AggregateSymbol("maxDist", "MAX", true, (Expression)col2));
        node.setElements(outputElements);
        ArrayList<ElementSymbol> groupingElements = new ArrayList<ElementSymbol>();
        groupingElements.add(col1);
        node.setGroupingElements(groupingElements);
        CommandContext context = new CommandContext((Object)"pid", "test", null, null, 1);
        List[] expected = new List[]{Arrays.asList(null, new Integer(2), new Integer(1), new Integer(1), new Long(3L), new Long(3L), new Double(3.0), new Double(3.0), new Integer(3), new Integer(3), new Integer(3), new Integer(3)), Arrays.asList(new Integer(0), new Integer(1), new Integer(1), new Integer(1), new Long(4L), new Long(4L), new Double(4.0), new Double(4.0), new Integer(4), new Integer(4), new Integer(4), new Integer(4)), Arrays.asList(new Integer(1), new Integer(1), new Integer(1), new Integer(1), new Long(2L), new Long(2L), new Double(2.0), new Double(2.0), new Integer(2), new Integer(2), new Integer(2), new Integer(2)), Arrays.asList(new Integer(2), new Integer(4), new Integer(4), new Integer(2), new Long(5L), new Long(3L), new Double(1.25), new Double(1.5), new Integer(1), new Integer(1), new Integer(2), new Integer(2)), Arrays.asList(new Integer(3), new Integer(1), new Integer(1), new Integer(1), new Long(0L), new Long(0L), new Double(0.0), new Double(0.0), new Integer(0), new Integer(0), new Integer(0), new Integer(0)), Arrays.asList(new Integer(4), new Integer(3), new Integer(2), new Integer(2), new Long(5L), new Long(5L), new Double(2.5), new Double(2.5), new Integer(2), new Integer(2), new Integer(3), new Integer(3)), Arrays.asList(new Integer(5), new Integer(1), new Integer(1), new Integer(1), new Long(3L), new Long(3L), new Double(3.0), new Double(3.0), new Integer(3), new Integer(3), new Integer(3), new Integer(3)), Arrays.asList(new Integer(6), new Integer(2), new Integer(2), new Integer(2), new Long(7L), new Long(7L), new Double(3.5), new Double(3.5), new Integer(3), new Integer(3), new Integer(4), new Integer(4))};
        this.helpProcess(mgr, node, context, expected, null);
        AggregateFunction[] functions = node.getFunctions();
        AggregateFunction countDist = functions[5];
        SortingFilter dup = (SortingFilter)countDist;
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.INTEGER, (Object)((ElementSymbol)dup.getElements().get(0)).getType());
    }

    @Test
    public void test2() throws Exception {
        BufferManager mgr = BufferManagerFactory.getStandaloneBufferManager();
        GroupingNode node = this.getExampleGroupingNode();
        CommandContext context = new CommandContext((Object)"pid", "test", null, null, 1);
        List[] expected = new List[]{Arrays.asList(null, new Integer(1)), Arrays.asList(new Integer(0), new Integer(1)), Arrays.asList(new Integer(1), new Integer(1)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(3), new Integer(1)), Arrays.asList(new Integer(4), new Integer(2)), Arrays.asList(new Integer(5), new Integer(1)), Arrays.asList(new Integer(6), new Integer(2))};
        this.helpProcess(mgr, node, context, expected, null);
    }

    @Test
    public void test3() throws Exception {
        BufferManagerImpl mgr = BufferManagerFactory.createBufferManager();
        mgr.setProcessorBatchSize(5);
        GroupingNode node = this.getExampleGroupingNode();
        CommandContext context = new CommandContext((Object)"pid", "test", null, null, 1);
        List[] expected = new List[]{Arrays.asList(null, new Integer(1)), Arrays.asList(new Integer(0), new Integer(1)), Arrays.asList(new Integer(1), new Integer(1)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(3), new Integer(1)), Arrays.asList(new Integer(4), new Integer(2)), Arrays.asList(new Integer(5), new Integer(1)), Arrays.asList(new Integer(6), new Integer(2))};
        this.helpProcess((BufferManager)mgr, node, context, expected, null);
    }

    @Test
    public void testDefect5769() throws Exception {
        BufferManager mgr = BufferManagerFactory.getStandaloneBufferManager();
        ElementSymbol bigDecimal = new ElementSymbol("value");
        bigDecimal.setType(DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        GroupingNode node = new GroupingNode(1);
        ArrayList<AggregateSymbol> outputElements = new ArrayList<AggregateSymbol>();
        outputElements.add(new AggregateSymbol("bigSum", "SUM", false, (Expression)bigDecimal));
        outputElements.add(new AggregateSymbol("bigAvg", "AVG", false, (Expression)bigDecimal));
        node.setElements(outputElements);
        node.setGroupingElements(null);
        CommandContext context = new CommandContext((Object)"pid", "test", null, null, 1);
        List[] data = new List[]{Arrays.asList(new BigDecimal("0.0")), Arrays.asList(new BigDecimal("1.0")), Arrays.asList(new BigDecimal("2.0")), Arrays.asList(new BigDecimal("3.0")), Arrays.asList(new BigDecimal("4.0"))};
        List[] expected = new List[]{Arrays.asList(new BigDecimal("10.0"), new BigDecimal("2.000000000"))};
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
        symbols.add(bigDecimal);
        FakeTupleSource dataSource = new FakeTupleSource(symbols, data);
        this.helpProcess(mgr, node, context, expected, dataSource, null);
    }

    @Test
    public void testdefect9842() throws Exception {
        BufferManager mgr = BufferManagerFactory.getStandaloneBufferManager();
        ElementSymbol col1 = new ElementSymbol("col1");
        col1.setType(Integer.class);
        ElementSymbol bigDecimal = new ElementSymbol("value");
        bigDecimal.setType(DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        GroupingNode node = new GroupingNode(1);
        ArrayList<Object> outputElements = new ArrayList<Object>();
        outputElements.add(col1);
        outputElements.add(new AggregateSymbol("bigSum", "SUM", false, (Expression)bigDecimal));
        outputElements.add(new AggregateSymbol("bigAvg", "AVG", false, (Expression)bigDecimal));
        node.setElements(outputElements);
        ArrayList<ElementSymbol> groupingElements = new ArrayList<ElementSymbol>();
        groupingElements.add(col1);
        node.setGroupingElements(groupingElements);
        CommandContext context = new CommandContext((Object)"pid", "test", null, null, 1);
        List[] data = new List[]{Arrays.asList(new Integer(1), new BigDecimal("0.0")), Arrays.asList(new Integer(1), new BigDecimal("1.0")), Arrays.asList(new Integer(2), new BigDecimal("2.0")), Arrays.asList(new Integer(2), new BigDecimal("3.0")), Arrays.asList(new Integer(2), new BigDecimal("4.0"))};
        List[] expected = new List[]{Arrays.asList(new Integer(1), new BigDecimal("1.0"), new BigDecimal("0.500000000")), Arrays.asList(new Integer(2), new BigDecimal("9.0"), new BigDecimal("3.000000000"))};
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
        symbols.add(col1);
        symbols.add(bigDecimal);
        FakeTupleSource dataSource = new FakeTupleSource(symbols, data);
        this.helpProcess(mgr, node, context, expected, dataSource, null);
    }

    private void helpTestLookupFunctionInAggregate(int batchSize) throws Exception {
        BufferManagerImpl mgr = BufferManagerFactory.createBufferManager();
        mgr.setProcessorBatchSize(batchSize);
        GroupingNode node = new GroupingNode(1);
        ArrayList<Object> outputElements = new ArrayList<Object>();
        ElementSymbol col1 = new ElementSymbol("col1");
        col1.setType(Integer.class);
        ElementSymbol col2 = new ElementSymbol("col2");
        col2.setType(Integer.class);
        Function func = new Function("lookup", new Expression[]{new Constant((Object)"pm1.g1"), new Constant((Object)"e2"), new Constant((Object)"e1"), col2});
        FunctionDescriptor desc = SystemFunctionManager.getSystemFunctionLibrary().findFunction("lookup", new Class[]{String.class, String.class, String.class, Integer.class});
        func.setFunctionDescriptor(desc);
        func.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        outputElements.add(col1);
        outputElements.add(new AggregateSymbol("count", "COUNT", false, (Expression)func));
        outputElements.add(new AggregateSymbol("sum", "SUM", false, (Expression)func));
        outputElements.add(new AggregateSymbol("sumDist", "SUM", true, (Expression)func));
        node.setElements(outputElements);
        ArrayList<ElementSymbol> groupingElements = new ArrayList<ElementSymbol>();
        groupingElements.add(col1);
        node.setGroupingElements(groupingElements);
        CommandContext context = new CommandContext((Object)"pid", "test", null, null, 1);
        FakeDataManager dataMgr = new FakeDataManager();
        dataMgr.setThrowBlocked(true);
        HashMap<Integer, Integer> valueMap = new HashMap<Integer, Integer>();
        valueMap.put(new Integer(0), new Integer(1));
        valueMap.put(new Integer(1), new Integer(2));
        valueMap.put(new Integer(2), new Integer(3));
        valueMap.put(new Integer(3), new Integer(4));
        valueMap.put(new Integer(4), new Integer(5));
        dataMgr.defineCodeTable("pm1.g1", "e1", "e2", valueMap);
        List[] expected = new List[]{Arrays.asList(null, new Integer(1), new Long(4L), new Long(4L)), Arrays.asList(new Integer(0), new Integer(1), new Long(5L), new Long(5L)), Arrays.asList(new Integer(1), new Integer(1), new Long(3L), new Long(3L)), Arrays.asList(new Integer(2), new Integer(4), new Long(9L), new Long(5L)), Arrays.asList(new Integer(3), new Integer(1), new Long(1L), new Long(1L)), Arrays.asList(new Integer(4), new Integer(2), new Long(7L), new Long(7L)), Arrays.asList(new Integer(5), new Integer(1), new Long(4L), new Long(4L)), Arrays.asList(new Integer(6), new Integer(2), new Long(9L), new Long(9L))};
        this.helpProcess((BufferManager)mgr, node, context, expected, dataMgr);
    }

    public void helpTestEmptyGroup(boolean groupBy) throws Exception {
        BufferManager mgr = BufferManagerFactory.getStandaloneBufferManager();
        ElementSymbol col1 = new ElementSymbol("col1");
        col1.setType(Integer.class);
        ElementSymbol bigDecimal = new ElementSymbol("value");
        bigDecimal.setType(DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        GroupingNode node = new GroupingNode(1);
        ArrayList<AggregateSymbol> outputElements = new ArrayList<AggregateSymbol>();
        outputElements.add(new AggregateSymbol("bigSum", "SUM", false, (Expression)bigDecimal));
        outputElements.add(new AggregateSymbol("bigAvg", "AVG", false, (Expression)bigDecimal));
        node.setElements(outputElements);
        if (groupBy) {
            ArrayList<ElementSymbol> groupingElements = new ArrayList<ElementSymbol>();
            groupingElements.add(new ElementSymbol("col1"));
            node.setGroupingElements(groupingElements);
        }
        CommandContext context = new CommandContext((Object)"pid", "test", null, null, 1);
        List[] data = new List[]{};
        List[] expected = new List[]{Arrays.asList(null, null)};
        if (groupBy) {
            expected = new List[]{};
        }
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
        symbols.add(col1);
        symbols.add(bigDecimal);
        FakeTupleSource dataSource = new FakeTupleSource(symbols, data);
        this.helpProcess(mgr, node, context, expected, dataSource, null);
    }

    @Test
    public void testTestEmptyGroupWithoutGroupBy() throws Exception {
        this.helpTestEmptyGroup(false);
    }

    @Test
    public void testTestEmptyGroupWithGroupBy() throws Exception {
        this.helpTestEmptyGroup(true);
    }

    @Test
    public void testLookupFunctionMultipleBatches() throws Exception {
        this.helpTestLookupFunctionInAggregate(3);
    }

    @Test
    public void testDupSort() throws Exception {
        BufferManager mgr = BufferManagerFactory.getStandaloneBufferManager();
        GroupingNode node = this.getExampleGroupingNode();
        node.setRemoveDuplicates(true);
        CommandContext context = new CommandContext((Object)"pid", "test", null, null, 1);
        List[] expected = new List[]{Arrays.asList(null, new Integer(1)), Arrays.asList(new Integer(0), new Integer(1)), Arrays.asList(new Integer(1), new Integer(1)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(3), new Integer(1)), Arrays.asList(new Integer(4), new Integer(2)), Arrays.asList(new Integer(5), new Integer(1)), Arrays.asList(new Integer(6), new Integer(2))};
        this.helpProcess(mgr, node, context, expected, null);
    }

    private GroupingNode getExampleGroupingNode() {
        GroupingNode node = new GroupingNode(1);
        ArrayList<Object> outputElements = new ArrayList<Object>();
        ElementSymbol col1 = new ElementSymbol("col1");
        col1.setType(Integer.class);
        ElementSymbol col2 = new ElementSymbol("col2");
        col2.setType(Integer.class);
        outputElements.add(col1);
        outputElements.add(new AggregateSymbol("countDist", "COUNT", true, (Expression)col2));
        node.setElements(outputElements);
        ArrayList<ElementSymbol> groupingElements = new ArrayList<ElementSymbol>();
        groupingElements.add(col1);
        node.setGroupingElements(groupingElements);
        return node;
    }
}

