/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.BatchIterator;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.relational.FakeRelationalNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SelectNode;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.util.CommandContext;

public class TestSelectNode {
    public void helpTestSelect(List elements, Criteria criteria, List[] data, List childElements, ProcessorDataManager dataMgr, List[] expected) throws TeiidComponentException, TeiidProcessingException {
        this.helpTestSelect(elements, criteria, childElements, dataMgr, expected, new FakeRelationalNode(2, data));
    }

    public void helpTestSelect(List elements, Criteria criteria, List childElements, ProcessorDataManager dataMgr, List[] expected, RelationalNode child) throws TeiidComponentException, TeiidProcessingException {
        SelectNode selectNode = new SelectNode(1);
        this.helpTestSelect(elements, criteria, childElements, dataMgr, expected, child, selectNode);
    }

    private void helpTestSelect(List elements, Criteria criteria, List childElements, ProcessorDataManager dataMgr, List[] expected, RelationalNode child, SelectNode selectNode) throws TeiidComponentException, TeiidProcessingException {
        BufferManager mgr = BufferManagerFactory.getStandaloneBufferManager();
        CommandContext context = new CommandContext((Object)"pid", "test", null, null, 1);
        child.setElements(childElements);
        child.initialize(context, mgr, dataMgr);
        selectNode.setCriteria(criteria);
        selectNode.setElements(elements);
        selectNode.addChild(child);
        selectNode.initialize(context, mgr, dataMgr);
        selectNode.open();
        BatchIterator iterator = new BatchIterator((BatchCollector.BatchProducer)selectNode);
        block3: for (int i = 0; i < expected.length; ++i) {
            while (true) {
                try {
                    Assert.assertEquals((String)("Rows don't match at " + i), (Object)expected[i], (Object)iterator.nextTuple());
                    continue block3;
                }
                catch (BlockedException e) {
                    continue;
                }
                catch (QueryProcessor.ExpiredTimeSliceException e) {
                    continue;
                }
                break;
            }
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testEmptyBatchIndexing() throws TeiidComponentException, TeiidProcessingException {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(es1);
        CompareCriteria crit = new CompareCriteria((Expression)new Constant((Object)0), 1, (Expression)new Constant((Object)new Integer(1)));
        ArrayList<ElementSymbol> childElements = new ArrayList<ElementSymbol>();
        childElements.add(es1);
        RelationalNode child = new RelationalNode(0){
            int i;
            {
                this.i = 0;
            }

            public Object clone() {
                return null;
            }

            protected TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
                if (this.i++ == 0) {
                    return new TupleBatch(1, new List[]{Arrays.asList(1), Arrays.asList(1)});
                }
                TupleBatch batch = new TupleBatch(3, new List[0]);
                batch.setTerminationFlag(true);
                return batch;
            }
        };
        this.helpTestSelect(elements, (Criteria)crit, childElements, null, new List[0], child);
    }

    @Test
    public void testTimeslicing() throws TeiidComponentException, TeiidProcessingException {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(es1);
        CompareCriteria crit = new CompareCriteria((Expression)es1, 1, (Expression)new Constant((Object)new Integer(1)));
        List[] data = new List[]{Arrays.asList(1), Arrays.asList(1), Arrays.asList(1)};
        ArrayList<ElementSymbol> childElements = new ArrayList<ElementSymbol>();
        childElements.add(es1);
        this.helpTestSelect(elements, (Criteria)crit, childElements, null, data, new FakeRelationalNode(2, data), new SelectNode(3){
            int i;
            {
                this.i = 0;
            }

            protected Evaluator getEvaluator(Map elementMap) {
                if (this.i++ == 1) {
                    throw new QueryProcessor.ExpiredTimeSliceException();
                }
                return super.getEvaluator(elementMap);
            }
        });
    }

    @Test
    public void testNoRows() throws TeiidComponentException, TeiidProcessingException {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ElementSymbol es2 = new ElementSymbol("e2");
        es2.setType(DataTypeManager.DefaultDataClasses.STRING);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(es1);
        List[] data = new List[]{};
        CompareCriteria crit = new CompareCriteria((Expression)es1, 1, (Expression)new Constant((Object)new Integer(1)));
        ArrayList<ElementSymbol> childElements = new ArrayList<ElementSymbol>();
        childElements.add(es1);
        childElements.add(es2);
        this.helpTestSelect(elements, (Criteria)crit, data, childElements, null, data);
    }

    @Test
    public void testSimpleSelect() throws TeiidComponentException, TeiidProcessingException {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ElementSymbol es2 = new ElementSymbol("e2");
        es2.setType(DataTypeManager.DefaultDataClasses.STRING);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(es1);
        CompareCriteria crit = new CompareCriteria((Expression)es1, 1, (Expression)new Constant((Object)new Integer(1)));
        List[] data = new List[20];
        for (int i = 0; i < 20; ++i) {
            data[i] = new ArrayList();
            data[i].add(new Integer(i * 51 % 11));
            String str = "" + i * 3;
            str = str.substring(0, 1);
            data[i].add(str);
        }
        ArrayList<ElementSymbol> childElements = new ArrayList<ElementSymbol>();
        childElements.add(es1);
        childElements.add(es2);
        List[] expected = new List[]{Arrays.asList(new Integer(1)), Arrays.asList(new Integer(1))};
        this.helpTestSelect(elements, (Criteria)crit, data, childElements, null, expected);
    }

    @Test
    public void testSelectWithLookup() throws TeiidComponentException, TeiidProcessingException {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ElementSymbol es2 = new ElementSymbol("e2");
        es2.setType(DataTypeManager.DefaultDataClasses.STRING);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(es1);
        Function func = new Function("lookup", new Expression[]{new Constant((Object)"pm1.g1"), new Constant((Object)"e2"), new Constant((Object)"e1"), es1});
        FunctionDescriptor desc = SystemFunctionManager.getSystemFunctionLibrary().findFunction("lookup", new Class[]{String.class, String.class, String.class, Integer.class});
        func.setFunctionDescriptor(desc);
        func.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        CompareCriteria crit = new CompareCriteria((Expression)func, 1, (Expression)new Constant((Object)new Integer(1)));
        List[] data = new List[20];
        for (int i = 0; i < 20; ++i) {
            data[i] = new ArrayList();
            data[i].add(new Integer(i * 51 % 11));
            String str = "" + i * 3;
            str = str.substring(0, 1);
            data[i].add(str);
        }
        ArrayList<ElementSymbol> childElements = new ArrayList<ElementSymbol>();
        childElements.add(es1);
        childElements.add(es2);
        List[] expected = new List[]{Arrays.asList(new Integer(0)), Arrays.asList(new Integer(0))};
        FakeDataManager dataMgr = new FakeDataManager();
        dataMgr.setThrowBlocked(true);
        HashMap<Integer, Integer> valueMap = new HashMap<Integer, Integer>();
        valueMap.put(new Integer(0), new Integer(1));
        valueMap.put(new Integer(1), new Integer(2));
        dataMgr.defineCodeTable("pm1.g1", "e1", "e2", valueMap);
        this.helpTestSelect(elements, (Criteria)crit, data, childElements, dataMgr, expected);
    }
}

