/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.unittest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.types.DataTypeManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.FakeMetadataFactory;

public class RealMetadataFactory {
    private static TransformationMetadata CACHED_BQT = RealMetadataFactory.exampleBQT();

    private RealMetadataFactory() {
    }

    public static TransformationMetadata exampleBQTCached() {
        return CACHED_BQT;
    }

    public static TransformationMetadata exampleBQT() {
        MetadataStore metadataStore = new MetadataStore();
        Schema bqt1 = RealMetadataFactory.createPhysicalModel("BQT1", metadataStore);
        Schema bqt2 = RealMetadataFactory.createPhysicalModel("BQT2", metadataStore);
        Schema bqt3 = RealMetadataFactory.createPhysicalModel("BQT3", metadataStore);
        Schema lob = RealMetadataFactory.createPhysicalModel("LOB", metadataStore);
        Schema vqt = RealMetadataFactory.createVirtualModel("VQT", metadataStore);
        Schema bvqt = RealMetadataFactory.createVirtualModel("BQT_V", metadataStore);
        Schema bvqt2 = RealMetadataFactory.createVirtualModel("BQT2_V", metadataStore);
        Table bqt1SmallA = RealMetadataFactory.createPhysicalGroup("SmallA", bqt1);
        Table bqt1SmallB = RealMetadataFactory.createPhysicalGroup("SmallB", bqt1);
        Table bqt1MediumA = RealMetadataFactory.createPhysicalGroup("MediumA", bqt1);
        Table bqt1MediumB = RealMetadataFactory.createPhysicalGroup("MediumB", bqt1);
        Table bqt2SmallA = RealMetadataFactory.createPhysicalGroup("SmallA", bqt2);
        Table bqt2SmallB = RealMetadataFactory.createPhysicalGroup("SmallB", bqt2);
        Table bqt2MediumA = RealMetadataFactory.createPhysicalGroup("MediumA", bqt2);
        Table bqt2MediumB = RealMetadataFactory.createPhysicalGroup("MediumB", bqt2);
        Table bqt3SmallA = RealMetadataFactory.createPhysicalGroup("SmallA", bqt3);
        Table bqt3SmallB = RealMetadataFactory.createPhysicalGroup("SmallB", bqt3);
        Table bqt3MediumA = RealMetadataFactory.createPhysicalGroup("MediumA", bqt3);
        Table bqt3MediumB = RealMetadataFactory.createPhysicalGroup("MediumB", bqt3);
        Table lobTable = RealMetadataFactory.createPhysicalGroup("LobTbl", lob);
        Table library = RealMetadataFactory.createPhysicalGroup("LOB_TESTING_ONE", lob);
        RealMetadataFactory.createElements(library, new String[]{"CLOB_COLUMN", "BLOB_COLUMN", "KEY_EMULATOR"}, new String[]{"clob", "blob", "integer"});
        QueryNode vqtn1 = new QueryNode("VQT.SmallA", "SELECT * FROM BQT1.SmallA");
        Table vqtg1 = RealMetadataFactory.createUpdatableVirtualGroup("SmallA", vqt, vqtn1);
        QueryNode vqtn2 = new QueryNode("VQT.SmallB", "SELECT Concat(stringKey, stringNum) as a12345 FROM BQT1.SmallA");
        Table vqtg2 = RealMetadataFactory.createUpdatableVirtualGroup("SmallB", vqt, vqtn2);
        QueryNode vqtn2589 = new QueryNode("VQT.SmallA_2589", "SELECT * FROM BQT1.SmallA WHERE StringNum = '10'");
        Table vqtg2589 = RealMetadataFactory.createVirtualGroup("SmallA_2589", vqt, vqtn2589);
        QueryNode vqtn2589a = new QueryNode("VQT.SmallA_2589a", "SELECT BQT1.SmallA.* FROM BQT1.SmallA INNER JOIN BQT1.SmallB ON SmallA.IntKey = SmallB.IntKey WHERE SmallA.StringNum = '10'");
        Table vqtg2589a = RealMetadataFactory.createVirtualGroup("SmallA_2589a", vqt, vqtn2589a);
        QueryNode vqtn2589b = new QueryNode("VQT.SmallA_2589b", "SELECT BQT1.SmallA.* FROM BQT1.SmallA INNER JOIN BQT1.SmallB ON SmallA.StringKey = SmallB.StringKey WHERE SmallA.StringNum = '10'");
        Table vqtg2589b = RealMetadataFactory.createVirtualGroup("SmallA_2589b", vqt, vqtn2589b);
        QueryNode vqtn2589c = new QueryNode("VQT.SmallA_2589c", "SELECT BQT1.SmallA.* FROM BQT1.SmallA INNER JOIN BQT1.SmallB ON SmallA.StringKey = SmallB.StringKey WHERE concat(SmallA.StringNum, SmallB.StringNum) = '1010'");
        Table vqtg2589c = RealMetadataFactory.createVirtualGroup("SmallA_2589c", vqt, vqtn2589c);
        QueryNode vqtn2589d = new QueryNode("VQT.SmallA_2589d", "SELECT BQT1.SmallA.* FROM BQT1.SmallA INNER JOIN BQT1.SmallB ON SmallA.StringKey = SmallB.StringKey WHERE SmallA.StringNum = '10' AND SmallA.IntNum = 10");
        Table vqtg2589d = RealMetadataFactory.createVirtualGroup("SmallA_2589d", vqt, vqtn2589d);
        QueryNode vqtn2589f = new QueryNode("VQT.SmallA_2589f", "SELECT * FROM VQT.SmallA_2589");
        Table vqtg2589f = RealMetadataFactory.createVirtualGroup("SmallA_2589f", vqt, vqtn2589f);
        QueryNode vqtn2589g = new QueryNode("VQT.SmallA_2589g", "SELECT * FROM VQT.SmallA_2589b");
        Table vqtg2589g = RealMetadataFactory.createVirtualGroup("SmallA_2589g", vqt, vqtn2589g);
        QueryNode vqtn2589h = new QueryNode("VQT.SmallA_2589h", "SELECT VQT.SmallA_2589.* FROM VQT.SmallA_2589 INNER JOIN BQT1.SmallB ON VQT.SmallA_2589.StringKey = SmallB.StringKey");
        Table vqtg2589h = RealMetadataFactory.createVirtualGroup("SmallA_2589h", vqt, vqtn2589h);
        QueryNode vqtn2589i = new QueryNode("VQT.SmallA_2589i", "SELECT BQT1.SmallA.* FROM BQT1.SmallA INNER JOIN BQT1.SmallB ON SmallA.StringKey = SmallB.StringKey WHERE SmallA.StringNum = '10' AND SmallB.StringNum = '10'");
        Table vqtg2589i = RealMetadataFactory.createVirtualGroup("SmallA_2589i", vqt, vqtn2589i);
        QueryNode vqtn15355 = new QueryNode("VQT.Defect15355", "SELECT convert(IntKey, string) as StringKey, BigIntegerValue FROM BQT1.SmallA UNION SELECT StringKey, (SELECT BigIntegerValue FROM BQT3.SmallA WHERE BQT3.SmallA.BigIntegerValue = BQT2.SmallA.StringNum) FROM BQT2.SmallA");
        Table vqtg15355 = RealMetadataFactory.createVirtualGroup("Defect15355", vqt, vqtn15355);
        QueryNode vqtn15355a = new QueryNode("VQT.Defect15355a", "SELECT StringKey, StringNum, BigIntegerValue FROM BQT1.SmallA UNION SELECT StringKey, StringNum, (SELECT BigIntegerValue FROM BQT3.SmallA WHERE BQT3.SmallA.BigIntegerValue = BQT2.SmallA.StringNum) FROM BQT2.SmallA");
        Table vqtg15355a = RealMetadataFactory.createVirtualGroup("Defect15355a", vqt, vqtn15355a);
        QueryNode vqtn15355b = new QueryNode("VQT.Defect15355b", "SELECT convert(IntKey, string) as IntKey, BigIntegerValue FROM BQT1.SmallA UNION SELECT StringKey, (SELECT BigIntegerValue FROM BQT3.SmallA WHERE BQT3.SmallA.BigIntegerValue = BQT2.SmallA.StringNum) FROM BQT2.SmallA");
        Table vqtg15355b = RealMetadataFactory.createVirtualGroup("Defect15355b", vqt, vqtn15355b);
        QueryNode bvqtn1 = new QueryNode("BQT_V.BQT_V", "SELECT a.* FROM BQT1.SMALLA AS a WHERE a.INTNUM = (SELECT MIN(b.INTNUM) FROM BQT1.SMALLA AS b WHERE b.INTKEY = a.IntKey ) OPTION MAKEDEP a");
        Table bvqtg1 = RealMetadataFactory.createUpdatableVirtualGroup("BQT_V", bvqt, bvqtn1);
        QueryNode bvqt2n1 = new QueryNode("BQT2_V.BQT2_V", "SELECT BQT2.SmallA.* FROM BQT2.SmallA, BQT_V.BQT_V WHERE BQT2.SmallA.IntKey = BQT_V.BQT_V.IntKey");
        Table bvqt2g1 = RealMetadataFactory.createUpdatableVirtualGroup("BQT2_V", bvqt2, bvqt2n1);
        String[] elemNames = new String[]{"IntKey", "StringKey", "IntNum", "StringNum", "FloatNum", "LongNum", "DoubleNum", "ByteNum", "DateValue", "TimeValue", "TimestampValue", "BooleanValue", "CharValue", "ShortValue", "BigIntegerValue", "BigDecimalValue", "ObjectValue"};
        String[] elemTypes = new String[]{"integer", "string", "integer", "string", "float", "long", "double", "byte", "date", "time", "timestamp", "boolean", "char", "short", "biginteger", "bigdecimal", "object"};
        List<Column> bqt1SmallAe = RealMetadataFactory.createElements(bqt1SmallA, elemNames, elemTypes);
        bqt1SmallAe.get(1).setNativeType("char");
        RealMetadataFactory.createElements(bqt1SmallB, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt1MediumA, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt1MediumB, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt2SmallA, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt2SmallB, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt2MediumA, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt2MediumB, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt3SmallA, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt3SmallB, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt3MediumA, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt3MediumB, elemNames, elemTypes);
        RealMetadataFactory.createElements(lobTable, new String[]{"ClobValue"}, new String[]{"clob"});
        RealMetadataFactory.createElements(vqtg1, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2, new String[]{"a12345"}, new String[]{"string"});
        RealMetadataFactory.createElements(vqtg15355, new String[]{"StringKey", "BigIntegerValue"}, new String[]{"string", "biginteger"});
        RealMetadataFactory.createElements(vqtg15355a, new String[]{"StringKey", "StringNum", "BigIntegerValue"}, new String[]{"string", "string", "biginteger"});
        RealMetadataFactory.createElements(vqtg15355b, new String[]{"IntKey", "BigIntegerValue"}, new String[]{"string", "biginteger"});
        RealMetadataFactory.createElements(vqtg2589, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2589a, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2589b, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2589c, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2589d, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2589f, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2589g, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2589h, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2589i, elemNames, elemTypes);
        RealMetadataFactory.createElements(bvqtg1, elemNames, elemTypes);
        RealMetadataFactory.createElements(bvqt2g1, elemNames, elemTypes);
        Schema pm1 = RealMetadataFactory.createPhysicalModel("pm1", metadataStore);
        ProcedureParameter rs1p1 = RealMetadataFactory.createParameter("intkey", 1, "integer");
        ColumnSet<Procedure> rs1 = RealMetadataFactory.createResultSet("rs1", new String[]{"IntKey", "StringKey"}, new String[]{"integer", "string"});
        Procedure spTest5 = RealMetadataFactory.createStoredProcedure("spTest5", pm1, Arrays.asList(rs1p1), "spTest5");
        spTest5.setResultSet(rs1);
        Schema pm2 = RealMetadataFactory.createPhysicalModel("pm2", metadataStore);
        ProcedureParameter rs2p1 = RealMetadataFactory.createParameter("inkey", 1, "integer");
        ProcedureParameter rs2p2 = RealMetadataFactory.createParameter("outkey", 2, "integer");
        ColumnSet<Procedure> rs2 = RealMetadataFactory.createResultSet("rs2", new String[]{"IntKey", "StringKey"}, new String[]{"integer", "string"});
        Procedure spTest8 = RealMetadataFactory.createStoredProcedure("spTest8", pm2, Arrays.asList(rs2p1, rs2p2), "spTest8");
        spTest8.setResultSet(rs2);
        ProcedureParameter rs2p2a = RealMetadataFactory.createParameter("outkey", 2, "integer");
        ColumnSet<Procedure> rs2a = RealMetadataFactory.createResultSet("rs2", new String[]{"IntKey", "StringKey"}, new String[]{"integer", "string"});
        Procedure spTest8a = RealMetadataFactory.createStoredProcedure("spTest8a", pm2, Arrays.asList(rs2p2a), "spTest8a");
        spTest8a.setResultSet(rs2a);
        Schema pm4 = RealMetadataFactory.createPhysicalModel("pm4", metadataStore);
        ProcedureParameter rs4p1 = RealMetadataFactory.createParameter("inkey", 1, "integer");
        ProcedureParameter rs4p2 = RealMetadataFactory.createParameter("ret", 4, "integer");
        RealMetadataFactory.createStoredProcedure("spTest9", pm4, Arrays.asList(rs4p1, rs4p2), "spTest9");
        Schema pm3 = RealMetadataFactory.createPhysicalModel("pm3", metadataStore);
        ProcedureParameter rs3p1 = RealMetadataFactory.createParameter("inkey", 1, "integer");
        ProcedureParameter rs3p2 = RealMetadataFactory.createParameter("outkey", 3, "integer");
        ColumnSet<Procedure> rs3 = RealMetadataFactory.createResultSet("rs3", new String[]{"IntKey", "StringKey"}, new String[]{"integer", "string"});
        Procedure spTest11 = RealMetadataFactory.createStoredProcedure("spTest11", pm3, Arrays.asList(rs3p1, rs3p2), "spTest11");
        spTest11.setResultSet(rs3);
        Schema mmspTest1 = RealMetadataFactory.createVirtualModel("mmspTest1", metadataStore);
        ColumnSet<Procedure> vsprs1 = RealMetadataFactory.createResultSet("mmspTest1.vsprs1", new String[]{"StringKey"}, new String[]{"string"});
        QueryNode vspqn1 = new QueryNode("vsp1", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT intkey FROM bqt1.smallA) AS intKeyCursor BEGIN x= intKeyCursor.intkey - 1; END SELECT stringkey FROM bqt1.smalla where intkey=x; END");
        Procedure vsp1 = RealMetadataFactory.createVirtualProcedure("MMSP1", mmspTest1, null, vspqn1);
        vsp1.setResultSet(vsprs1);
        ColumnSet<Procedure> vsprs2 = RealMetadataFactory.createResultSet("mmspTest1.vsprs1", new String[]{"StringKey"}, new String[]{"string"});
        QueryNode vspqn2 = new QueryNode("vsp2", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT intkey FROM bqt1.smallA) AS intKeyCursor1 BEGIN LOOP ON (SELECT intkey FROM bqt1.smallB) AS intKeyCursor2 BEGIN x= intKeyCursor1.intkey - intKeyCursor2.intkey; END END SELECT stringkey FROM bqt1.smalla where intkey=x; END");
        Procedure vsp2 = RealMetadataFactory.createVirtualProcedure("MMSP2", mmspTest1, null, vspqn2);
        vsp2.setResultSet(vsprs2);
        ColumnSet<Procedure> vsprs3 = RealMetadataFactory.createResultSet("mmspTest1.vsprs1", new String[]{"StringKey"}, new String[]{"string"});
        QueryNode vspqn3 = new QueryNode("vsp3", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT intkey FROM bqt1.smallA) AS intKeyCursor BEGIN x= intKeyCursor.intkey - 1; if(x = 25) BEGIN BREAK; END ELSE BEGIN CONTINUE; END END SELECT stringkey FROM bqt1.smalla where intkey=x; END");
        Procedure vsp3 = RealMetadataFactory.createVirtualProcedure("MMSP3", mmspTest1, null, vspqn3);
        vsp3.setResultSet(vsprs3);
        ColumnSet<Procedure> vsprs4 = RealMetadataFactory.createResultSet("mmspTest1.vsprs1", new String[]{"StringKey"}, new String[]{"string"});
        QueryNode vspqn4 = new QueryNode("vsp4", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; x=0; WHILE(x < 50) BEGIN x= x + 1; if(x = 25) BEGIN BREAK; END ELSE BEGIN CONTINUE; END END SELECT stringkey FROM bqt1.smalla where intkey=x; END");
        Procedure vsp4 = RealMetadataFactory.createVirtualProcedure("MMSP4", mmspTest1, null, vspqn4);
        vsp4.setResultSet(vsprs4);
        ColumnSet<Procedure> vsprs5 = RealMetadataFactory.createResultSet("mmspTest1.vsprs1", new String[]{"StringKey"}, new String[]{"string"});
        ProcedureParameter vsp5p1 = RealMetadataFactory.createParameter("param1", 1, "string");
        QueryNode vspqn5 = new QueryNode("vsp5", "CREATE VIRTUAL PROCEDURE BEGIN SELECT 0; END");
        Procedure vsp5 = RealMetadataFactory.createVirtualProcedure("MMSP5", mmspTest1, Arrays.asList(vsp5p1), vspqn5);
        vsp5.setResultSet(vsprs5);
        ColumnSet<Procedure> vsprs6 = RealMetadataFactory.createResultSet("mmspTest1.vsprs1", new String[]{"StringKey"}, new String[]{"string"});
        ProcedureParameter vsp6p1 = RealMetadataFactory.createParameter("p1", 1, "string");
        QueryNode vspqn6 = new QueryNode("vsp6", "CREATE VIRTUAL PROCEDURE BEGIN SELECT 1; END");
        Procedure vsp6 = RealMetadataFactory.createVirtualProcedure("MMSP6", mmspTest1, Arrays.asList(vsp6p1), vspqn6);
        vsp6.setResultSet(vsprs6);
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "bqt");
    }

    private static TransformationMetadata createTransformationMetadata(MetadataStore metadataStore, String vdbName) {
        CompositeMetadataStore store = new CompositeMetadataStore(metadataStore);
        VDBMetaData vdbMetaData = new VDBMetaData();
        vdbMetaData.setName(vdbName);
        vdbMetaData.setVersion(1);
        for (Schema schema : metadataStore.getSchemas().values()) {
            vdbMetaData.addModel(FakeMetadataFactory.createModel(schema.getName(), schema.isPhysical()));
        }
        return new TransformationMetadata(vdbMetaData, store, null, null);
    }

    public static QueryMetadataInterface exampleMaterializedView() {
        MetadataStore metadataStore = new MetadataStore();
        Schema virtModel = RealMetadataFactory.createVirtualModel("MatView", metadataStore);
        Schema physModel = RealMetadataFactory.createPhysicalModel("MatTable", metadataStore);
        Schema physModel_virtSrc = RealMetadataFactory.createPhysicalModel("MatSrc", metadataStore);
        Table physTable = RealMetadataFactory.createPhysicalGroup("info", physModel);
        RealMetadataFactory.createElements(physTable, new String[]{"e1", "e2", "e3"}, new String[]{"string", "integer", "string"});
        Table physGroup = RealMetadataFactory.createPhysicalGroup("MatTable", physModel);
        RealMetadataFactory.createElements(physGroup, new String[]{"e1"}, new String[]{"string"});
        Table physGroupStage = RealMetadataFactory.createPhysicalGroup("MatStage", physModel);
        RealMetadataFactory.createElements(physGroupStage, new String[]{"e1"}, new String[]{"string"});
        Table physGroup1 = RealMetadataFactory.createPhysicalGroup("MatTable1", physModel);
        RealMetadataFactory.createElements(physGroup1, new String[]{"e1"}, new String[]{"string"});
        Table physGroupStage1 = RealMetadataFactory.createPhysicalGroup("MatStage1", physModel);
        RealMetadataFactory.createElements(physGroupStage, new String[]{"e1"}, new String[]{"string"});
        Table physGroup_virtSrc = RealMetadataFactory.createPhysicalGroup("MatSrc", physModel_virtSrc);
        RealMetadataFactory.createElements(physGroup_virtSrc, new String[]{"X"}, new String[]{"string"});
        QueryNode virtTrans = new QueryNode("MatView", "SELECT x as e1 FROM MatSrc.MatSrc");
        Table virtGroup = RealMetadataFactory.createVirtualGroup("MatView", virtModel, virtTrans);
        RealMetadataFactory.createElements(virtGroup, new String[]{"e1"}, new String[]{"string"});
        virtGroup.setMaterialized(true);
        virtGroup.setMaterializedTable(physGroup);
        virtGroup.setMaterializedStageTable(physGroupStage);
        QueryNode vTrans = new QueryNode("VGroup", "SELECT e1 FROM MatView.MatView option NOCACHE");
        Table vGroup = RealMetadataFactory.createVirtualGroup("VGroup", virtModel, vTrans);
        RealMetadataFactory.createElements(vGroup, new String[]{"e1"}, new String[]{"string"});
        QueryNode virtTrans1 = new QueryNode("MatView1", "SELECT e1 FROM MatView.MatView where e1 = 1");
        Table virtGroup1 = RealMetadataFactory.createVirtualGroup("MatView1", virtModel, virtTrans1);
        RealMetadataFactory.createElements(virtGroup1, new String[]{"e1"}, new String[]{"string"});
        virtGroup1.setMaterializedTable(physGroup1);
        virtGroup1.setMaterializedStageTable(physGroupStage1);
        QueryNode vTrans2 = new QueryNode("VGroup2", "SELECT x FROM matsrc");
        Table vGroup2 = RealMetadataFactory.createVirtualGroup("VGroup2", virtModel, vTrans2);
        vGroup2.setMaterialized(true);
        RealMetadataFactory.createElements(vGroup2, new String[]{"x"}, new String[]{"string"});
        QueryNode vTrans3 = new QueryNode("VGroup3", "SELECT x, 'z' || substring(x, 2) as y FROM matsrc");
        Table vGroup3 = RealMetadataFactory.createVirtualGroup("VGroup3", virtModel, vTrans3);
        vGroup3.setMaterialized(true);
        List<Column> vElements3 = RealMetadataFactory.createElements(vGroup3, new String[]{"x", "y"}, new String[]{"string", "string"});
        RealMetadataFactory.createKey("pk", vGroup3, vElements3.subList(0, 1));
        QueryNode vTrans4 = new QueryNode("VGroup4", "/*+ cache(ttl:100) */ SELECT x FROM matsrc");
        Table vGroup4 = RealMetadataFactory.createVirtualGroup("VGroup4", virtModel, vTrans4);
        vGroup4.setMaterialized(true);
        RealMetadataFactory.createElements(vGroup4, new String[]{"x"}, new String[]{"string"});
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "");
    }

    public static KeyRecord createKey(String name, Table group, List<Column> elements) {
        KeyRecord key = new KeyRecord(KeyRecord.Type.Primary);
        key.setName(name);
        for (Column column : elements) {
            key.addColumn(column);
        }
        group.setPrimaryKey(key);
        return key;
    }

    public static Schema createPhysicalModel(String name, MetadataStore metadataStore) {
        Schema schema = new Schema();
        schema.setName(name);
        metadataStore.addSchema(schema);
        return schema;
    }

    public static Schema createVirtualModel(String name, MetadataStore metadataStore) {
        Schema schema = new Schema();
        schema.setName(name);
        schema.setPhysical(false);
        metadataStore.addSchema(schema);
        return schema;
    }

    public static Table createPhysicalGroup(String name, Schema model, boolean fullyQualify) {
        Table table = new Table();
        table.setName(name);
        model.addTable(table);
        table.setSupportsUpdate(true);
        table.setNameInSource(fullyQualify || name.lastIndexOf(".") == -1 ? name : name.substring(name.lastIndexOf(".") + 1));
        return table;
    }

    public static Table createPhysicalGroup(String name, Schema model) {
        return RealMetadataFactory.createPhysicalGroup(name, model, false);
    }

    public static Table createVirtualGroup(String name, Schema model, QueryNode plan) {
        Table table = new Table();
        table.setName(name);
        model.addTable(table);
        table.setVirtual(true);
        table.setSelectTransformation(plan.getQuery());
        return table;
    }

    public static Table createUpdatableVirtualGroup(String name, Schema model, QueryNode plan) {
        return RealMetadataFactory.createUpdatableVirtualGroup(name, model, plan, null);
    }

    public static Table createUpdatableVirtualGroup(String name, Schema model, QueryNode plan, String updatePlan) {
        Table table = RealMetadataFactory.createVirtualGroup(name, model, plan);
        table.setUpdatePlan(updatePlan);
        table.setSupportsUpdate(true);
        return table;
    }

    public static Column createElement(String name, ColumnSet<?> group, String type) {
        Column column = new Column();
        column.setName(name);
        group.addColumn(column);
        column.setRuntimeType(type);
        if (type.equals("string")) {
            column.setSearchType(Column.SearchType.Searchable);
        } else if (DataTypeManager.isNonComparable((String)type)) {
            column.setSearchType(Column.SearchType.Unsearchable);
        } else {
            column.setSearchType(Column.SearchType.All_Except_Like);
        }
        column.setNullType(BaseColumn.NullType.Nullable);
        column.setPosition(group.getColumns().size());
        column.setUpdatable(true);
        column.setLength(100);
        column.setNameInSource(name);
        return column;
    }

    public static List<Column> createElements(ColumnSet<?> group, String[] names, String[] types) {
        return RealMetadataFactory.createElementsWithDefaults(group, names, types, new String[names.length]);
    }

    public static List<Column> createElementsWithDefaults(ColumnSet<?> group, String[] names, String[] types, String[] defaults) {
        ArrayList<Column> elements = new ArrayList<Column>();
        for (int i = 0; i < names.length; ++i) {
            Column element = RealMetadataFactory.createElement(names[i], group, types[i]);
            element.setDefaultValue(defaults[i]);
            elements.add(element);
        }
        return elements;
    }

    public static ProcedureParameter createParameter(String name, int direction, String type) {
        ProcedureParameter param = new ProcedureParameter();
        param.setName(name);
        switch (direction) {
            case 1: {
                param.setType(ProcedureParameter.Type.In);
                break;
            }
            case 3: {
                param.setType(ProcedureParameter.Type.InOut);
                break;
            }
            case 2: {
                param.setType(ProcedureParameter.Type.Out);
                break;
            }
            case 5: {
                throw new AssertionError((Object)"should not directly create a resultset param");
            }
            case 4: {
                param.setType(ProcedureParameter.Type.ReturnValue);
            }
        }
        param.setRuntimeType(type);
        return param;
    }

    public static Procedure createStoredProcedure(String name, Schema model, List<ProcedureParameter> params, String callableName) {
        Procedure proc = new Procedure();
        proc.setName(name);
        if (params != null) {
            int index = 1;
            for (ProcedureParameter procedureParameter : params) {
                procedureParameter.setProcedure(proc);
                procedureParameter.setPosition(index++);
            }
            proc.setParameters(params);
        }
        model.addProcedure(proc);
        return proc;
    }

    public static Procedure createVirtualProcedure(String name, Schema model, List<ProcedureParameter> params, QueryNode queryPlan) {
        Procedure proc = RealMetadataFactory.createStoredProcedure(name, model, params, null);
        proc.setVirtual(true);
        proc.setQueryPlan(queryPlan.getQuery());
        return proc;
    }

    public static ColumnSet<Procedure> createResultSet(String name, String[] colNames, String[] colTypes) {
        ColumnSet rs = new ColumnSet();
        rs.setName(name);
        for (Column column : RealMetadataFactory.createElements(rs, colNames, colTypes)) {
            column.setParent(rs);
        }
        return rs;
    }
}

