/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.ApplicationInfo;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.DatabaseMetaDataImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.util.ResultSetUtil;

public class TestMMDatabaseMetaData {
    private static final boolean REPLACE_EXPECTED = false;
    private static final boolean WRITE_ACTUAL_RESULTS_TO_FILE = false;
    private static final boolean PRINT_RESULTSETS_TO_CONSOLE = false;
    private static final int MAX_COL_WIDTH = 65;
    static Connection conn = null;
    DatabaseMetaData dbmd;
    private Map expectedMap = new HashMap();
    private static final int NO_LIMIT = 0;
    private static final int ResultSet_HOLD_CURSORS_OVER_COMMIT = 1;
    private static final int ResultSet_CLOSE_CURSORS_AT_COMMIT = 2;

    public static void compareResultSet(ResultSet ... rs) throws IOException, SQLException {
        StackTraceElement ste = new Exception().getStackTrace()[1];
        String testName = ste.getMethodName();
        String className = ste.getClassName();
        className = className.substring(className.lastIndexOf(46) + 1);
        testName = className + "/" + testName;
        TestMMDatabaseMetaData.compareResultSet(testName, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compareResultSet(String testName, ResultSet ... rs) throws FileNotFoundException, SQLException, IOException {
        FileOutputStream actualOut = null;
        BufferedReader expectedIn = null;
        PrintStream stream = null;
        try {
            File expected = new File(UnitTestUtil.getTestDataPath() + "/" + testName + ".expected");
            expectedIn = new BufferedReader(new FileReader(expected));
            PrintStream defaultStream = null;
            stream = ResultSetUtil.getPrintStream((OutputStream)actualOut, (BufferedReader)expectedIn, defaultStream);
            for (int i = 0; i < rs.length; ++i) {
                ResultSetUtil.printResultSet((ResultSet)rs[i], (int)65, (boolean)true, (PrintStream)stream);
            }
            Assert.assertEquals((String)"Actual data did not match expected", (Object)Collections.EMPTY_LIST, (Object)ResultSetUtil.getUnequalLines((PrintStream)stream));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (actualOut != null) {
                actualOut.close();
            }
            if (expectedIn != null) {
                expectedIn.close();
            }
        }
    }

    @Before
    public void setUp() throws Exception {
        this.dbmd = new DatabaseMetaDataImpl((ConnectionImpl)conn);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        if (conn != null) {
            conn.close();
        }
    }

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        FakeServer server = new FakeServer();
        server.deployVDB("QT_Ora9DS", UnitTestUtil.getTestDataPath() + "/QT_Ora9DS_1.vdb");
        conn = server.createConnection("jdbc:teiid:QT_Ora9DS");
    }

    @Test
    public void testMethodsWithoutParams() throws Exception {
        Class<?> dbmdClass = this.dbmd.getClass();
        Method[] methods = dbmdClass.getDeclaredMethods();
        this.expectedMap = this.getExpected();
        for (int i = 0; i < methods.length; ++i) {
            if (!this.expectedMap.containsKey(methods[i].getName())) continue;
            Object actualValue = null;
            Object expectedValue = null;
            Object expectedReturn = this.expectedMap.get(methods[i].getName());
            Object[] params = null;
            if (expectedReturn instanceof List) {
                List returned = (List)expectedReturn;
                params = (Object[])returned.get(1);
                expectedValue = returned.get(0);
                actualValue = methods[i].invoke((Object)this.dbmd, params);
            } else {
                expectedValue = expectedReturn;
                actualValue = methods[i].invoke((Object)this.dbmd, new Object[0]);
            }
            Assert.assertEquals((String)(" Expected doesn't match with actual for method - " + methods[i].getName()), expectedValue, (Object)actualValue);
        }
    }

    @Test
    public void testMethodsWithExceptions() throws Exception {
        Class<?> dbmdClass = this.dbmd.getClass();
        Method[] methods = dbmdClass.getDeclaredMethods();
        this.expectedMap = new HashMap();
        for (int i = 0; i < methods.length; ++i) {
            if (!this.expectedMap.containsKey(methods[i].getName())) continue;
            methods[i].invoke((Object)this.dbmd, new Object[0]);
        }
    }

    @Test
    public void testSupportResultSetConcurrency() throws Exception {
        boolean returned = true;
        String functionName = "supportResultSetConcurrency";
        Object[] params = new Object[]{new Integer(1003), new Integer(1007)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004), new Integer(1007)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004), new Integer(1008)};
        returned = false;
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1003), new Integer(1008)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testSupportResultSetHoldability() throws Exception {
        boolean returned = false;
        String functionName = "supportResultSetHoldability";
        Object[] params = new Object[]{new Integer(1)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(2)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testSupportResultSetType() throws Exception {
        boolean returned = true;
        String functionName = "supportResultSetType";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        returned = false;
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testSupportsTransactionIsolationLevel() throws Exception {
        boolean returned = false;
        String functionName = "supportsTransactionIsolationLevel";
        Object[] params = new Object[]{new Integer(1)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testDeletesAreDetected() throws Exception {
        boolean returned = false;
        String functionName = "deletesAreDetected";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testInsertsAreDetected() throws Exception {
        boolean returned = false;
        String functionName = "insertsAreDetected";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testUpdatesAreDetected() throws Exception {
        boolean returned = false;
        String functionName = "updatesAreDetected";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testOwnUpdatesAreVisible() throws Exception {
        boolean returned = false;
        String functionName = "ownUpdatesAreVisible";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testOwnInsertsAreVisible() throws Exception {
        boolean returned = false;
        String functionName = "ownInsertsAreVisible";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testOthersUpdatesAreVisible() throws Exception {
        boolean returned = false;
        String functionName = "othersUpdatesAreVisible";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testOthersInsertsAreVisible() throws Exception {
        boolean returned = false;
        String functionName = "othersInsertsAreVisible";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testOthersDeletesAreVisible() throws Exception {
        boolean returned = false;
        String functionName = "othersDeletesAreVisible";
        Object[] params = new Object[]{new Integer(1003)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1004)};
        this.helpTestMethodsWithParams(functionName, returned, params);
        params = new Object[]{new Integer(1005)};
        this.helpTestMethodsWithParams(functionName, returned, params);
    }

    @Test
    public void testSupportsConvert1() throws Exception {
        Assert.assertEquals((String)"Expected doesn't match with actual for method - supportsConvert()", (Object)true, (Object)this.dbmd.supportsConvert());
    }

    @Test
    public void testSupportsConvert2() throws Exception {
        this.helpTestSupportsConverts(1, 1, true);
        this.helpTestSupportsConverts(1, 12, true);
        this.helpTestSupportsConverts(1, -1, true);
        this.helpTestSupportsConverts(1, -7, true);
        this.helpTestSupportsConverts(1, 5, true);
        this.helpTestSupportsConverts(1, -6, true);
        this.helpTestSupportsConverts(1, 4, true);
        this.helpTestSupportsConverts(1, -5, true);
        this.helpTestSupportsConverts(1, 6, true);
        this.helpTestSupportsConverts(1, 7, true);
        this.helpTestSupportsConverts(1, 8, true);
        this.helpTestSupportsConverts(1, 2, true);
        this.helpTestSupportsConverts(1, 3, true);
        this.helpTestSupportsConverts(1, 91, true);
        this.helpTestSupportsConverts(1, 92, true);
        this.helpTestSupportsConverts(1, 93, true);
        this.helpTestSupportsConverts(91, 4, false);
        this.helpTestSupportsConverts(1, -5, true);
        this.helpTestSupportsConverts(1, 6, true);
        this.helpTestSupportsConverts(1, 7, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUcaseMatchReturnsRows() throws Exception {
        ResultSet rs = null;
        try {
            Statement stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT Name FROM SYS.Tables WHERE UCASE(SchemaName) = 'SYS'");
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            Assert.assertEquals((long)12L, (long)count);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    @Test
    public void testGetColumnsSingleMatch() throws Exception {
        ResultSet rs = this.dbmd.getColumns(null, "System", "VirtualDatabases", "Name");
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetCatalogs() throws Exception {
        TestMMDatabaseMetaData.compareResultSet(this.dbmd.getCatalogs());
    }

    @Test
    public void testGetCrossReference() throws Exception {
        ResultSet rs = this.dbmd.getCrossReference(null, "BQT1", "SmallA", null, "BQT1", "SmallB");
        ResultSet rs1 = this.dbmd.getCrossReference(null, "Foo%", "%", null, null, "%");
        ResultSet rs2 = this.dbmd.getCrossReference("foo", "Foo%", "%", null, null, "%");
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetImportedKeys() throws Exception {
        ResultSet rs = this.dbmd.getImportedKeys(null, "BQT1", "SmallA");
        ResultSet rs1 = this.dbmd.getImportedKeys(null, "Foo%", "%");
        ResultSet rs2 = this.dbmd.getImportedKeys("foo", "Foo%", "%");
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetExportedKeys() throws Exception {
        ResultSet rs = this.dbmd.getExportedKeys(null, "BQT1", "SmallA");
        ResultSet rs1 = this.dbmd.getExportedKeys(null, "Foo%", "%");
        ResultSet rs2 = this.dbmd.getExportedKeys("foo", "Foo%", "%");
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetIndexInfo() throws Exception {
        ResultSet rs = this.dbmd.getIndexInfo(null, "System", "KeyColumns", true, true);
        ResultSet rs1 = this.dbmd.getIndexInfo(null, "Foo%", "%", true, false);
        ResultSet rs2 = this.dbmd.getIndexInfo("foo", "Foo%", "%", true, false);
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetPrimaryKeys() throws Exception {
        ResultSet rs = this.dbmd.getPrimaryKeys(null, "BQT1", "SmallA");
        ResultSet rs1 = this.dbmd.getPrimaryKeys(null, "Foo%", "BQT1.SmallA");
        ResultSet rs2 = this.dbmd.getPrimaryKeys("foo", "Foo%", "BQT1.SmallA");
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetProcedureColumns() throws Exception {
        ResultSet rs = this.dbmd.getProcedureColumns(null, null, null, null);
        ResultSet rs1 = this.dbmd.getProcedureColumns(null, "Foo%", null, null);
        ResultSet rs2 = this.dbmd.getProcedureColumns("foo", "Foo%", null, null);
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetProcedures() throws Exception {
        ResultSet rs = this.dbmd.getProcedures(null, null, null);
        ResultSet rs1 = this.dbmd.getProcedures(null, "Foo%", null);
        ResultSet rs2 = this.dbmd.getProcedures("foo", "Foo%", null);
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetSchemas() throws Exception {
        TestMMDatabaseMetaData.compareResultSet(this.dbmd.getSchemas());
    }

    @Test
    public void testGetColumns() throws Exception {
        ResultSet rs = this.dbmd.getColumns(null, null, null, null);
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetColumns2() throws Exception {
        ResultSet rs = this.dbmd.getColumns(null, "QT_Ora%", "%", "%");
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetColumns3() throws Exception {
        ResultSet rs = this.dbmd.getColumns(null, "Foo%", "%", "%");
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetColumns4() throws Exception {
        ResultSet rs = this.dbmd.getColumns("foo", "Foo%", "%", "%");
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetColumnPrivileges() throws Exception {
        ResultSet rs = this.dbmd.getColumnPrivileges(null, "Parts", "%", "%");
        ResultSet rs1 = this.dbmd.getColumnPrivileges(null, "%foo", null, null);
        ResultSet rs2 = this.dbmd.getColumnPrivileges("foo", "%foo", null, null);
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetColumnPrivilegesResultSetMetaData() throws Exception {
        ResultSet rs = this.dbmd.getColumnPrivileges(null, "Parts", "%", "%");
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetTablePrivileges() throws Exception {
        ResultSet rs = this.dbmd.getTablePrivileges(null, "Parts", "%");
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetTablePrivilegesResultSetMetaData() throws Exception {
        ResultSet rs = this.dbmd.getTablePrivileges(null, "Parts", "%");
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetTables_specificTable() throws Exception {
        ResultSet rs = this.dbmd.getTables(null, "SYSTEM", "VIRTUALDATABASES", null);
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetTables_specificTableTypes() throws Exception {
        String[] tables = new String[]{"Table"};
        ResultSet rs = this.dbmd.getTables(null, null, null, tables);
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetTables_specificTableMultipleTypes() throws Exception {
        String[] tables = new String[]{"Table", "View"};
        ResultSet rs = this.dbmd.getTables(null, null, null, tables);
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetTables() throws Exception {
        ResultSet rs = this.dbmd.getTables(null, null, null, null);
        ResultSet rs1 = this.dbmd.getTables(null, "%foo", null, null);
        ResultSet rs2 = this.dbmd.getTables("foo", "%foo", null, null);
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetTables_allTables() throws Exception {
        ResultSet rs = this.dbmd.getTables(null, null, null, null);
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetTableTypes() throws Exception {
        ResultSet rs = this.dbmd.getTableTypes();
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetTypeInfo_TotalNumber() throws Exception {
        ResultSet rs = this.dbmd.getTypeInfo();
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetUDTs() throws Exception {
        ResultSet rs = this.dbmd.getUDTs(null, null, "%blob%", null);
        ResultSet rs1 = this.dbmd.getUDTs(null, "%foo", "%blob%", null);
        ResultSet rs2 = this.dbmd.getUDTs("foo", "%foo", "%blob%", null);
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetUDTs_specificTypeName() throws Exception {
        ResultSet rs = this.dbmd.getUDTs(null, null, "%blob%", null);
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetVersionColumns() throws Exception {
        ResultSet rs = this.dbmd.getVersionColumns(null, null, null);
        ResultSet rs1 = this.dbmd.getVersionColumns(null, "Foo%", null);
        ResultSet rs2 = this.dbmd.getVersionColumns("foo", "Foo%", null);
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetBestRowIdentifier() throws Exception {
        ResultSet rs = this.dbmd.getBestRowIdentifier(null, null, "SYS.VIRTUALDATABASES", 0, true);
        ResultSet rs1 = this.dbmd.getBestRowIdentifier(null, "%foo", null, 1, true);
        ResultSet rs2 = this.dbmd.getBestRowIdentifier("foo", "%foo", null, 1, true);
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetSuperTables() throws Exception {
        ResultSet rs = this.dbmd.getSuperTables(null, "Parts", "%");
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetSuperTypes() throws Exception {
        ResultSet rs = this.dbmd.getSuperTypes(null, "Parts", "%");
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testGetColumnsWithEscape() throws Exception {
        ResultSet columns = this.dbmd.getColumns("QT\\_Ora9DS", "BQT1", "SmallA", "IntKey");
        columns.next();
        Assert.assertEquals((Object)"BQT1", (Object)columns.getString(2));
        Assert.assertFalse((boolean)columns.next());
    }

    @Test
    public void testGetCrossReferenceWithEscape() throws Exception {
        ResultSet rs = this.dbmd.getCrossReference(null, "QT\\_Ora9DS", "BQT1.SmallA", null, null, "BQT1.SmallB");
        ResultSet rs1 = this.dbmd.getCrossReference(null, "Foo%", "%", null, null, "%");
        ResultSet rs2 = this.dbmd.getCrossReference("foo", "Foo%", "%", null, null, "%");
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetExportedKeysWithEscape() throws Exception {
        ResultSet rs = this.dbmd.getExportedKeys(null, "QT\\_Ora9DS", "BQT1.SmallA");
        ResultSet rs1 = this.dbmd.getExportedKeys(null, "Foo%", "%");
        ResultSet rs2 = this.dbmd.getExportedKeys("foo", "Foo%", "%");
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetImportedKeysWithEscape() throws Exception {
        ResultSet rs = this.dbmd.getImportedKeys(null, "QT\\_Ora9DS", "BQT1.SmallA");
        ResultSet rs1 = this.dbmd.getImportedKeys(null, "Foo%", "%");
        ResultSet rs2 = this.dbmd.getImportedKeys("foo", "Foo%", "%");
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetIndexInfoWithEscape() throws Exception {
        ResultSet rs = this.dbmd.getIndexInfo(null, "QT\\_Ora9DS", "SYS.KeyElements", true, true);
        ResultSet rs1 = this.dbmd.getIndexInfo(null, "Foo%", "%", true, false);
        ResultSet rs2 = this.dbmd.getIndexInfo("foo", "Foo%", "%", true, false);
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetPrimaryKeysWithEscape() throws Exception {
        ResultSet rs = this.dbmd.getPrimaryKeys("QT\\_Ora9DS", "BQT1", "SmallA");
        ResultSet rs1 = this.dbmd.getPrimaryKeys(null, "Foo%", "BQT1.SmallA");
        ResultSet rs2 = this.dbmd.getPrimaryKeys("foo", "Foo%", "BQT1.SmallA");
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetProceduresWithEscape() throws Exception {
        ResultSet rs = this.dbmd.getProcedures("QT\\_Ora9DS", null, null);
        ResultSet rs1 = this.dbmd.getProcedures(null, "Foo%", null);
        ResultSet rs2 = this.dbmd.getProcedures("foo", "Foo%", null);
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    private void helpTestSupportsConverts(int from, int to, boolean result) throws Exception {
        Assert.assertEquals((String)"Expected doesn't match with actual for method - supportsConvert()", (Object)result, (Object)this.dbmd.supportsConvert(from, to));
    }

    private void helpTestMethodsWithParams(String methodName, boolean returned, Object[] params) throws Exception {
        Class<?> dbmdClass = this.dbmd.getClass();
        Method[] methods = dbmdClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equalsIgnoreCase(methodName)) continue;
            Object actual = methods[i].invoke((Object)this.dbmd, params);
            Assert.assertEquals((String)("Expected doesn't match with actual for method - " + methodName), (Object)new Boolean(returned), (Object)actual);
        }
    }

    private Map getExpected() {
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("allProceduresAreCallable", Boolean.TRUE);
        expected.put("allTablesAreSelectable", Boolean.TRUE);
        expected.put("doesMaxRowSizeIncludeBlobs", Boolean.FALSE);
        expected.put("isCatalogAtStart", Boolean.FALSE);
        expected.put("isReadOnly", Boolean.FALSE);
        expected.put("locatorsUpdateCopy", Boolean.FALSE);
        expected.put("nullPlusNonNullIsNull", Boolean.TRUE);
        expected.put("nullsAreSortedAtEnd", Boolean.FALSE);
        expected.put("nullsAreSortedAtStart", Boolean.FALSE);
        expected.put("nullsAreSortedHigh", Boolean.FALSE);
        expected.put("nullsAreSortedLow", Boolean.TRUE);
        expected.put("storesLowerCaseIdentifiers", Boolean.FALSE);
        expected.put("storesLowerCaseQuotedIdentifiers", Boolean.FALSE);
        expected.put("storesMixedCaseIdentifiers", Boolean.TRUE);
        expected.put("storesMixedCaseQuotedIdentifiers", Boolean.TRUE);
        expected.put("storesUpperCaseIdentifiers", Boolean.FALSE);
        expected.put("storesUpperCaseQuotedIdentifiers", Boolean.FALSE);
        expected.put("supportsAlterTableWithAddColumn", Boolean.FALSE);
        expected.put("supportsAlterTableWithDropColumn", Boolean.FALSE);
        expected.put("supportsANSI92EntryLevelSQL", Boolean.FALSE);
        expected.put("supportsANSI92FullSQL", Boolean.FALSE);
        expected.put("supportsANSI92IntermediateSQL", Boolean.FALSE);
        expected.put("supportsBatchUpdates", Boolean.TRUE);
        expected.put("supportsCatalogsInDataManipulation", Boolean.FALSE);
        expected.put("supportsCatalogsInIndexDefinitions", Boolean.FALSE);
        expected.put("supportsCatalogsInPrivilegeDefinitions", Boolean.FALSE);
        expected.put("supportsCatalogsInProcedureCalls", Boolean.FALSE);
        expected.put("supportsCatalogsInTableDefinitions", Boolean.FALSE);
        expected.put("supportsColumnAliasing", Boolean.TRUE);
        expected.put("supportsCorrelatedSubqueries", Boolean.TRUE);
        expected.put("supportsCoreSQLGrammar", Boolean.FALSE);
        expected.put("supportsDataDefinitionAndDataManipulationTransactions", Boolean.FALSE);
        expected.put("supportsDataManipulationTransactionsOnly", Boolean.FALSE);
        expected.put("supportsDifferentTableCorrelationNames", Boolean.FALSE);
        expected.put("supportsExpressionsInOrderBy", Boolean.TRUE);
        expected.put("supportsExtendedSQLGrammar", Boolean.FALSE);
        expected.put("supportsFullOuterJoins", Boolean.TRUE);
        expected.put("supportsGetGeneratedKeys", Boolean.FALSE);
        expected.put("supportsGroupBy", Boolean.TRUE);
        expected.put("supportsGroupByBeyondSelect", Boolean.TRUE);
        expected.put("supportsGroupByUnrelated", Boolean.FALSE);
        expected.put("supportsIntegrityEnhancementFacility", Boolean.FALSE);
        expected.put("supportsLikeEscapeClause", Boolean.TRUE);
        expected.put("supportsLimitedOuterJoins", Boolean.TRUE);
        expected.put("supportsMinimumSQLGrammar", Boolean.TRUE);
        expected.put("supportsMixedCaseIdentifiers", Boolean.FALSE);
        expected.put("supportsMixedCaseQuotedIdentifiers", Boolean.FALSE);
        expected.put("supportsOpenCursorsAcrossCommit", Boolean.FALSE);
        expected.put("supportsMultipleResultSets", Boolean.FALSE);
        expected.put("supportsMultipleOpenResults", Boolean.FALSE);
        expected.put("supportsMultipleTransactions", Boolean.TRUE);
        expected.put("supportsNamedParameters", Boolean.FALSE);
        expected.put("supportsNonNullableColumns", Boolean.TRUE);
        expected.put("supportsOpenCursorsAcrossRollback", Boolean.FALSE);
        expected.put("supportsOpenStatementsAcrossCommit", Boolean.TRUE);
        expected.put("supportsOpenStatementsAcrossRollback", Boolean.TRUE);
        expected.put("supportsOrderByUnrelated", Boolean.TRUE);
        expected.put("supportsOuterJoins", Boolean.TRUE);
        expected.put("supportsPositionedDelete", Boolean.FALSE);
        expected.put("supportsPositionedUpdate", Boolean.FALSE);
        expected.put("supportsSavepoints", Boolean.FALSE);
        expected.put("supportsSchemasInDataManipulation", Boolean.TRUE);
        expected.put("supportsSchemasInIndexDefinitions", Boolean.FALSE);
        expected.put("supportsSchemasInPrivilegeDefinitions", Boolean.FALSE);
        expected.put("supportsSchemasInProcedureCalls", Boolean.TRUE);
        expected.put("supportsSchemasInTableDefinitions", Boolean.FALSE);
        expected.put("supportsSelectForUpdate", Boolean.FALSE);
        expected.put("supportsStatementPooling", Boolean.FALSE);
        expected.put("supportsStoredProcedures", Boolean.TRUE);
        expected.put("supportsSubqueriesInComparisons", Boolean.TRUE);
        expected.put("supportsSubqueriesInExists", Boolean.TRUE);
        expected.put("supportsSubqueriesInIns", Boolean.TRUE);
        expected.put("supportsSubqueriesInQuantifieds", Boolean.TRUE);
        expected.put("supportsTableCorrelationNames", Boolean.TRUE);
        expected.put("supportsTransactions", Boolean.TRUE);
        expected.put("supportsUnion", Boolean.TRUE);
        expected.put("supportsUnionAll", Boolean.TRUE);
        expected.put("usesLocalFilePerTable", Boolean.FALSE);
        expected.put("usesLocalFiles", Boolean.FALSE);
        expected.put("usesLocalFilePerTable", Boolean.FALSE);
        expected.put("getDatabaseMinorVersion", new Integer(ApplicationInfo.getInstance().getMinorReleaseVersion()));
        expected.put("getDatabaseMajorVersion", new Integer(ApplicationInfo.getInstance().getMajorReleaseVersion()));
        expected.put("getJDBCMajorVersion", new Integer(3));
        expected.put("getJDBCMinorVersion", new Integer(0));
        expected.put("getDefaultTransactionIsolation", 2);
        expected.put("getDriverMajorVersion", new Integer(ApplicationInfo.getInstance().getMajorReleaseVersion()));
        expected.put("getDriverMinorVersion", new Integer(ApplicationInfo.getInstance().getMinorReleaseVersion()));
        expected.put("getMaxBinaryLiteralLength", new Integer(0));
        expected.put("getMaxCatalogNameLength", 255);
        expected.put("getMaxCharLiteralLength", new Integer(0));
        expected.put("getMaxColumnNameLength", new Integer(255));
        expected.put("getMaxColumnsInGroupBy", new Integer(0));
        expected.put("getMaxColumnsInIndex", new Integer(0));
        expected.put("getMaxColumnsInOrderBy", new Integer(0));
        expected.put("getMaxColumnsInSelect", new Integer(0));
        expected.put("getMaxColumnsInTable", new Integer(0));
        expected.put("getMaxConnections", new Integer(0));
        expected.put("getMaxCursorNameLength", new Integer(0));
        expected.put("getMaxIndexLength", new Integer(0));
        expected.put("getMaxProcedureNameLength", new Integer(255));
        expected.put("getMaxRowSize", new Integer(0));
        expected.put("getMaxSchemaNameLength", new Integer(0));
        expected.put("getMaxStatementLength", new Integer(0));
        expected.put("getMaxStatements", new Integer(0));
        expected.put("getMaxTableNameLength", new Integer(255));
        expected.put("getMaxTablesInSelect", new Integer(0));
        expected.put("getMaxUserNameLength", new Integer(255));
        expected.put("getSQLStateType", new Integer(2));
        expected.put("getCatalogSeparator", "");
        expected.put("getCatalogTerm", "VirtualDatabase");
        expected.put("getDatabaseProductName", "Teiid Embedded");
        expected.put("getDatabaseProductVersion", "7.1");
        expected.put("getDriverName", "Teiid JDBC Driver");
        expected.put("getDriverVersion", ApplicationInfo.getInstance().getMajorReleaseVersion() + "." + ApplicationInfo.getInstance().getMinorReleaseVersion());
        expected.put("getExtraNameCharacters", ".@");
        expected.put("getIdentifierQuoteString", "\"");
        expected.put("getNumericFunctions", "ABS, ACOS, ASIN, ATAN, ATAN2, BITAND, BITNOT, BITOR, BITXOR, CEILING, COS, COT, DEGREES, EXP, FLOOR, FORMATBIGDECIMAL, FORMATBIGINTEGER, FORMATDOUBLE, FORMATFLOAT, FORMATINTEGER, FORMATLONG, LOG, LOG10, MOD, PARSEBIGDECIMAL, PARSEBIGINTEGER, PARSEDOUBLE, PARSEFLOAT, PARSEINTEGER, PARSELONG, PI, POWER, RADIANS, RAND, ROUND, SIGN, SIN, SQRT, TAN");
        expected.put("getProcedureTerm", "StoredProcedure");
        expected.put("getSchemaTerm", "Schema");
        expected.put("getSearchStringEscape", "\\");
        expected.put("getSQLKeywords", "OPTION, BIGDECIMAL, BIGDECIMAL, BIGINTEGER, BREAK, BYTE, CRITERIA, ERROR, LIMIT, LONG, LOOP, MAKEDEP, MAKENOTDEP, NOCACHE, STRING, VIRTUAL, WHILE");
        expected.put("getStringFunctions", "ASCII, CHR, CHAR, CONCAT, CONCAT2, INITCAP, INSERT, LCASE, LEFT, LENGTH, LOCATE, LOWER, LPAD, LTRIM, REPEAT, REPLACE, RIGHT, RPAD, RTRIM, SUBSTRING, TRANSLATE, UCASE, UPPER");
        expected.put("getSystemFunctions", "CAST, COALESCE, CONVERT, DECODESTRING, DECODEINTEGER, IFNULL, NULLIF, NVL, LOOKUP");
        expected.put("getTimeDateFunctions", "CURDATE, CURTIME, NOW, DAYNAME, DAYOFMONTH, DAYOFWEEK, DAYOFYEAR, FORMATDATE, FORMATTIME, FORMATTIMESTAMP, FROM_UNIXTIME, HOUR, MINUTE, MONTH, MONTHNAME, PARSEDATE, PARSETIME, PARSETIMESTAMP, QUARTER, SECOND, TIMESTAMPADD, TIMESTAMPDIFF, WEEK, YEAR");
        expected.put("getUserName", "anonymous");
        expected.put("getConnection", conn);
        return expected;
    }
}

