/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.FakeServer;

public class TestVirtualDocWithVirtualProc
extends AbstractMMQueryTestCase {
    private static final String VDB = "xmlvp";

    public TestVirtualDocWithVirtualProc() {
        this.DELIMITER = "\t";
    }

    @Before
    public void setUp() throws Exception {
        FakeServer server = new FakeServer();
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/xml-vp/xmlvp_1.vdb");
        this.internalConnection = server.createConnection("jdbc:teiid:xmlvp");
    }

    @Override
    @After
    public void tearDown() {
        this.closeConnection();
    }

    @Test
    public void testDefect15241() {
        String sql = "SELECT SchemaName, Name, Description FROM SYS.Tables WHERE Name = 'yyyTestDocument'";
        String[] expected = new String[]{"SchemaName[string]\tName[string]\tDescription[string]", "test13326Doc\tyyyTestDocument\tnull", "testDoc\tyyyTestDocument\tThis is a test description of virtual doc yyyTestDocument"};
        this.executeAndAssertResults(sql, expected);
    }

    @Test
    public void testDefect15241a() {
        String sql = "SELECT TableName, Name, Description FROM SYS.Columns WHERE Name = 'IntKey'";
        String[] expected = new String[]{"TableName[string]\tName[string]\tDescription[string]", "HugeA\tIntKey\tnull", "HugeB\tIntKey\tnull", "LargeA\tIntKey\tnull", "LargeB\tIntKey\tnull", "MediumA\tIntKey\tnull", "MediumB\tIntKey\tnull", "SmallA\tIntKey\tThis is a test description of SmallA.IntKey element", "SmallB\tIntKey\tnull"};
        this.executeAndAssertResults(sql, expected);
    }

    @Test
    public void testDefect15241b() {
        String sql = "SELECT p.Name, p.Value, UID FROM SYS.Properties p";
        String[] expected = new String[]{"Name[string]\tValue[string]\tUID[string]", "NugentXAttribute\tNuuuuuge22222\tmmuuid:4789b280-841c-1f15-9526-ebd0cace03e1", "NugentYAttribute\tNuuuuuge44444\tmmuuid:4789b280-841c-1f15-9526-ebd0cace03e1"};
        this.executeAndAssertResults(sql, expected);
    }
}

