/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.crypto;

import junit.framework.TestCase;
import org.teiid.core.crypto.CryptoException;
import org.teiid.core.crypto.DhKeyGenerator;
import org.teiid.core.crypto.SymmetricCryptor;

public class TestDhKeyGenerator
extends TestCase {
    public void testKeyGenerationDefault() throws CryptoException {
        DhKeyGenerator keyGenServer = new DhKeyGenerator();
        DhKeyGenerator keyGenClient = new DhKeyGenerator();
        byte[] serverKey = keyGenServer.createPublicKey();
        byte[] clientKey = keyGenClient.createPublicKey();
        SymmetricCryptor serverCryptor = keyGenServer.getSymmetricCryptor(clientKey);
        SymmetricCryptor clientCryptor = keyGenClient.getSymmetricCryptor(serverKey);
        String cleartext = "cleartext!";
        String ciphertext = serverCryptor.encrypt(cleartext);
        String cleartext2 = clientCryptor.decrypt(ciphertext);
        TestDhKeyGenerator.assertEquals((String)cleartext, (String)cleartext2);
        TestDhKeyGenerator.assertTrue((!ciphertext.equals(cleartext) ? 1 : 0) != 0);
    }
}

