/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.teiid.core.util.StringUtil;

public class TestStringUtil
extends TestCase {
    public TestStringUtil(String name) {
        super(name);
    }

    public void helpTestEncloseInSingleQuotes(String input, String expectedResult) {
        String result = StringUtil.enclosedInSingleQuotes((String)input);
        TestStringUtil.assertEquals((String)"Unexpected encloseInSignleQuotes result", (String)expectedResult, (String)result);
    }

    public void helpTestComputeDisplayableForm(String input, String expectedResult) {
        String result = StringUtil.computeDisplayableForm((String)input, (String)input);
        TestStringUtil.assertEquals((String)"Unexpected ComputeDisplayableForm result", (String)expectedResult, (String)result);
    }

    public void helpTestComputePluralForm(String input, String expectedResult) {
        String result = StringUtil.computePluralForm((String)input);
        TestStringUtil.assertEquals((String)"Unexpected ComputePluralForm result", (String)expectedResult, (String)result);
    }

    public void helpTestJoin(List input, String delimiter, String expectedResult) {
        String result = StringUtil.join((List)input, (String)delimiter);
        TestStringUtil.assertEquals((String)"Unexpected Join result", (String)expectedResult, (String)result);
    }

    public void helpTestReplace(String source, String search, String replace, String expectedResult) {
        String result = StringUtil.replace((String)source, (String)search, (String)replace);
        TestStringUtil.assertEquals((String)"Unexpected Replace result", (String)expectedResult, (String)result);
    }

    public void helpTestReplaceAll(String source, String search, String replace, String expectedResult) {
        String result = StringUtil.replaceAll((String)source, (String)search, (String)replace);
        TestStringUtil.assertEquals((String)"Unexpected ReplaceAll result", (String)expectedResult, (String)result);
    }

    public void helpTestTruncString(String input, int length, String expectedResult) {
        String result = StringUtil.truncString((String)input, (int)length);
        TestStringUtil.assertEquals((String)"Unexpected TruncString result", (String)expectedResult, (String)result);
    }

    public void testEncloseInSingleQuotes() {
        this.helpTestEncloseInSingleQuotes("testString", "'testString'");
    }

    public void testComputeDisplayableForm1() {
        this.helpTestComputeDisplayableForm("testString", "Test String");
    }

    public void testComputeDisplayableForm2() {
        this.helpTestComputeDisplayableForm("TEST STRING", "TEST STRING");
    }

    public void testComputeDisplayableForm3() {
        this.helpTestComputeDisplayableForm("TestSTRING", "Test STRING");
    }

    public void testComputeDisplayableForm4() {
        this.helpTestComputeDisplayableForm("MetaMatrix", "MetaMatrix");
    }

    public void testComputeDisplayableForm5() {
        this.helpTestComputeDisplayableForm("metaMatrix", "MetaMatrix");
    }

    public void testComputeDisplayableForm6() {
        this.helpTestComputeDisplayableForm("Metamatrix", "Metamatrix");
    }

    public void testComputeDisplayableForm7() {
        this.helpTestComputeDisplayableForm("SomeMetaMatrixEmbedded", "Some MetaMatrix Embedded");
    }

    public void testComputeDisplayableForm8() {
        this.helpTestComputeDisplayableForm("SomeMetaMetaMatrixMetaEmbedded", "Some Meta MetaMatrix Meta Embedded");
    }

    public void testComputeDisplayableForm9() {
        this.helpTestComputeDisplayableForm("SomemetaMatrixMetaMatrixMetaEmbedded", "Somemeta Matrix MetaMatrix Meta Embedded");
    }

    public void testComputePluralForm1() {
        this.helpTestComputePluralForm("Test", "Tests");
    }

    public void testComputePluralForm2() {
        this.helpTestComputePluralForm("ss", "sses");
    }

    public void testComputePluralForm3() {
        this.helpTestComputePluralForm("x", "xes");
    }

    public void testComputePluralForm4() {
        this.helpTestComputePluralForm("ch", "ches");
    }

    public void testComputePluralForm5() {
        this.helpTestComputePluralForm("zy", "zies");
    }

    public void testComputePluralForm6() {
        this.helpTestComputePluralForm("ay", "ays");
    }

    public void testComputePluralForm7() {
        this.helpTestComputePluralForm("ey", "eys");
    }

    public void testComputePluralForm8() {
        this.helpTestComputePluralForm("iy", "iys");
    }

    public void testComputePluralForm9() {
        this.helpTestComputePluralForm("oy", "oys");
    }

    public void testComputePluralForm10() {
        this.helpTestComputePluralForm("uy", "uys");
    }

    public void testComputePluralForm11() {
        this.helpTestComputePluralForm("any", "anys");
    }

    public void testComputePluralForm12() {
        this.helpTestComputePluralForm("classes", "classes");
    }

    public void testJoin1() {
        ArrayList<String> input = new ArrayList<String>();
        input.add("One");
        input.add("Two");
        this.helpTestJoin(input, null, null);
    }

    public void testJoin2() {
        this.helpTestJoin(null, "/", null);
    }

    public void testJoin3() {
        ArrayList<String> input = new ArrayList<String>();
        input.add("One");
        input.add("Two");
        this.helpTestJoin(input, "/", "One/Two");
    }

    public void testReplace1() {
        this.helpTestReplace("12225", null, "234", "12225");
    }

    public void testReplace2() {
        this.helpTestReplace("12225", "222", null, "12225");
    }

    public void testReplace3() {
        this.helpTestReplace("12225", "222", "234", "12345");
    }

    public void testReplaceAll() {
        this.helpTestReplaceAll("1121121112", "2", "1", "1111111111");
    }

    public void testTruncString() {
        this.helpTestTruncString("123456", 5, "12345");
    }

    public void testGetStackTrace() {
        String expectedStackTrace = "java.lang.RuntimeException: Test";
        RuntimeException t = new RuntimeException("Test");
        String trace = StringUtil.getStackTrace((Throwable)t);
        if (!trace.startsWith("java.lang.RuntimeException: Test")) {
            TestStringUtil.fail((String)("Stack trace: \n" + trace + "\n did not match expected stack trace: \n" + "java.lang.RuntimeException: Test"));
        }
    }

    public void testToString() {
        Object[] input = new String[]{"string1", "string2", "string3"};
        String output = StringUtil.toString((Object[])input);
        TestStringUtil.assertEquals((String)"[string1,string2,string3]", (String)output);
    }

    public void testGetTokens() {
        String input = "string with; tokens ; delimited by ; ; semicolons; there;; are 7 tokens.";
        List tokens = StringUtil.getTokens((String)"string with; tokens ; delimited by ; ; semicolons; there;; are 7 tokens.", (String)";");
        TestStringUtil.assertEquals((int)7, (int)tokens.size());
        TestStringUtil.assertEquals((Object)"string with", tokens.get(0));
        TestStringUtil.assertEquals((Object)" tokens ", tokens.get(1));
        TestStringUtil.assertEquals((Object)" delimited by ", tokens.get(2));
        TestStringUtil.assertEquals((Object)" ", tokens.get(3));
        TestStringUtil.assertEquals((Object)" semicolons", tokens.get(4));
        TestStringUtil.assertEquals((Object)" there", tokens.get(5));
        TestStringUtil.assertEquals((Object)" are 7 tokens.", tokens.get(6));
    }

    public void testSplitOnEntireString() {
        List result = StringUtil.splitOnEntireString((String)"thisNEXTcanNEXTbe", (String)"NEXT");
        TestStringUtil.assertEquals((int)3, (int)result.size());
        TestStringUtil.assertEquals((Object)"this", result.get(0));
        TestStringUtil.assertEquals((Object)"can", result.get(1));
        TestStringUtil.assertEquals((Object)"be", result.get(2));
    }

    public void testSplitOnEntireStringEmptyString() {
        List result = StringUtil.splitOnEntireString((String)"", (String)"NEXT");
        TestStringUtil.assertEquals((int)1, (int)result.size());
        TestStringUtil.assertEquals((Object)"", result.get(0));
    }

    public void testSplitOnEntireStringEntireStringIsDelimiter() {
        List result = StringUtil.splitOnEntireString((String)"NEXT", (String)"NEXT");
        TestStringUtil.assertEquals((int)2, (int)result.size());
        TestStringUtil.assertEquals((Object)"", result.get(0));
        TestStringUtil.assertEquals((Object)"", result.get(1));
    }

    public void testSplitOnEntireStringEmptyDelimiter() {
        List result = StringUtil.splitOnEntireString((String)"test", (String)"");
        TestStringUtil.assertEquals((int)1, (int)result.size());
        TestStringUtil.assertEquals((Object)"test", result.get(0));
    }

    public void testSplitOnEntireStringEndsWithDelimiter() {
        List result = StringUtil.splitOnEntireString((String)"testNEXT", (String)"NEXT");
        TestStringUtil.assertEquals((int)2, (int)result.size());
        TestStringUtil.assertEquals((Object)"test", result.get(0));
        TestStringUtil.assertEquals((Object)"", result.get(1));
    }

    public void testIndexOfIgnoreCase() {
        String text = "test";
        TestStringUtil.assertEquals((int)-1, (int)StringUtil.indexOfIgnoreCase(null, (String)text));
        TestStringUtil.assertEquals((int)-1, (int)StringUtil.indexOfIgnoreCase((String)"", (String)text));
        TestStringUtil.assertEquals((int)-1, (int)StringUtil.indexOfIgnoreCase((String)text, null));
        TestStringUtil.assertEquals((int)-1, (int)StringUtil.indexOfIgnoreCase((String)text, (String)""));
        TestStringUtil.assertEquals((int)-1, (int)StringUtil.indexOfIgnoreCase((String)text, (String)"testing"));
        TestStringUtil.assertEquals((int)1, (int)StringUtil.indexOfIgnoreCase((String)text, (String)"es"));
        TestStringUtil.assertEquals((int)1, (int)StringUtil.indexOfIgnoreCase((String)text, (String)"Es"));
        TestStringUtil.assertEquals((int)1, (int)StringUtil.indexOfIgnoreCase((String)text, (String)"eS"));
        TestStringUtil.assertEquals((int)2, (int)StringUtil.indexOfIgnoreCase((String)text, (String)"ST"));
    }

    public void testStartsWithIgnoreCase() {
        String text = "test";
        TestStringUtil.assertEquals((boolean)false, (boolean)StringUtil.startsWithIgnoreCase(null, (String)text));
        TestStringUtil.assertEquals((boolean)false, (boolean)StringUtil.startsWithIgnoreCase((String)"", (String)text));
        TestStringUtil.assertEquals((boolean)false, (boolean)StringUtil.startsWithIgnoreCase((String)text, null));
        TestStringUtil.assertEquals((boolean)true, (boolean)StringUtil.startsWithIgnoreCase((String)text, (String)""));
        TestStringUtil.assertEquals((boolean)false, (boolean)StringUtil.startsWithIgnoreCase((String)text, (String)"testing"));
        TestStringUtil.assertEquals((boolean)false, (boolean)StringUtil.startsWithIgnoreCase((String)text, (String)"es"));
        TestStringUtil.assertEquals((boolean)true, (boolean)StringUtil.startsWithIgnoreCase((String)text, (String)"te"));
        TestStringUtil.assertEquals((boolean)true, (boolean)StringUtil.startsWithIgnoreCase((String)text, (String)"Te"));
        TestStringUtil.assertEquals((boolean)true, (boolean)StringUtil.startsWithIgnoreCase((String)text, (String)"tE"));
        TestStringUtil.assertEquals((boolean)true, (boolean)StringUtil.startsWithIgnoreCase((String)text, (String)"TE"));
    }

    public void testEndsWithIgnoreCase() {
        String text = "test";
        TestStringUtil.assertEquals((boolean)false, (boolean)StringUtil.endsWithIgnoreCase(null, (String)text));
        TestStringUtil.assertEquals((boolean)false, (boolean)StringUtil.endsWithIgnoreCase((String)"", (String)text));
        TestStringUtil.assertEquals((boolean)false, (boolean)StringUtil.endsWithIgnoreCase((String)text, null));
        TestStringUtil.assertEquals((boolean)true, (boolean)StringUtil.endsWithIgnoreCase((String)text, (String)""));
        TestStringUtil.assertEquals((boolean)false, (boolean)StringUtil.endsWithIgnoreCase((String)text, (String)"testing"));
        TestStringUtil.assertEquals((boolean)false, (boolean)StringUtil.endsWithIgnoreCase((String)text, (String)"es"));
        TestStringUtil.assertEquals((boolean)true, (boolean)StringUtil.endsWithIgnoreCase((String)text, (String)"st"));
        TestStringUtil.assertEquals((boolean)true, (boolean)StringUtil.endsWithIgnoreCase((String)text, (String)"St"));
        TestStringUtil.assertEquals((boolean)true, (boolean)StringUtil.endsWithIgnoreCase((String)text, (String)"sT"));
        TestStringUtil.assertEquals((boolean)true, (boolean)StringUtil.endsWithIgnoreCase((String)text, (String)"ST"));
    }

    public void testIsDigits() {
        TestStringUtil.assertTrue((boolean)StringUtil.isDigits((String)"012872"));
        TestStringUtil.assertTrue((boolean)StringUtil.isDigits((String)"634644"));
        TestStringUtil.assertFalse((boolean)StringUtil.isDigits((String)"A634644"));
        TestStringUtil.assertFalse((boolean)StringUtil.isDigits((String)"634A644"));
    }

    public void testToFixedLengthNull() {
        TestStringUtil.assertEquals((String)"    ", (String)StringUtil.toFixedLength(null, (int)4));
    }

    public void testToFixedLengthPad() {
        TestStringUtil.assertEquals((String)"a   ", (String)StringUtil.toFixedLength((String)"a", (int)4));
    }

    public void testToFixedLengthNoChange() {
        TestStringUtil.assertEquals((String)"abcd", (String)StringUtil.toFixedLength((String)"abcd", (int)4));
    }

    public void testToFixedLengthChop() {
        TestStringUtil.assertEquals((String)"abcd", (String)StringUtil.toFixedLength((String)"abcdefgh", (int)4));
    }

    public void testIsLetter() {
        TestStringUtil.assertTrue((boolean)StringUtil.isLetter((char)'a'));
        TestStringUtil.assertTrue((boolean)StringUtil.isLetter((char)'A'));
        TestStringUtil.assertFalse((boolean)StringUtil.isLetter((char)'5'));
        TestStringUtil.assertFalse((boolean)StringUtil.isLetter((char)'_'));
        TestStringUtil.assertTrue((boolean)StringUtil.isLetter((char)'\u00cf'));
        TestStringUtil.assertFalse((boolean)StringUtil.isLetter((char)'\u0967'));
        TestStringUtil.assertTrue((boolean)StringUtil.isLetter((char)'\u0905'));
    }

    public void testIsDigit() {
        TestStringUtil.assertFalse((boolean)StringUtil.isDigit((char)'a'));
        TestStringUtil.assertFalse((boolean)StringUtil.isDigit((char)'A'));
        TestStringUtil.assertTrue((boolean)StringUtil.isDigit((char)'5'));
        TestStringUtil.assertFalse((boolean)StringUtil.isDigit((char)'_'));
        TestStringUtil.assertFalse((boolean)StringUtil.isDigit((char)'\u00cf'));
        TestStringUtil.assertTrue((boolean)StringUtil.isDigit((char)'\u0967'));
        TestStringUtil.assertFalse((boolean)StringUtil.isDigit((char)'\u0905'));
    }

    public void testIsLetterOrDigit() {
        TestStringUtil.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'a'));
        TestStringUtil.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'A'));
        TestStringUtil.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'5'));
        TestStringUtil.assertFalse((boolean)StringUtil.isLetterOrDigit((char)'_'));
        TestStringUtil.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'\u00cf'));
        TestStringUtil.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'\u0967'));
        TestStringUtil.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'\u0905'));
    }

    public void testToUpperCase() {
        TestStringUtil.assertEquals((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890", (String)StringUtil.toUpperCase((String)"abcdefghijklmnopqrstuvwxyz1234567890"));
        TestStringUtil.assertEquals((String)"LATIN1_\u00c0", (String)StringUtil.toUpperCase((String)"Latin1_\u00e0"));
    }

    public void testToLowerCase() {
        TestStringUtil.assertEquals((String)"abcdefghijklmnopqrstuvwxyz1234567890", (String)StringUtil.toLowerCase((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890"));
        TestStringUtil.assertEquals((String)"latin1_\u00e0", (String)StringUtil.toLowerCase((String)"Latin1_\u00c0"));
    }

    public void testCreateFileName() {
        TestStringUtil.assertEquals((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890", (String)StringUtil.createFileName((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890"));
        TestStringUtil.assertEquals((String)"http:__www.metamatrix.com_parm1=test;parm2=testy2", (String)StringUtil.createFileName((String)"http://www.metamatrix.com?parm1=test;parm2=testy2"));
    }

    public void testGetFirstToken() {
        TestStringUtil.assertEquals((String)"/foo/bar", (String)StringUtil.getFirstToken((String)"/foo/bar.vdb", (String)"."));
        TestStringUtil.assertEquals((String)"", (String)StringUtil.getFirstToken((String)"/foo/bar.vdb", (String)"/"));
        TestStringUtil.assertEquals((String)"/foo", (String)StringUtil.getFirstToken((String)"/foo./bar.vdb", (String)"."));
        TestStringUtil.assertEquals((String)"bar", (String)StringUtil.getFirstToken((String)StringUtil.getLastToken((String)"/foo/bar.vdb", (String)"/"), (String)"."));
        TestStringUtil.assertEquals((String)"vdb", (String)StringUtil.getLastToken((String)"/foo/bar.vdb", (String)"."));
    }

    public void testValueOf() throws Exception {
        TestStringUtil.assertEquals((Object)21, (Object)StringUtil.valueOf((String)"21", Integer.class));
        TestStringUtil.assertEquals((Object)true, (Object)StringUtil.valueOf((String)"true", Boolean.class));
        TestStringUtil.assertEquals((Object)"Foo", (Object)StringUtil.valueOf((String)"Foo", String.class));
        TestStringUtil.assertEquals((Object)Float.valueOf(10.12f), (Object)StringUtil.valueOf((String)"10.12", Float.class));
        TestStringUtil.assertEquals((Object)121.123, (Object)StringUtil.valueOf((String)"121.123", Double.class));
        TestStringUtil.assertEquals((Object)12334567L, (Object)StringUtil.valueOf((String)"12334567", Long.class));
        TestStringUtil.assertEquals((Object)21, (Object)StringUtil.valueOf((String)"21", Short.class));
        List list = (List)StringUtil.valueOf((String)"foo,bar,x,y,z", List.class);
        TestStringUtil.assertEquals((int)5, (int)list.size());
        TestStringUtil.assertTrue((boolean)list.contains("foo"));
        TestStringUtil.assertTrue((boolean)list.contains("x"));
        int[] values = (int[])StringUtil.valueOf((String)"1,2,3,4,5", new int[0].getClass());
        TestStringUtil.assertEquals((int)5, (int)values.length);
        TestStringUtil.assertEquals((int)5, (int)values[4]);
        Map m = (Map)StringUtil.valueOf((String)"foo=bar,x=,y=z", Map.class);
        TestStringUtil.assertEquals((int)3, (int)m.size());
        TestStringUtil.assertEquals(m.get("foo"), (Object)"bar");
        TestStringUtil.assertEquals(m.get("x"), (Object)"");
        TestStringUtil.assertEquals((Object)((Object)Test.HELLO), (Object)StringUtil.valueOf((String)"HELLO", Test.class));
        TestStringUtil.assertEquals((Object)new URL("http://teiid.org"), (Object)StringUtil.valueOf((String)"http://teiid.org", URL.class));
    }

    public static enum Test {
        HELLO,
        WORLD;

    }
}

