/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.client.impl;

import java.io.File;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teiid.core.util.SqlUtil;
import org.teiid.test.client.ExpectedResults;
import org.teiid.test.client.ctc.ResultsHolder;
import org.teiid.test.framework.TestLogger;
import org.teiid.test.framework.exception.QueryTestFailedException;
import org.teiid.test.util.TestResultSetUtil;

public class ExpectedResultsImpl
implements ExpectedResults {
    private static final int MAX_COL_WIDTH = 65;
    protected Properties props;
    protected int resultMode = -1;
    protected String generateDir = null;
    protected String querySetIdentifier = null;
    protected String results_dir_loc = null;
    protected Map<String, ResultsHolder> loadedResults = new HashMap<String, ResultsHolder>();

    public ExpectedResultsImpl(String querySetIdentifier, Properties properties) {
        this.props = properties;
        this.querySetIdentifier = querySetIdentifier;
        this.results_dir_loc = this.props.getProperty("results.loc", "");
        String expected_root_loc = this.props.getProperty("results.root.dir");
        if (expected_root_loc != null) {
            File dir = new File(expected_root_loc, this.results_dir_loc);
            this.results_dir_loc = dir.getAbsolutePath();
        }
        TestLogger.logInfo("Expected results loc: " + this.results_dir_loc);
    }

    @Override
    public boolean isExceptionExpected(String queryidentifier) throws QueryTestFailedException {
        return false;
    }

    @Override
    public String getQuerySetID() {
        return this.querySetIdentifier;
    }

    @Override
    public synchronized File getResultsFile(String queryidentifier) throws QueryTestFailedException {
        return this.findExpectedResultsFile(queryidentifier, this.querySetIdentifier);
    }

    @Override
    public Object compareResults(String queryIdentifier, String sql, ResultSet resultSet, Throwable actualException, int testStatus, boolean isOrdered, int updateCnt, boolean resultFromQuery) throws QueryTestFailedException {
        File expectedResultsFile = this.getResultsFile(queryIdentifier);
        List results = null;
        if (actualException != null) {
            try {
                results = TestResultSetUtil.compareThrowable(actualException, sql, expectedResultsFile, false);
            }
            catch (Throwable e) {
                QueryTestFailedException t = new QueryTestFailedException(e.getMessage());
                t.initCause(e);
                throw t;
            }
            if (results != null && results.size() > 0) {
                return results;
            }
            return null;
        }
        if (!resultFromQuery) {
            if (SqlUtil.isUpdateSql((String)sql)) {
                if (updateCnt == 0 && expectedResultsFile.length() > 0L) {
                    throw new QueryTestFailedException("Update cnt was zero: " + expectedResultsFile.getName());
                }
                if (updateCnt > 0 && expectedResultsFile.length() == 0L) {
                    throw new QueryTestFailedException("Update cnt was greater than zero, but didnt expected any updates");
                }
            } else if (expectedResultsFile.length() > 0L) {
                throw new QueryTestFailedException("No results from query, but expected results");
            }
        } else {
            try {
                if (expectedResultsFile.length() == 0L) {
                    if (!resultSet.first()) {
                        throw new QueryTestFailedException("Expected results is empty, but query produced results");
                    }
                    return results;
                }
                resultSet.beforeFirst();
                results = TestResultSetUtil.writeAndCompareResultSet(resultSet, sql, 65, false, null, expectedResultsFile, false);
            }
            catch (QueryTestFailedException qe) {
                throw qe;
            }
            catch (Throwable e) {
                QueryTestFailedException t = new QueryTestFailedException(e.getMessage());
                t.initCause(e);
                throw t;
            }
            if (results != null && results.size() > 0) {
                return results;
            }
            return null;
        }
        return results;
    }

    @Override
    public Object getMetaData(String queryidentifier) {
        return null;
    }

    private File findExpectedResultsFile(String queryIdentifier, String querySetIdentifier) throws QueryTestFailedException {
        String resultFileName = queryIdentifier + ".txt";
        File file = new File(this.results_dir_loc + "/" + querySetIdentifier, resultFileName);
        if (!file.exists()) {
            throw new QueryTestFailedException("Query results file " + file.getAbsolutePath() + " cannot be found");
        }
        return file;
    }
}

