/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import org.jboss.deployers.spi.DeploymentException;
import org.mockito.Mockito;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.client.DQP;
import org.teiid.client.security.ILogon;
import org.teiid.deployers.MetadataStoreGroup;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.FakeTransactionService;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.service.BufferService;
import org.teiid.dqp.service.FakeBufferService;
import org.teiid.dqp.service.SessionService;
import org.teiid.dqp.service.TransactionService;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.EmbeddedProfile;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.index.IndexMetadataFactory;
import org.teiid.metadata.index.VDBMetadataFactory;
import org.teiid.net.ServerConnection;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.services.SessionServiceImpl;
import org.teiid.transport.ClientServiceRegistry;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.LocalServerConnection;
import org.teiid.transport.LogonImpl;

public class FakeServer
extends ClientServiceRegistryImpl {
    SessionServiceImpl sessionService = new SessionServiceImpl();
    LogonImpl logon;
    DQPCore dqp = new DQPCore();
    VDBRepository repo = new VDBRepository();
    private ConnectorManagerRepository cmr;

    public FakeServer() {
        this.logon = new LogonImpl((SessionService)this.sessionService, null);
        this.repo.setSystemStore(VDBMetadataFactory.getSystem());
        this.repo.setSystemFunctionManager(new SystemFunctionManager());
        this.repo.odbcEnabled();
        this.repo.start();
        this.sessionService.setVDBRepository(this.repo);
        this.dqp.setBufferService((BufferService)new FakeBufferService());
        this.dqp.setCacheFactory((CacheFactory)new DefaultCacheFactory());
        this.dqp.setTransactionService((TransactionService)new FakeTransactionService());
        this.cmr = (ConnectorManagerRepository)Mockito.mock(ConnectorManagerRepository.class);
        Mockito.stub((Object)this.cmr.getConnectorManager("source")).toReturn((Object)new ConnectorManager("x", "x"){

            public SourceCapabilities getCapabilities() {
                return new BasicSourceCapabilities();
            }
        });
        DQPConfiguration config = new DQPConfiguration();
        config.setResultsetCacheConfig(new CacheConfiguration(CacheConfiguration.Policy.LRU, 60, 250));
        this.dqp.setCacheFactory((CacheFactory)new DefaultCacheFactory());
        this.dqp.start(config);
        this.sessionService.setDqp(this.dqp);
        this.registerClientService(ILogon.class, this.logon, null);
        this.registerClientService(DQP.class, this.dqp, null);
    }

    public void deployVDB(String vdbName, String vdbPath) throws Exception {
        IndexMetadataFactory imf = VDBMetadataFactory.loadMetadata((URL)new File(vdbPath).toURI().toURL());
        MetadataStore metadata = imf.getMetadataStore(this.repo.getSystemStore().getDatatypes());
        VDBMetaData vdbMetaData = new VDBMetaData();
        vdbMetaData.setName(vdbName);
        vdbMetaData.setStatus(VDB.Status.ACTIVE);
        for (Schema schema : this.repo.getSystemStore().getSchemas().values()) {
            this.addModel(vdbMetaData, schema);
        }
        for (Schema schema : this.repo.getODBCStore().getSchemas().values()) {
            this.addModel(vdbMetaData, schema);
        }
        for (Schema schema : metadata.getSchemas().values()) {
            this.addModel(vdbMetaData, schema);
        }
        try {
            MetadataStoreGroup stores = new MetadataStoreGroup();
            stores.addStore(metadata);
            this.repo.addVDB(vdbMetaData, stores, imf.getEntriesPlusVisibilities(), null, this.cmr);
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeVDB(String vdbName) {
        this.repo.removeVDB(vdbName, 1);
    }

    private void addModel(VDBMetaData vdbMetaData, Schema schema) {
        ModelMetaData model = new ModelMetaData();
        model.setName(schema.getName());
        vdbMetaData.addModel(model);
        model.addSourceMapping("source", "translator", "jndi:source");
    }

    public VDBMetaData getVDB(String vdbName) {
        return this.repo.getVDB(vdbName, 1);
    }

    public void undeployVDB(String vdbName) {
        this.repo.removeVDB(vdbName, 1);
    }

    public void mergeVDBS(String sourceVDB, String targetVDB) throws AdminException {
        this.repo.mergeVDBs(sourceVDB, 1, targetVDB, 1);
    }

    public ConnectionImpl createConnection(String embeddedURL) throws Exception {
        Properties p = new Properties();
        EmbeddedProfile.parseURL((String)embeddedURL, (Properties)p);
        LocalServerConnection conn = new LocalServerConnection(p){

            protected ClientServiceRegistry getClientServiceRegistry() {
                return FakeServer.this;
            }
        };
        return new ConnectionImpl((ServerConnection)conn, p, embeddedURL);
    }
}

