/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.regex.Pattern;
import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.StringUtil;

public class SqlUtil {
    public static final char CR_CHAR = '\r';
    public static final char NL_CHAR = '\n';
    public static final char SPACE_CHAR = ' ';
    public static final char TAB_CHAR = '\t';
    private static Pattern PATTERN = Pattern.compile("^([\\s]|(/\\*.*\\*/))*(insert|update|delete|create|drop|(select([\\s]|(/\\*.*\\*/))+.*into([\\s]|(/\\*.*\\*/))+)).*", 10);

    private SqlUtil() {
    }

    public static boolean isUpdateSql(String sql) throws IllegalArgumentException {
        ArgCheck.isNotNull(sql);
        return PATTERN.matcher(sql).matches();
    }

    public static String normalize(String inputSqlString) {
        String normalizedString = inputSqlString;
        if (inputSqlString != null && inputSqlString.length() > 0) {
            if (inputSqlString.indexOf(10) > -1 || inputSqlString.indexOf(13) > -1 || inputSqlString.indexOf(9) > -1 || inputSqlString.indexOf("  ") > -1) {
                normalizedString = normalizedString.replace('\n', ' ');
                normalizedString = normalizedString.replace('\r', ' ');
                normalizedString = normalizedString.replace('\t', ' ');
                normalizedString = StringUtil.replaceAll(normalizedString, "  ", StringUtil.Constants.SPACE);
            }
            normalizedString = StringUtil.collapseWhitespace(normalizedString);
        }
        return normalizedString;
    }

    public static boolean stringsAreDifferent(String newSql, String oldSql) {
        String normalizedOldSql;
        String normalizedNewSql;
        boolean isDifferent = true;
        if (newSql == null) {
            if (oldSql == null) {
                isDifferent = false;
            }
        } else if (oldSql != null && (normalizedNewSql = SqlUtil.normalize(newSql)).equals(normalizedOldSql = SqlUtil.normalize(oldSql))) {
            isDifferent = false;
        }
        return isDifferent;
    }

    public static SQLException createFeatureNotSupportedException() {
        return new SQLFeatureNotSupportedException();
    }
}

