/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache;

import java.io.Serializable;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCache;
import org.teiid.core.TeiidRuntimeException;

public class DefaultCacheFactory
implements CacheFactory,
Serializable {
    private static final long serialVersionUID = -5541424157695857527L;
    DefaultCache cacheRoot;
    private volatile boolean destroyed = false;

    public DefaultCacheFactory() {
        this(CacheConfiguration.DEFAULT);
    }

    public DefaultCacheFactory(CacheConfiguration config) {
        this.cacheRoot = new DefaultCache("Teiid", config.getMaxEntries(), config.getMaxAgeInSeconds() * 1000);
    }

    @Override
    public void destroy() {
        this.destroyed = true;
    }

    @Override
    public <K, V> Cache<K, V> get(Cache.Type type, CacheConfiguration config) {
        if (!this.destroyed) {
            return this.cacheRoot.addChild(type.location());
        }
        throw new TeiidRuntimeException("Cache system has been shutdown");
    }

    @Override
    public boolean isReplicated() {
        return false;
    }
}

