/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.Collection;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Navigator;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.xml.QueryUtil;
import org.teiid.query.optimizer.xml.XMLPlannerEnvironment;
import org.teiid.query.optimizer.xml.XMLQueryPlanner;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;

public class XMLStagaingQueryPlanner {
    static void stageQueries(MappingDocument doc, final XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        MappingVisitor queryPlanVisitor = new MappingVisitor(){

            @Override
            public void visit(MappingSourceNode sourceNode) {
                try {
                    XMLStagaingQueryPlanner.stagePlannedQuery(sourceNode, planEnv);
                }
                catch (Exception e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
            }
        };
        XMLStagaingQueryPlanner.planWalk(doc, queryPlanVisitor);
    }

    private static void planWalk(MappingDocument doc, MappingVisitor visitor) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        try {
            Navigator walker = new Navigator(true, visitor);
            doc.acceptVisitor(walker);
        }
        catch (TeiidRuntimeException e) {
            if (e.getCause() instanceof QueryPlannerException) {
                throw (QueryPlannerException)((Object)e.getCause());
            }
            if (e.getCause() instanceof QueryMetadataException) {
                throw (QueryMetadataException)((Object)e.getCause());
            }
            if (e.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)e.getCause();
            }
            throw e;
        }
    }

    static boolean stagePlannedQuery(MappingSourceNode sourceNode, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        Option option = planEnv.xmlCommand.getOption();
        if (sourceNode.isRootSourceNode()) {
            return false;
        }
        if (sourceNode.getAliasResultName() != null) {
            return false;
        }
        String groupName = sourceNode.getActualResultSetName();
        ResultSetInfo rsInfo = sourceNode.getResultSetInfo();
        if (!rsInfo.isCriteriaRaised()) {
            return false;
        }
        QueryNode queryNode = QueryUtil.getQueryNode(groupName, planEnv.getGlobalMetadata());
        if (queryNode.getBindings() != null && !queryNode.getBindings().isEmpty()) {
            return false;
        }
        Object metadataID = planEnv.getGlobalMetadata().getGroupID(sourceNode.getResultName());
        if (RelationalPlanner.isNoCacheGroup(planEnv.getGlobalMetadata(), metadataID, option)) {
            return false;
        }
        metadataID = planEnv.getGlobalMetadata().getGroupID(sourceNode.getActualResultSetName());
        if (RelationalPlanner.isNoCacheGroup(planEnv.getGlobalMetadata(), metadataID, option)) {
            return false;
        }
        Query stagableQuery = (Query)QueryUtil.getQueryFromQueryNode(groupName, planEnv);
        Collection<GroupSymbol> groups = GroupCollectorVisitor.getGroupsIgnoreInlineViews((LanguageObject)stagableQuery, false);
        if (groups.size() == 1) {
            GroupSymbol group = groups.iterator().next();
            if (planEnv.isStagingTable((group = QueryUtil.createResolvedGroup(group.clone(), (QueryMetadataInterface)planEnv.getGlobalMetadata())).getMetadataID()) && stagableQuery.getCriteria() == null) {
                return false;
            }
        }
        stagableQuery = (Query)stagableQuery.clone();
        String stagingGroupName = planEnv.getStagedResultName(groupName);
        if (!XMLQueryPlanner.planStagaingQuery(true, groupName, stagingGroupName, stagableQuery, planEnv)) {
            return false;
        }
        sourceNode.addStagingTable(stagingGroupName);
        return true;
    }
}

