/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.processor.BatchIterator;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.proc.Program;
import org.teiid.query.processor.proc.ProgramInstruction;
import org.teiid.query.processor.proc.RepeatedInstruction;
import org.teiid.query.processor.relational.SubqueryAwareEvaluator;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.util.CommandContext;

public class ProcedurePlan
extends ProcessorPlan {
    private Program originalProgram;
    private ProcessorDataManager dataMgr;
    private ProcessorDataManager parentDataMrg;
    private BufferManager bufferMgr;
    private int batchSize;
    private boolean done = false;
    private CursorState currentState;
    private TupleSource finalTupleSource;
    private int beginBatch = 1;
    private List batchRows;
    private boolean lastBatch = false;
    private LinkedHashMap<ElementSymbol, Expression> params;
    private Map<ElementSymbol, Reference> implicitParams;
    private QueryMetadataInterface metadata;
    private Map<String, CursorState> cursorStates = new HashMap<String, CursorState>();
    private static ElementSymbol ROWS_UPDATED = new ElementSymbol("VARIABLES.ROWS_UPDATED");
    static ElementSymbol ROWCOUNT = new ElementSymbol("VARIABLES.ROWCOUNT");
    private VariableContext currentVarContext;
    private boolean isUpdateProcedure = true;
    private TupleSource lastTupleSource;
    private List outputElements;
    private TempTableStore tempTableStore;
    private LinkedList tempContext = new LinkedList();
    private SubqueryAwareEvaluator evaluator;
    private Stack<Program> programs = new Stack();
    private boolean evaluatedParams;
    private boolean requiresTransaction = true;

    public ProcedurePlan(Program originalProgram) {
        this.originalProgram = originalProgram;
        this.programs.add(originalProgram);
        this.createVariableContext();
    }

    public Program getOriginalProgram() {
        return this.originalProgram;
    }

    @Override
    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        this.bufferMgr = bufferMgr;
        this.batchSize = bufferMgr.getProcessorBatchSize();
        this.setContext(context.clone());
        this.dataMgr = dataMgr;
        this.parentDataMrg = dataMgr;
        if (this.evaluator == null) {
            this.evaluator = new SubqueryAwareEvaluator(Collections.emptyMap(), this.getDataManager(), this.getContext(), this.bufferMgr);
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.evaluator != null) {
            this.evaluator.reset();
        }
        this.evaluatedParams = false;
        this.cursorStates.clear();
        this.createVariableContext();
        this.lastTupleSource = null;
        this.done = false;
        this.currentState = null;
        this.finalTupleSource = null;
        this.beginBatch = 1;
        this.batchRows = null;
        this.lastBatch = false;
        this.originalProgram.resetProgramCounter();
        this.tempContext.clear();
        this.programs.clear();
        this.programs.push(this.originalProgram);
        LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"ProcedurePlan reset"});
    }

    public ProcessorDataManager getDataManager() {
        return this.dataMgr;
    }

    @Override
    public void open() throws TeiidProcessingException, TeiidComponentException {
        if (!this.evaluatedParams) {
            if (this.params != null) {
                for (Map.Entry<ElementSymbol, Expression> entry : this.params.entrySet()) {
                    ElementSymbol param = entry.getKey();
                    Expression expr = entry.getValue();
                    VariableContext context = this.getCurrentVariableContext();
                    Object value = this.evaluateExpression(expr);
                    if (value == null && !this.metadata.elementSupports(param.getMetadataID(), 4)) {
                        throw new QueryValidatorException(QueryPlugin.Util.getString("ProcedurePlan.nonNullableParam", new Object[]{expr}));
                    }
                    this.setParameterValue(param, context, value);
                }
            }
            if (this.implicitParams != null) {
                for (Map.Entry<ElementSymbol, Expression> entry : this.implicitParams.entrySet()) {
                    VariableContext context = this.getCurrentVariableContext();
                    Object value = this.evaluateExpression(entry.getValue());
                    context.setValue(entry.getKey(), value);
                }
            }
            this.tempTableStore = new TempTableStore(this.getContext().getConnectionID());
            this.getContext().setTempTableStore(this.tempTableStore);
        }
        this.evaluatedParams = true;
    }

    protected void setParameterValue(ElementSymbol param, VariableContext context, Object value) {
        context.setValue(param, value);
    }

    @Override
    public TupleBatch nextBatch() throws TeiidComponentException, TeiidProcessingException, BlockedException {
        if (this.done) {
            TupleBatch emptyTerminationBatch = new TupleBatch(this.beginBatch, new List[0]);
            emptyTerminationBatch.setTerminationFlag(true);
            return emptyTerminationBatch;
        }
        if (this.finalTupleSource == null) {
            this.finalTupleSource = this.processProcedure();
        }
        while (!this.isBatchFull()) {
            List<?> tuple = this.finalTupleSource.nextTuple();
            if (tuple == null) {
                this.terminateBatches();
                this.done = true;
                break;
            }
            this.addBatchRow(tuple);
        }
        return this.pullBatch();
    }

    private TupleSource processProcedure() throws TeiidComponentException, TeiidProcessingException, BlockedException {
        ProgramInstruction inst = null;
        while (!this.programs.empty()) {
            Program program = this.peek();
            inst = program.getCurrentInstruction();
            if (inst == null) {
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Finished program", program});
                this.pop();
                continue;
            }
            if (inst instanceof RepeatedInstruction) {
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Executing repeated instruction", inst});
                RepeatedInstruction loop = (RepeatedInstruction)((Object)inst);
                if (loop.testCondition(this)) {
                    LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Passed condition, executing program " + loop.getNestedProgram()});
                    inst.process(this);
                    this.push(loop.getNestedProgram());
                    continue;
                }
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Exiting repeated instruction", inst});
                loop.postInstruction(this);
            } else {
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Executing instruction", inst});
                inst.process(this);
            }
            program.incrementProgramCounter();
        }
        if (this.isUpdateProcedure) {
            return this.getUpdateCountAsToupleSource();
        }
        if (this.lastTupleSource == null) {
            return CollectionTupleSource.createNullTupleSource();
        }
        return this.lastTupleSource;
    }

    @Override
    public void close() throws TeiidComponentException {
        if (!this.cursorStates.isEmpty()) {
            ArrayList<String> cursors = new ArrayList<String>(this.cursorStates.keySet());
            for (String rsName : cursors) {
                this.removeResults(rsName);
            }
        }
        if (this.getTempTableStore() != null) {
            this.getTempTableStore().removeTempTables();
        }
        if (this.evaluator != null) {
            this.evaluator.close();
        }
        this.tempTableStore = null;
        this.dataMgr = this.parentDataMrg;
    }

    public String toString() {
        return "ProcedurePlan:\n" + this.originalProgram;
    }

    @Override
    public ProcessorPlan clone() {
        ProcedurePlan plan = new ProcedurePlan((Program)this.originalProgram.clone());
        plan.setUpdateProcedure(this.isUpdateProcedure());
        plan.setOutputElements(this.getOutputElements());
        plan.setParams(this.params);
        plan.setImplicitParams(this.implicitParams);
        plan.setMetadata(this.metadata);
        plan.requiresTransaction = this.requiresTransaction;
        return plan;
    }

    private void addBatchRow(List row) {
        if (this.batchRows == null) {
            this.batchRows = new ArrayList(this.batchSize);
        }
        this.batchRows.add(row);
    }

    protected void terminateBatches() {
        this.lastBatch = true;
    }

    protected boolean isBatchFull() {
        return this.batchRows != null && this.batchRows.size() == this.batchSize;
    }

    protected TupleBatch pullBatch() {
        TupleBatch batch = null;
        if (this.batchRows != null) {
            batch = new TupleBatch(this.beginBatch, this.batchRows);
            this.beginBatch += this.batchRows.size();
        } else {
            batch = new TupleBatch(this.beginBatch, Collections.EMPTY_LIST);
        }
        batch.setTerminationFlag(this.lastBatch);
        this.batchRows = null;
        this.lastBatch = false;
        return batch;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode node = this.originalProgram.getDescriptionProperties();
        node.addProperty("Output Columns", AnalysisRecord.getOutputColumnProperties(this.getOutputElements()));
        return node;
    }

    public void setMetadata(QueryMetadataInterface metadata) {
        this.metadata = metadata;
    }

    public void setParams(LinkedHashMap<ElementSymbol, Expression> params) {
        this.params = params;
    }

    public void setImplicitParams(Map<ElementSymbol, Reference> implicitParams) {
        this.implicitParams = implicitParams;
    }

    private void createVariableContext() {
        this.currentVarContext = new VariableContext(true);
        this.currentVarContext.setValue(ROWS_UPDATED, 0);
        this.currentVarContext.setValue(ROWCOUNT, 0);
    }

    private TupleSource getUpdateCountAsToupleSource() {
        Object rowCount = this.currentVarContext.getValue(ROWS_UPDATED);
        if (rowCount == null) {
            rowCount = 0;
        }
        return CollectionTupleSource.createUpdateCountTupleSource((Integer)rowCount);
    }

    public VariableContext getCurrentVariableContext() {
        return this.currentVarContext;
    }

    public void executePlan(ProcessorPlan command, String rsName, Map<ElementSymbol, ElementSymbol> procAssignments, boolean keepRs) throws TeiidComponentException, TeiidProcessingException {
        CursorState state = this.cursorStates.get(rsName.toUpperCase());
        if (state == null) {
            if (this.currentState == null) {
                command.reset();
                CommandContext subContext = this.getContext().clone();
                subContext.setVariableContext(this.currentVarContext);
                subContext.setTempTableStore(this.getTempTableStore());
                state = new CursorState();
                state.processor = new QueryProcessor(command, subContext, this.bufferMgr, this.dataMgr);
                state.ts = new BatchIterator(state.processor);
                if (procAssignments != null && state.processor.getOutputElements().size() - procAssignments.size() > 0) {
                    state.resultsBuffer = this.bufferMgr.createTupleBuffer(state.processor.getOutputElements().subList(0, state.processor.getOutputElements().size() - procAssignments.size()), this.getContext().getConnectionID(), BufferManager.TupleSourceType.PROCESSOR);
                }
                this.currentState = state;
            }
            this.currentState.ts.hasNext();
            if (procAssignments != null) {
                while (this.currentState.ts.hasNext()) {
                    if (this.currentState.currentRow != null && this.currentState.resultsBuffer != null) {
                        this.currentState.resultsBuffer.addTuple(this.currentState.currentRow.subList(0, this.currentState.resultsBuffer.getSchema().size()));
                        this.currentState.currentRow = null;
                    }
                    this.currentState.currentRow = this.currentState.ts.nextTuple();
                }
                Assertion.assertTrue((this.currentState.currentRow != null ? 1 : 0) != 0);
                for (Map.Entry<ElementSymbol, ElementSymbol> entry : procAssignments.entrySet()) {
                    if (entry.getValue() == null) continue;
                    int index = this.currentState.processor.getOutputElements().indexOf(entry.getKey());
                    this.getCurrentVariableContext().setValue(entry.getValue(), DataTypeManager.transformValue(this.currentState.currentRow.get(index), (Class)entry.getValue().getType()));
                }
                if (this.currentState.resultsBuffer == null) {
                    this.currentState.processor.closeProcessing();
                    this.currentState = null;
                    return;
                }
                this.currentState.resultsBuffer.close();
                this.currentState.ts = this.currentState.resultsBuffer.createIndexedTupleSource();
            }
            this.cursorStates.put(rsName.toUpperCase(), this.currentState);
            if (keepRs) {
                this.lastTupleSource = this.currentState.ts;
            }
            this.currentState = null;
        }
    }

    public void pop() throws TeiidComponentException {
        Program program = this.programs.pop();
        if (this.currentVarContext.getParentContext() != null) {
            this.currentVarContext = this.currentVarContext.getParentContext();
        }
        Set current = this.getTempContext();
        Set tempTables = this.getLocalTempTables();
        tempTables.addAll(current);
        if (program != this.originalProgram) {
            Iterator i = tempTables.iterator();
            while (i.hasNext()) {
                this.tempTableStore.removeTempTableByName((String)i.next());
            }
        }
        this.tempContext.removeLast();
    }

    public void push(Program program) {
        program.resetProgramCounter();
        this.programs.push(program);
        VariableContext context = new VariableContext(true);
        context.setParentContext(this.currentVarContext);
        this.currentVarContext = context;
        Set current = this.getTempContext();
        Set tempTables = this.getLocalTempTables();
        current.addAll(tempTables);
        this.tempContext.add(new HashSet());
    }

    public void incrementProgramCounter() throws TeiidComponentException {
        Program program = this.peek();
        ProgramInstruction instr = program.getCurrentInstruction();
        if (instr instanceof RepeatedInstruction) {
            RepeatedInstruction repeated = (RepeatedInstruction)((Object)instr);
            repeated.postInstruction(this);
        }
        this.peek().incrementProgramCounter();
    }

    private Set getLocalTempTables() {
        Set<String> tempTables = this.tempTableStore.getAllTempTables();
        for (int i = 0; i < this.tempContext.size() - 1; ++i) {
            tempTables.removeAll((Set)this.tempContext.get(i));
        }
        return tempTables;
    }

    public Set getTempContext() {
        if (this.tempContext.isEmpty()) {
            this.tempContext.addLast(new HashSet());
        }
        return (Set)this.tempContext.getLast();
    }

    public List getCurrentRow(String rsName) throws TeiidComponentException {
        return this.getCursorState((String)rsName.toUpperCase()).currentRow;
    }

    public boolean iterateCursor(String rsName) throws TeiidComponentException, TeiidProcessingException {
        String rsKey = rsName.toUpperCase();
        CursorState state = this.getCursorState(rsKey);
        state.currentRow = state.ts.nextTuple();
        return state.currentRow != null;
    }

    private CursorState getCursorState(String rsKey) throws TeiidComponentException {
        CursorState state = this.cursorStates.get(rsKey);
        if (state == null) {
            throw new TeiidComponentException(QueryPlugin.Util.getString("ERR.015.006.0037", new Object[]{rsKey}));
        }
        return state;
    }

    public void removeResults(String rsName) {
        String rsKey = rsName.toUpperCase();
        CursorState state = this.cursorStates.remove(rsKey);
        if (state != null) {
            state.processor.closeProcessing();
            if (state.resultsBuffer != null) {
                state.resultsBuffer.remove();
            }
        }
    }

    public List getSchema(String rsName) throws TeiidComponentException {
        String rsKey = rsName.toUpperCase();
        CursorState cursorState = this.getCursorState(rsKey);
        List schema = cursorState.processor.getOutputElements();
        return schema;
    }

    public boolean resultSetExists(String rsName) {
        String rsKey = rsName.toUpperCase();
        boolean exists = this.cursorStates.containsKey(rsKey);
        return exists;
    }

    @Override
    public CommandContext getContext() {
        CommandContext context = super.getContext();
        if (this.evaluatedParams) {
            context.setVariableContext(this.currentVarContext);
        }
        return context;
    }

    public boolean isUpdateProcedure() {
        return this.isUpdateProcedure;
    }

    public void setUpdateProcedure(boolean b) {
        this.isUpdateProcedure = b;
    }

    @Override
    public List getOutputElements() {
        return this.outputElements;
    }

    public void setOutputElements(List outputElements) {
        this.outputElements = outputElements;
    }

    public TempTableStore getTempTableStore() {
        return this.tempTableStore;
    }

    boolean evaluateCriteria(Criteria condition) throws BlockedException, TeiidProcessingException, TeiidComponentException {
        this.evaluator.initialize(this.getContext(), this.getDataManager());
        boolean result = this.evaluator.evaluate(condition, Collections.emptyList());
        this.evaluator.close();
        return result;
    }

    Object evaluateExpression(Expression expression) throws BlockedException, TeiidProcessingException, TeiidComponentException {
        this.evaluator.initialize(this.getContext(), this.getDataManager());
        Object result = this.evaluator.evaluate(expression, Collections.emptyList());
        this.evaluator.close();
        return result;
    }

    public Program peek() {
        return this.programs.peek();
    }

    public void setRequiresTransaction(boolean requiresTransaction) {
        this.requiresTransaction = requiresTransaction;
    }

    @Override
    public boolean requiresTransaction(boolean transactionalReads) {
        return this.requiresTransaction || transactionalReads;
    }

    private static class CursorState {
        QueryProcessor processor;
        IndexedTupleSource ts;
        List<?> currentRow;
        TupleBuffer resultsBuffer;

        private CursorState() {
        }
    }
}

