/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.Map;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.logging.LogManager;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.processor.xml.PlanExecutor;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;

public class ExecStagingTableInstruction
extends ProcessorInstruction {
    String resultSetName;
    ResultSetInfo info;

    public ExecStagingTableInstruction(String resultName, ResultSetInfo info) {
        this.resultSetName = resultName;
        this.info = info;
    }

    @Override
    public XMLContext process(XMLProcessorEnvironment env, XMLContext context) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (!env.isStagingTableLoaded(this.resultSetName)) {
            LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"SQL: Result set DOESN'T exist:", this.resultSetName});
            PlanExecutor executor = context.getResultExecutor(this.resultSetName);
            if (executor == null) {
                executor = env.createResultExecutor(this.resultSetName, this.info);
                context.setResultExecutor(this.resultSetName, executor);
            }
            Map referenceValues = null;
            executor.execute(referenceValues);
            env.markStagingTableAsLoaded(this.resultSetName);
            context.removeResultExecutor(this.resultSetName);
        }
        env.incrementCurrentProgramCounter();
        return context;
    }

    public String toString() {
        return "STAGING:" + this.resultSetName;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("Staging Table");
        props.addProperty("Result Set", this.resultSetName);
        props.addProperty("Is Staging Flag", "true");
        props.addProperty("Query", this.info.getPlan().getDescriptionProperties());
        return props;
    }
}

