/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public abstract class Criteria
implements Expression {
    @Override
    public abstract Object clone();

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public static List<Criteria> separateCriteriaByAnd(Criteria crit) {
        if (crit == null) {
            return Collections.emptyList();
        }
        ArrayList<Criteria> parts = new ArrayList<Criteria>();
        Criteria.separateCriteria(crit, parts);
        return parts;
    }

    public static Criteria combineCriteria(List parts) {
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        if (parts.size() == 1) {
            return (Criteria)parts.get(0);
        }
        return new CompoundCriteria(parts);
    }

    private static void separateCriteria(Criteria crit, Collection<Criteria> parts) {
        if (crit instanceof CompoundCriteria) {
            CompoundCriteria compCrit = (CompoundCriteria)crit;
            if (compCrit.getOperator() == 0) {
                for (Criteria conjunct : compCrit.getCriteria()) {
                    Criteria.separateCriteria(conjunct, parts);
                }
            } else {
                parts.add(crit);
            }
        } else {
            parts.add(crit);
        }
    }

    public static Criteria combineCriteria(Criteria primaryCrit, Criteria additionalCrit) {
        return Criteria.combineCriteria(primaryCrit, additionalCrit, false);
    }

    public static Criteria combineCriteria(Criteria primaryCrit, Criteria additionalCrit, boolean disjunctively) {
        if (primaryCrit == null) {
            return additionalCrit;
        }
        if (additionalCrit == null) {
            return primaryCrit;
        }
        CompoundCriteria compCrit = new CompoundCriteria();
        compCrit.setOperator(disjunctively ? 1 : 0);
        if (primaryCrit instanceof CompoundCriteria && ((CompoundCriteria)primaryCrit).getOperator() == (disjunctively ? 1 : 0)) {
            compCrit.getCriteria().addAll(((CompoundCriteria)primaryCrit).getCriteria());
        } else {
            compCrit.addCriteria(primaryCrit);
        }
        if (additionalCrit instanceof CompoundCriteria && ((CompoundCriteria)additionalCrit).getOperator() == (disjunctively ? 1 : 0)) {
            compCrit.getCriteria().addAll(((CompoundCriteria)additionalCrit).getCriteria());
        } else {
            compCrit.addCriteria(additionalCrit);
        }
        return compCrit;
    }

    public static Criteria toDisjunctiveNormalForm(Criteria input) {
        return Criteria.normalize(input, true);
    }

    public static Criteria toConjunctiveNormalForm(Criteria input) {
        return Criteria.normalize(input, false);
    }

    static Criteria normalize(Criteria input, boolean dnf) {
        boolean invert = false;
        if (input instanceof NotCriteria) {
            NotCriteria not = (NotCriteria)input;
            Criteria child = not.getCriteria();
            if (child instanceof NotCriteria) {
                return Criteria.normalize(((NotCriteria)child).getCriteria(), dnf);
            }
            if (child instanceof CompoundCriteria) {
                invert = true;
                input = child;
            }
        }
        if (!(input instanceof CompoundCriteria)) {
            return input;
        }
        CompoundCriteria compCrit = (CompoundCriteria)input;
        int operator = compCrit.getOperator();
        if (invert) {
            operator = operator == 1 ? 0 : 1;
        }
        ArrayList<Criteria> criteria = new ArrayList<Criteria>(compCrit.getCriteria().size());
        LinkedList<CompoundCriteria> parts = new LinkedList<CompoundCriteria>();
        for (Criteria crit : compCrit.getCriteria()) {
            if (invert) {
                crit = new NotCriteria(crit);
            }
            if ((crit = Criteria.normalize(crit, dnf)) instanceof CompoundCriteria) {
                CompoundCriteria child = (CompoundCriteria)crit;
                if (operator == child.getOperator()) {
                    criteria.addAll(child.getCriteria());
                    continue;
                }
                if (dnf && operator == 0 || !dnf && operator == 1) {
                    parts.add(child);
                    continue;
                }
            }
            criteria.add(crit);
        }
        if (parts.isEmpty()) {
            return new CompoundCriteria(operator, criteria);
        }
        int total = 1;
        int[] divisors = new int[parts.size()];
        for (int i = 0; i < parts.size(); ++i) {
            divisors[i] = total;
            total *= ((CompoundCriteria)parts.get(i)).getCriteriaCount();
        }
        ArrayList<CompoundCriteria> newCrits = new ArrayList<CompoundCriteria>(total);
        for (int i = 0; i < total; ++i) {
            CompoundCriteria crit = new CompoundCriteria(dnf ? 0 : 1, new ArrayList(parts.size() + criteria.size()));
            crit.getCriteria().addAll(criteria);
            for (int j = 0; j < parts.size(); ++j) {
                CompoundCriteria disjunct = (CompoundCriteria)parts.get(j);
                Criteria part = disjunct.getCriteria().get(i / divisors[j] % disjunct.getCriteriaCount());
                crit.addCriteria(part);
            }
            newCrits.add(crit);
        }
        return new CompoundCriteria(!dnf ? 0 : 1, newCrits);
    }

    @Override
    public Class getType() {
        return DataTypeManager.DefaultDataClasses.BOOLEAN;
    }

    @Override
    public boolean isResolved() {
        return true;
    }
}

