/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Symbol;

public class GroupSymbol
extends Symbol
implements Comparable<GroupSymbol> {
    public static final String TEMP_GROUP_PREFIX = "#";
    private String definition;
    private Object metadataID;
    private boolean isTempTable;
    private boolean isGlobalTable;
    private boolean isProcedure;
    private Object modelMetadataId;
    private String outputDefinition;

    protected GroupSymbol(String name, String canonicalName, String definition) {
        super(name, canonicalName);
        this.setDefinition(definition);
    }

    public GroupSymbol(String name) {
        super(name);
    }

    public GroupSymbol(String name, String definition) {
        super(name);
        this.setDefinition(definition);
    }

    public Object getModelMetadataId() {
        return this.modelMetadataId;
    }

    public void setModelMetadataId(Object modelMetadataId) {
        this.modelMetadataId = modelMetadataId;
    }

    public String getNonCorrelationName() {
        if (this.definition == null) {
            return this.getName();
        }
        return this.getDefinition();
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
        this.outputDefinition = definition;
    }

    public Object getMetadataID() {
        return this.metadataID;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public void setMetadataID(Object metadataID) {
        if (metadataID == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0016"));
        }
        this.metadataID = metadataID;
    }

    @Override
    public boolean isResolved() {
        return this.metadataID != null;
    }

    public boolean isTempGroupSymbol() {
        return this.isTempTable || this.isImplicitTempGroupSymbol();
    }

    public boolean isImplicitTempGroupSymbol() {
        return GroupSymbol.isTempGroupName(this.getNonCorrelationName());
    }

    @Override
    public int compareTo(GroupSymbol o) {
        return this.getCanonicalName().compareTo(o.getCanonicalName());
    }

    @Override
    public GroupSymbol clone() {
        GroupSymbol copy = new GroupSymbol(this.getName(), this.getCanonical(), this.getDefinition());
        if (this.getMetadataID() != null) {
            copy.setMetadataID(this.getMetadataID());
        }
        copy.setIsTempTable(this.isTempTable);
        copy.setProcedure(this.isProcedure);
        copy.setOutputDefinition(this.getOutputDefinition());
        copy.setOutputName(this.getOutputName());
        copy.isGlobalTable = this.isGlobalTable;
        copy.modelMetadataId = this.modelMetadataId;
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GroupSymbol)) {
            return false;
        }
        GroupSymbol other = (GroupSymbol)obj;
        if (this.getDefinition() == null && other.getDefinition() == null || this.getDefinition() != null && other.getDefinition() != null) {
            return this.getCanonicalName().equals(other.getCanonicalName());
        }
        return false;
    }

    public boolean hasAlias() {
        return this.getDefinition() != null;
    }

    public void setIsTempTable(boolean isTempTable) {
        this.isTempTable = isTempTable;
    }

    public static boolean isTempGroupName(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith(TEMP_GROUP_PREFIX);
    }

    public boolean isTempTable() {
        return this.isTempTable;
    }

    public boolean isProcedure() {
        return this.isProcedure;
    }

    public void setProcedure(boolean isProcedure) {
        this.isProcedure = isProcedure;
    }

    public String getOutputDefinition() {
        return this.outputDefinition;
    }

    public void setOutputDefinition(String outputDefinition) {
        this.outputDefinition = outputDefinition;
    }

    public boolean isGlobalTable() {
        return this.isGlobalTable;
    }

    public void setGlobalTable(boolean isGlobalTable) {
        this.isGlobalTable = isGlobalTable;
    }
}

