/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.Assertion;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.proc.CriteriaSelector;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;

public class CriteriaTranslatorVisitor
extends ExpressionMappingVisitor {
    private CriteriaSelector selector;
    private Collection translations;
    private Map<ElementSymbol, Reference> implicitParams = new HashMap<ElementSymbol, Reference>();

    public CriteriaTranslatorVisitor() {
        this(null);
    }

    public CriteriaTranslatorVisitor(Map symbolMap) {
        super(symbolMap);
        Assertion.isNotNull((Object)symbolMap);
    }

    public void setCriteriaSelector(CriteriaSelector selector) {
        this.selector = selector;
    }

    public void setTranslations(Collection translations) {
        this.translations = translations;
    }

    private boolean selectorContainsCriteriaElements(Criteria criteria, int criteriaType) {
        int selectorType = this.selector.getSelectorType();
        if (selectorType != 0 && selectorType != criteriaType) {
            return false;
        }
        if (this.selector.hasElements()) {
            Iterator selectElmnIter = this.selector.getElements().iterator();
            Collection<ElementSymbol> critElmnts = ElementCollectorVisitor.getElements((LanguageObject)criteria, true);
            while (selectElmnIter.hasNext()) {
                ElementSymbol selectElmnt = (ElementSymbol)selectElmnIter.next();
                if (!critElmnts.contains(selectElmnt)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Expression replaceExpression(Expression obj) {
        if (this.translations != null && obj instanceof ElementSymbol) {
            for (CompareCriteria compCrit : this.translations) {
                Collection<ElementSymbol> leftElmnts = ElementCollectorVisitor.getElements((LanguageObject)compCrit.getLeftExpression(), true);
                ElementSymbol element = leftElmnts.iterator().next();
                if (!obj.equals(element)) continue;
                return compCrit.getRightExpression();
            }
        }
        if (obj instanceof Reference) {
            Reference implicit = (Reference)obj;
            ElementSymbol key = null;
            key = implicit.isPositional() ? new ElementSymbol("$INPUT." + implicit.getContextSymbol()) : new ElementSymbol("$INPUT." + implicit.getExpression().getName());
            key.setType(implicit.getType());
            this.implicitParams.put(key, implicit);
            return new Reference(key);
        }
        return super.replaceExpression(obj);
    }

    public Map<ElementSymbol, Reference> getImplicitParams() {
        return this.implicitParams;
    }

    public void translate(Criteria crit) throws QueryValidatorException {
        CriteriaTranslatorNavigator nav = new CriteriaTranslatorNavigator();
        try {
            crit.acceptVisitor(nav);
        }
        catch (TeiidRuntimeException e) {
            throw (QueryValidatorException)((Object)e.getCause());
        }
    }

    class CriteriaTranslatorNavigator
    extends PreOrderNavigator {
        public CriteriaTranslatorNavigator() {
            super(CriteriaTranslatorVisitor.this);
        }

        @Override
        public void visit(BetweenCriteria obj) {
            if (!CriteriaTranslatorVisitor.this.selectorContainsCriteriaElements(obj, 10)) {
                throw new TeiidRuntimeException((Throwable)((Object)new QueryValidatorException(QueryPlugin.Util.getString("Translate.error", new Object[]{obj, CriteriaTranslatorVisitor.this.selector}))));
            }
            super.visit(obj);
        }

        @Override
        public void visit(CompareCriteria obj) {
            if (!CriteriaTranslatorVisitor.this.selectorContainsCriteriaElements(obj, obj.getOperator())) {
                throw new TeiidRuntimeException((Throwable)((Object)new QueryValidatorException(QueryPlugin.Util.getString("Translate.error", new Object[]{obj, CriteriaTranslatorVisitor.this.selector}))));
            }
            super.visit(obj);
        }

        @Override
        public void visit(IsNullCriteria obj) {
            if (!CriteriaTranslatorVisitor.this.selectorContainsCriteriaElements(obj, 9)) {
                throw new TeiidRuntimeException((Throwable)((Object)new QueryValidatorException(QueryPlugin.Util.getString("Translate.error", new Object[]{obj, CriteriaTranslatorVisitor.this.selector}))));
            }
            super.visit(obj);
        }

        @Override
        public void visit(MatchCriteria obj) {
            if (!CriteriaTranslatorVisitor.this.selectorContainsCriteriaElements(obj, 7)) {
                throw new TeiidRuntimeException((Throwable)((Object)new QueryValidatorException(QueryPlugin.Util.getString("Translate.error", new Object[]{obj, CriteriaTranslatorVisitor.this.selector}))));
            }
            super.visit(obj);
        }

        @Override
        public void visit(SetCriteria obj) {
            if (!CriteriaTranslatorVisitor.this.selectorContainsCriteriaElements(obj, 8)) {
                throw new TeiidRuntimeException((Throwable)((Object)new QueryValidatorException(QueryPlugin.Util.getString("Translate.error", new Object[]{obj, CriteriaTranslatorVisitor.this.selector}))));
            }
            super.visit(obj);
        }

        @Override
        public void visit(DependentSetCriteria obj) {
            if (!CriteriaTranslatorVisitor.this.selectorContainsCriteriaElements(obj, 8)) {
                throw new TeiidRuntimeException((Throwable)((Object)new QueryValidatorException(QueryPlugin.Util.getString("Translate.error", new Object[]{obj, CriteriaTranslatorVisitor.this.selector}))));
            }
            super.visit(obj);
        }
    }
}

