/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.dqp.internal.process.CachedResults;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.navigator.PostOrderNavigator;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.tempdata.TempTable;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.util.CommandContext;
import org.teiid.vdb.runtime.VDBKey;

public class TempTableDataManager
implements ProcessorDataManager {
    private static final String REFRESHMATVIEWROW = ".refreshmatviewrow";
    private static final String REFRESHMATVIEW = ".refreshmatview";
    private static final String CODE_PREFIX = "#CODE_";
    private ProcessorDataManager processorDataManager;
    private BufferManager bufferManager;
    private SessionAwareCache<CachedResults> cache;
    private Executor executor;
    private Cache<MatTableKey, MatTableEntry> tables;
    private SessionAwareCache<CachedResults> distributedCache;

    public TempTableDataManager(ProcessorDataManager processorDataManager, BufferManager bufferManager, Executor executor, SessionAwareCache<CachedResults> cache, SessionAwareCache<CachedResults> distibutedCache, CacheFactory cacheFactory) {
        this.processorDataManager = processorDataManager;
        this.bufferManager = bufferManager;
        this.executor = executor;
        this.cache = cache;
        this.distributedCache = distibutedCache;
        if (distibutedCache != null) {
            CacheConfiguration cc = new CacheConfiguration(CacheConfiguration.Policy.LRU, -1, -1);
            this.tables = cacheFactory.get(Cache.Type.MATTABLES, cc);
        }
    }

    @Override
    public TupleSource registerRequest(CommandContext context, Command command, String modelName, String connectorBindingId, int nodeID) throws TeiidComponentException, TeiidProcessingException {
        TupleSource result;
        TempTableStore tempTableStore = context.getTempTableStore();
        if (tempTableStore != null && (result = this.registerRequest(context, modelName, command)) != null) {
            return result;
        }
        return this.processorDataManager.registerRequest(context, command, modelName, connectorBindingId, nodeID);
    }

    TupleSource registerRequest(CommandContext context, String modelName, Command command) throws TeiidComponentException, TeiidProcessingException {
        TempTableStore contextStore = context.getTempTableStore();
        if (command instanceof Query) {
            Query query = (Query)command;
            return this.registerQuery(context, contextStore, query);
        }
        if (command instanceof ProcedureContainer) {
            if (command instanceof StoredProcedure) {
                StoredProcedure proc = (StoredProcedure)command;
                if ("SYSADMIN".equals(modelName)) {
                    TupleSource result = this.handleSystemProcedures(context, proc);
                    if (result != null) {
                        return result;
                    }
                } else if (proc.getGroup().isGlobalTable()) {
                    return this.handleCachedProcedure(context, proc);
                }
                return null;
            }
            GroupSymbol group = ((ProcedureContainer)command).getGroup();
            if (!group.isTempGroupSymbol()) {
                return null;
            }
            String groupKey = group.getNonCorrelationName().toUpperCase();
            TempTable table = contextStore.getOrCreateTempTable(groupKey, command, this.bufferManager, false);
            if (command instanceof Insert) {
                Insert insert = (Insert)command;
                TupleSource ts = insert.getTupleSource();
                if (ts == null) {
                    ArrayList<Object> values = new ArrayList<Object>(insert.getValues().size());
                    for (Expression expr : insert.getValues()) {
                        values.add(Evaluator.evaluate(expr));
                    }
                    ts = new CollectionTupleSource(Arrays.asList(values).iterator());
                }
                return table.insert(ts, insert.getVariables());
            }
            if (command instanceof Update) {
                Update update = (Update)command;
                Criteria crit = update.getCriteria();
                return table.update(crit, update.getChangeList());
            }
            if (command instanceof Delete) {
                Delete delete = (Delete)command;
                Criteria crit = delete.getCriteria();
                if (crit == null) {
                    int rows = table.truncate();
                    return CollectionTupleSource.createUpdateCountTupleSource(rows);
                }
                return table.delete(crit);
            }
        }
        if (command instanceof Create) {
            Create create = (Create)command;
            String tempTableName = create.getTable().getCanonicalName();
            if (contextStore.hasTempTable(tempTableName)) {
                throw new QueryProcessingException(QueryPlugin.Util.getString("TempTableStore.table_exist_error", new Object[]{tempTableName}));
            }
            contextStore.addTempTable(tempTableName, create, this.bufferManager, true);
            return CollectionTupleSource.createUpdateCountTupleSource(0);
        }
        if (command instanceof Drop) {
            String tempTableName = ((Drop)command).getTable().getCanonicalName();
            contextStore.removeTempTableByName(tempTableName);
            return CollectionTupleSource.createUpdateCountTupleSource(0);
        }
        return null;
    }

    private TupleSource handleCachedProcedure(CommandContext context, StoredProcedure proc) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException {
        String fullName = context.getMetadata().getFullName(proc.getProcedureID());
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"processing cached procedure request for", fullName});
        LinkedList<Object> vals = new LinkedList<Object>();
        for (SPParameter param : proc.getInputParameters()) {
            vals.add(((Constant)param.getExpression()).getValue());
        }
        int hash = vals.hashCode();
        hash |= hash >>> 16;
        hash |= hash >>> 8;
        SessionAwareCache.CacheID cid = new SessionAwareCache.CacheID(new ParseInfo(), fullName + (hash &= 0xFF), context.getVdbName(), context.getVdbVersion(), context.getConnectionID(), context.getUserName());
        cid.setParameters(vals);
        CachedResults results = this.cache.get(cid);
        if (results != null) {
            TupleBuffer buffer = results.getResults();
            return buffer.createIndexedTupleSource();
        }
        CacheHint hint = proc.getCacheHint();
        proc.setCacheHint(null);
        Option option = new Option();
        option.setNoCache(true);
        option.addNoCacheGroup(fullName);
        proc.setOption(option);
        int determinismLevel = context.resetDeterminismLevel();
        QueryProcessor qp = context.getQueryProcessorFactory().createQueryProcessor(proc.toString(), fullName.toUpperCase(), context, new Object[0]);
        qp.setNonBlocking(true);
        BatchCollector bc = qp.createBatchCollector();
        TupleBuffer tb = bc.collectTuples();
        CachedResults cr = new CachedResults();
        cr.setResults(tb);
        cr.setHint(hint);
        this.cache.put(cid, context.getDeterminismLevel(), cr, hint != null ? hint.getTtl() : null);
        context.setDeterminismLevel(determinismLevel);
        return tb.createIndexedTupleSource();
    }

    private TupleSource handleSystemProcedures(CommandContext context, StoredProcedure proc) throws TeiidComponentException, QueryMetadataException, QueryProcessingException, QueryResolverException, QueryValidatorException, TeiidProcessingException, ExpressionEvaluationException {
        QueryMetadataInterface metadata = context.getMetadata();
        TempTableStore globalStore = context.getGlobalTableStore();
        if (StringUtil.endsWithIgnoreCase((String)proc.getProcedureCallableName(), (String)REFRESHMATVIEW)) {
            TempTableStore.MatState oldState;
            Object groupID = this.validateMatView(metadata, proc);
            String matViewName = metadata.getFullName(groupID);
            String matTableName = "#MAT_" + matViewName.toUpperCase();
            LogManager.logDetail((String)"org.teiid.PROCESSOR.MATVIEWS", (Object[])new Object[]{"processing refreshmatview for", matViewName});
            TempTableStore.MatTableInfo info = globalStore.getMatTableInfo(matTableName);
            boolean invalidate = Boolean.TRUE.equals(((Constant)proc.getParameter(1).getExpression()).getValue());
            if (invalidate) {
                this.touchTable(context, matTableName, false);
            }
            if ((oldState = info.setState(TempTableStore.MatState.NEEDS_LOADING, invalidate ? Boolean.FALSE : null, null)) == TempTableStore.MatState.LOADING) {
                return CollectionTupleSource.createUpdateCountTupleSource(-1);
            }
            GroupSymbol group = new GroupSymbol(matViewName);
            group.setMetadataID(groupID);
            Object matTableId = RelationalPlanner.getGlobalTempTableMetadataId(group, matTableName, context, metadata, AnalysisRecord.createNonRecordingRecord());
            GroupSymbol matTable = new GroupSymbol(matTableName);
            matTable.setMetadataID(matTableId);
            int rowCount = this.loadGlobalTable(context, matTable, matTableName, globalStore, info, null);
            return CollectionTupleSource.createUpdateCountTupleSource(rowCount);
        }
        if (StringUtil.endsWithIgnoreCase((String)proc.getProcedureCallableName(), (String)REFRESHMATVIEWROW)) {
            List<?> result;
            Object groupID = this.validateMatView(metadata, proc);
            Object pk = metadata.getPrimaryKey(groupID);
            String matViewName = metadata.getFullName(groupID);
            if (pk == null) {
                throw new QueryProcessingException(QueryPlugin.Util.getString("TempTableDataManager.row_refresh_pk", new Object[]{matViewName}));
            }
            List ids = metadata.getElementIDsInKey(pk);
            if (ids.size() > 1) {
                throw new QueryProcessingException(QueryPlugin.Util.getString("TempTableDataManager.row_refresh_composite", new Object[]{matViewName}));
            }
            String matTableName = "#MAT_" + matViewName.toUpperCase();
            TempTableStore.MatTableInfo info = globalStore.getMatTableInfo(matTableName);
            if (!info.isValid()) {
                return CollectionTupleSource.createUpdateCountTupleSource(-1);
            }
            TempTable tempTable = globalStore.getOrCreateTempTable(matTableName, new Query(), this.bufferManager, false);
            if (!tempTable.isUpdatable()) {
                throw new QueryProcessingException(QueryPlugin.Util.getString("TempTableDataManager.row_refresh_updatable", new Object[]{matViewName}));
            }
            Constant key = (Constant)proc.getParameter(2).getExpression();
            LogManager.logInfo((String)"org.teiid.PROCESSOR.MATVIEWS", (String)QueryPlugin.Util.getString("TempTableDataManager.row_refresh", new Object[]{matViewName, key}));
            String queryString = "SELECT * FROM " + matViewName + ' ' + "WHERE" + ' ' + metadata.getFullName(ids.iterator().next()) + " = ?" + ' ' + "OPTION" + ' ' + "NOCACHE";
            QueryProcessor qp = context.getQueryProcessorFactory().createQueryProcessor(queryString, matViewName.toUpperCase(), context, key.getValue());
            qp.setNonBlocking(true);
            BatchCollector.BatchProducerTupleSource ts = new BatchCollector.BatchProducerTupleSource(qp);
            tempTable = globalStore.getOrCreateTempTable(matTableName, new Query(), this.bufferManager, false);
            List<Object> tuple = ts.nextTuple();
            boolean delete = false;
            if (tuple == null) {
                delete = true;
                tuple = Arrays.asList(key.getValue());
            }
            return CollectionTupleSource.createUpdateCountTupleSource((result = tempTable.updateTuple(tuple, delete)) != null ? 1 : 0);
        }
        return null;
    }

    private Object validateMatView(QueryMetadataInterface metadata, StoredProcedure proc) throws TeiidComponentException, TeiidProcessingException {
        String name = (String)((Constant)proc.getParameter(1).getExpression()).getValue();
        try {
            Object groupID = metadata.getGroupID(name);
            if (!metadata.hasMaterialization(groupID) || metadata.getMaterialization(groupID) != null) {
                throw new QueryProcessingException(QueryPlugin.Util.getString("TempTableDataManager.not_implicit_matview", new Object[]{name}));
            }
            return groupID;
        }
        catch (QueryMetadataException e) {
            throw new TeiidProcessingException((Throwable)((Object)e));
        }
    }

    private TupleSource registerQuery(CommandContext context, TempTableStore contextStore, Query query) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException, ExpressionEvaluationException, QueryProcessingException {
        GroupSymbol group = query.getFrom().getGroups().get(0);
        if (!group.isTempGroupSymbol()) {
            return null;
        }
        final String tableName = group.getNonCorrelationName().toUpperCase();
        boolean remapColumns = !tableName.equalsIgnoreCase(group.getName());
        TempTable table = null;
        if (group.isGlobalTable()) {
            boolean load;
            TempTableStore globalStore = context.getGlobalTableStore();
            TempTableStore.MatTableInfo info = globalStore.getMatTableInfo(tableName);
            Long loadTime = null;
            if (this.distributedCache != null) {
                MatTableKey key = new MatTableKey();
                key.name = tableName;
                key.vdb = new VDBKey(context.getVdbName(), context.getVdbVersion());
                MatTableEntry entry = this.tables.get(key);
                if (entry != null && entry.lastUpdate > info.getUpdateTime() && info.getState() != TempTableStore.MatState.LOADING) {
                    info.setState(TempTableStore.MatState.NEEDS_LOADING, entry.valid, null);
                    loadTime = entry.lastUpdate;
                }
            }
            if (load = info.shouldLoad()) {
                if (!info.isValid()) {
                    this.loadGlobalTable(context, group, tableName, globalStore, info, loadTime);
                } else {
                    this.loadAsynch(context, group, tableName, globalStore, info, loadTime);
                }
            }
            table = globalStore.getOrCreateTempTable(tableName, query, this.bufferManager, false);
        } else {
            table = contextStore.getOrCreateTempTable(tableName, query, this.bufferManager, true);
        }
        if (remapColumns) {
            ExpressionMappingVisitor emv = new ExpressionMappingVisitor(null){

                @Override
                public Expression replaceExpression(Expression element) {
                    if (element instanceof ElementSymbol) {
                        ElementSymbol es = (ElementSymbol)element;
                        ((ElementSymbol)element).setName(tableName + "." + es.getShortName());
                    }
                    return element;
                }
            };
            PostOrderNavigator.doVisit(query, emv);
        }
        return table.createTupleSource(query.getProjectedSymbols(), query.getCriteria(), query.getOrderBy());
    }

    private void loadAsynch(final CommandContext context, final GroupSymbol group, final String tableName, final TempTableStore globalStore, final TempTableStore.MatTableInfo info, final Long loadTime) {
        Callable<Integer> toCall = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return TempTableDataManager.this.loadGlobalTable(context, group, tableName, globalStore, info, loadTime);
            }
        };
        FutureTask<Integer> task = new FutureTask<Integer>(toCall);
        this.executor.execute(task);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int loadGlobalTable(CommandContext context, GroupSymbol group, String tableName, TempTableStore globalStore, TempTableStore.MatTableInfo info, Long loadTime) throws TeiidComponentException, TeiidProcessingException {
        int rowCount;
        TempTable table;
        block16: {
            LogManager.logInfo((String)"org.teiid.PROCESSOR.MATVIEWS", (String)QueryPlugin.Util.getString("TempTableDataManager.loading", new Object[]{tableName}));
            QueryMetadataInterface metadata = context.getMetadata();
            Create create = new Create();
            create.setTable(group);
            List<ElementSymbol> allColumns = ResolverUtil.resolveElementsInGroup(group, metadata);
            create.setColumns(allColumns);
            Object pk = metadata.getPrimaryKey(group.getMetadataID());
            if (pk != null) {
                List<ElementSymbol> pkColumns = this.resolveIndex(metadata, allColumns, pk);
                create.getPrimaryKey().addAll(pkColumns);
            }
            table = globalStore.addTempTable(tableName, create, this.bufferManager, false);
            table.setUpdatable(false);
            CacheHint hint = table.getCacheHint();
            boolean updatable = false;
            if (hint != null) {
                table.setPreferMemory(hint.getPrefersMemory());
                if (hint.getTtl() != null) {
                    info.setTtl(table.getCacheHint().getTtl());
                }
                if (pk != null) {
                    updatable = hint.isUpdatable();
                }
            }
            rowCount = -1;
            try {
                List<ElementSymbol> columns;
                CachedResults cr;
                String fullName = metadata.getFullName(group.getMetadataID());
                TupleSource ts = null;
                SessionAwareCache.CacheID cid = null;
                if (this.distributedCache != null && (cr = this.distributedCache.get(cid = new SessionAwareCache.CacheID(new ParseInfo(), fullName, context.getVdbName(), context.getVdbVersion(), context.getConnectionID(), context.getUserName()))) != null) {
                    ts = cr.getResults().createIndexedTupleSource();
                }
                List<ElementSymbol> variables = table.getColumns();
                if (ts == null) {
                    variables = allColumns;
                    String transformation = metadata.getVirtualPlan(group.getMetadataID()).getQuery();
                    QueryProcessor qp = context.getQueryProcessorFactory().createQueryProcessor(transformation, fullName, context, new Object[0]);
                    qp.setNonBlocking(true);
                    if (this.distributedCache != null) {
                        CachedResults cr2 = new CachedResults();
                        BatchCollector bc = qp.createBatchCollector();
                        TupleBuffer tb = bc.collectTuples();
                        cr2.setResults(tb);
                        this.touchTable(context, fullName, true);
                        this.distributedCache.put(cid, 1, cr2, info.getTtl());
                        ts = tb.createIndexedTupleSource();
                    } else {
                        ts = new BatchCollector.BatchProducerTupleSource(qp);
                    }
                }
                table.insert(ts, variables);
                rowCount = table.getRowCount();
                for (Object index : metadata.getIndexesInGroup(group.getMetadataID())) {
                    columns = this.resolveIndex(metadata, allColumns, index);
                    table.addIndex(columns);
                }
                for (Object key : metadata.getUniqueKeysInGroup(group.getMetadataID())) {
                    columns = this.resolveIndex(metadata, allColumns, key);
                    table.addIndex(columns);
                }
                table.setUpdatable(updatable);
                if (rowCount != -1) break block16;
                info.setState(TempTableStore.MatState.FAILED_LOAD, null, null);
                return rowCount;
            }
            catch (TeiidComponentException e) {
                try {
                    LogManager.logError((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e, (String)QueryPlugin.Util.getString("TempTableDataManager.failed_load", new Object[]{tableName}));
                    throw e;
                    catch (TeiidProcessingException e2) {
                        LogManager.logError((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e2, (String)QueryPlugin.Util.getString("TempTableDataManager.failed_load", new Object[]{tableName}));
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    if (rowCount == -1) {
                        info.setState(TempTableStore.MatState.FAILED_LOAD, null, null);
                        throw throwable;
                    }
                    globalStore.swapTempTable(tableName, table);
                    info.setState(TempTableStore.MatState.LOADED, true, loadTime);
                    LogManager.logInfo((String)"org.teiid.PROCESSOR.MATVIEWS", (String)QueryPlugin.Util.getString("TempTableDataManager.loaded", new Object[]{tableName, rowCount}));
                    throw throwable;
                }
            }
        }
        globalStore.swapTempTable(tableName, table);
        info.setState(TempTableStore.MatState.LOADED, true, loadTime);
        LogManager.logInfo((String)"org.teiid.PROCESSOR.MATVIEWS", (String)QueryPlugin.Util.getString("TempTableDataManager.loaded", new Object[]{tableName, rowCount}));
        return rowCount;
    }

    private void touchTable(CommandContext context, String fullName, boolean valid) {
        MatTableKey key = new MatTableKey();
        key.name = fullName;
        key.vdb = new VDBKey(context.getVdbName(), context.getVdbVersion());
        MatTableEntry matTableEntry = new MatTableEntry();
        matTableEntry.valid = valid;
        this.tables.put(key, matTableEntry, null);
    }

    private List<ElementSymbol> resolveIndex(QueryMetadataInterface metadata, List<ElementSymbol> allColumns, Object pk) throws TeiidComponentException, QueryMetadataException {
        List pkIds = metadata.getElementIDsInKey(pk);
        ArrayList<ElementSymbol> pkColumns = new ArrayList<ElementSymbol>(pkIds.size());
        for (Object col : pkIds) {
            pkColumns.add(allColumns.get(metadata.getPosition(col) - 1));
        }
        return pkColumns;
    }

    @Override
    public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        String matTableName = CODE_PREFIX + (codeTableName + "." + keyElementName + "." + returnElementName).toUpperCase();
        ElementSymbol keyElement = new ElementSymbol(matTableName + "." + keyElementName);
        ElementSymbol returnElement = new ElementSymbol(matTableName + "." + returnElementName);
        QueryMetadataInterface metadata = context.getMetadata();
        keyElement.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(metadata.getElementID(codeTableName + "." + keyElementName))));
        returnElement.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(metadata.getElementID(codeTableName + "." + returnElementName))));
        TempMetadataID id = context.getGlobalTableStore().getMetadataStore().getTempGroupID(matTableName);
        if (id == null) {
            id = context.getGlobalTableStore().getMetadataStore().addTempGroup(matTableName, Arrays.asList(keyElement, returnElement), false, true);
            String queryString = "SELECT " + keyElementName + " ," + returnElementName + ' ' + "FROM" + ' ' + codeTableName;
            id.setQueryNode(new QueryNode(matTableName, queryString));
            id.setPrimaryKey(id.getElements().subList(0, 1));
            CacheHint hint = new CacheHint(true, null);
            id.setCacheHint(hint);
        }
        Query query = RelationalPlanner.createMatViewQuery(id, matTableName, Arrays.asList(returnElement), true);
        query.setCriteria(new CompareCriteria(keyElement, 1, new Constant(keyValue)));
        TupleSource ts = this.registerQuery(context, context.getTempTableStore(), query);
        List<?> row = ts.nextTuple();
        Object result = null;
        if (row != null) {
            result = row.get(0);
        }
        ts.closeSource();
        return result;
    }

    private static class MatTableEntry
    implements Serializable {
        private static final long serialVersionUID = 8559613701442751579L;
        long lastUpdate = System.currentTimeMillis();
        boolean valid;

        private MatTableEntry() {
        }
    }

    private static class MatTableKey
    implements Serializable {
        private static final long serialVersionUID = 5481692896572663992L;
        String name;
        VDBKey vdb;

        private MatTableKey() {
        }

        public int hashCode() {
            return HashCodeUtil.hashCode((int)this.name.hashCode(), (Object[])new Object[]{this.vdb});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MatTableKey)) {
                return false;
            }
            MatTableKey other = (MatTableKey)obj;
            return this.name.equals(other.name) && this.vdb.equals(other.vdb);
        }
    }
}

