/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.id;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import junit.framework.TestCase;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.id.InvalidIDException;
import org.teiid.core.id.ObjectID;
import org.teiid.core.id.UUID;
import org.teiid.core.util.UnitTestUtil;

public class TestParsingObjectIDs
extends TestCase {
    private static final boolean DEBUG_PRINT = false;
    private static final String COMMENT_PREFIX = "#";
    private static final String UUIDS_FILENAME2 = "UUIDs.txt";

    public TestParsingObjectIDs(String name) {
        super(name);
    }

    public static Collection helpTestStringToObject(String filename, boolean checkForDuplicates) throws Exception {
        String stringifiedID2 = null;
        HashSet<ObjectID> objectIDs = new HashSet<ObjectID>();
        try {
            Collection stringifiedIDs = TestParsingObjectIDs.helpLoad(filename);
            for (String stringifiedID2 : stringifiedIDs) {
                ObjectID objectId = IDGenerator.getInstance().stringToObject(stringifiedID2);
                if (checkForDuplicates && objectIDs.contains(objectId)) {
                    TestParsingObjectIDs.fail((String)("ObjectID '" + objectId + "' is a duplicate!"));
                }
                objectIDs.add(objectId);
            }
        }
        catch (InvalidIDException e) {
            TestParsingObjectIDs.fail((String)("Unable to convert stringified ID \"" + stringifiedID2 + "\" to an ObjectID"));
        }
        return objectIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection helpLoad(String filename) throws Exception {
        FileInputStream stream = new FileInputStream(UnitTestUtil.getTestDataFile((String)filename));
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0 || line.startsWith(COMMENT_PREFIX)) continue;
                result.add(line);
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                TestParsingObjectIDs.fail((String)("Unable to close the stream to the test file \"" + filename + "\""));
            }
        }
        return result;
    }

    public void helpCheckVariant(Collection objectIDs, int expectedVariant) {
        for (ObjectID objectId : objectIDs) {
            if (!(objectId instanceof UUID)) continue;
            TestParsingObjectIDs.helpCheckVariant((UUID)objectId, expectedVariant);
        }
    }

    public static void helpCheckVariant(UUID uuid, int expectedVariant) {
        if (UUID.getVariant((ObjectID)uuid) != expectedVariant) {
            TestParsingObjectIDs.fail((String)("UUID '" + uuid + "' variant ('" + UUID.getVariant((ObjectID)uuid) + "') does not match the expected variant " + expectedVariant));
        }
    }

    public void testStringToObjectFromUUIDFile() throws Exception {
        Collection ids = TestParsingObjectIDs.helpTestStringToObject(UUIDS_FILENAME2, false);
        this.helpCheckVariant(ids, 2);
    }
}

