/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import junit.framework.TestCase;
import org.teiid.dqp.internal.datamgr.TstLanguageBridgeFactory;
import org.teiid.language.NamedTable;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.unittest.FakeMetadataObject;

public class TestGroupImpl
extends TestCase {
    public TestGroupImpl(String name) {
        super(name);
    }

    public static GroupSymbol helpExample(String groupName) {
        return TestGroupImpl.helpExample(groupName, null);
    }

    public static GroupSymbol helpExample(String groupName, String definition) {
        String name = groupName;
        if (definition != null) {
            name = definition;
        }
        FakeMetadataObject obj = new FakeMetadataObject(name, "Group");
        return TestGroupImpl.helpExample(groupName, definition, obj);
    }

    public static GroupSymbol helpExample(String groupName, String definition, Object metadataID) {
        GroupSymbol symbol = new GroupSymbol(groupName, definition);
        symbol.setMetadataID(metadataID);
        return symbol;
    }

    public static NamedTable example(String groupName) throws Exception {
        return TestGroupImpl.example(groupName, null);
    }

    public static NamedTable example(String groupName, String definition) throws Exception {
        return TstLanguageBridgeFactory.factory.translate(TestGroupImpl.helpExample(groupName, definition));
    }

    public static NamedTable example(String groupName, String definition, Object metadataID) throws Exception {
        return TstLanguageBridgeFactory.factory.translate(TestGroupImpl.helpExample(groupName, definition, metadataID));
    }

    public void testGetContext() throws Exception {
        Object metadataID = TstLanguageBridgeFactory.metadata.getGroupID("pm1.g1");
        TestGroupImpl.assertEquals((String)"x", (String)TestGroupImpl.example("x", "pm1.g1", metadataID).getCorrelationName());
    }

    public void testGetDefinition() throws Exception {
        Object metadataID = TstLanguageBridgeFactory.metadata.getGroupID("pm1.g1");
        TestGroupImpl.assertEquals((String)"g1", (String)TestGroupImpl.example("x", "pm1.g1", metadataID).getName());
    }
}

