/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.Serializable;
import java.util.HashMap;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.internal.process.DQPWorkContext;

public class TestDQPWorkContext
extends TestCase {
    public TestDQPWorkContext(String name) {
        super(name);
    }

    public static DQPWorkContext example() {
        DQPWorkContext message = new DQPWorkContext();
        message.getSession().setVDBName("vdbName");
        message.getSession().setVDBVersion(1);
        message.getSession().setApplicationName("querybuilder");
        message.getSession().setSessionId(String.valueOf(5));
        message.getSession().setUserName("userName");
        return message;
    }

    public void testSerialize() throws Exception {
        DQPWorkContext copy = (DQPWorkContext)UnitTestUtil.helpSerialize((Serializable)TestDQPWorkContext.example());
        TestDQPWorkContext.assertEquals((String)"5", (String)copy.getSessionId());
        TestDQPWorkContext.assertEquals((String)"userName", (String)copy.getUserName());
        TestDQPWorkContext.assertEquals((String)"vdbName", (String)copy.getVdbName());
        TestDQPWorkContext.assertEquals((int)1, (int)copy.getVdbVersion());
        TestDQPWorkContext.assertEquals((String)"querybuilder", (String)copy.getAppName());
    }

    public void testClearPolicies() {
        DQPWorkContext message = new DQPWorkContext();
        message.setSession((SessionMetadata)Mockito.mock(SessionMetadata.class));
        Mockito.stub((Object)message.getSession().getVdb()).toReturn((Object)new VDBMetaData());
        HashMap map = message.getAllowedDataPolicies();
        map.put("role", Mockito.mock(DataPolicy.class));
        TestDQPWorkContext.assertFalse((boolean)map.isEmpty());
        message.setSession((SessionMetadata)Mockito.mock(SessionMetadata.class));
        Mockito.stub((Object)message.getSession().getVdb()).toReturn((Object)new VDBMetaData());
        map = message.getAllowedDataPolicies();
        TestDQPWorkContext.assertTrue((boolean)map.isEmpty());
    }

    public void testAnyAuthenticated() {
        DQPWorkContext message = new DQPWorkContext();
        message.setSession((SessionMetadata)Mockito.mock(SessionMetadata.class));
        VDBMetaData vdb = new VDBMetaData();
        DataPolicyMetadata dpm = new DataPolicyMetadata();
        dpm.setAnyAuthenticated(true);
        vdb.addDataPolicy(dpm);
        Mockito.stub((Object)message.getSession().getVdb()).toReturn((Object)vdb);
        HashMap map = message.getAllowedDataPolicies();
        TestDQPWorkContext.assertEquals((int)1, (int)map.size());
    }
}

