/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.UDFSource;
import org.teiid.query.function.metadata.FunctionMethod;
import org.teiid.query.function.metadata.FunctionParameter;
import org.teiid.query.function.source.SystemSource;
import org.teiid.query.unittest.FakeMetadataFactory;

public class TestFunctionTree {
    @Test
    public void testWalkTree() {
        SystemSource source = new SystemSource(false);
        FunctionTree ft = new FunctionTree((FunctionMetadataSource)source);
        Collection categories = ft.getCategories();
        for (String category : categories) {
            Collection functions = ft.getFunctionForms(category);
            Assert.assertTrue((functions.size() > 0 ? 1 : 0) != 0);
        }
    }

    public String z() {
        return null;
    }

    protected static String x() {
        return null;
    }

    public static String y() {
        return null;
    }

    @Test
    public void testLoadErrors() {
        FunctionMethod method = new FunctionMethod("dummy", null, null, 0, "nonexistentClass", "noMethod", new FunctionParameter[0], new FunctionParameter("output", "string"));
        new FunctionLibrary(FakeMetadataFactory.SFM.getSystemFunctions(), new FunctionTree((FunctionMetadataSource)new UDFSource(Arrays.asList(method))));
        try {
            new FunctionLibrary(FakeMetadataFactory.SFM.getSystemFunctions(), new FunctionTree((FunctionMetadataSource)new UDFSource(Arrays.asList(method)), true));
            Assert.fail();
        }
        catch (TeiidRuntimeException e) {
            // empty catch block
        }
        method.setInvocationClass(TestFunctionTree.class.getName());
        try {
            new FunctionLibrary(FakeMetadataFactory.SFM.getSystemFunctions(), new FunctionTree((FunctionMetadataSource)new UDFSource(Arrays.asList(method)), true));
            Assert.fail();
        }
        catch (TeiidRuntimeException e) {
            // empty catch block
        }
        method.setInvocationMethod("testLoadErrors");
        try {
            new FunctionLibrary(FakeMetadataFactory.SFM.getSystemFunctions(), new FunctionTree((FunctionMetadataSource)new UDFSource(Arrays.asList(method)), true));
            Assert.fail();
        }
        catch (TeiidRuntimeException e) {
            // empty catch block
        }
        method.setInvocationMethod("x");
        try {
            new FunctionLibrary(FakeMetadataFactory.SFM.getSystemFunctions(), new FunctionTree((FunctionMetadataSource)new UDFSource(Arrays.asList(method)), true));
            Assert.fail();
        }
        catch (TeiidRuntimeException e) {
            // empty catch block
        }
        method.setInvocationMethod("z");
        try {
            new FunctionLibrary(FakeMetadataFactory.SFM.getSystemFunctions(), new FunctionTree((FunctionMetadataSource)new UDFSource(Arrays.asList(method)), true));
            Assert.fail();
        }
        catch (TeiidRuntimeException teiidRuntimeException) {
            // empty catch block
        }
        method.setInvocationMethod("y");
        new FunctionLibrary(FakeMetadataFactory.SFM.getSystemFunctions(), new FunctionTree((FunctionMetadataSource)new UDFSource(Arrays.asList(method)), true));
    }

    @Test
    public void testNullCategory() {
        FunctionMetadataSource fms = (FunctionMetadataSource)Mockito.mock(FunctionMetadataSource.class);
        Mockito.stub((Object)fms.getFunctionMethods()).toReturn(Arrays.asList(new FunctionMethod("dummy", null, null, 2, "nonexistentClass", "noMethod", new FunctionParameter[0], new FunctionParameter("output", "string"))));
        FunctionTree ft = new FunctionTree(fms);
        Assert.assertEquals((long)1L, (long)ft.getFunctionForms("Miscellaneous").size());
    }
}

