/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.jboss.virtual.VirtualFile;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.translator.TranslatorException;

public class TestTransformationMetadata {
    @Test
    public void testAmbiguousProc() throws Exception {
        TransformationMetadata tm = this.exampleTransformationMetadata();
        try {
            tm.getStoredProcedureInfoForProcedure("y");
            Assert.fail((String)"expected exception");
        }
        catch (QueryMetadataException e) {
            Assert.assertEquals((Object)"Procedure 'y' is ambiguous, use the fully qualified name instead", (Object)e.getMessage());
        }
    }

    private TransformationMetadata exampleTransformationMetadata() throws TranslatorException {
        HashMap<String, Datatype> datatypes = new HashMap<String, Datatype>();
        datatypes.put("string", new Datatype());
        MetadataFactory mf = new MetadataFactory("x", datatypes, new Properties());
        mf.addProcedure("y");
        Table t = mf.addTable("foo");
        mf.addColumn("col", "string", (ColumnSet)t);
        MetadataFactory mf1 = new MetadataFactory("x1", datatypes, new Properties());
        mf1.addProcedure("y");
        Table table = mf1.addTable("doc");
        table.setSchemaPaths(Arrays.asList("../../x.xsd"));
        table.setResourcePath("/a/b/doc.xmi");
        HashMap<String, TransformationMetadata.Resource> resources = new HashMap<String, TransformationMetadata.Resource>();
        resources.put("/x.xsd", new TransformationMetadata.Resource((VirtualFile)Mockito.mock(VirtualFile.class), true));
        CompositeMetadataStore cms = new CompositeMetadataStore(Arrays.asList(mf.getMetadataStore(), mf1.getMetadataStore()));
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("vdb");
        vdb.setVersion(1);
        vdb.addModel(this.buildModel("x"));
        vdb.addModel(this.buildModel("x1"));
        vdb.addModel(this.buildModel("y"));
        return new TransformationMetadata(vdb, cms, resources, null, FakeMetadataFactory.SFM.getSystemFunctions());
    }

    ModelMetaData buildModel(String name) {
        ModelMetaData model = new ModelMetaData();
        model.setName(name);
        model.setModelType(Model.Type.PHYSICAL);
        model.setVisible(Boolean.valueOf(true));
        return model;
    }

    @Test
    public void testAmbiguousTableWithPrivateModel() throws Exception {
        HashMap<String, Datatype> datatypes = new HashMap<String, Datatype>();
        datatypes.put("string", new Datatype());
        MetadataFactory mf = new MetadataFactory("x", datatypes, new Properties());
        mf.addTable("y");
        MetadataFactory mf1 = new MetadataFactory("x1", datatypes, new Properties());
        mf1.addTable("y");
        CompositeMetadataStore cms = new CompositeMetadataStore(Arrays.asList(mf.getMetadataStore(), mf1.getMetadataStore()));
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("foo");
        vdb.setVersion(1);
        ModelMetaData model = new ModelMetaData();
        model.setName("x1");
        vdb.addModel(model);
        ModelMetaData model2 = new ModelMetaData();
        model2.setName("x");
        model2.setVisible(Boolean.valueOf(true));
        vdb.addModel(model2);
        TransformationMetadata tm = new TransformationMetadata(vdb, cms, null, null, FakeMetadataFactory.SFM.getSystemFunctions());
        Collection result = tm.getGroupsForPartialName("y");
        Assert.assertEquals((long)2L, (long)result.size());
        FakeMetadataFactory.buildWorkContext((QueryMetadataInterface)tm, vdb);
        model.setVisible(Boolean.valueOf(false));
        tm = new TransformationMetadata(vdb, cms, null, null, FakeMetadataFactory.SFM.getSystemFunctions());
        result = tm.getGroupsForPartialName("y");
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testElementId() throws Exception {
        TransformationMetadata tm = this.exampleTransformationMetadata();
        tm.getElementID("x.FoO.coL");
    }

    @Test
    public void testRelativeSchemas() throws Exception {
        TransformationMetadata tm = this.exampleTransformationMetadata();
        Assert.assertEquals((long)1L, (long)tm.getXMLSchemas((Object)tm.getGroupID("x1.doc")).size());
    }
}

