/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.DependentAccessNode;
import org.teiid.query.processor.relational.GroupingNode;
import org.teiid.query.processor.relational.LimitNode;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.NestedLoopJoinStrategy;
import org.teiid.query.processor.relational.NullNode;
import org.teiid.query.processor.relational.PlanExecutionNode;
import org.teiid.query.processor.relational.ProjectNode;
import org.teiid.query.processor.relational.SelectNode;
import org.teiid.query.processor.relational.SortNode;
import org.teiid.query.processor.relational.UnionAllNode;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.unittest.FakeMetadataObject;
import org.teiid.query.unittest.FakeMetadataStore;

public class TestLimit
extends TestCase {
    private static final int[] FULL_PUSHDOWN = new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final Class<?>[] NODE_TYPES = new Class[]{AccessNode.class, DependentAccessNode.class, TestOptimizer.DependentSelectNode.class, TestOptimizer.DependentProjectNode.class, TestOptimizer.DupRemoveNode.class, GroupingNode.class, LimitNode.class, NestedLoopJoinStrategy.class, MergeJoinStrategy.class, NullNode.class, PlanExecutionNode.class, ProjectNode.class, SelectNode.class, SortNode.class, UnionAllNode.class};

    public TestLimit(String name) {
        super(name);
    }

    private static FakeMetadataFacade exampleMetadata() {
        FakeMetadataObject pm1 = FakeMetadataFactory.createPhysicalModel("pm1");
        FakeMetadataObject vm1 = FakeMetadataFactory.createVirtualModel("vm1");
        FakeMetadataObject pm1g1 = FakeMetadataFactory.createPhysicalGroup("pm1.g1", pm1);
        FakeMetadataObject pm1g2 = FakeMetadataFactory.createPhysicalGroup("pm1.g2", pm1);
        FakeMetadataObject pm1g3 = FakeMetadataFactory.createPhysicalGroup("pm1.g3", pm1);
        FakeMetadataObject pm1g4 = FakeMetadataFactory.createPhysicalGroup("pm1.g4", pm1);
        FakeMetadataObject pm1g5 = FakeMetadataFactory.createPhysicalGroup("pm1.g5", pm1);
        FakeMetadataObject pm1g6 = FakeMetadataFactory.createPhysicalGroup("pm1.g6", pm1);
        List<FakeMetadataObject> pm1g1e = FakeMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g2e = FakeMetadataFactory.createElements(pm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g3e = FakeMetadataFactory.createElements(pm1g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g4e = FakeMetadataFactory.createElements(pm1g4, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        pm1g4e.get(1).putProperty("supSelect", Boolean.FALSE);
        pm1g4e.get(3).putProperty("supSelect", Boolean.FALSE);
        List<FakeMetadataObject> pm1g5e = FakeMetadataFactory.createElements(pm1g5, new String[]{"e1"}, new String[]{"string"});
        pm1g5e.get(0).putProperty("supSelect", Boolean.FALSE);
        List<FakeMetadataObject> pm1g6e = FakeMetadataFactory.createElements(pm1g6, new String[]{"in", "in3"}, new String[]{"string", "string"});
        QueryNode vm1g1n1 = new QueryNode("vm1.g1", "SELECT * FROM pm1.g1 LIMIT 100");
        FakeMetadataObject vm1g1 = FakeMetadataFactory.createVirtualGroup("vm1.g1", vm1, vm1g1n1);
        List<FakeMetadataObject> vm1g1e = FakeMetadataFactory.createElements(vm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        QueryNode vm1g2n1 = new QueryNode("vm1.g2", "SELECT * FROM vm1.g1 ORDER BY e1");
        FakeMetadataObject vm1g2 = FakeMetadataFactory.createVirtualGroup("vm1.g2", vm1, vm1g2n1);
        List<FakeMetadataObject> vm1g2e = FakeMetadataFactory.createElements(vm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(pm1);
        store.addObject(pm1g1);
        store.addObjects(pm1g1e);
        store.addObject(pm1g2);
        store.addObjects(pm1g2e);
        store.addObject(pm1g3);
        store.addObjects(pm1g3e);
        store.addObject(pm1g4);
        store.addObjects(pm1g4e);
        store.addObject(pm1g5);
        store.addObjects(pm1g5e);
        store.addObject(pm1g6);
        store.addObjects(pm1g6e);
        store.addObject(vm1);
        store.addObject(vm1g1);
        store.addObjects(vm1g1e);
        store.addObject(vm1g2);
        store.addObjects(vm1g2e);
        return new FakeMetadataFacade(store);
    }

    public void testLimit() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "SELECT * FROM pm1.g1 limit 100";
        String[] expectedSql = new String[]{"SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NODE_TYPES);
    }

    public void testLimitPushdown() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "SELECT * FROM pm1.g1 limit 100";
        String[] expectedSql = new String[]{"SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1 LIMIT 100"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN, NODE_TYPES);
    }

    public void testLimitWithOffset() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "SELECT * FROM pm1.g1 limit 50, 100";
        String[] expectedSql = new String[]{"SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NODE_TYPES);
    }

    public void testPushedLimitWithOffset() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "SELECT * FROM pm1.g1 limit 50, 100";
        String[] expectedSql = new String[]{"SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1 LIMIT 150"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NODE_TYPES);
    }

    public void testLimitWithOffsetFullyPushed() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_OFFSET, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "SELECT * FROM pm1.g1 limit 50, 100";
        String[] expectedSql = new String[]{"SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1 LIMIT 50, 100"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN, NODE_TYPES);
    }

    public void testSort() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "SELECT * FROM pm1.g1 order by e1 limit 100";
        String[] expectedSql = new String[]{"SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0}, NODE_TYPES);
    }

    public void testSortPushed() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("pm3", (SourceCapabilities)caps);
        String sql = "SELECT * FROM pm3.g1 order by e1 limit 100";
        String[] expectedSql = new String[]{"SELECT pm3.g1.e1, pm3.g1.e2, pm3.g1.e3, pm3.g1.e4 FROM pm3.g1 ORDER BY pm3.g1.e1"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NODE_TYPES);
    }

    public void testSortPushedWithLimit() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        capFinder.addCapabilities("pm3", (SourceCapabilities)caps);
        String sql = "SELECT * FROM pm3.g1 order by e1 limit 100";
        String[] expectedSql = new String[]{"SELECT pm3.g1.e1, pm3.g1.e2, pm3.g1.e3, pm3.g1.e4 FROM pm3.g1 ORDER BY pm3.g1.e1 LIMIT 100"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN, NODE_TYPES);
    }

    public void testSortUnderLimitNotRemoved() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm3", (SourceCapabilities)caps);
        String sql = "SELECT * FROM (SELECT * FROM pm3.g1 order by e1 limit 100) AS V1 ORDER BY v1.e2";
        String[] expectedSql = new String[]{"SELECT pm3.g1.e1, pm3.g1.e2, pm3.g1.e3, pm3.g1.e4 FROM pm3.g1"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 2, 0}, NODE_TYPES);
    }

    public void testSortAboveLimitNotPushed() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "SELECT * FROM vm1.g2 order by e1";
        String[] expectedSql = new String[]{"SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1 LIMIT 100"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestLimit.exampleMetadata(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0}, NODE_TYPES);
    }

    public void testLimitNotPushedWithUnion() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "SELECT * FROM pm1.g1 UNION SELECT * FROM PM1.g2 LIMIT 100";
        String[] expectedSql = new String[]{"SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1 UNION SELECT pm1.g2.e1, pm1.g2.e2, pm1.g2.e3, pm1.g2.e4 FROM PM1.g2"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NODE_TYPES);
    }

    public void testLimitPushedWithUnion() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "SELECT * FROM pm1.g1 UNION SELECT * FROM PM1.g2 LIMIT 100";
        String[] expectedSql = new String[]{"SELECT pm1.g2.e1, pm1.g2.e2, pm1.g2.e3, pm1.g2.e4 FROM PM1.g2 LIMIT 100", "SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1 LIMIT 100"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1}, NODE_TYPES);
    }

    public void testLimitWithOffsetPushedWithUnion() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_OFFSET, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "SELECT * FROM pm1.g1 UNION SELECT * FROM PM1.g2 LIMIT 50, 100";
        String[] expectedSql = new String[]{"SELECT PM1.g2.e1 AS c_0, PM1.g2.e2 AS c_1, PM1.g2.e3 AS c_2, PM1.g2.e4 AS c_3 FROM PM1.g2 LIMIT 150", "SELECT pm1.g1.e1 AS c_0, pm1.g1.e2 AS c_1, pm1.g1.e3 AS c_2, pm1.g1.e4 AS c_3 FROM pm1.g1 LIMIT 150"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1}, NODE_TYPES);
    }

    public void testLimitNotPushedWithUnionOrderBy() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "SELECT * FROM pm1.g1 UNION SELECT * FROM PM1.g2 ORDER BY e1 LIMIT 100";
        String[] expectedSql = new String[]{"SELECT pm1.g2.e1, pm1.g2.e2, pm1.g2.e3, pm1.g2.e4 FROM PM1.g2", "SELECT pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 FROM pm1.g1"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1}, NODE_TYPES);
        TestOptimizer.checkNodeTypes(plan, new int[]{1}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    public void testCombinedLimits() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "SELECT * from (SELECT pm1.g1.e1 FROM pm1.g1 LIMIT 10, 100) x LIMIT 20, 75";
        String[] expectedSql = new String[]{"SELECT pm1.g1.e1 AS c_0 FROM pm1.g1 LIMIT 105"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NODE_TYPES);
    }

    public void testCombinedLimitsWithOffset() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_OFFSET, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "SELECT * from (SELECT pm1.g1.e1 FROM pm1.g1 LIMIT 10, 100) x LIMIT 40, 75";
        String[] expectedSql = new String[]{"SELECT pm1.g1.e1 AS c_0 FROM pm1.g1 LIMIT 10, 60"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN, NODE_TYPES);
    }

    public void testInlineView() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, true);
        capFinder.addCapabilities("pm3", (SourceCapabilities)caps);
        String sql = "SELECT * FROM (SELECT * FROM pm3.g1) as v1 limit 100";
        String[] expectedSql = new String[]{"SELECT pm3.g1.e1, pm3.g1.e2, pm3.g1.e3, pm3.g1.e4 FROM pm3.g1 LIMIT 100"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN, NODE_TYPES);
    }

    public void testInlineViewAboveLimitNotMerged() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        capFinder.addCapabilities("pm3", (SourceCapabilities)caps);
        String sql = "SELECT * FROM (SELECT * FROM pm3.g1 limit 100) as v1 order by e1";
        String[] expectedSql = new String[]{"SELECT v_0.c_0, v_0.c_1, v_0.c_2, v_0.c_3 FROM (SELECT pm3.g1.e1 AS c_0, pm3.g1.e2 AS c_1, pm3.g1.e3 AS c_2, pm3.g1.e4 AS c_3 FROM pm3.g1 LIMIT 100) AS v_0 ORDER BY c_0"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    public void testCriteriaPushedUnderLimit() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        capFinder.addCapabilities("pm3", (SourceCapabilities)caps);
        String sql = "SELECT * FROM (SELECT * FROM pm3.g1 limit 100) as v1 where v1.e1 = 1";
        String[] expectedSql = new String[]{"SELECT pm3.g1.e1, pm3.g1.e2, pm3.g1.e3, pm3.g1.e4 FROM pm3.g1 WHERE pm3.g1.e1 = '1' LIMIT 100"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN, NODE_TYPES);
    }

    public void testInlineViewJoin() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "SELECT x FROM ((SELECT e1 as x FROM pm1.g1 LIMIT 700) c INNER JOIN (SELECT e1 FROM pm1.g2) d ON d.e1 = c.x) order by x LIMIT 5";
        String[] expectedSql = new String[]{"SELECT e1 FROM pm1.g1 LIMIT 700", "SELECT e1 FROM pm1.g2"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0}, NODE_TYPES);
        FakeDataManager fdm = new FakeDataManager();
        TestProcessor.sampleData1(fdm);
        TestProcessor.helpProcess(plan, fdm, new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")});
    }

    public void testDontPushSelectWithOrderedLimit() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select * from (SELECT e1 as x FROM pm1.g1 order by x LIMIT 700) y where x = 1";
        String[] expectedSql = new String[]{"SELECT g_0.e1 AS c_0 FROM pm1.g1 AS g_0 ORDER BY c_0"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0}, NODE_TYPES);
    }

    public void testDontPushSelectWithOrderedLimit1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select * from (SELECT e1 as x FROM pm1.g1 order by x LIMIT 10, 700) y where x = 1";
        String[] expectedSql = new String[]{"SELECT g_0.e1 AS c_0 FROM pm1.g1 AS g_0 ORDER BY c_0"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0}, NODE_TYPES);
    }

    public void testLimitWithNoAccessNode() {
        String sql = "select 1 limit 1";
        String[] expectedSql = new String[]{};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), expectedSql);
        TestOptimizer.checkNodeTypes(plan, new int[]{0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0}, NODE_TYPES);
    }

    public void testAggregateCriteriaOverUnSortedLimit() {
        String sql = "select a from (SELECT MAX(e2) as a FROM pm1.g1 GROUP BY e2 LIMIT 1) x where a = 0";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_HAVING, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String[] expectedSql = new String[]{"SELECT MAX(e2) FROM pm1.g1 GROUP BY e2 HAVING MAX(e2) = 0 LIMIT 1"};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, expectedSql, true);
        TestOptimizer.checkNodeTypes(plan, FULL_PUSHDOWN, NODE_TYPES);
    }

    public void testSortWithLimitInlineView() {
        String sql = "select e1 from (select pm1.g1.e1, pm1.g1.e2 from pm1.g1 order by pm1.g1.e1, pm1.g1.e2 limit 1) x";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e1 AS c_0 FROM pm1.g1 AS g_0 ORDER BY c_0, g_0.e2"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0}, NODE_TYPES);
    }
}

