/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.rules.CriteriaCapabilityValidatorVisitor;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.unittest.FakeMetadataObject;

public class TestCriteriaCapabilityValidatorVisitor {
    public void helpTestVisitor(String sql, Object modelID, FakeMetadataFacade metadata, CapabilitiesFinder capFinder, boolean isValid, boolean expectException) {
        try {
            Criteria criteria = QueryParser.getQueryParser().parseCriteria(sql);
            QueryResolver.resolveCriteria((Criteria)criteria, (QueryMetadataInterface)metadata);
            Assert.assertEquals((String)"Got incorrect isValid flag", (Object)isValid, (Object)CriteriaCapabilityValidatorVisitor.canPushLanguageObject((LanguageObject)criteria, (Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder, null));
        }
        catch (QueryMetadataException e) {
            if (!expectException) {
                throw new RuntimeException(e);
            }
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
    }

    public void helpTestVisitorWithCommand(String sql, Object modelID, FakeMetadataFacade metadata, CapabilitiesFinder capFinder, boolean isValid, boolean expectException) {
        try {
            Command command = QueryParser.getQueryParser().parseCommand(sql);
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
            Assert.assertEquals((String)"Got incorrect isValid flag", (Object)isValid, (Object)CriteriaCapabilityValidatorVisitor.canPushLanguageObject((LanguageObject)command, (Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder, null));
        }
        catch (QueryMetadataException e) {
            if (!expectException) {
                throw new RuntimeException(e);
            }
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testCompareCriteriaSuccess() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 = 'x'", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testCompareCriteriaCapFail1() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 = 'x'", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testCompareCriteriaOpCapFail1() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 = 'x'", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testCompareCriteriaOpCapFail2() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 <> 'x'", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testCompareCriteriaOpCapFail3() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 < 'x'", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testCompareCriteriaOpCapFail4() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 <= 'x'", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testCompareCriteriaOpCapFail5() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 > 'x'", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testCompareCriteriaOpCapFail6() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 >= 'x'", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testCompareCriteriaSearchableFail() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject e1 = metadata.getStore().findObject("pm1.g1.e1", "Element");
        e1.putProperty("supCompare", Boolean.FALSE);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 = 'x'", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testCompareCriteriaNoCaps() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        this.helpTestVisitor("pm1.g1.e1 = 'x'", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testCompoundCriteriaAnd1() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 = 'x' AND 0 = 1", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testCompoundCriteriaAnd4() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        this.helpTestVisitor("pm1.g1.e1 = 'x' AND 0 = 1", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testCompoundCriteriaOr1() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_OR, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 = 'x' OR 0 = 1", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testCompoundCriteriaOr2() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_OR, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 = 'x' OR 0 = 1", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testCompoundCriteriaOr4() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        this.helpTestVisitor("pm1.g1.e1 = 'x' OR 0 = 1", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testScalarFunction1() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setFunctionSupport("curtime", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("curtime() = {t'10:00:00'}", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testScalarFunction2() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setFunctionSupport("+", false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("1 + 1 = 2", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testScalarFunction2a() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setFunctionSupport("curtime", false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("curtime() = '{t'10:00:00'}", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testScalarFunction2b() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setFunctionSupport("rand", false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("rand() = '1.0'", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testIsNull1() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_ISNULL, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 IS NULL", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testIsNull2() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_ISNULL, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 IS NULL", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testIsNull3() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        this.helpTestVisitor("pm1.g1.e1 IS NULL", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testIsNull4() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject e1 = metadata.getStore().findObject("pm1.g1.e1", "Element");
        e1.putProperty("supCompare", Boolean.FALSE);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_ISNULL, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 IS NULL", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testIsNull6() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_ISNULL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_NOT, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 IS NOT NULL", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testIsNull6fails() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_ISNULL, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 IS NOT NULL", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testMatchCriteriaSuccess() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 LIKE 'x'", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testMatchCriteriaSuccess2() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE_ESCAPE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 LIKE 'x' ESCAPE '#'", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testMatchCriteriaSuccess3() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_NOT, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 NOT LIKE 'x'", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testMatchCriteriaSuccess3fails() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 NOT LIKE 'x'", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testMatchCriteriaCapFail1() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE_ESCAPE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 LIKE 'x'", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testMatchCriteriaCapFail2() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE_ESCAPE, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 LIKE 'x' ESCAPE '#'", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testMatchCriteriaMatchableFail() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject e1 = metadata.getStore().findObject("pm1.g1.e1", "Element");
        e1.putProperty("supLike", Boolean.FALSE);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE_ESCAPE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 LIKE 'x'", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testMatchCriteriaNoCaps() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        this.helpTestVisitor("pm1.g1.e1 LIKE 'x'", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testNotCriteria1() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_NOT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("NOT pm1.g1.e1 = 'x'", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testNotCriteria2() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_NOT, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("NOT pm1.g1.e1 = 'x'", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSetCriteria1() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 IN ('x')", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testSetCriteria2() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 IN ('x')", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSetCriteria3() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        this.helpTestVisitor("pm1.g1.e1 IN ('x')", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testSetCriteria5() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject elementID = metadata.getStore().findObject("pm1.g1.e1", "Element");
        elementID.putProperty("supCompare", Boolean.FALSE);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 IN ('x')", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSetCriteria7() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_NOT, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 NOT IN ('x')", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testSetCriteria7fails() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 NOT IN ('x')", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSetCriteria8() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(2));
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 IN ('x', 'y', 'z')", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSetCriteria9() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(2));
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 IN ('x', 'y')", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testSubquerySetCriteria() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 IN (SELECT 'xyz' FROM pm1.g1)", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSearchCase() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitor("pm1.g1.e1 = case when pm1.g1.e2 = 1 then 1 else 2 end", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSubqueryCompareCriteriaSuccess() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_QUANTIFIED_SOME, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE pm1.g1.e1 = ANY (SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testSubqueryCompareCriteriaCapFail1() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE pm1.g1.e1 = ANY (SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSubqueryCompareCriteriaCapFail2() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE pm1.g1.e1 = ANY (SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSubqueryCompareCriteriaFail3() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_QUANTIFIED_SOME, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE pm1.g1.e1 = ANY (SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSubqueryCompareCriteriaFail4() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_QUANTIFIED_SOME, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE pm1.g1.e1 = ANY (SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSubqueryCompareCriteriaFail5() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_QUANTIFIED_SOME, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_QUANTIFIED_ALL, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE pm1.g1.e1 = ANY (SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSubqueryCompareCriteriaFail6() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_QUANTIFIED_SOME, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_QUANTIFIED_ALL, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE pm1.g1.e1 = ALL (SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSubqueryCompareCriteriaOpCapFail1() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE pm1.g1.e1 = ANY (SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSubqueryCompareCriteriaOpCapFail2() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE pm1.g1.e1 <> ANY (SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSubqueryCompareCriteriaOpCapFail3() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE pm1.g1.e1 < ANY (SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSubqueryCompareCriteriaOpCapFail4() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE pm1.g1.e1 <= ANY (SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSubqueryCompareCriteriaOpCapFail5() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE pm1.g1.e1 > ANY (SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSubqueryCompareCriteriaOpCapFail6() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE pm1.g1.e1 >= ANY (SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testSubqueryCompareCriteriaSearchableFail() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject e1 = metadata.getStore().findObject("pm1.g1.e1", "Element");
        e1.putProperty("supCompare", Boolean.FALSE);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE pm1.g1.e1 = ANY (SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testExistsCriteria1() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_EXISTS, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE EXISTS(SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, true, false);
    }

    @Test
    public void testExistsCriteria2() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_EXISTS, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE EXISTS(SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, false, false);
    }

    @Test
    public void testExistsCriteria5() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_EXISTS, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        this.helpTestVisitorWithCommand("SELECT e1 FROM pm1.g1 WHERE EXISTS(SELECT e1 FROM pm1.g2)", modelID, metadata, capFinder, true, false);
    }
}

