/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.logging.LogManager;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.processor.FakeTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.TranslatableProcedureContainer;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ReferenceCollectorVisitor;
import org.teiid.query.util.CommandContext;

public class FakeDataManager
implements ProcessorDataManager {
    private Map tuples = new HashMap();
    private static final String LOG_CONTEXT = "FAKE_DATA_MANAGER";
    private boolean blockOnce;
    private Map codeTableValues = new HashMap();
    private boolean throwBlocked = false;
    private Map blockedState = new HashMap();
    private List<String> queries = new ArrayList<String>();
    private boolean recordingCommands = true;

    public List<String> getQueries() {
        return this.queries;
    }

    public List<String> clearQueries() {
        ArrayList<String> rc = new ArrayList<String>(this.getQueries());
        this.queries.clear();
        return rc;
    }

    public void registerTuples(Object groupID, List elements, List[] data) {
        this.tuples.put(groupID, new Object[]{elements, data});
    }

    public void closeRequest(Object requestID) {
    }

    public TupleSource registerRequest(CommandContext context, Command command, String modelName, String connectorBindingId, int nodeID) throws TeiidComponentException {
        LogManager.logTrace((String)LOG_CONTEXT, (Object[])new Object[]{"Register Request:", command, ",processorID:", context.getProcessorID(), ",model name:", modelName, ",TupleSourceID nodeID:", new Integer(nodeID)});
        if (this.recordingCommands && !(command instanceof BatchedUpdateCommand)) {
            this.queries.add(command.toString());
        }
        if (ReferenceCollectorVisitor.getReferences((LanguageObject)command).size() > 0) {
            throw new IllegalArgumentException("Found references in the command registered with the DataManager.");
        }
        GroupSymbol group = null;
        if (command instanceof Query) {
            group = this.getQueryGroup((Query)command);
        } else if (command instanceof SetQuery) {
            SetQuery union = (SetQuery)command;
            group = this.getQueryGroup(union.getProjectedQuery());
        } else if (command instanceof ProcedureContainer) {
            group = ((ProcedureContainer)command).getGroup();
        } else if (command instanceof BatchedUpdateCommand) {
            if (command.getSubCommands().get(0) instanceof Update) {
                group = ((Update)command.getSubCommands().get(0)).getGroup();
            }
            if (this.recordingCommands) {
                Iterator it = ((BatchedUpdateCommand)command).getUpdateCommands().iterator();
                while (it.hasNext()) {
                    this.queries.add(((Command)it.next()).toString());
                }
            }
        }
        Object groupID = group.getMetadataID();
        Object[] tupleInfo = (Object[])this.tuples.get(groupID);
        ArrayList elements = (ArrayList)tupleInfo[0];
        List[] tuples = (List[])tupleInfo[1];
        List projectedSymbols = command.getProjectedSymbols();
        int[] columnMap = this.getColumnMap(elements, projectedSymbols);
        ArrayList<Command> updateCommands = new ArrayList<Command>();
        if (command instanceof Query) {
            Query query = (Query)command;
            if (query.getCriteria() != null) {
                Object element;
                int i;
                HashMap lookupMap = new HashMap();
                for (i = 0; i < elements.size(); ++i) {
                    element = elements.get(i);
                    this.mapElementToIndex(lookupMap, element, new Integer(i), group);
                }
                for (i = 0; i < projectedSymbols.size(); ++i) {
                    element = projectedSymbols.get(i);
                    this.mapElementToIndex(lookupMap, element, new Integer(columnMap[i]), group);
                }
                ArrayList<List> filteredTuples = new ArrayList<List>();
                for (int i2 = 0; i2 < tuples.length; ++i2) {
                    try {
                        if (!new Evaluator(lookupMap, null, null).evaluate(query.getCriteria(), tuples[i2])) continue;
                        filteredTuples.add(tuples[i2]);
                        continue;
                    }
                    catch (ExpressionEvaluationException e) {
                        throw new TeiidComponentException((Throwable)e, e.getMessage());
                    }
                }
                tuples = new List[filteredTuples.size()];
                filteredTuples.toArray(tuples);
            }
        } else if (command instanceof Insert || command instanceof Update || command instanceof Delete) {
            updateCommands.add(command);
        } else if (command instanceof BatchedUpdateCommand) {
            updateCommands.addAll(((BatchedUpdateCommand)command).getUpdateCommands());
        }
        if (updateCommands.size() > 0) {
            ArrayList<List<Object>> filteredTuples = new ArrayList<List<Object>>();
            for (int c = 0; c < updateCommands.size(); ++c) {
                Command cmd = (Command)updateCommands.get(c);
                if (cmd instanceof TranslatableProcedureContainer) {
                    Object element;
                    int i;
                    TranslatableProcedureContainer update = (TranslatableProcedureContainer)cmd;
                    if (update.getCriteria() == null) continue;
                    HashMap lookupMap = new HashMap();
                    for (i = 0; i < elements.size(); ++i) {
                        element = elements.get(i);
                        this.mapElementToIndex(lookupMap, element, new Integer(i), group);
                    }
                    for (i = 0; i < projectedSymbols.size(); ++i) {
                        element = projectedSymbols.get(i);
                        this.mapElementToIndex(lookupMap, element, new Integer(columnMap[i]), group);
                    }
                    int updated = 0;
                    for (int i3 = 0; i3 < tuples.length; ++i3) {
                        try {
                            if (!new Evaluator(lookupMap, null, null).evaluate(update.getCriteria(), tuples[i3])) continue;
                            ++updated;
                            continue;
                        }
                        catch (ExpressionEvaluationException e) {
                            throw new TeiidComponentException((Throwable)e, e.getMessage());
                        }
                    }
                    ArrayList<Integer> updateTuple = new ArrayList<Integer>(1);
                    updateTuple.add(new Integer(updated));
                    filteredTuples.add(updateTuple);
                    continue;
                }
                filteredTuples.add(Arrays.asList(1));
            }
            tuples = new List[filteredTuples.size()];
            filteredTuples.toArray(tuples);
            elements = new ArrayList(projectedSymbols);
            columnMap[0] = 0;
        }
        FakeTupleSource ts = new FakeTupleSource(elements, tuples, projectedSymbols, columnMap);
        if (this.blockOnce) {
            ts.setBlockOnce();
        }
        return ts;
    }

    private GroupSymbol getQueryGroup(Query query) throws TeiidComponentException {
        From from = query.getFrom();
        List groups = from.getGroups();
        if (groups.size() != 1) {
            throw new TeiidComponentException("Cannot build fake tuple source for command: " + query);
        }
        GroupSymbol group = (GroupSymbol)groups.get(0);
        for (Object symbol : query.getSelect().getProjectedSymbols()) {
            if (!(symbol instanceof ElementSymbol)) continue;
            ElementSymbol elementSymbol = (ElementSymbol)symbol;
            GroupSymbol g = elementSymbol.getGroupSymbol();
            if (!g.equals((Object)group)) {
                throw new TeiidComponentException("Illegal symbol " + elementSymbol + " in SELECT of command: " + query);
            }
            if (elementSymbol.getMetadataID() == null) {
                throw new TeiidComponentException("Illegal null metadata ID in ElementSymbol " + elementSymbol + " in SELECT of command: " + query);
            }
            if (!(elementSymbol.getMetadataID() instanceof TempMetadataID)) continue;
            throw new TeiidComponentException("Illegal TempMetadataID in ElementSymbol " + elementSymbol + " in SELECT of command: " + query);
        }
        return group;
    }

    private void mapElementToIndex(Map lookupMap, Object element, Integer index, GroupSymbol group) {
        if (group.getDefinition() != null) {
            String groupAlias = group.getCanonicalName();
            ElementSymbol elementSymbol = (ElementSymbol)SymbolMap.getExpression((Expression)((SingleElementSymbol)element));
            String newName = groupAlias + "." + elementSymbol.getShortName();
            ElementSymbol aliasedElement = new ElementSymbol(newName, elementSymbol.getDisplayFullyQualified());
            aliasedElement.setGroupSymbol(elementSymbol.getGroupSymbol());
            aliasedElement.setMetadataID(elementSymbol.getMetadataID());
            aliasedElement.setType(elementSymbol.getType());
            lookupMap.put(aliasedElement, index);
        } else {
            lookupMap.put(element, index);
        }
    }

    private int[] getColumnMap(List allElements, List expectedElements) {
        int[] map = new int[expectedElements.size()];
        for (int i = 0; i < expectedElements.size(); ++i) {
            SingleElementSymbol symbol = (SingleElementSymbol)expectedElements.get(i);
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
            }
            String shortName = symbol.getShortName();
            boolean foundMatch = false;
            for (int j = 0; j < allElements.size(); ++j) {
                SingleElementSymbol tupleSymbol = (SingleElementSymbol)allElements.get(j);
                if (!tupleSymbol.getShortName().equalsIgnoreCase(shortName)) continue;
                map[i] = j;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            map[i] = -1;
        }
        return map;
    }

    public void setThrowBlocked(boolean throwBlocked) {
        this.throwBlocked = throwBlocked;
    }

    public void defineCodeTable(String tableName, String keyCol, String retCol, Map values) {
        String key = tableName.toUpperCase() + keyCol.toUpperCase() + retCol.toUpperCase();
        this.codeTableValues.put(key, values);
        this.blockedState.put(key, Boolean.FALSE);
    }

    public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, TeiidComponentException {
        String tableKey = codeTableName.toUpperCase() + keyElementName.toUpperCase() + returnElementName.toUpperCase();
        if (!this.codeTableValues.containsKey(tableKey)) {
            throw new TeiidComponentException("Unknown code table: " + codeTableName);
        }
        if (this.throwBlocked && this.blockedState.get(tableKey).equals(Boolean.FALSE)) {
            this.blockedState.put(tableKey, Boolean.TRUE);
            throw BlockedException.INSTANCE;
        }
        Map values = (Map)this.codeTableValues.get(tableKey);
        return values.get(keyValue);
    }

    public void setBlockOnce() {
        this.blockOnce = true;
    }

    public boolean isRecordingCommands() {
        return this.recordingCommands;
    }

    public void setRecordingCommands(boolean shouldRecord) {
        this.recordingCommands = shouldRecord;
    }

    public void registerTuples(QueryMetadataInterface metadata, String groupName, List[] tuples) throws QueryResolverException, TeiidComponentException {
        GroupSymbol group = new GroupSymbol(groupName);
        ResolverUtil.resolveGroup((GroupSymbol)group, (QueryMetadataInterface)metadata);
        List elementSymbols = ResolverUtil.resolveElementsInGroup((GroupSymbol)group, (QueryMetadataInterface)metadata);
        this.registerTuples(group.getMetadataID(), elementSymbols, tuples);
    }
}

