/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.CheckNoTempMetadataIDsVisitor;
import org.teiid.query.resolver.CheckSymbolsAreResolvedVisitor;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.BindVariableVisitor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.FunctionCollectorVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.sql.visitor.ReferenceCollectorVisitor;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.unittest.FakeMetadataObject;
import org.teiid.query.unittest.FakeMetadataStore;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.unittest.TimestampUtil;

public class TestResolver {
    private FakeMetadataFacade metadata;

    @Before
    public void setUp() {
        this.metadata = FakeMetadataFactory.example1Cached();
    }

    static Command helpParse(String sql) {
        try {
            return QueryParser.getQueryParser().parseCommand(sql);
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
    }

    private Command helpResolveSubquery(String sql, String[] variableNames) {
        Query query = (Query)this.helpResolve(sql);
        Collection<ElementSymbol> variables = TestResolver.getVariables((LanguageObject)query);
        Assert.assertTrue((String)("Expected variables size " + variableNames.length + " but was " + variables.size()), (variables.size() == variableNames.length ? 1 : 0) != 0);
        Iterator<ElementSymbol> variablesIter = variables.iterator();
        int i = 0;
        while (variablesIter.hasNext()) {
            ElementSymbol variable = variablesIter.next();
            Assert.assertTrue((String)("Expected variable name " + variableNames[i] + " but was " + variable.getName()), (boolean)variable.getName().equalsIgnoreCase(variableNames[i]));
            ++i;
        }
        if (variableNames.length == 0) {
            Collection symbols = CheckNoTempMetadataIDsVisitor.checkSymbols((LanguageObject)query);
            Assert.assertTrue((String)("Expected no symbols with temp metadataIDs, but got " + symbols), (boolean)symbols.isEmpty());
        }
        return query;
    }

    public static Collection<ElementSymbol> getVariables(LanguageObject languageObject) {
        Collection variables = ElementCollectorVisitor.getElements((LanguageObject)languageObject, (boolean)false, (boolean)true);
        Iterator iterator = variables.iterator();
        while (iterator.hasNext()) {
            ElementSymbol elementSymbol = (ElementSymbol)iterator.next();
            if (elementSymbol.isExternalReference()) continue;
            iterator.remove();
        }
        return variables;
    }

    public static Command helpResolve(String sql, QueryMetadataInterface queryMetadata, AnalysisRecord analysis) {
        return TestResolver.helpResolve(TestResolver.helpParse(sql), queryMetadata, analysis);
    }

    private Command helpResolve(String sql) {
        return this.helpResolve(TestResolver.helpParse(sql));
    }

    private Command helpResolve(Command command) {
        return TestResolver.helpResolve(command, (QueryMetadataInterface)this.metadata, AnalysisRecord.createNonRecordingRecord());
    }

    static Command helpResolve(Command command, QueryMetadataInterface queryMetadataInterface, AnalysisRecord analysis) {
        try {
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)queryMetadataInterface, (AnalysisRecord)analysis);
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
        CheckSymbolsAreResolvedVisitor vis = new CheckSymbolsAreResolvedVisitor();
        DeepPreOrderNavigator.doVisit((LanguageObject)command, (LanguageVisitor)vis);
        Collection unresolvedSymbols = vis.getUnresolvedSymbols();
        Assert.assertTrue((String)("Found unresolved symbols: " + unresolvedSymbols), (boolean)unresolvedSymbols.isEmpty());
        return command;
    }

    private void helpResolveFails(Command command) {
        QueryResolverException exception = null;
        try {
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)this.metadata);
        }
        catch (QueryResolverException e) {
            exception = e;
        }
        catch (TeiidException e) {
            Assert.fail((String)("Exception during resolution (" + ((Object)((Object)e)).getClass().getName() + "): " + e.getMessage()));
        }
        Assert.assertNotNull((String)"Expected a QueryResolverException but got none.", (Object)((Object)exception));
    }

    private Criteria helpResolveCriteria(String sql) {
        Criteria criteria = null;
        try {
            criteria = QueryParser.getQueryParser().parseCriteria(sql);
        }
        catch (TeiidException e) {
            Assert.fail((String)("Exception during parsing (" + ((Object)((Object)e)).getClass().getName() + "): " + e.getMessage()));
        }
        try {
            QueryResolver.resolveCriteria((Criteria)criteria, (QueryMetadataInterface)this.metadata);
        }
        catch (TeiidException e) {
            e.printStackTrace();
            Assert.fail((String)("Exception during resolution (" + ((Object)((Object)e)).getClass().getName() + "): " + e.getMessage()));
        }
        CheckSymbolsAreResolvedVisitor vis = new CheckSymbolsAreResolvedVisitor();
        DeepPreOrderNavigator.doVisit((LanguageObject)criteria, (LanguageVisitor)vis);
        Collection unresolvedSymbols = vis.getUnresolvedSymbols();
        Assert.assertTrue((String)("Found unresolved symbols: " + unresolvedSymbols), (boolean)unresolvedSymbols.isEmpty());
        return criteria;
    }

    private Command helpResolve(String sql, List bindings) {
        Command command = TestResolver.helpParse(sql);
        if (bindings != null) {
            try {
                BindVariableVisitor.bindReferences((LanguageObject)command, (List)bindings, (QueryMetadataInterface)this.metadata);
            }
            catch (TeiidException e) {
                Assert.fail((String)("Exception during binding (" + ((Object)((Object)e)).getClass().getName() + "): " + e.getMessage()));
            }
        }
        try {
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)this.metadata);
        }
        catch (TeiidException e) {
            Assert.fail((String)("Exception during resolution (" + ((Object)((Object)e)).getClass().getName() + "): " + e.getMessage()));
        }
        CheckSymbolsAreResolvedVisitor vis = new CheckSymbolsAreResolvedVisitor();
        DeepPreOrderNavigator.doVisit((LanguageObject)command, (LanguageVisitor)vis);
        Collection unresolvedSymbols = vis.getUnresolvedSymbols();
        Assert.assertTrue((String)("Found unresolved symbols: " + unresolvedSymbols), (boolean)unresolvedSymbols.isEmpty());
        return command;
    }

    static void helpResolveException(String sql, QueryMetadataInterface queryMetadata) {
        TestResolver.helpResolveException(sql, queryMetadata, null);
    }

    static void helpResolveException(String sql, QueryMetadataInterface queryMetadata, String expectedExceptionMessage) {
        Command command = TestResolver.helpParse(sql);
        try {
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)queryMetadata);
            Assert.fail((String)("Expected exception for resolving " + sql));
        }
        catch (QueryResolverException e) {
            if (expectedExceptionMessage != null) {
                Assert.assertEquals((Object)expectedExceptionMessage, (Object)e.getMessage());
            }
        }
        catch (TeiidComponentException e) {
            throw new RuntimeException(e);
        }
    }

    private void helpResolveException(String sql, String expectedExceptionMessage) {
        TestResolver.helpResolveException(sql, (QueryMetadataInterface)this.metadata, expectedExceptionMessage);
    }

    private void helpResolveException(String sql) {
        TestResolver.helpResolveException(sql, (QueryMetadataInterface)this.metadata);
    }

    private void helpCheckFrom(Query query, String[] groupIDs) {
        From from = query.getFrom();
        List groups = from.getGroups();
        Assert.assertEquals((String)"Wrong number of group IDs: ", (long)groupIDs.length, (long)groups.size());
        for (int i = 0; i < groups.size(); ++i) {
            GroupSymbol group = (GroupSymbol)groups.get(i);
            String matchString = null;
            if (group.getMetadataID() instanceof FakeMetadataObject) {
                matchString = ((FakeMetadataObject)group.getMetadataID()).getName();
            } else if (group.getMetadataID() instanceof TempMetadataID) {
                matchString = ((TempMetadataID)group.getMetadataID()).getID();
            }
            Assert.assertEquals((String)"Group ID does not match: ", (Object)groupIDs[i].toUpperCase(), (Object)matchString.toUpperCase());
        }
    }

    private void helpCheckSelect(Query query, String[] elementNames) {
        Select select = query.getSelect();
        List elements = select.getSymbols();
        Assert.assertEquals((String)"Wrong number of select symbols: ", (long)elementNames.length, (long)elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            SelectSymbol symbol = (SelectSymbol)elements.get(i);
            Assert.assertEquals((String)"Element name does not match: ", (Object)elementNames[i].toUpperCase(), (Object)symbol.getName().toUpperCase());
        }
    }

    private void helpCheckElements(LanguageObject langObj, String[] elementNames, String[] elementIDs) {
        ArrayList elements = new ArrayList();
        ElementCollectorVisitor.getElements((LanguageObject)langObj, elements);
        Assert.assertEquals((String)"Wrong number of elements: ", (long)elementNames.length, (long)elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol symbol = (ElementSymbol)elements.get(i);
            Assert.assertEquals((String)"Element name does not match: ", (Object)elementNames[i].toUpperCase(), (Object)symbol.getName().toUpperCase());
            FakeMetadataObject elementID = (FakeMetadataObject)symbol.getMetadataID();
            Assert.assertNotNull((String)("ElementSymbol " + symbol + " was not resolved and has no metadataID"), (Object)elementID);
            Assert.assertEquals((String)"ElementID name does not match: ", (Object)elementIDs[i].toUpperCase(), (Object)elementID.getName().toUpperCase());
        }
    }

    private void helpTestIsXMLQuery(String sql, boolean isXML) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        Query query = (Query)TestResolver.helpParse(sql);
        boolean actual = QueryResolver.isXMLQuery((Query)query, (QueryMetadataInterface)this.metadata);
        Assert.assertEquals((String)"Wrong answer for isXMLQuery", (Object)isXML, (Object)actual);
    }

    private StoredProcedure helpResolveExec(String sql, Object[] expectedParameterExpressions) {
        StoredProcedure proc = (StoredProcedure)this.helpResolve(sql);
        List params = proc.getParameters();
        Iterator paramIter = params.iterator();
        while (paramIter.hasNext()) {
            SPParameter param = (SPParameter)paramIter.next();
            if (param.getParameterType() == 1 || param.getParameterType() == 3) continue;
            paramIter.remove();
        }
        Assert.assertEquals((long)expectedParameterExpressions.length, (long)params.size());
        for (int i = 0; i < expectedParameterExpressions.length; ++i) {
            SPParameter param = (SPParameter)params.get(i);
            if (expectedParameterExpressions[i] == null) {
                Assert.assertNull((Object)param.getExpression());
                continue;
            }
            Assert.assertEquals((Object)expectedParameterExpressions[i], (Object)param.getExpression());
        }
        return proc;
    }

    @Test
    public void testElementSymbolForms() {
        String sql = "SELECT pm1.g1.e1, e2, pm1.g1.e3 AS a, e4 AS b FROM pm1.g1";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.g1.e1", "pm1.g1.e2", "a", "b"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"pm1.g1.e1", "pm1.g1.e2", "pm1.g1.e3", "pm1.g1.e4"}, new String[]{"pm1.g1.e1", "pm1.g1.e2", "pm1.g1.e3", "pm1.g1.e4"});
        Assert.assertEquals((String)"Resolved string form was incorrect ", (Object)sql, (Object)resolvedQuery.toString());
    }

    @Test
    public void testElementSymbolFormsWithAliasedGroup() {
        String sql = "SELECT x.e1, e2, x.e3 AS a, e4 AS b FROM pm1.g1 AS x";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        this.helpCheckSelect(resolvedQuery, new String[]{"x.e1", "x.e2", "a", "b"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"x.e1", "x.e2", "x.e3", "x.e4"}, new String[]{"pm1.g1.e1", "pm1.g1.e2", "pm1.g1.e3", "pm1.g1.e4"});
        Assert.assertEquals((String)"Resolved string form was incorrect ", (Object)sql, (Object)resolvedQuery.toString());
    }

    @Test
    public void testGroupWithVDB() {
        String sql = "SELECT e1 FROM myvdb.pm1.g1";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        Assert.assertEquals((String)"Resolved string form was incorrect ", (Object)sql, (Object)resolvedQuery.toString());
    }

    @Test
    public void testAliasedGroupWithVDB() {
        String sql = "SELECT e1 FROM myvdb.pm1.g1 AS x";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        Assert.assertEquals((String)"Resolved string form was incorrect ", (Object)sql, (Object)resolvedQuery.toString());
    }

    @Test
    public void testPartiallyQualifiedGroup1() {
        this.metadata = FakeMetadataFactory.example3();
        String sql = "SELECT e1 FROM cat2.cat3.g1";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.cat1.cat2.cat3.g1"});
    }

    @Test
    public void testPartiallyQualifiedGroup2() {
        this.metadata = FakeMetadataFactory.example3();
        String sql = "SELECT e1 FROM cat1.g2";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.cat1.g2"});
    }

    @Test
    public void testPartiallyQualifiedGroup3() {
        this.metadata = FakeMetadataFactory.example3();
        String sql = "SELECT e1 FROM cat1.cat2.cat3.g1";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.cat1.cat2.cat3.g1"});
    }

    @Test
    public void testPartiallyQualifiedGroup4() {
        this.metadata = FakeMetadataFactory.example3();
        String sql = "SELECT e1 FROM cat2.g2";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckFrom(resolvedQuery, new String[]{"pm2.cat2.g2"});
    }

    @Test
    public void testPartiallyQualifiedGroup5() {
        this.metadata = FakeMetadataFactory.example3();
        String sql = "SELECT e1 FROM cat2.g3";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.cat2.g3"});
    }

    @Test
    public void testPartiallyQualifiedGroup6() {
        this.metadata = FakeMetadataFactory.example3();
        String sql = "SELECT e1 FROM cat1.g1";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckFrom(resolvedQuery, new String[]{"pm2.cat1.g1"});
    }

    @Test
    public void testPartiallyQualifiedGroup7() {
        this.metadata = FakeMetadataFactory.example3();
        String sql = "SELECT e1 FROM g4";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckFrom(resolvedQuery, new String[]{"pm2.g4"});
    }

    @Test
    public void testPartiallyQualifiedGroup8() {
        this.metadata = FakeMetadataFactory.example3();
        String sql = "SELECT e1 FROM pm2.g3";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckFrom(resolvedQuery, new String[]{"pm2.g3"});
    }

    @Test
    public void testPartiallyQualifiedGroupWithAlias() {
        this.metadata = FakeMetadataFactory.example3();
        String sql = "SELECT X.e1 FROM cat2.cat3.g1 as X";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.cat1.cat2.cat3.g1"});
    }

    @Test
    public void testPartiallyQualifiedElement1() {
        this.metadata = FakeMetadataFactory.example3();
        String sql = "SELECT cat2.cat3.g1.e1 FROM cat2.cat3.g1";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.cat1.cat2.cat3.g1.e1"});
    }

    @Test
    public void testPartiallyQualifiedElement2() {
        this.metadata = FakeMetadataFactory.example3();
        String sql = "SELECT cat3.g1.e1 FROM cat2.cat3.g1";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.cat1.cat2.cat3.g1.e1"});
    }

    @Test
    public void testPartiallyQualifiedElement3() {
        this.metadata = FakeMetadataFactory.example3();
        String sql = "SELECT cat3.g1.e1 FROM cat2.cat3.g1, cat1.g2";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.cat1.cat2.cat3.g1.e1"});
    }

    @Test
    public void testPartiallyQualifiedElement4() {
        this.metadata = FakeMetadataFactory.example3();
        String sql = "SELECT cat3.g1.e1, cat1.g2.e1 FROM cat2.cat3.g1, cat1.g2";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.cat1.cat2.cat3.g1.e1", "pm1.cat1.g2.e1"});
    }

    @Test
    public void testPartiallyQualifiedElement5() {
        this.metadata = FakeMetadataFactory.example3();
        String sql = "SELECT cat3.g1.e1, cat1.g2.e1 FROM myvdb.pm1.cat1.cat2.cat3.g1, pm1.cat1.g2";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.cat1.cat2.cat3.g1.e1", "pm1.cat1.g2.e1"});
    }

    @Test
    public void testPartiallyQualifiedElement6() {
        this.metadata = FakeMetadataFactory.example3();
        String sql = "SELECT cat3.g1.e1, e2 FROM cat2.cat3.g1";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.cat1.cat2.cat3.g1.e1", "pm1.cat1.cat2.cat3.g1.e2"});
    }

    @Test
    public void testPartiallyQualifiedElement7() {
        this.metadata = FakeMetadataFactory.example3();
        String sql = "SELECT cat3.g1.e1, cat2.cat3.g1.e2, g1.e3 FROM pm1.cat1.cat2.cat3.g1";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.cat1.cat2.cat3.g1.e1", "pm1.cat1.cat2.cat3.g1.e2", "pm1.cat1.cat2.cat3.g1.e3"});
    }

    @Test
    public void testFailPartiallyQualifiedGroup1() {
        this.metadata = FakeMetadataFactory.example3();
        this.helpResolveException("SELECT e1 FROM cat3.g1");
    }

    @Test
    public void testFailPartiallyQualifiedGroup2() {
        this.metadata = FakeMetadataFactory.example3();
        this.helpResolveException("SELECT e1 FROM g1");
    }

    @Test
    public void testFailPartiallyQualifiedGroup3() {
        this.metadata = FakeMetadataFactory.example3();
        this.helpResolveException("SELECT e1 FROM g2");
    }

    @Test
    public void testFailPartiallyQualifiedGroup4() {
        this.metadata = FakeMetadataFactory.example3();
        this.helpResolveException("SELECT e1 FROM g3");
    }

    @Test
    public void testFailPartiallyQualifiedGroup5() {
        this.metadata = FakeMetadataFactory.example3();
        this.helpResolveException("SELECT e1 FROM g5");
    }

    @Test
    public void testFailPartiallyQualifiedElement1() {
        this.metadata = FakeMetadataFactory.example3();
        this.helpResolveException("SELECT cat3.g1.e1 FROM pm1.cat1.cat2.cat3.g1, pm2.cat3.g1");
    }

    @Test
    public void testFailPartiallyQualifiedElement2() {
        this.metadata = FakeMetadataFactory.example3();
        this.helpResolveException("SELECT g1.e1 FROM pm1.cat1.cat2.cat3.g1, pm2.cat3.g1");
    }

    @Test
    public void testFailPartiallyQualifiedElement3() {
        this.metadata = FakeMetadataFactory.example3();
        this.helpResolveException("SELECT cat3.g1.e1 FROM pm2.cat2.g2, pm1.cat2.g3");
    }

    @Test
    public void testFailPartiallyQualifiedElement4() {
        this.metadata = FakeMetadataFactory.example3();
        this.helpResolveException("SELECT cat3.g1.e1 FROM pm2.cat2.g2");
    }

    @Test
    public void testFailPartiallyQualifiedElement5() {
        this.metadata = FakeMetadataFactory.example3();
        this.helpResolveException("SELECT cat3.g1.e1 FROM g1");
    }

    @Test
    public void testElementWithVDB() {
        String sql = "SELECT myvdb.pm1.g1.e1 FROM pm1.g1";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.g1.e1"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
        Assert.assertEquals((String)"Resolved string form was incorrect ", (Object)sql, (Object)resolvedQuery.toString());
    }

    @Test
    public void testAliasedElementWithVDB() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT myvdb.pm1.g1.e1 AS x FROM pm1.g1");
        this.helpCheckSelect(resolvedQuery, new String[]{"x"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testSelectStar() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT * FROM pm1.g1");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        this.helpCheckSelect(resolvedQuery, new String[]{"*"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"pm1.g1.e1", "pm1.g1.e2", "pm1.g1.e3", "pm1.g1.e4"}, new String[]{"pm1.g1.e1", "pm1.g1.e2", "pm1.g1.e3", "pm1.g1.e4"});
    }

    @Test
    public void testSelectStarFromAliasedGroup() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT * FROM pm1.g1 as x");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        this.helpCheckSelect(resolvedQuery, new String[]{"*"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"x.e1", "x.e2", "x.e3", "x.e4"}, new String[]{"pm1.g1.e1", "pm1.g1.e2", "pm1.g1.e3", "pm1.g1.e4"});
    }

    @Test
    public void testSelectStarFromMultipleAliasedGroups() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT * FROM pm1.g1 as x, pm1.g1 as y");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1", "pm1.g1"});
        this.helpCheckSelect(resolvedQuery, new String[]{"*"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"x.e1", "x.e2", "x.e3", "x.e4", "y.e1", "y.e2", "y.e3", "y.e4"}, new String[]{"pm1.g1.e1", "pm1.g1.e2", "pm1.g1.e3", "pm1.g1.e4", "pm1.g1.e1", "pm1.g1.e2", "pm1.g1.e3", "pm1.g1.e4"});
    }

    @Test
    public void testSelectStarWhereSomeElementsAreNotSelectable() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT * FROM pm1.g4");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g4"});
        this.helpCheckSelect(resolvedQuery, new String[]{"*"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"pm1.g4.e1", "pm1.g4.e3"}, new String[]{"pm1.g4.e1", "pm1.g4.e3"});
    }

    @Test
    public void testSelectGroupStarWhereSomeElementsAreNotSelectable() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT pm1.g4.* FROM pm1.g4");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g4"});
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.g4.*"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"pm1.g4.e1", "pm1.g4.e3"}, new String[]{"pm1.g4.e1", "pm1.g4.e3"});
    }

    @Test
    public void testFullyQualifiedSelectStar() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT pm1.g1.* FROM pm1.g1");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.g1.*"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"pm1.g1.e1", "pm1.g1.e2", "pm1.g1.e3", "pm1.g1.e4"}, new String[]{"pm1.g1.e1", "pm1.g1.e2", "pm1.g1.e3", "pm1.g1.e4"});
    }

    @Test
    public void testSelectAllInAliasedGroup() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT x.* FROM pm1.g1 as x");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        this.helpCheckSelect(resolvedQuery, new String[]{"x.*"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"x.e1", "x.e2", "x.e3", "x.e4"}, new String[]{"pm1.g1.e1", "pm1.g1.e2", "pm1.g1.e3", "pm1.g1.e4"});
    }

    @Test
    public void testSelectExpressions() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT e1, concat(e1, 's'), concat(e1, 's') as c FROM pm1.g1");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.g1.e1", "expr", "c"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"pm1.g1.e1", "pm1.g1.e1", "pm1.g1.e1"}, new String[]{"pm1.g1.e1", "pm1.g1.e1", "pm1.g1.e1"});
    }

    @Test
    public void testSelectCountStar() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT count(*) FROM pm1.g1");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        this.helpCheckSelect(resolvedQuery, new String[]{"count"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[0], new String[0]);
    }

    @Test
    public void testMultipleIdenticalElements() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT e1, e1 FROM pm1.g1");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.g1.e1", "pm1.g1.e1"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"pm1.g1.e1", "pm1.g1.e1"}, new String[]{"pm1.g1.e1", "pm1.g1.e1"});
    }

    @Test
    public void testMultipleIdenticalElements2() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT e1, pm1.g1.e1 FROM pm1.g1");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.g1.e1", "pm1.g1.e1"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"pm1.g1.e1", "pm1.g1.e1"}, new String[]{"pm1.g1.e1", "pm1.g1.e1"});
    }

    @Test
    public void testMultipleIdenticalElements3() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT e1, e1 as x FROM pm1.g1");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.g1.e1", "x"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"pm1.g1.e1", "pm1.g1.e1"}, new String[]{"pm1.g1.e1", "pm1.g1.e1"});
    }

    @Test
    public void testDifferentElementsSameName() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT e1 as x, e2 as x FROM pm1.g2");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g2"});
        this.helpCheckSelect(resolvedQuery, new String[]{"x", "x"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"pm1.g2.e1", "pm1.g2.e2"}, new String[]{"pm1.g2.e1", "pm1.g2.e2"});
    }

    @Test
    public void testDifferentConstantsSameName() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT 1 as x, 2 as x FROM pm1.g2");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g2"});
        this.helpCheckSelect(resolvedQuery, new String[]{"x", "x"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[0], new String[0]);
    }

    @Test
    public void testFailSameGroupsWithSameNames() {
        this.helpResolveException("SELECT * FROM pm1.g1 as x, pm1.g1 as x");
    }

    @Test
    public void testFailDifferentGroupsWithSameNames() {
        this.helpResolveException("SELECT * FROM pm1.g1 as x, pm1.g2 as x");
    }

    @Test
    public void testFailAmbiguousElement() {
        this.helpResolveException("SELECT e1 FROM pm1.g1, pm1.g2");
    }

    @Test
    public void testFailAmbiguousElementAliasedGroup() {
        this.helpResolveException("SELECT e1 FROM pm1.g1 as x, pm1.g1");
    }

    @Test
    public void testFailFullyQualifiedElementUnknownGroup() {
        this.helpResolveException("SELECT pm1.g1.e1 FROM pm1.g2");
    }

    @Test
    public void testFailUnknownGroup() {
        this.helpResolveException("SELECT x.e1 FROM x");
    }

    @Test
    public void testFailUnknownElement() {
        this.helpResolveException("SELECT x FROM pm1.g1");
    }

    @Test
    public void testFailFunctionOfAggregatesInSelect() {
        this.helpResolveException("SELECT (SUM(e0) * COUNT(e0)) FROM test.group GROUP BY e0");
    }

    @Test
    public void testFailGroupNotReferencedByAlias() {
        this.helpResolveException("SELECT pm1.g1.x FROM pm1.g1 as H");
    }

    @Test
    public void testFailGroupNotReferencedByAliasSelectAll() {
        this.helpResolveException("SELECT pm1.g1.* FROM pm1.g1 as H");
    }

    @Test
    public void testComplicatedQuery() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT pm1.g1.e2 as y, pm1.g1.E3 as z, CONVERT(pm1.g1.e1, integer) * 1000 as w  FROM pm1.g1 WHERE e1 <> 'x'");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        this.helpCheckSelect(resolvedQuery, new String[]{"y", "z", "w"});
        this.helpCheckElements((LanguageObject)resolvedQuery, new String[]{"pm1.g1.e2", "pm1.g1.e3", "pm1.g1.e1", "pm1.g1.e1"}, new String[]{"pm1.g1.e2", "pm1.g1.e3", "pm1.g1.e1", "pm1.g1.e1"});
    }

    @Test
    public void testJoinQuery() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT pm3.g1.e2, pm3.g2.e2 FROM pm3.g1, pm3.g2 WHERE pm3.g1.e2=pm3.g2.e2");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm3.g1", "pm3.g2"});
        this.helpCheckSelect(resolvedQuery, new String[]{"pm3.g1.e2", "pm3.g2.e2"});
        this.helpCheckElements((LanguageObject)resolvedQuery, new String[]{"pm3.g1.e2", "pm3.g2.e2", "pm3.g1.e2", "pm3.g2.e2"}, new String[]{"pm3.g1.e2", "pm3.g2.e2", "pm3.g1.e2", "pm3.g2.e2"});
    }

    @Test
    public void testHavingRequiringConvertOnAggregate1() {
        this.helpResolve("SELECT * FROM pm1.g1 GROUP BY e4 HAVING MAX(e2) > 1.2");
    }

    @Test
    public void testHavingRequiringConvertOnAggregate2() {
        this.helpResolve("SELECT * FROM pm1.g1 GROUP BY e4 HAVING MIN(e2) > 1.2");
    }

    @Test
    public void testHavingRequiringConvertOnAggregate3() {
        this.helpResolve("SELECT * FROM pm1.g1 GROUP BY e4 HAVING 1.2 > MAX(e2)");
    }

    @Test
    public void testHavingRequiringConvertOnAggregate4() {
        this.helpResolve("SELECT * FROM pm1.g1 GROUP BY e4 HAVING 1.2 > MIN(e2)");
    }

    @Test
    public void testHavingWithAggsOfDifferentTypes() {
        this.helpResolve("SELECT * FROM pm1.g1 GROUP BY e4 HAVING MIN(e1) = MIN(e2)");
    }

    @Test
    public void testCaseInGroupBy() {
        String sql = "SELECT SUM(e2) FROM pm1.g1 GROUP BY CASE WHEN e2 = 0 THEN 1 ELSE 2 END";
        Command command = this.helpResolve(sql);
        Assert.assertEquals((Object)sql, (Object)command.toString());
        this.helpCheckElements((LanguageObject)command, new String[]{"pm1.g1.e2", "pm1.g1.e2"}, new String[]{"pm1.g1.e2", "pm1.g1.e2"});
    }

    @Test
    public void testFunctionInGroupBy() {
        String sql = "SELECT SUM(e2) FROM pm1.g1 GROUP BY (e2 + 1)";
        Command command = this.helpResolve(sql);
        Assert.assertEquals((Object)sql, (Object)command.toString());
        this.helpCheckElements((LanguageObject)command, new String[]{"pm1.g1.e2", "pm1.g1.e2"}, new String[]{"pm1.g1.e2", "pm1.g1.e2"});
    }

    @Test
    public void testUnknownFunction() {
        this.helpResolveException("SELECT abc(e1) FROM pm1.g1", "Error Code:ERR.015.008.0039 Message:The function 'abc(e1)' is an unknown form.  Check that the function name and number of arguments is correct.");
    }

    @Test
    public void testConversionNotPossible() {
        this.helpResolveException("SELECT dayofmonth('2002-01-01') FROM pm1.g1", "Error Code:ERR.015.008.0040 Message:The function 'dayofmonth('2002-01-01')' is a valid function form, but the arguments do not match a known type signature and cannot be converted using implicit type conversions.");
    }

    @Test
    public void testResolveParameters() {
        ArrayList<String> bindings = new ArrayList<String>();
        bindings.add("pm1.g2.e1");
        bindings.add("pm1.g2.e2");
        Query resolvedQuery = (Query)this.helpResolve("SELECT pm1.g1.e1, ? FROM pm1.g1 WHERE pm1.g1.e1 = ?", bindings);
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.g1.e1", "expr"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getCriteria(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testResolveParametersInsert() {
        ArrayList<String> bindings = new ArrayList<String>();
        bindings.add("pm1.g2.e1");
        this.helpResolve("INSERT INTO pm1.g1 (e1) VALUES (?)", bindings);
    }

    @Test
    public void testResolveParametersExec() {
        ArrayList<String> bindings = new ArrayList<String>();
        bindings.add("pm1.g2.e1");
        Query resolvedQuery = (Query)this.helpResolve("SELECT * FROM (exec pm1.sq2(?)) as a", bindings);
        List refs = ReferenceCollectorVisitor.getReferences((LanguageObject)resolvedQuery);
        Reference ref = (Reference)refs.get(0);
        Assert.assertNotNull((Object)ref.getType());
    }

    @Test
    public void testUseNonExistentAlias() {
        this.helpResolveException("SELECT portfoliob.e1 FROM ((pm1.g1 AS portfoliob JOIN pm1.g2 AS portidentb ON portfoliob.e1 = portidentb.e1) RIGHT OUTER JOIN pm1.g3 AS identifiersb ON portidentb.e1 = 'ISIN' and portidentb.e2 = identifiersb.e2) RIGHT OUTER JOIN pm1.g1 AS issuesb ON a.identifiersb.e1 = issuesb.e1");
    }

    @Test
    public void testCriteria1() {
        CompareCriteria expected = new CompareCriteria();
        ElementSymbol es = new ElementSymbol("pm1.g1.e1");
        GroupSymbol gs = new GroupSymbol("pm1.g1");
        es.setGroupSymbol(gs);
        expected.setLeftExpression((Expression)es);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)"abc"));
        Criteria actual = this.helpResolveCriteria("pm1.g1.e1 = 'abc'");
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    @Test
    public void testSubquery1() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT e1 FROM pm1.g1, (SELECT pm1.g2.e1 AS x FROM pm1.g2) AS y WHERE e1 = x");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1", "y"});
        this.helpCheckSelect(resolvedQuery, new String[]{"pm1.g1.e1"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testStoredQuery1() {
        StoredProcedure proc = (StoredProcedure)this.helpResolve("EXEC pm1.sq2('abc')");
        List params = proc.getParameters();
        Assert.assertEquals((String)"Did not get expected parameter count", (long)2L, (long)params.size());
        SPParameter param1 = (SPParameter)params.get(0);
        this.helpCheckParameter(param1, 5, 1, "pm1.sq2.ret", ResultSet.class, null);
        SPParameter param2 = (SPParameter)params.get(1);
        this.helpCheckParameter(param2, 1, 2, "pm1.sq2.in", DataTypeManager.DefaultDataClasses.STRING, (Expression)new Constant((Object)"abc"));
    }

    @Test
    public void testStoredQueryParamOrdering_8211() {
        StoredProcedure proc = (StoredProcedure)this.helpResolve("EXEC pm1.sq3a('abc', 123)");
        List params = proc.getParameters();
        Assert.assertEquals((String)"Did not get expected parameter count", (long)2L, (long)params.size());
        SPParameter param1 = (SPParameter)params.get(0);
        this.helpCheckParameter(param1, 1, 1, "pm1.sq3a.in", DataTypeManager.DefaultDataClasses.STRING, (Expression)new Constant((Object)"abc"));
        SPParameter param2 = (SPParameter)params.get(1);
        this.helpCheckParameter(param2, 1, 3, "pm1.sq3a.in2", DataTypeManager.DefaultDataClasses.INTEGER, (Expression)new Constant((Object)new Integer(123)));
    }

    private void helpCheckParameter(SPParameter param, int paramType, int index, String name, Class type, Expression expr) {
        Assert.assertEquals((String)"Did not get expected parameter type", (long)paramType, (long)param.getParameterType());
        Assert.assertEquals((String)"Did not get expected index for param", (long)index, (long)param.getIndex());
        Assert.assertEquals((String)"Did not get expected name for param", (Object)name, (Object)param.getName());
        Assert.assertEquals((String)"Did not get expected type for param", (Object)type, (Object)param.getClassType());
        Assert.assertEquals((String)"Did not get expected type for param", (Object)expr, (Object)param.getExpression());
    }

    @Test
    public void testStoredSubQuery1() {
        Query resolvedQuery = (Query)this.helpResolve("select x.e1 from (EXEC pm1.sq1()) as x");
        this.helpCheckFrom(resolvedQuery, new String[]{"x"});
        this.helpCheckSelect(resolvedQuery, new String[]{"x.e1"});
    }

    @Test
    public void testStoredSubQuery2() {
        Query resolvedQuery = (Query)this.helpResolve("select x.e1 from (EXEC pm1.sq3('abc', 5)) as x");
        this.helpCheckFrom(resolvedQuery, new String[]{"x"});
        this.helpCheckSelect(resolvedQuery, new String[]{"x.e1"});
    }

    @Test
    public void testStoredSubQuery3() {
        Query resolvedQuery = (Query)this.helpResolve("select * from (EXEC pm1.sq2('abc')) as x");
        this.helpCheckFrom(resolvedQuery, new String[]{"x"});
        List elements = (List)ElementCollectorVisitor.getElements((LanguageObject)resolvedQuery.getSelect(), (boolean)false);
        ElementSymbol elem1 = (ElementSymbol)elements.get(0);
        Assert.assertEquals((String)"Did not get expected element", (Object)"X.e1", (Object)elem1.getName());
        Assert.assertEquals((String)"Did not get expected type", (Object)DataTypeManager.DefaultDataClasses.STRING, (Object)elem1.getType());
        ElementSymbol elem2 = (ElementSymbol)elements.get(1);
        Assert.assertEquals((String)"Did not get expected element", (Object)"X.e2", (Object)elem2.getName());
        Assert.assertEquals((String)"Did not get expected type", (Object)DataTypeManager.DefaultDataClasses.INTEGER, (Object)elem2.getType());
    }

    @Test
    public void testStoredQueryTransformationWithVariable() throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand("SELECT * FROM pm1.g1 WHERE pm1.sq5.in1 = 5");
        GroupSymbol sqGroup = new GroupSymbol("pm1.sq5");
        ArrayList<ElementSymbol> sqParams = new ArrayList<ElementSymbol>();
        ElementSymbol in = new ElementSymbol("pm1.sq5.in1");
        in.setType(DataTypeManager.DefaultDataClasses.STRING);
        sqParams.add(in);
        HashMap<GroupSymbol, ArrayList<ElementSymbol>> externalMetadata = new HashMap<GroupSymbol, ArrayList<ElementSymbol>>();
        externalMetadata.put(sqGroup, sqParams);
        QueryResolver.resolveCommand((Command)command, externalMetadata, (QueryMetadataInterface)this.metadata, (AnalysisRecord)AnalysisRecord.createNonRecordingRecord());
        this.helpCheckFrom((Query)command, new String[]{"pm1.g1"});
        Collection<ElementSymbol> vars = TestResolver.getVariables((LanguageObject)command);
        Assert.assertEquals((String)"Did not find variable in resolved query", (long)1L, (long)vars.size());
    }

    @Test
    public void testStoredQueryTransformationWithVariable2() throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand("SELECT * FROM pm1.g1 WHERE in1 = 5");
        GroupSymbol sqGroup = new GroupSymbol("pm1.sq5");
        ArrayList<ElementSymbol> sqParams = new ArrayList<ElementSymbol>();
        ElementSymbol in = new ElementSymbol("pm1.sq5.in1");
        in.setType(DataTypeManager.DefaultDataClasses.STRING);
        sqParams.add(in);
        HashMap<GroupSymbol, ArrayList<ElementSymbol>> externalMetadata = new HashMap<GroupSymbol, ArrayList<ElementSymbol>>();
        externalMetadata.put(sqGroup, sqParams);
        QueryResolver.resolveCommand((Command)command, externalMetadata, (QueryMetadataInterface)this.metadata, (AnalysisRecord)AnalysisRecord.createNonRecordingRecord());
        this.helpCheckFrom((Query)command, new String[]{"pm1.g1"});
        Collection<ElementSymbol> vars = TestResolver.getVariables((LanguageObject)command);
        Assert.assertEquals((String)"Did not find variable in resolved query", (long)1L, (long)vars.size());
    }

    @Test
    public void testStoredQueryTransformationWithVariable3() throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand("SELECT * FROM pm1.g1 WHERE in1 = 5 UNION SELECT * FROM pm1.g1");
        GroupSymbol sqGroup = new GroupSymbol("pm1.sq5");
        ArrayList<ElementSymbol> sqParams = new ArrayList<ElementSymbol>();
        ElementSymbol in = new ElementSymbol("pm1.sq5.in1");
        in.setType(DataTypeManager.DefaultDataClasses.STRING);
        sqParams.add(in);
        HashMap<GroupSymbol, ArrayList<ElementSymbol>> externalMetadata = new HashMap<GroupSymbol, ArrayList<ElementSymbol>>();
        externalMetadata.put(sqGroup, sqParams);
        QueryResolver.resolveCommand((Command)command, externalMetadata, (QueryMetadataInterface)this.metadata, (AnalysisRecord)AnalysisRecord.createNonRecordingRecord());
        Collection<ElementSymbol> vars = TestResolver.getVariables((LanguageObject)command);
        Assert.assertEquals((String)"Did not find variable in resolved query", (long)1L, (long)vars.size());
    }

    @Test
    public void testStoredQueryTransformationWithVariable4() throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand("EXEC pm1.sq2(pm1.sq2.in)");
        try {
            GroupSymbol sqGroup = new GroupSymbol("pm1.sq5");
            ArrayList<ElementSymbol> sqParams = new ArrayList<ElementSymbol>();
            ElementSymbol in = new ElementSymbol("pm1.sq5.in1");
            in.setType(DataTypeManager.DefaultDataClasses.STRING);
            sqParams.add(in);
            HashMap<GroupSymbol, ArrayList<ElementSymbol>> externalMetadata = new HashMap<GroupSymbol, ArrayList<ElementSymbol>>();
            externalMetadata.put(sqGroup, sqParams);
            QueryResolver.resolveCommand((Command)command, externalMetadata, (QueryMetadataInterface)this.metadata, (AnalysisRecord)AnalysisRecord.createNonRecordingRecord());
            Assert.fail((String)"Expected exception on invalid variable pm1.sq2.in");
        }
        catch (QueryResolverException e) {
            Assert.assertEquals((Object)"Symbol pm1.sq2.\"in\" is specified with an unknown group context", (Object)e.getMessage());
        }
    }

    @Test
    public void testExec1() {
        this.helpResolve("EXEC pm1.sq2('xyz')");
    }

    @Test
    public void testExec2() {
        this.helpResolve("EXEC pm1.sq2(5)");
    }

    @Test
    public void testExecNamedParam() {
        Object[] expectedParameterExpressions = new Object[]{new Constant((Object)"xyz")};
        this.helpResolveExec("EXEC pm1.sq2(\"in\" = 'xyz')", expectedParameterExpressions);
    }

    @Test
    public void testExecNamedParamDup() {
        this.helpResolveException("EXEC pm1.sq2(\"in\" = 'xyz', \"in\" = 'xyz1')");
    }

    @Test
    public void testExecWrongParamName() {
        this.helpResolveException("EXEC pm1.sq2(in1 = 'xyz')");
    }

    @Test
    public void testExecNamedParams() {
        Object[] expectedParameterExpressions = new Object[]{new Constant((Object)"xyz"), new Constant((Object)new Integer(5))};
        this.helpResolveExec("EXEC pm1.sq3(\"in\" = 'xyz', in2 = 5)", expectedParameterExpressions);
    }

    @Test
    public void testExecNamedParamsReversed() {
        Object[] expectedParameterExpressions = new Object[]{new Constant((Object)"xyz"), new Constant((Object)new Integer(5))};
        this.helpResolveExec("EXEC pm1.sq3(in2 = 5, \"in\" = 'xyz')", expectedParameterExpressions);
    }

    @Test
    public void testExecNamedParamsOptionalParam() {
        Object[] expectedParameterExpressions = new Object[]{new Constant((Object)"xyz"), new Constant(null), new Constant((Object)"something")};
        this.helpResolveExec("EXEC pm1.sq3b(\"in\" = 'xyz', in3 = 'something')", expectedParameterExpressions);
    }

    @Test
    public void testExecNamedParamsOmitRequiredParamWithDefaultValue() {
        Object[] expectedParameterExpressions = new Object[]{new Constant((Object)"xyz"), new Constant((Object)new Integer(666)), new Constant((Object)"YYZ")};
        StoredProcedure sp = this.helpResolveExec("EXEC pm1.sq3b(\"in\" = 'xyz', in2 = 666)", expectedParameterExpressions);
        Assert.assertEquals((Object)"EXEC pm1.sq3b(\"in\" => 'xyz', in2 => 666)", (Object)sp.toString());
    }

    @Test
    public void testExecNamedParamsOptionalParamWithDefaults() {
        Object[] expectedParameterExpressions = this.helpGetStoredProcDefaultValues();
        expectedParameterExpressions[0] = new Constant((Object)"xyz");
        this.helpResolveExec("EXEC pm1.sqDefaults(inString = 'xyz')", expectedParameterExpressions);
    }

    @Test
    public void testExecNamedParamsOptionalParamWithDefaultsCaseInsensitive() {
        Object[] expectedParameterExpressions = this.helpGetStoredProcDefaultValues();
        expectedParameterExpressions[0] = new Constant((Object)"xyz");
        this.helpResolveExec("EXEC pm1.sqDefaults(iNsTrInG = 'xyz')", expectedParameterExpressions);
    }

    @Test
    public void testExecNamedParamsOptionalParamWithDefaults2() {
        Object[] expectedParameterExpressions = this.helpGetStoredProcDefaultValues();
        expectedParameterExpressions[3] = new Constant((Object)Boolean.FALSE);
        expectedParameterExpressions[9] = new Constant((Object)new Integer(666));
        this.helpResolveExec("EXEC pm1.sqDefaults(ininteger = 666, inboolean={b'false'})", expectedParameterExpressions);
    }

    @Test
    public void testExecNamedParamsOptionalParamWithAllDefaults() {
        Object[] expectedParameterExpressions = this.helpGetStoredProcDefaultValues();
        this.helpResolveExec("EXEC pm1.sqDefaults()", expectedParameterExpressions);
    }

    private Object[] helpGetStoredProcDefaultValues() {
        return new Object[]{new Constant((Object)"x"), new Constant((Object)new BigDecimal("13.0")), new Constant((Object)new BigInteger("13")), new Constant((Object)Boolean.TRUE), new Constant((Object)new Byte("1")), new Constant((Object)new Character('q')), new Constant((Object)Date.valueOf("2003-03-20")), new Constant((Object)new Double(13.0)), new Constant((Object)new Float(13.0)), new Constant((Object)new Integer(13)), new Constant((Object)new Long(13L)), new Constant((Object)new Short(13)), new Constant((Object)Timestamp.valueOf("2003-03-20 21:26:00.000000")), new Constant((Object)Time.valueOf("21:26:00"))};
    }

    @Test
    public void testExceptionNotSupplyingRequiredParam() {
        this.helpResolveException("EXEC pm1.sq3(in2 = 5)");
    }

    @Test
    public void testExceptionBadDefaultValue() {
        this.helpResolveException("EXEC pm1.sqBadDefault()");
    }

    @Test
    public void testExecWithForcedConvertOfStringToCorrectType() {
        this.helpResolve("EXEC pm1.sq3('x', '5')");
    }

    @Test
    public void testExecBadType() {
        this.helpResolve("EXEC pm1.sq3('xyz', {b'true'})");
    }

    @Test
    public void testSubqueryInUnion() {
        String sql = "SELECT IntKey, FloatNum FROM BQT1.MediumA WHERE (IntKey >= 0) AND (IntKey < 15) UNION ALL SELECT BQT2.SmallB.IntKey, y.FloatNum FROM BQT2.SmallB INNER JOIN (SELECT IntKey, FloatNum FROM BQT1.MediumA ) AS y ON BQT2.SmallB.IntKey = y.IntKey WHERE (y.IntKey >= 10) AND (y.IntKey < 30) ORDER BY IntKey, FloatNum";
        TestResolver.helpResolve(sql, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), null);
    }

    @Test
    public void testSubQueryINClause1() {
        Select innerSelect = new Select();
        ElementSymbol e2inner = new ElementSymbol("e2");
        innerSelect.addSymbol((SelectSymbol)e2inner);
        From innerFrom = new From();
        GroupSymbol pm4g1 = new GroupSymbol("pm4.g1");
        innerFrom.addGroup(pm4g1);
        Query innerQuery = new Query();
        innerQuery.setSelect(innerSelect);
        innerQuery.setFrom(innerFrom);
        Select outerSelect = new Select();
        ElementSymbol e1 = new ElementSymbol("e1");
        outerSelect.addSymbol((SelectSymbol)e1);
        From outerFrom = new From();
        GroupSymbol pm1g1 = new GroupSymbol("pm1.g1");
        outerFrom.addGroup(pm1g1);
        ElementSymbol e2outer = new ElementSymbol("e2");
        SubquerySetCriteria crit = new SubquerySetCriteria((Expression)e2outer, (QueryCommand)innerQuery);
        Query outerQuery = new Query();
        outerQuery.setSelect(outerSelect);
        outerQuery.setFrom(outerFrom);
        outerQuery.setCriteria((Criteria)crit);
        this.helpResolve((Command)outerQuery);
        this.helpCheckFrom(outerQuery, new String[]{"pm1.g1"});
        this.helpCheckFrom(innerQuery, new String[]{"pm4.g1"});
        this.helpCheckSelect(outerQuery, new String[]{"pm1.g1.e1"});
        this.helpCheckSelect(innerQuery, new String[]{"pm4.g1.e2"});
        this.helpCheckElements((LanguageObject)outerQuery.getSelect(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
        this.helpCheckElements((LanguageObject)innerQuery.getSelect(), new String[]{"pm4.g1.e2"}, new String[]{"pm4.g1.e2"});
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 IN (SELECT e2 FROM pm4.g1)";
        Assert.assertEquals((String)"Resolved string form was incorrect ", (Object)sql, (Object)outerQuery.toString());
    }

    @Test
    public void testSubQueryINClauseImplicitConversion() {
        Select innerSelect = new Select();
        ElementSymbol e1inner = new ElementSymbol("e1");
        innerSelect.addSymbol((SelectSymbol)e1inner);
        From innerFrom = new From();
        GroupSymbol pm4g1 = new GroupSymbol("pm4.g1");
        innerFrom.addGroup(pm4g1);
        Query innerQuery = new Query();
        innerQuery.setSelect(innerSelect);
        innerQuery.setFrom(innerFrom);
        Select outerSelect = new Select();
        ElementSymbol e1 = new ElementSymbol("e1");
        outerSelect.addSymbol((SelectSymbol)e1);
        From outerFrom = new From();
        GroupSymbol pm1g1 = new GroupSymbol("pm1.g1");
        outerFrom.addGroup(pm1g1);
        ElementSymbol e2 = new ElementSymbol("e2");
        SubquerySetCriteria crit = new SubquerySetCriteria((Expression)e2, (QueryCommand)innerQuery);
        Query outerQuery = new Query();
        outerQuery.setSelect(outerSelect);
        outerQuery.setFrom(outerFrom);
        outerQuery.setCriteria((Criteria)crit);
        this.helpResolve((Command)outerQuery);
        this.helpCheckFrom(outerQuery, new String[]{"pm1.g1"});
        this.helpCheckFrom(innerQuery, new String[]{"pm4.g1"});
        this.helpCheckSelect(outerQuery, new String[]{"pm1.g1.e1"});
        this.helpCheckSelect(innerQuery, new String[]{"pm4.g1.e1"});
        this.helpCheckElements((LanguageObject)outerQuery.getSelect(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
        this.helpCheckElements((LanguageObject)innerQuery.getSelect(), new String[]{"pm4.g1.e1"}, new String[]{"pm4.g1.e1"});
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 IN (SELECT e1 FROM pm4.g1)";
        Assert.assertEquals((String)"Resolved string form was incorrect ", (Object)sql, (Object)outerQuery.toString());
        Collection functions = FunctionCollectorVisitor.getFunctions((LanguageObject)outerQuery, (boolean)true);
        Assert.assertTrue((functions.size() == 1 ? 1 : 0) != 0);
        Function function = (Function)functions.iterator().next();
        Assert.assertTrue((boolean)function.getName().equals("convert"));
        Expression[] args = function.getArgs();
        Assert.assertSame((Object)e2, (Object)args[0]);
        Assert.assertTrue((boolean)(args[1] instanceof Constant));
    }

    @Test
    public void testSubQueryINClauseNoConversionFails() {
        Select innerSelect = new Select();
        ElementSymbol e2inner = new ElementSymbol("e2");
        innerSelect.addSymbol((SelectSymbol)e2inner);
        From innerFrom = new From();
        GroupSymbol pm4g1 = new GroupSymbol("pm4.g1");
        innerFrom.addGroup(pm4g1);
        Query innerQuery = new Query();
        innerQuery.setSelect(innerSelect);
        innerQuery.setFrom(innerFrom);
        Select outerSelect = new Select();
        ElementSymbol e1 = new ElementSymbol("e1");
        outerSelect.addSymbol((SelectSymbol)e1);
        From outerFrom = new From();
        GroupSymbol pm1g1 = new GroupSymbol("pm1.g1");
        outerFrom.addGroup(pm1g1);
        SubquerySetCriteria crit = new SubquerySetCriteria((Expression)e1, (QueryCommand)innerQuery);
        Query outerQuery = new Query();
        outerQuery.setSelect(outerSelect);
        outerQuery.setFrom(outerFrom);
        outerQuery.setCriteria((Criteria)crit);
        this.helpResolveFails((Command)outerQuery);
    }

    @Test
    public void testSubQueryINClauseTooManyColumns() {
        String sql = "select e1 from pm1.g1 where e1 in (select e1, e2 from pm4.g1)";
        this.helpResolveException(sql);
    }

    @Test
    public void testStoredQueryInFROMSubquery() {
        String sql = "select X.e1 from (EXEC pm1.sq3('abc', 123)) as X";
        this.helpResolve(sql);
    }

    @Test
    public void testStoredQueryInINSubquery() throws Exception {
        String sql = "select * from pm1.g1 where e1 in (EXEC pm1.sqsp1())";
        this.helpResolve(sql);
    }

    @Test
    public void testIsXMLQuery1() throws Exception {
        this.helpTestIsXMLQuery("SELECT * FROM pm1.g1", false);
    }

    @Test
    public void testIsXMLQuery2() throws Exception {
        this.helpTestIsXMLQuery("SELECT * FROM xmltest.doc1", true);
    }

    @Test
    public void testIsXMLQuery3() throws Exception {
        this.helpTestIsXMLQuery("SELECT * FROM doc1", true);
    }

    @Test
    public void testIsXMLQueryFail1() throws Exception {
        this.helpTestIsXMLQuery("SELECT * FROM xmltest.doc1, xmltest.doc2", false);
    }

    @Test
    public void testIsXMLQueryFail2() throws Exception {
        this.helpTestIsXMLQuery("SELECT * FROM xmltest.doc1, pm1.g1", false);
    }

    @Test
    public void testIsXMLQueryFail3() throws Exception {
        this.helpTestIsXMLQuery("SELECT * FROM pm1.g1, xmltest.doc1", false);
    }

    @Test
    public void testIsXMLQueryFail4() throws Exception {
        Query query = (Query)TestResolver.helpParse("SELECT * FROM docA");
        try {
            QueryResolver.isXMLQuery((Query)query, (QueryMetadataInterface)this.metadata);
            Assert.fail((String)"expected exception");
        }
        catch (QueryResolverException e) {
            Assert.assertEquals((Object)"Group specified is ambiguous, resubmit the query by fully qualifying the group name: docA", (Object)e.getMessage());
        }
    }

    @Test
    public void testStringConversion1() {
        ElementSymbol e1 = new ElementSymbol("pm3.g1.e2");
        e1.setType(DataTypeManager.DefaultDataClasses.DATE);
        Class srcType = DataTypeManager.DefaultDataClasses.STRING;
        String tgtTypeName = "date";
        Constant expression = new Constant((Object)"2003-02-27");
        FunctionLibrary library = FakeMetadataFactory.SFM.getSystemFunctionLibrary();
        FunctionDescriptor fd = library.findFunction("convert", new Class[]{srcType, DataTypeManager.DefaultDataClasses.STRING});
        Function conversion = new Function(fd.getName(), new Expression[]{expression, new Constant((Object)tgtTypeName)});
        conversion.setType(DataTypeManager.getDataTypeClass((String)tgtTypeName));
        conversion.setFunctionDescriptor(fd);
        conversion.makeImplicit();
        CompareCriteria expected = new CompareCriteria();
        expected.setLeftExpression((Expression)e1);
        expected.setOperator(1);
        expected.setRightExpression((Expression)conversion);
        CompareCriteria actual = (CompareCriteria)this.helpResolveCriteria("pm3.g1.e2='2003-02-27'");
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    @Test
    public void testStringConversion2() {
        ElementSymbol e1 = new ElementSymbol("pm3.g1.e2");
        e1.setType(DataTypeManager.DefaultDataClasses.DATE);
        Class srcType = DataTypeManager.DefaultDataClasses.STRING;
        String tgtTypeName = "date";
        Constant expression = new Constant((Object)"2003-02-27");
        FunctionLibrary library = FakeMetadataFactory.SFM.getSystemFunctionLibrary();
        FunctionDescriptor fd = library.findFunction("convert", new Class[]{srcType, DataTypeManager.DefaultDataClasses.STRING});
        Function conversion = new Function(fd.getName(), new Expression[]{expression, new Constant((Object)tgtTypeName)});
        conversion.setType(DataTypeManager.getDataTypeClass((String)tgtTypeName));
        conversion.setFunctionDescriptor(fd);
        conversion.makeImplicit();
        CompareCriteria expected = new CompareCriteria();
        expected.setLeftExpression((Expression)conversion);
        expected.setOperator(1);
        expected.setRightExpression((Expression)e1);
        CompareCriteria actual = (CompareCriteria)this.helpResolveCriteria("'2003-02-27'=pm3.g1.e2");
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    @Test
    public void testStringConversion3() {
        ElementSymbol e1 = new ElementSymbol("pm3.g1.e1");
        e1.setType(DataTypeManager.DefaultDataClasses.STRING);
        Constant e2 = new Constant((Object)"2003-02-27");
        CompareCriteria expected = new CompareCriteria();
        expected.setLeftExpression((Expression)e1);
        expected.setOperator(1);
        expected.setRightExpression((Expression)e2);
        CompareCriteria actual = (CompareCriteria)this.helpResolveCriteria("pm3.g1.e1='2003-02-27'");
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    @Test
    public void testDateToTimestampConversion_defect9747() {
        ElementSymbol e1 = new ElementSymbol("pm3.g1.e4");
        e1.setType(DataTypeManager.DefaultDataClasses.TIMESTAMP);
        Constant e2 = new Constant((Object)TimestampUtil.createDate((int)96, (int)0, (int)31), DataTypeManager.DefaultDataClasses.DATE);
        Function f1 = new Function("convert", new Expression[]{e2, new Constant((Object)"timestamp")});
        f1.makeImplicit();
        CompareCriteria expected = new CompareCriteria();
        expected.setLeftExpression((Expression)e1);
        expected.setOperator(4);
        expected.setRightExpression((Expression)f1);
        CompareCriteria actual = (CompareCriteria)this.helpResolveCriteria("pm3.g1.e4 > {d '1996-01-31'}");
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    @Test
    public void testFailedConversion_defect9725() throws Exception {
        this.helpResolveException("select * from pm3.g1 where pm3.g1.e4 > {b 'true'}", "Error Code:ERR.015.008.0027 Message:The expressions in this criteria are being compared but are of differing types (timestamp and boolean) and no implicit conversion is available:  pm3.g1.e4 > TRUE");
    }

    @Test
    public void testLookupFunction() {
        String sql = "SELECT lookup('pm1.g1', 'e1', 'e2', e2) AS x, lookup('pm1.g1', 'e4', 'e3', e3) AS y FROM pm1.g1";
        Query resolvedQuery = (Query)this.helpResolve(sql);
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        this.helpCheckSelect(resolvedQuery, new String[]{"x", "y"});
        this.helpCheckElements((LanguageObject)resolvedQuery.getSelect(), new String[]{"PM1.G1.E2", "PM1.G1.E3"}, new String[]{"PM1.G1.E2", "PM1.G1.E3"});
        Assert.assertEquals((String)"Resolved string form was incorrect ", (Object)sql, (Object)resolvedQuery.toString());
        List projSymbols = resolvedQuery.getSelect().getProjectedSymbols();
        Assert.assertEquals((String)"Wrong number of projected symbols", (long)2L, (long)projSymbols.size());
        Assert.assertEquals((String)"Wrong type for first symbol", String.class, (Object)((SingleElementSymbol)projSymbols.get(0)).getType());
        Assert.assertEquals((String)"Wrong type for second symbol", Double.class, (Object)((SingleElementSymbol)projSymbols.get(1)).getType());
    }

    @Test
    public void testLookupFunctionFailBadElement() {
        String sql = "SELECT lookup('nosuch', 'elementhere', 'e2', e2) AS x FROM pm1.g1";
        this.helpResolveException(sql);
    }

    @Test
    public void testLookupFunctionFailNotConstantArg1() {
        String sql = "SELECT lookup(e1, 'e1', 'e2', e2) AS x FROM pm1.g1";
        this.helpResolveException(sql);
    }

    @Test
    public void testLookupFunctionFailNotConstantArg2() {
        String sql = "SELECT lookup('pm1.g1', e1, 'e2', e2) AS x FROM pm1.g1";
        this.helpResolveException(sql);
    }

    @Test
    public void testLookupFunctionFailNotConstantArg3() {
        String sql = "SELECT lookup('pm1.g1', 'e1', e1, e2) AS x FROM pm1.g1";
        this.helpResolveException(sql);
    }

    @Test
    public void testLookupFunctionVirtualGroup() throws Exception {
        String sql = "SELECT lookup('vm1.g1', 'e1', 'e2', e2)  FROM vm1.g1 ";
        Query command = (Query)TestResolver.helpParse(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testLookupFunctionPhysicalGroup() throws Exception {
        String sql = "SELECT lookup('pm1.g1', 'e1', 'e2', e2)  FROM pm1.g1 ";
        Query command = (Query)TestResolver.helpParse(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testLookupFunctionFailBadKeyElement() throws Exception {
        String sql = "SELECT lookup('pm1.g1', 'e1', 'x', e2) AS x, lookup('pm1.g1', 'e4', 'e3', e3) AS y FROM pm1.g1";
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        try {
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)this.metadata);
            Assert.fail((String)"exception expected");
        }
        catch (QueryResolverException queryResolverException) {
            // empty catch block
        }
    }

    @Test
    public void testSetCriteriaCastFromExpression_9657() {
        Criteria expected = null;
        Criteria actual = null;
        try {
            actual = QueryParser.getQueryParser().parseCriteria("bqt1.smalla.shortvalue IN (1, 2)");
            expected = QueryParser.getQueryParser().parseCriteria("convert(bqt1.smalla.shortvalue, integer) IN (1, 2)");
        }
        catch (TeiidException e) {
            Assert.fail((String)("Exception during parsing (" + ((Object)((Object)e)).getClass().getName() + "): " + e.getMessage()));
        }
        try {
            QueryResolver.resolveCriteria((Criteria)expected, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
            QueryResolver.resolveCriteria((Criteria)actual, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
        }
        catch (TeiidException e) {
            Assert.fail((String)("Exception during resolution (" + ((Object)((Object)e)).getClass().getName() + "): " + e.getMessage()));
        }
        ((Function)((SetCriteria)expected).getExpression()).makeImplicit();
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    @Test
    public void testBetween1() {
        String sql = "select e1 from pm1.g1 where e2 BETWEEN 1000 AND 2000";
        this.helpResolve(sql);
    }

    @Test
    public void testBetween2() {
        String sql = "select e1 from pm1.g1 where e2 NOT BETWEEN 1000 AND 2000";
        this.helpResolve(sql);
    }

    @Test
    public void testBetween3() {
        String sql = "select e2 from pm1.g1 where e4 BETWEEN 1000 AND e2";
        this.helpResolve(sql);
    }

    @Test
    public void testBetween4() {
        String sql = "select e2 from pm1.g1 where e2 BETWEEN 1000 AND e4";
        this.helpResolve(sql);
    }

    @Test
    public void testBetween5() {
        String sql = "select e1 from pm1.g1 where 1000 BETWEEN e1 AND e2";
        this.helpResolve(sql);
    }

    @Test
    public void testBetween6() {
        String sql = "select e1 from pm1.g1 where 1000 BETWEEN e2 AND e1";
        this.helpResolve(sql);
    }

    @Test
    public void testBetween7() {
        String sql = "select e1 from pm3.g1 where e2 BETWEEN e3 AND e4";
        this.helpResolve(sql);
    }

    @Test
    public void testBetween8() {
        String sql = "select pm3.g1.e1 from pm3.g1, pm3.g2 where pm3.g1.e4 BETWEEN pm3.g1.e2 AND pm3.g2.e2";
        this.helpResolve(sql);
    }

    @Test
    public void testCompareSubQuery1() {
        String sql = "select e1 from pm1.g1 where e2 = any (select e2 from pm4.g1)";
        Query outerQuery = (Query)this.helpResolveSubquery(sql, new String[0]);
        this.helpCheckFrom(outerQuery, new String[]{"pm1.g1"});
        this.helpCheckSelect(outerQuery, new String[]{"pm1.g1.e1"});
        this.helpCheckElements((LanguageObject)outerQuery.getSelect(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
        String sqlActual = "SELECT e1 FROM pm1.g1 WHERE e2 = ANY (SELECT e2 FROM pm4.g1)";
        Assert.assertEquals((String)"Resolved string form was incorrect ", (Object)sqlActual, (Object)outerQuery.toString());
    }

    @Test
    public void testCompareSubQuery2() {
        String sql = "select e1 from pm1.g1 where e2 = all (select e2 from pm4.g1)";
        this.helpResolveSubquery(sql, new String[0]);
    }

    @Test
    public void testCompareSubQuery3() {
        String sql = "select e1 from pm1.g1 where e2 < (select e2 from pm4.g1 where e1 = '3')";
        this.helpResolveSubquery(sql, new String[0]);
    }

    @Test
    public void testCompareSubQueryImplicitConversion() {
        String sql = "select e1 from pm1.g1 where e1 < (select e2 from pm4.g1 where e1 = '3')";
        this.helpResolveSubquery(sql, new String[0]);
    }

    @Test
    public void testExistsSubQuery() {
        String sql = "select e1 from pm1.g1 where exists (select e2 from pm4.g1)";
        this.helpResolveSubquery(sql, new String[0]);
    }

    @Test
    public void testExistsSubQuery2() {
        String sql = "select e1 from pm1.g1 where exists (select e1, e2 from pm4.g1)";
        this.helpResolveSubquery(sql, new String[0]);
    }

    @Test
    public void testScalarSubQueryInSelect() {
        String sql = "select e1, (select e2 from pm4.g1 where e1 = '3') from pm1.g1";
        this.helpResolveSubquery(sql, new String[0]);
    }

    @Test
    public void testScalarSubQueryInSelect2() {
        String sql = "select (select e2 from pm4.g1 where e1 = '3'), e1 from pm1.g1";
        this.helpResolveSubquery(sql, new String[0]);
    }

    @Test
    public void testScalarSubQueryInSelectWithAlias() {
        String sql = "select e1, (select e2 from pm4.g1 where e1 = '3') as X from pm1.g1";
        this.helpResolveSubquery(sql, new String[0]);
    }

    @Test
    public void testSelectWithNoFrom() {
        String sql = "SELECT 5";
        this.helpResolve(sql);
    }

    @Test
    public void testSelectWithNoFrom_Alias() {
        String sql = "SELECT 5 AS INTKEY";
        this.helpResolve(sql);
    }

    @Test
    public void testSelectWithNoFrom_Alias_OrderBy() {
        String sql = "SELECT 5 AS INTKEY ORDER BY INTKEY";
        this.helpResolve(sql);
    }

    @Test
    public void testSubqueryCorrelatedInCriteria() {
        String sql = "select e2 from pm1.g1 where e2 = all (select e2 from pm4.g1 where pm1.g1.e1 = pm4.g1.e1)";
        this.helpResolveSubquery(sql, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testSubqueryCorrelatedInCriteria2() {
        String sql = "select e1 from pm1.g1 where e2 = all (select e2 from pm4.g1 where pm1.g1.e1 = e1)";
        this.helpResolveSubquery(sql, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testSubqueryCorrelatedInCriteria3() {
        String sql = "select e1 from pm1.g1 X where e2 = all (select e2 from pm4.g1 where X.e1 = pm4.g1.e1)";
        this.helpResolveSubquery(sql, new String[]{"X.e1"});
    }

    @Test
    public void testSubqueryCorrelatedInCriteria4() {
        String sql = "select e2 from pm1.g1 X where e2 in (select e2 from pm1.g1 Y where X.e1 = Y.e1)";
        this.helpResolveSubquery(sql, new String[]{"X.e1"});
    }

    @Test
    public void testSubqueryCorrelatedInCriteria5() {
        String sql = "select e1 from pm1.g1 X where e2 = all (select e2 from pm1.g1 Y where X.e1 = e1)";
        this.helpResolveSubquery(sql, new String[]{"X.e1"});
    }

    @Test
    public void testSubqueryCorrelatedInCriteria6() {
        String sql = "select e1 from pm4.g2 where e2 = some (select e2 from pm4.g1 where e5 = e1)";
        this.helpResolveSubquery(sql, new String[]{"pm4.g2.e5"});
    }

    @Test
    public void testSubqueryCorrelatedInCriteria7() {
        String sql = "select e1 from pm4.g2 where exists (select e2 from pm4.g1 where e5 = e1)";
        this.helpResolveSubquery(sql, new String[]{"pm4.g2.e5"});
    }

    @Test
    public void testSubqueryCorrelatedInHaving() {
        String sql = "select e1, e2 from pm4.g2 group by e2 having e2 in (select e2 from pm4.g1 where e5 = e1)";
        this.helpResolveSubquery(sql, new String[]{"pm4.g2.e5"});
    }

    @Test
    public void testSubqueryCorrelatedInHaving2() {
        String sql = "select e1, e2 from pm4.g2 group by e2 having e2 <= all (select e2 from pm4.g1 where e5 = e1)";
        this.helpResolveSubquery(sql, new String[]{"pm4.g2.e5"});
    }

    @Test
    public void testSubqueryCorrelatedInSelect() {
        String sql = "select e1, (select e2 from pm4.g1 where e5 = e1) from pm4.g2";
        this.helpResolveSubquery(sql, new String[]{"pm4.g2.e5"});
    }

    @Test
    public void testSubqueryCorrelatedInSelect2() {
        String sql = "select e1, (select e2 from pm4.g1 where pm4.g2.e5 = e1) from pm4.g2";
        this.helpResolveSubquery(sql, new String[]{"pm4.g2.e5"});
    }

    @Test
    public void testSubqueryCorrelatedInSelect3() {
        String sql = "select e1, (select e2 from pm4.g1 Y where X.e5 = Y.e1) from pm4.g2 X";
        this.helpResolveSubquery(sql, new String[]{"X.e5"});
    }

    @Test
    public void testNestedCorrelatedSubqueries() {
        String sql = "select e1, (select e2 from pm1.g1 where e2 = all (select e2 from pm4.g1 where e5 = e1)) from pm4.g2";
        this.helpResolveSubquery(sql, new String[]{"pm4.g2.e5"});
    }

    @Test
    public void testNestedCorrelatedSubqueries2() {
        String sql = "select e1, (select e2 from pm4.g2 Y where e2 = all (select e2 from pm4.g1 where e5 = e1)) from pm4.g2 X";
        this.helpResolveSubquery(sql, new String[]{"Y.e5"});
    }

    @Test
    public void testNestedCorrelatedSubqueries3() {
        String sql = "select e1, (select e2 from pm4.g2 Y where e2 = all (select e2 from pm4.g1 where X.e5 = e1)) from pm4.g2 X";
        this.helpResolveSubquery(sql, new String[]{"X.e5"});
    }

    @Test
    public void testNestedCorrelatedSubqueries4() {
        String sql = "select X.e2 from pm4.g2 Y, pm4.g2 X where X.e2 = all (select e2 from pm4.g1 where e5 = e1)";
        TestResolver.helpResolveException(sql, (QueryMetadataInterface)this.metadata, "Element \"e5\" is ambiguous, it exists in two or more groups.");
    }

    @Test
    public void testSubqueryCorrelatedInCriteriaVirtualLayer() {
        String sql = "select e2 from vm1.g1 where e2 = all (select e2 from vm1.g2 where vm1.g1.e1 = vm1.g2.e1)";
        this.helpResolveSubquery(sql, new String[]{"vm1.g1.e1"});
    }

    @Test
    public void testSubqueryCorrelatedInCriteriaVirtualLayer2() {
        String sql = "select e2 from vm1.g1 X where e2 = all (select e2 from vm1.g2 where X.e1 = vm1.g2.e1)";
        this.helpResolveSubquery(sql, new String[]{"X.e1"});
    }

    @Test
    public void testSubqueryNonCorrelatedInCriteria() {
        String sql = "select e2 from pm1.g1 where e2 = all (select e2 from pm4.g1)";
        this.helpResolveSubquery(sql, new String[0]);
    }

    @Test
    public void testSubqueryNonCorrelatedInCriteria2() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 IN (SELECT e2 FROM pm2.g1 WHERE e1 IN (SELECT e1 FROM pm1.g1))";
        this.helpResolveSubquery(sql, new String[0]);
    }

    @Test
    public void testSubqueryNonCorrelatedInCriteria3() {
        String sql = "SELECT e2 FROM pm2.g1 WHERE e1 IN (SELECT e1 FROM pm1.g1)";
        this.helpResolveSubquery(sql, new String[0]);
    }

    @Test
    public void testSubquery_defect10090() {
        String sql = "select pm1.g1.e1 from pm1.g1 where pm1.g1.e2 in (select pm1.g1.e2 from pm1.g1 where pm1.g1.e4 = 2.0)";
        this.helpResolveSubquery(sql, new String[0]);
    }

    @Test
    public void testSubquery_defect10090Workaround() {
        String sql = "select X.e1 from pm1.g1 X where X.e2 in (select pm1.g1.e2 from pm1.g1 where pm1.g1.e4 = 2.0)";
        this.helpResolveSubquery(sql, new String[0]);
    }

    @Test
    public void testSubquery2_defect10090() {
        String sql = "select pm1.g1.e1 from pm1.g1 where pm1.g1.e2 in (select X.e2 from pm1.g1 X where X.e4 = 2.0)";
        this.helpResolveSubquery(sql, new String[0]);
    }

    @Test
    public void testUser() {
        FunctionLibrary library = FakeMetadataFactory.SFM.getSystemFunctionLibrary();
        FunctionDescriptor fd = library.findFunction("user", new Class[0]);
        Function user = new Function(fd.getName(), new Expression[0]);
        user.setFunctionDescriptor(fd);
        CompareCriteria expected = new CompareCriteria();
        Constant e1 = new Constant((Object)"bqt2", String.class);
        expected.setLeftExpression((Expression)user);
        expected.setOperator(1);
        expected.setRightExpression((Expression)e1);
        CompareCriteria actual = (CompareCriteria)this.helpResolveCriteria("user()='bqt2'");
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    @Test
    public void testCaseExpression1() {
        String sql = "SELECT e1, CASE e2 WHEN 0 THEN 20 WHEN 1 THEN 21 WHEN 2 THEN 500 END AS testElement FROM pm1.g1 WHERE e1 = CASE WHEN e2 = 0 THEN 'a' WHEN e2 = 1 THEN 'b' ELSE 'c' END";
        this.helpResolve(sql);
    }

    @Test
    public void testCaseExpression2() {
        String sql = "SELECT CASE e2 WHEN 0 THEN CASE e1  WHEN 'a' THEN 100 WHEN 'b' THEN 200  ELSE 1000  END WHEN 1 THEN 21 WHEN (CASE WHEN e1 = 'z' THEN 2 WHEN e1 = 'y' THEN 100 ELSE 3 END) THEN 500 END AS testElement FROM pm1.g1";
        this.helpResolve(sql);
    }

    @Test
    public void testCaseExpressionWithNestedFunction() {
        String sql = "SELECT CASE WHEN e2 < 0 THEN abs(CASE WHEN e2 < 0 THEN -1 ELSE e2 END) ELSE e2 END FROM pm1.g1";
        this.helpResolve(sql);
    }

    @Test
    public void testFunctionWithNestedCaseExpression() {
        String sql = "SELECT abs(CASE e1 WHEN 'testString1' THEN -13 WHEN 'testString2' THEN -5 ELSE abs(e2) END) AS absVal FROM pm1.g1";
        this.helpResolve(sql);
    }

    @Test
    public void testDefect10809() {
        String sql = "select * from LOB_TESTING_ONE where CLOB_COLUMN LIKE '%fff%'";
        TestResolver.helpResolve(TestResolver.helpParse(sql), (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), AnalysisRecord.createNonRecordingRecord());
    }

    @Test
    public void testNonAutoConversionOfLiteralIntegerToShort() throws Exception {
        Query command = (Query)QueryParser.getQueryParser().parseCommand("SELECT intkey FROM bqt1.smalla WHERE shortvalue = 5");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
        CompareCriteria crit = (CompareCriteria)command.getCriteria();
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.SHORT, (Object)crit.getRightExpression().getType());
        Assert.assertEquals((String)"Sql is incorrect after resolving", (Object)"SELECT intkey FROM bqt1.smalla WHERE shortvalue = 5", (Object)command.toString());
    }

    @Test
    public void testNonAutoConversionOfLiteralIntegerToShort2() throws Exception {
        Query command = (Query)QueryParser.getQueryParser().parseCommand("SELECT intkey FROM bqt1.smalla WHERE 5 = shortvalue");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
        CompareCriteria crit = (CompareCriteria)command.getCriteria();
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.SHORT, (Object)crit.getLeftExpression().getType());
        Assert.assertEquals((String)"Sql is incorrect after resolving", (Object)"SELECT intkey FROM bqt1.smalla WHERE 5 = shortvalue", (Object)command.toString());
    }

    @Test
    public void testAliasedOrderBy() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT pm1.g1.e1 as y FROM pm1.g1 ORDER BY y");
        this.helpCheckFrom(resolvedQuery, new String[]{"pm1.g1"});
        this.helpCheckSelect(resolvedQuery, new String[]{"y"});
    }

    @Test
    public void testUnaliasedOrderBySucceeds() {
        this.helpResolve("SELECT pm1.g1.e1 a, pm1.g1.e1 b FROM pm1.g1 ORDER BY pm1.g1.e1");
    }

    @Test
    public void testUnaliasedOrderBySucceeds1() {
        this.helpResolve("SELECT pm1.g1.e1 a FROM pm1.g1 group by pm1.g1.e1 ORDER BY pm1.g1.e1");
    }

    @Test
    public void testUnaliasedOrderByFails() {
        this.helpResolveException("SELECT pm1.g1.e1 e2 FROM pm1.g1 group by pm1.g1.e1 ORDER BY pm1.g1.e2");
    }

    @Test
    public void testUnaliasedOrderByFails1() {
        this.helpResolveException("SELECT pm1.g1.e1 e2 FROM pm1.g1 group by pm1.g1.e1 ORDER BY pm1.g1.e2 + 1");
    }

    @Test
    public void testUnionOrderByFail() {
        this.helpResolveException("SELECT pm1.g1.e1 FROM pm1.g1 UNION SELECT pm1.g2.e1 FROM pm1.g2 ORDER BY g1.e1", "ORDER BY expression 'g1.e1' cannot be used with a set query.");
    }

    @Test
    public void testUnionOrderByFail1() {
        this.helpResolveException("SELECT pm1.g1.e1 FROM pm1.g1 UNION SELECT pm1.g2.e1 FROM pm1.g2 ORDER BY pm1.g1.e1", "ORDER BY expression 'pm1.g1.e1' cannot be used with a set query.");
    }

    @Test
    public void testOrderByPartiallyQualified() {
        this.helpResolve("SELECT pm1.g1.e1 FROM pm1.g1 ORDER BY g1.e1");
    }

    @Test
    public void testUnionOrderBy() {
        this.helpResolve("SELECT pm1.g1.e1 FROM pm1.g1 UNION SELECT pm1.g2.e1 FROM pm1.g2 ORDER BY e1");
    }

    @Test
    public void testImplConversionBetweenIntAndShort() throws Exception {
        Insert command = (Insert)QueryParser.getQueryParser().parseCommand("Insert into pm5.g3(e2) Values(100)");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)this.metadata);
        Assert.assertTrue((((Expression)command.getValues().get(0)).getType() == DataTypeManager.DefaultDataClasses.SHORT ? 1 : 0) != 0);
    }

    public static FakeMetadataFacade example_12968() {
        FakeMetadataObject pm1 = FakeMetadataFactory.createPhysicalModel("myModel");
        FakeMetadataObject pm2 = FakeMetadataFactory.createPhysicalModel("myModel2");
        FakeMetadataObject pm1g1 = FakeMetadataFactory.createPhysicalGroup("myModel.myTable", pm1);
        FakeMetadataObject pm2g1 = FakeMetadataFactory.createPhysicalGroup("myModel2.mySchema.myTable2", pm2);
        List<FakeMetadataObject> pm1g1e = FakeMetadataFactory.createElements(pm1g1, new String[]{"myColumn", "myColumn2"}, new String[]{"string", "integer"});
        List<FakeMetadataObject> pm2g1e = FakeMetadataFactory.createElements(pm2g1, new String[]{"myColumn", "myColumn2"}, new String[]{"string", "integer"});
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(pm1);
        store.addObject(pm1g1);
        store.addObjects(pm1g1e);
        store.addObject(pm2g1);
        store.addObjects(pm2g1e);
        return new FakeMetadataFacade(store);
    }

    @Test
    public void testDefect12968_union() {
        TestResolver.helpResolve(TestResolver.helpParse("SELECT myModel.myTable.myColumn AS myColumn from myModel.myTable UNION SELECT convert(null, string) AS myColumn From myModel2.mySchema.myTable2"), (QueryMetadataInterface)TestResolver.example_12968(), AnalysisRecord.createNonRecordingRecord());
    }

    @Test
    public void testUnionQueryWithNull() throws Exception {
        this.helpResolve("SELECT NULL, e2 FROM pm1.g2 UNION ALL SELECT e1, e2 FROM pm1.g3");
        this.helpResolve("SELECT e1, e2 FROM pm1.g1 UNION ALL SELECT NULL, e2 FROM pm1.g2 UNION ALL SELECT e1, e2 FROM pm1.g3");
        this.helpResolve("SELECT e1, NULL FROM pm1.g2 UNION ALL SELECT e1, e2 FROM pm1.g3");
        this.helpResolve("SELECT e1, NULL FROM pm1.g2 UNION ALL SELECT e1, NULL FROM pm1.g3");
        this.helpResolve("SELECT e1, NULL as e2 FROM pm1.g2 UNION ALL SELECT e1, e2 FROM pm1.g3");
        this.helpResolve("SELECT e1, NULL as e2 FROM pm1.g1 UNION ALL SELECT e1, e3 FROM pm1.g2");
    }

    @Test
    public void testUnionQueryWithDiffTypes() throws Exception {
        this.helpResolve("SELECT e1, e3 FROM pm1.g1 UNION ALL SELECT e2, e3 FROM pm1.g2");
        this.helpResolve("SELECT e1, e3 FROM pm1.g1 UNION ALL SELECT e2, e3 FROM pm1.g2 UNION ALL SELECT NULL, e3 FROM pm1.g2");
        this.helpResolve("SELECT e1, e3 FROM pm1.g1 UNION ALL SELECT e3, e3 FROM pm1.g2 UNION ALL SELECT NULL, e3 FROM pm1.g2");
        this.helpResolve("SELECT e1, e2 FROM pm1.g3 UNION ALL SELECT MAX(e4), e2 FROM pm1.g1 UNION ALL SELECT e3, e2 FROM pm1.g2");
        this.helpResolve("SELECT e1, e4 FROM pm1.g1 UNION ALL SELECT e2, e3 FROM pm1.g2");
        this.helpResolve("SELECT e4, e2 FROM pm1.g1 UNION ALL SELECT e3, e2 FROM pm1.g2");
        this.helpResolve("SELECT e1, e2 FROM pm1.g1 UNION ALL SELECT e3, e4 FROM pm1.g2");
        this.helpResolve("SELECT e4, e2 FROM pm1.g1 UNION ALL SELECT e3, e2 FROM pm1.g2 UNION ALL SELECT e1, e2 FROM pm1.g2");
        this.helpResolve("SELECT e4, e2 FROM pm1.g1 UNION ALL SELECT e1, e2 FROM pm1.g2");
        this.helpResolve("SELECT MAX(e4), e2 FROM pm1.g1 UNION ALL SELECT e3, e2 FROM pm1.g2");
        this.helpResolve("select e2 from pm3.g1 union select e3 from pm3.g1 union select e4 from pm3.g1");
    }

    @Test
    public void testUnionQueryWithDiffTypesFails() throws Exception {
        this.helpResolveException("SELECT e1 FROM pm1.g1 UNION (SELECT e2 FROM pm1.g2 UNION SELECT e2 from pm1.g1 order by e2)", "The Expression e2 used in a nested UNION ORDER BY clause cannot be implicitly converted from type integer to type string.");
    }

    @Test
    public void testNestedUnionQueryWithNull() throws Exception {
        SetQuery command = (SetQuery)this.helpResolve("SELECT e2, e3 FROM pm1.g1 UNION (SELECT null, e3 FROM pm1.g2 UNION SELECT null, e3 from pm1.g1)");
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.INTEGER, (Object)((SingleElementSymbol)command.getProjectedSymbols().get(0)).getType());
    }

    @Test
    public void testUnionQueryClone() throws Exception {
        SetQuery command = (SetQuery)this.helpResolve("SELECT e2, e3 FROM pm1.g1 UNION SELECT e3, e2 from pm1.g1");
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.INTEGER, (Object)((SingleElementSymbol)command.getProjectedSymbols().get(1)).getType());
        command = (SetQuery)command.clone();
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.INTEGER, (Object)((SingleElementSymbol)command.getProjectedSymbols().get(1)).getType());
    }

    @Test
    public void testSelectIntoNoFrom() {
        this.helpResolve("SELECT 'a', 19, {b'true'}, 13.999 INTO pm1.g1");
    }

    @Test
    public void testSelectInto() {
        this.helpResolve("SELECT e1, e2, e3, e4 INTO pm1.g1 FROM pm1.g2");
    }

    @Test
    public void testSelectIntoTempGroup() {
        this.helpResolve("SELECT 'a', 19, {b'true'}, 13.999 INTO #myTempTable");
        this.helpResolve("SELECT e1, e2, e3, e4 INTO #myTempTable FROM pm1.g1");
    }

    @Test
    public void testProcInVirtualGroup1() {
        String sql = "select e1 from pm1.vsp26 where param1=1 and param2='a'";
        this.helpResolve(sql);
    }

    @Test
    public void testProcInVirtualGroup2() {
        String sql = "select * from pm1.vsp26 as p where param1=1 and param2='a'";
        this.helpResolve(sql);
    }

    @Test
    public void testProcInVirtualGroup3() {
        String sql = "SELECT P.e1 as ve3 FROM pm1.vsp26 as P, pm1.g2 where P.e1=g2.e1 and param1=1 and param2='a'";
        this.helpResolve(sql);
    }

    @Test
    public void testProcInVirtualGroup4() {
        String sql = "SELECT P.e1 as ve3 FROM pm1.vsp26 as P, vm1.g1 where P.e1=g1.e1 and param1=1 and param2='a'";
        this.helpResolve(sql);
    }

    @Test
    public void testProcInVirtualGroup5() {
        String sql = "SELECT * FROM (SELECT p.* FROM pm1.vsp26 as P, vm1.g1 where P.e1=g1.e1) x where param1=1 and param2='a'";
        this.helpResolve(sql);
    }

    @Test
    public void testProcInVirtualGroup6() {
        String sql = "SELECT P.e1 as ve3, P.e2 as ve4 FROM pm1.vsp26 as P where param1=1 and param2='a'";
        this.helpResolve(sql);
    }

    @Test
    public void testProcInVirtualGroup7() {
        String sql = "SELECT P.e2 as ve3, P.e1 as ve4 FROM pm1.vsp47 as P where param1=1 and param2='a'";
        this.helpResolve(sql);
    }

    @Test
    public void testProcInVirtualGroup7a() {
        String sql = "SELECT P.e2 as ve3, P.e1 as ve4 FROM pm1.vsp47 as P where param1=1";
        this.helpResolve(sql);
    }

    @Test
    public void testProcParamComparison_defect13653() {
        String userSql = "SELECT * FROM (EXEC mmspTest1.MMSP5('a')) AS a, (EXEC mmsptest1.mmsp6('b')) AS b";
        TransformationMetadata metadata = FakeMetadataFactory.exampleBQTCached();
        AnalysisRecord analysis = AnalysisRecord.createNonRecordingRecord();
        Query query = (Query)TestResolver.helpResolve(userSql, (QueryMetadataInterface)metadata, analysis);
        From from = query.getFrom();
        List fromClauses = from.getClauses();
        SPParameter[] params = new SPParameter[2];
        for (SubqueryFromClause clause : fromClauses) {
            StoredProcedure proc = (StoredProcedure)clause.getCommand();
            List procParams = proc.getParameters();
            for (int i = 0; i < procParams.size(); ++i) {
                SPParameter param = (SPParameter)procParams.get(i);
                if (param.getParameterType() != 1) continue;
                if (params[0] == null) {
                    params[0] = param;
                    continue;
                }
                params[1] = param;
            }
        }
        Assert.assertTrue((String)"Params should be not equal", (!params[0].equals((Object)params[1]) ? 1 : 0) != 0);
    }

    @Test
    public void testNullConstantInSelect() throws Exception {
        String userSql = "SELECT null as x";
        Query query = (Query)TestResolver.helpParse(userSql);
        QueryResolver.resolveCommand((Command)query, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), (AnalysisRecord)AnalysisRecord.createNonRecordingRecord());
        SingleElementSymbol symbol = (SingleElementSymbol)query.getSelect().getSymbols().get(0);
        Assert.assertNotNull((Object)symbol.getType());
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.STRING, (Object)symbol.getType());
    }

    @Test
    public void test11716() throws Exception {
        String sql = "SELECT e1 FROM pm1.g1 where e1='1'";
        HashMap externalMetadata = new HashMap();
        GroupSymbol inputSet = new GroupSymbol("INPUT");
        ArrayList<ElementSymbol> inputSetElements = new ArrayList<ElementSymbol>();
        ElementSymbol inputSetElement = new ElementSymbol("INPUT.e1");
        inputSetElements.add(inputSetElement);
        externalMetadata.put(inputSet, inputSetElements);
        Query command = (Query)TestResolver.helpParse(sql);
        QueryResolver.resolveCommand((Command)command, externalMetadata, (QueryMetadataInterface)this.metadata, (AnalysisRecord)AnalysisRecord.createNonRecordingRecord());
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)command, (boolean)false);
        Assert.assertFalse((boolean)groups.contains(inputSet));
    }

    @Test
    public void testDefect15872() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN SELECT * FROM pm1.g1 where model.table.param=e1; end ";
        Command command = TestResolver.helpParse(sql);
        HashMap externalMetadata = new HashMap();
        GroupSymbol procGroup = new GroupSymbol("model.table");
        ArrayList<ElementSymbol> procPrarms = new ArrayList<ElementSymbol>();
        ElementSymbol param = new ElementSymbol("model.table.param");
        param.setType(String.class);
        procPrarms.add(param);
        externalMetadata.put(procGroup, procPrarms);
        QueryResolver.resolveCommand((Command)command, externalMetadata, (QueryMetadataInterface)this.metadata, (AnalysisRecord)AnalysisRecord.createNonRecordingRecord());
        CreateUpdateProcedureCommand proc = (CreateUpdateProcedureCommand)command;
        Query query = (Query)proc.getSubCommands().get(0);
        ElementSymbol inElement = (ElementSymbol)((CompareCriteria)query.getCriteria()).getLeftExpression();
        Assert.assertNotNull((String)"Input parameter does not have group", (Object)inElement.getGroupSymbol());
    }

    @Test
    public void testInputToInputsConversion() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "ROWS_UPDATED = (Select pm1.g1.e2 from pm1.g1 where e2=INPUTS.e2);\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e2=40";
        CreateUpdateProcedureCommand command = this.helpResolveUpdateProcedure(procedure, userUpdateStr);
        Assert.assertEquals((Object)"CREATE PROCEDURE\nBEGIN\nDECLARE integer var1;\nROWS_UPDATED = (SELECT pm1.g1.e2 FROM pm1.g1 WHERE e2 = INPUTS.e2);\nEND", (Object)command.toString());
    }

    @Test
    public void testDefect16894_resolverException_1() {
        this.helpResolve("SELECT * FROM (SELECT * FROM Pm1.g1 AS Y) AS X");
    }

    @Test
    public void testDefect16894_resolverException_2() {
        this.helpResolve("SELECT * FROM (SELECT * FROM Pm1.g1) AS X");
    }

    @Test
    public void testDefect17385() throws Exception {
        String sql = "select e1 as x ORDER BY x";
        this.helpResolveException(sql);
    }

    @Test
    public void testValidFullElementNotInQueryGroups() {
        this.helpResolveException("select pm1.g1.e1 FROM pm1.g1 g");
    }

    @Test
    public void testUnionInSubquery() throws Exception {
        String sql = "SELECT StringKey FROM (SELECT BQT2.SmallB.StringKey FROM BQT2.SmallB union SELECT convert(BQT2.SmallB.FloatNum, string) FROM BQT2.SmallB) x";
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testParameterError() throws Exception {
        TestResolver.helpResolveException("EXEC pm1.sp2(1, 2)", (QueryMetadataInterface)this.metadata, "Error Code:ERR.015.008.0007 Message:Incorrect number of parameters specified on the stored procedure pm1.sp2 - expected 1 but got 2");
    }

    @Test
    public void testUnionOfAliasedLiteralsGetsModified() {
        String sql = "SELECT 5 AS x UNION ALL SELECT 10 AS x";
        Command c = this.helpResolve(sql);
        Assert.assertEquals((Object)sql, (Object)c.toString());
    }

    @Test
    public void testXMLWithProcSubquery() {
        String sql = "SELECT * FROM xmltest.doc4 WHERE node2 IN (SELECT e1 FROM (EXEC pm1.vsp1()) AS x)";
        Command c = this.helpResolve(sql);
        Assert.assertEquals((Object)sql, (Object)c.toString());
    }

    @Test
    public void testDefect18832() {
        String sql = "SELECT * from (SELECT null as a, e1 FROM pm1.g1) b";
        Command c = this.helpResolve(sql);
        List projectedSymbols = c.getProjectedSymbols();
        for (int i = 0; i < projectedSymbols.size(); ++i) {
            ElementSymbol symbol = (ElementSymbol)projectedSymbols.get(i);
            Assert.assertTrue((!symbol.getType().equals(DataTypeManager.DefaultDataClasses.NULL) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDefect18832_2() {
        String sql = "SELECT a.*, b.* from (SELECT null as a, e1 FROM pm1.g1) a, (SELECT e1 FROM pm1.g1) b";
        Command c = this.helpResolve(sql);
        List projectedSymbols = c.getProjectedSymbols();
        for (int i = 0; i < projectedSymbols.size(); ++i) {
            ElementSymbol symbol = (ElementSymbol)projectedSymbols.get(i);
            Assert.assertTrue((!symbol.getType().equals(DataTypeManager.DefaultDataClasses.NULL) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDefect20113() {
        String sql = "SELECT g1.* from pm1.g1";
        this.helpResolve(sql);
    }

    @Test
    public void testDefect20113_2() {
        String sql = "SELECT g7.* from g7";
        this.helpResolve(sql);
    }

    private void verifyProjectedTypes(Command c, Class[] types) {
        List projSymbols = c.getProjectedSymbols();
        for (int i = 0; i < projSymbols.size(); ++i) {
            Assert.assertEquals((String)("Found type mismatch at column " + i), (Object)types[i], (Object)((SingleElementSymbol)projSymbols.get(i)).getType());
        }
    }

    @Test
    public void testNestedInlineViews() throws Exception {
        String sql = "SELECT * FROM (SELECT * FROM (SELECT * FROM pm1.g1) AS Y) AS X";
        Command c = this.helpResolve(sql);
        Assert.assertEquals((Object)sql, (Object)c.toString());
        this.verifyProjectedTypes(c, new Class[]{String.class, Integer.class, Boolean.class, Double.class});
    }

    @Test
    public void testNestedInlineViewsNoStar() throws Exception {
        String sql = "SELECT e1 FROM (SELECT e1 FROM (SELECT e1 FROM pm1.g1) AS Y) AS X";
        Command c = this.helpResolve(sql);
        Assert.assertEquals((Object)sql, (Object)c.toString());
        this.verifyProjectedTypes(c, new Class[]{String.class});
    }

    @Test
    public void testNestedInlineViewsCount() throws Exception {
        String sql = "SELECT COUNT(*) FROM (SELECT * FROM (SELECT * FROM pm1.g1) AS Y) AS X";
        Command c = this.helpResolve(sql);
        Assert.assertEquals((Object)sql, (Object)c.toString());
        this.verifyProjectedTypes(c, new Class[]{Integer.class});
    }

    @Test
    public void testAggOverInlineView() throws Exception {
        String sql = "SELECT SUM(x) FROM (SELECT (e2 + 1) AS x FROM pm1.g1) AS g";
        Command c = this.helpResolve(sql);
        Assert.assertEquals((Object)sql, (Object)c.toString());
        this.verifyProjectedTypes(c, new Class[]{Long.class});
    }

    @Test
    public void testCaseOverInlineView() throws Exception {
        String sql = "SELECT CASE WHEN x > 0 THEN 1.0 ELSE 2.0 END FROM (SELECT e2 AS x FROM pm1.g1) AS g";
        Command c = this.helpResolve(sql);
        Assert.assertEquals((Object)sql, (Object)c.toString());
        this.verifyProjectedTypes(c, new Class[]{Double.class});
    }

    @Test
    public void testDefect20083_1() {
        this.helpResolve("EXEC pm1.vsp56()");
    }

    @Test
    public void testDefect20083_2() {
        this.helpResolve("EXEC pm1.vsp57()");
    }

    @Test
    public void testTypeConversionOverUnion() throws Exception {
        String sql = "SELECT * FROM (SELECT e2, e1 FROM pm1.g1 UNION SELECT convert(e2, string), e1 FROM pm1.g1) FOO where e2/2 = 1";
        this.helpResolveException(sql);
    }

    @Test
    public void testVariableDeclarationAfterStatement() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "select * from pm1.g1 where pm1.g1.e1 = VARIABLES.X;\n";
        procedure = procedure + "DECLARE string VARIABLES.X = 1;\n";
        procedure = procedure + "END\n";
        this.helpResolveException(procedure, "Element \"VARIABLES.X\" is not defined by any relevant group.");
    }

    @Test
    public void testVariableDeclarationAfterStatement1() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "select * from xmltest.doc1 where node1 = VARIABLES.X;\n";
        procedure = procedure + "DECLARE string VARIABLES.X = 1;\n";
        procedure = procedure + "END\n";
        this.helpResolveException(procedure, "Error Code:ERR.015.008.0019 Message:Unable to resolve element: VARIABLES.X");
    }

    @Test
    public void testCreate() {
        String sql = "CREATE LOCAL TEMPORARY TABLE temp_table (column1 string)";
        Command c = this.helpResolve(sql);
        Assert.assertEquals((Object)sql, (Object)c.toString());
    }

    @Test
    public void testCreateQualifiedName() {
        String sql = "CREATE LOCAL TEMPORARY TABLE pm1.g1 (column1 string)";
        this.helpResolveException(sql, "Cannot create temporary table \"pm1.g1\". Local temporary tables must be created with unqualified names.");
    }

    @Test
    public void testCreatePk() {
        String sql = "CREATE LOCAL TEMPORARY TABLE foo (column1 string, column2 integer, primary key (column1, column2))";
        this.helpResolve(sql);
    }

    @Test
    public void testCreateUnknownPk() {
        String sql = "CREATE LOCAL TEMPORARY TABLE foo (column1 string, primary key (column2))";
        this.helpResolveException(sql, "Element \"column2\" is not defined by any relevant group.");
    }

    @Test
    public void testCreateAlreadyExists() {
        String sql = "CREATE LOCAL TEMPORARY TABLE g1 (column1 string)";
        this.helpResolveException(sql, "Cannot create temporary table \"g1\". A table with the same name already exists.");
    }

    @Test
    public void testCreateImplicitName() {
        String sql = "CREATE LOCAL TEMPORARY TABLE #g1 (column1 string)";
        Command c = this.helpResolve(sql);
        Assert.assertEquals((Object)sql, (Object)c.toString());
    }

    @Test
    public void testCreateInProc() throws Exception {
        this.helpResolveException("CREATE VIRTUAL PROCEDURE BEGIN create local temporary table g1(c1 string); end", "Cannot create temporary table \"g1\". A table with the same name already exists.");
    }

    @Test
    public void testTempTableScope() {
        String proc = "CREATE VIRTUAL PROCEDURE BEGIN         DECLARE integer VARIABLES.BITS;        LOOP ON (SELECT DISTINCT phys.t.ID, phys.t.Name FROM phys.t) AS idCursor        BEGIN                VARIABLES.BITS = 0;                LOOP ON (SELECT phys.t.source_bits FROM phys.t WHERE phys.t.ID = idCursor.id) AS bitsCursor                BEGIN                        VARIABLES.BITS = bitor(VARIABLES.BITS, bitsCursor.source_bits);                END                SELECT idCursor.id, idCursor.name, VARIABLES.BITS INTO #temp;        END        SELECT ID, Name, #temp.BITS AS source_bits FROM #temp;END";
        TestResolver.helpResolveException(proc, (QueryMetadataInterface)FakeMetadataFactory.exampleBitwise(), "Group does not exist: #temp");
    }

    @Test
    public void testDrop() {
        String sql = "DROP TABLE temp_table";
        this.helpResolveException(sql, "Group does not exist: temp_table");
    }

    @Test
    public void testResolveUnqualifiedCriteria() throws Exception {
        Criteria criteria = QueryParser.getQueryParser().parseCriteria("e1 = 1");
        try {
            QueryResolver.resolveCriteria((Criteria)criteria, (QueryMetadataInterface)this.metadata);
            Assert.fail((String)"Exception expected");
        }
        catch (QueryResolverException e) {
            Assert.assertEquals((Object)"Symbol e1 is specified with an unknown group context", (Object)e.getMessage());
        }
    }

    @Test
    public void testSameNameRoot() {
        String sql = "select p.e1 from pm1.g1 as pp, pm1.g1 as p";
        this.helpResolve(sql);
    }

    @Test
    public void testDefect23342() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN IF (param = '1') BEGIN SELECT * FROM pm1.g1 where model.table.param=e1;  END end ";
        Command command = TestResolver.helpParse(sql);
        HashMap externalMetadata = new HashMap();
        GroupSymbol proc = new GroupSymbol("model.table");
        ArrayList<ElementSymbol> procPrarms = new ArrayList<ElementSymbol>();
        ElementSymbol param = new ElementSymbol("model.table.param");
        param.setType(DataTypeManager.DefaultDataClasses.STRING);
        procPrarms.add(param);
        externalMetadata.put(proc, procPrarms);
        QueryResolver.resolveCommand((Command)command, externalMetadata, (QueryMetadataInterface)this.metadata, (AnalysisRecord)AnalysisRecord.createNonRecordingRecord());
    }

    @Test
    public void testBatchedUpdateResolver() throws Exception {
        String update1 = "update pm1.g1 set e1 =1";
        String update2 = "update pm2.g1 set e1 =1";
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(QueryParser.getQueryParser().parseCommand(update1));
        commands.add(QueryParser.getQueryParser().parseCommand(update2));
        BatchedUpdateCommand command = new BatchedUpdateCommand(commands);
        this.helpResolve((Command)command);
    }

    @Test
    public void testAmbiguousAllInGroup() {
        String sql = "SELECT g1.* from pm1.g1, pm2.g1";
        TestResolver.helpResolveException(sql, (QueryMetadataInterface)this.metadata, "The symbol g1.* refers to more than one group defined in the FROM clause.");
    }

    @Test
    public void testRowsUpdatedInProcedure() {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN SELECT ROWS_UPDATED; end ";
        TestResolver.helpResolveException(sql, (QueryMetadataInterface)this.metadata, "Element \"ROWS_UPDATED\" is not defined by any relevant group.");
    }

    @Test
    public void testXMLQueryWithVariable() {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN declare string x = '1'; select * from xmltest.doc1 where node1 = x; end ";
        CreateUpdateProcedureCommand command = (CreateUpdateProcedureCommand)this.helpResolve(sql);
        CommandStatement cmdStmt = (CommandStatement)command.getBlock().getStatements().get(1);
        CompareCriteria criteria = (CompareCriteria)((Query)cmdStmt.getCommand()).getCriteria();
        Assert.assertEquals((Object)"VARIABLES", (Object)((ElementSymbol)criteria.getRightExpression()).getGroupSymbol().getCanonicalName());
    }

    @Test
    public void testLookupWithoutConstant() throws Exception {
        String sql = "SELECT lookup('pm1.g1', convert('e3', float), 'e2', e2) FROM pm1.g1";
        TestResolver.helpResolveException(sql, (QueryMetadataInterface)this.metadata, "Error Code:ERR.015.008.0063 Message:The first three arguments for the LOOKUP function must be specified as constants.");
    }

    @Test
    public void testPowerWithBigInteger_Fails() throws Exception {
        String sql = "SELECT power(10, 999999999999999999999999999999999999999999999)";
        this.helpResolveException(sql);
    }

    @Test
    public void testPowerWithLong_Fails() throws Exception {
        String sql = "SELECT power(10, 999999999999)";
        this.helpResolveException(sql);
    }

    @Test
    public void testUpdateError() {
        String userUpdateStr = "UPDATE vm1.g2 SET e1='x'";
        TestResolver.helpResolveException(userUpdateStr, (QueryMetadataInterface)this.metadata, "Error Code:ERR.015.008.0009 Message:Update is not allowed on the virtual group vm1.g2: no Update procedure was defined.");
    }

    @Test
    public void testInsertError() {
        String userUpdateStr = "INSERT into vm1.g2 (e1) values ('x')";
        TestResolver.helpResolveException(userUpdateStr, (QueryMetadataInterface)this.metadata, "Error Code:ERR.015.008.0009 Message:Insert is not allowed on the virtual group vm1.g2: no Insert procedure was defined.");
    }

    @Test
    public void testDeleteError() {
        String userUpdateStr = "DELETE from vm1.g2 where e1='x'";
        TestResolver.helpResolveException(userUpdateStr, (QueryMetadataInterface)this.metadata, "Error Code:ERR.015.008.0009 Message:Delete is not allowed on the virtual group vm1.g2: no Delete procedure was defined.");
    }

    @Test
    public void testResolveXMLSelect() {
        String procedure = "CREATE VIRTUAL PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE string VARIABLES.X = 1;\n";
        procedure = procedure + "select VARIABLES.X from xmltest.doc1;\n";
        procedure = procedure + "END\n";
        this.helpResolveException(procedure, "Error Code:ERR.015.008.0019 Message:Unable to resolve element: VARIABLES.X");
    }

    @Test
    public void testXMLJoinFail() {
        String query = "select * from xmltest.doc1, xmltest.doc2";
        this.helpResolveException(query, "Error Code:ERR.015.008.0003 Message:Only one XML document may be specified in the FROM clause of a query.");
    }

    @Test
    public void testExecProjectedSymbols() {
        String query = "exec pm1.sq1()";
        StoredProcedure proc = (StoredProcedure)this.helpResolve(query);
        List projected = proc.getProjectedSymbols();
        Assert.assertEquals((long)2L, (long)projected.size());
        for (ElementSymbol symbol : projected) {
            Assert.assertNotNull((Object)symbol.getGroupSymbol());
        }
    }

    @Test
    public void testExecWithDuplicateNames() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataStore store = metadata.getStore();
        FakeMetadataObject pm1 = store.findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs2", pm1, new String[]{"in", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode sq2n1 = new QueryNode("pm1.sq2", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1 WHERE e1=pm1.sq2.in; END");
        FakeMetadataObject sq2 = FakeMetadataFactory.createVirtualProcedure("pm1.sq2", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        store.addObject(rs2);
        store.addObject(sq2);
        TestResolver.helpResolveException("select * from pm1.sq2", (QueryMetadataInterface)metadata, "Cannot access procedure pm1.sq2 using table semantics since the parameter and result set column names are not all unique.");
    }

    @Test
    public void testInlineViewNullLiteralInUnion() {
        String sql = "select e2 from pm1.g1 union all (select x from (select null as x) y)";
        this.helpResolve(sql);
    }

    @Test
    public void testSelectIntoWithDuplicateNames() {
        String sql = "select 1 as x, 2 as x into #temp";
        this.helpResolveException(sql, "Cannot create group '#temp' with multiple columns named 'x'");
    }

    @Test
    public void testCreateWithDuplicateNames() {
        String sql = "CREATE LOCAL TEMPORARY TABLE temp_table (column1 string, column1 string)";
        this.helpResolveException(sql, "Cannot create group 'temp_table' with multiple columns named 'column1'");
    }

    @Test
    public void testXMLQuery4() {
        this.helpResolveException("SELECT * FROM xmltest.doc1 group by a2", "Queries against XML documents can not have a GROUP By clause");
    }

    @Test
    public void testXMLQuery5() {
        this.helpResolveException("SELECT * FROM xmltest.doc1 having a2='x'", "Queries against XML documents can not have a HAVING clause");
    }

    @Test
    public void testSelectIntoWithOrderBy() {
        String sql = "select e1, e2 into #temp from pm1.g1 order by e1 limit 10";
        this.helpResolve(sql);
    }

    @Test
    public void testUnionBranchesWithDifferentElementCounts() {
        this.helpResolveException("SELECT e2, e3 FROM pm1.g1 UNION SELECT e2 FROM pm1.g2", "Queries combined with the set operator UNION must have the same number of output elements.");
        this.helpResolveException("SELECT e2 FROM pm1.g1 UNION SELECT e2, e3 FROM pm1.g2", "Queries combined with the set operator UNION must have the same number of output elements.");
    }

    @Test
    public void testSelectIntoWithNullLiteral() {
        String sql = "select null as x into #temp from pm1.g1";
        Query query = (Query)this.helpResolve(sql);
        TempMetadataStore store = new TempMetadataStore(query.getTemporaryMetadata());
        TempMetadataID id = store.getTempElementID("#temp.x");
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.STRING, (Object)id.getType());
    }

    @Test
    public void testInsertWithNullLiteral() {
        String sql = "insert into #temp (x) values (null)";
        Insert insert = (Insert)this.helpResolve(sql);
        TempMetadataStore store = new TempMetadataStore(insert.getTemporaryMetadata());
        TempMetadataID id = store.getTempElementID("#temp.x");
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.STRING, (Object)id.getType());
    }

    @Test
    public void testInsertWithoutColumnsFails() {
        String sql = "Insert into pm1.g1 values (1, 2)";
        this.helpResolveException(sql, "Error Code:ERR.015.008.0010 Message:INSERT statement must have the same number of elements and values specified.  This statement has 4 elements and 2 values.");
    }

    @Test
    public void testInsertWithoutColumnsFails1() {
        String sql = "Insert into pm1.g1 values (1, 2, 3, 4)";
        this.helpResolveException(sql, "Error Code:ERR.015.008.0041 Message:Expected value of type 'boolean' but '3' is of type 'integer' and no implicit conversion is available.");
    }

    @Test
    public void testInsertWithQueryFails() {
        String sql = "Insert into pm1.g1 select 1, 2, 3, 4";
        this.helpResolveException(sql, "Cannot convert insert query expression projected symbol '3' of type java.lang.Integer to insert column 'pm1.g1.e3' of type java.lang.Boolean");
    }

    @Test
    public void testInsertWithQueryImplicitWithoutColumns() {
        String sql = "Insert into #X select 1 as x, 2 as y, 3 as z";
        this.helpResolve(sql);
    }

    @Test
    public void testInsertWithQueryImplicitWithoutColumns1() {
        String sql = "Insert into #X select 1 as x, 2 as y, 3 as y";
        this.helpResolveException(sql, "Cannot create group '#X' with multiple columns named 'y'");
    }

    @Test
    public void testInsertWithoutColumnsPasses() {
        String sql = "Insert into pm1.g1 values (1, 2, true, 4)";
        this.helpResolve(sql);
        Insert command = (Insert)this.helpResolve(sql);
        Assert.assertEquals((long)4L, (long)command.getVariables().size());
    }

    @Test
    public void testInsertWithoutColumnsUndefinedTemp() {
        String sql = "Insert into #temp values (1, 2)";
        Insert command = (Insert)this.helpResolve(sql);
        Assert.assertEquals((long)2L, (long)command.getVariables().size());
    }

    @Test
    public void testImplicitTempInsertWithNoColumns() {
        StringBuffer proc = new StringBuffer("CREATE VIRTUAL PROCEDURE").append("\nBEGIN").append("\n  create local temporary table #matt (x integer);").append("\n  insert into #matt values (1);").append("\nEND");
        Command cmd = this.helpResolve(proc.toString());
        String sExpected = "CREATE VIRTUAL PROCEDURE\nBEGIN\nCREATE LOCAL TEMPORARY TABLE #matt (x integer);\nINSERT INTO #matt (#MATT.x) VALUES (1);\nEND\n\tCREATE LOCAL TEMPORARY TABLE #matt (x integer)\n\tINSERT INTO #matt (#MATT.x) VALUES (1)\n";
        String sActual = cmd.printCommandTree();
        Assert.assertEquals((Object)sExpected, (Object)sActual);
    }

    @Test
    public void testCase6319() throws QueryResolverException, TeiidComponentException {
        String sql = "select floatnum from bqt1.smalla group by floatnum having sum(floatnum) between 51.0 and 100.0 ";
        Query query = (Query)TestResolver.helpParse(sql);
        QueryResolver.resolveCommand((Command)query, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testUniqeNamesWithInlineView() {
        TestResolver.helpResolveException("select * from (select count(intNum) a, count(stringKey) b, bqt1.smalla.intkey as b from bqt1.smalla group by bqt1.smalla.intkey) q1 order by q1.a", (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), "Cannot create group 'q1' with multiple columns named 'b'");
    }

    @Test
    public void testResolveOldProcRelational() {
        this.helpResolveException("SELECT * FROM pm1.g1, (exec pm1.sq2(pm1.g1.e1)) as a", "Symbol pm1.g1.e1 is specified with an unknown group context");
    }

    @Test
    public void testResolverOrderOfPrecedence() {
        this.helpResolveException("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1 CROSS JOIN (pm1.g2 LEFT OUTER JOIN pm2.g1 on pm1.g1.e1 = pm2.g1.e1)", "Symbol pm1.g1.e1 is specified with an unknown group context");
    }

    @Test
    public void testResolverOrderOfPrecedence_1() {
        this.helpResolve("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1 CROSS JOIN pm1.g2 LEFT OUTER JOIN pm2.g1 on pm1.g1.e1 = pm2.g1.e1");
    }

    @Test
    public void testInvalidColumnReferenceWithNestedJoin() {
        this.helpResolveException("SELECT a.* FROM (pm1.g2 a left outer join pm1.g2 b on a.e1= b.e1) LEFT OUTER JOIN (select a.e1) c on (a.e1 = c.e1)");
    }

    @Test
    public void testCallableStatementTooManyParameters() throws Exception {
        String sql = "{call pm4.spTest9(?, ?)}";
        TestResolver.helpResolveException(sql, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), "Error Code:ERR.015.008.0007 Message:Incorrect number of parameters specified on the stored procedure pm4.spTest9 - expected 1 but got 2");
    }

    @Test
    public void testUpdateSetClauseReferenceType() {
        String sql = "UPDATE pm1.g1 SET pm1.g1.e1 = 1, pm1.g1.e2 = ?;";
        Update update = (Update)TestResolver.helpResolve(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null);
        Expression ref = ((SetClause)update.getChangeList().getClauses().get(1)).getValue();
        Assert.assertTrue((boolean)(ref instanceof Reference));
        Assert.assertNotNull((Object)ref.getType());
    }

    @Test
    public void testNoTypeCriteria() {
        String sql = "select * from pm1.g1 where ? = ?";
        TestResolver.helpResolveException(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "Error Code:ERR.015.008.0026 Message:Expression '? = ?' has a parameter with non-determinable type information.  The use of an explicit convert may be necessary.");
    }

    @Test
    public void testReferenceInSelect() {
        String sql = "select ?, e1 from pm1.g1";
        Query command = (Query)TestResolver.helpResolve(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.STRING, (Object)((SingleElementSymbol)command.getProjectedSymbols().get(0)).getType());
    }

    @Test
    public void testReferenceInSelect1() {
        String sql = "select convert(?, integer), e1 from pm1.g1";
        Query command = (Query)TestResolver.helpResolve(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.INTEGER, (Object)((SingleElementSymbol)command.getProjectedSymbols().get(0)).getType());
    }

    @Test
    public void testUnionWithObjectTypeConversion() {
        String sql = "select convert(null, xml) from pm1.g1 union all select 1";
        SetQuery query = (SetQuery)TestResolver.helpResolve(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.OBJECT, (Object)((SingleElementSymbol)query.getProjectedSymbols().get(0)).getType());
    }

    @Test
    public void testUnionWithSubQuery() {
        String sql = "select 1 from pm1.g1 where exists (select 1) union select 2";
        SetQuery command = (SetQuery)this.helpResolve(sql);
        Assert.assertEquals((long)1L, (long)command.getSubCommands().size());
    }

    @Test
    public void testOrderBy_J658a() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT pm1.g1.e1, e2, e3 as x, (5+2) as y FROM pm1.g1 ORDER BY e3");
        OrderBy orderBy = resolvedQuery.getOrderBy();
        int[] expectedPositions = new int[]{2};
        this.helpTestOrderBy(orderBy, expectedPositions);
    }

    private void helpTestOrderBy(OrderBy orderBy, int[] expectedPositions) {
        Assert.assertEquals((long)expectedPositions.length, (long)orderBy.getVariableCount());
        for (int i = 0; i < expectedPositions.length; ++i) {
            Assert.assertEquals((long)expectedPositions[i], (long)orderBy.getExpressionPosition(i));
        }
    }

    @Test
    public void testOrderBy_J658b() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT pm1.g1.e1, e2, e3 as x, (5+2) as y FROM pm1.g1 ORDER BY e2, e3 ");
        this.helpTestOrderBy(resolvedQuery.getOrderBy(), new int[]{1, 2});
    }

    @Test
    public void testOrderBy_J658c() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT pm1.g1.e1, e2 as x, e3 as y FROM pm1.g1 ORDER BY x, e3 ");
        this.helpTestOrderBy(resolvedQuery.getOrderBy(), new int[]{1, 2});
    }

    @Test
    public void testOrderBy_J658d() {
        this.helpResolveException("SELECT pm1.g1.e1, e2 as x, e3 as x FROM pm1.g1 ORDER BY x, e1 ", "Error Code:ERR.015.008.0042 Message:Element 'x' in ORDER BY is ambiguous and may refer to more than one element of SELECT clause.");
    }

    @Test
    public void testOrderBy_J658e() {
        Query resolvedQuery = (Query)this.helpResolve("SELECT pm1.g1.e1, e2 as x, e3 as e2 FROM pm1.g1 ORDER BY x, e2 ");
        this.helpTestOrderBy(resolvedQuery.getOrderBy(), new int[]{1, 2});
    }

    @Test
    public void testSPOutParamWithExec() {
        StoredProcedure proc = (StoredProcedure)TestResolver.helpResolve("exec pm2.spTest8(1)", (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), null);
        Assert.assertEquals((long)2L, (long)proc.getProjectedSymbols().size());
    }

    @Test
    public void testSPOutParamWithCallableStatement() {
        StoredProcedure proc = (StoredProcedure)TestResolver.helpResolve("{call pm2.spTest8(1)}", (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), null);
        Assert.assertEquals((long)3L, (long)proc.getProjectedSymbols().size());
    }

    @Test
    public void testOutWithWrongType() {
        TestResolver.helpResolveException("exec pm2.spTest8(inkey=>1, outkey=>{t '12:00:00'})", (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testProcRelationalWithOutParam() {
        Query proc = (Query)TestResolver.helpResolve("select * from pm2.spTest8 where inkey = 1", (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), null);
        Assert.assertEquals((long)3L, (long)proc.getProjectedSymbols().size());
    }

    @Test
    public void testSPReturnParamWithNoResultSet() {
        StoredProcedure proc = (StoredProcedure)TestResolver.helpResolve("exec pm4.spTest9(1)", (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), null);
        Assert.assertEquals((long)1L, (long)proc.getProjectedSymbols().size());
    }

    @Test
    public void testSecondPassFunctionResolving() {
        this.helpResolve("SELECT pm1.g1.e1 FROM pm1.g1 where lower(?) = e1 ");
    }

    @Test
    public void testSecondPassFunctionResolving1() {
        try {
            this.helpResolve("SELECT pm1.g1.e1 FROM pm1.g1 where 1/(e1 - 2) <> 4 ");
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            QueryResolverException qre = (QueryResolverException)e.getCause();
            Assert.assertEquals((Object)"ERR.015.008.0040", (Object)qre.getCode());
        }
    }

    @Ignore(value="currently not supported - we get type hints from the criteria not from the possible signatures")
    @Test
    public void testSecondPassFunctionResolving2() {
        this.helpResolve("SELECT pm1.g1.e1 FROM pm1.g1 where (lower(?) || 1) = e1 ");
    }

    @Test
    public void testAggregateWithBetweenInCaseInSelect() {
        String sql = "SELECT SUM(CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 ELSE -1 END) FROM pm1.g1";
        this.helpResolve(sql);
    }

    @Test
    public void testBetweenInCaseInSelect() {
        String sql = "SELECT CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 ELSE -1 END FROM pm1.g1";
        this.helpResolve(sql);
    }

    @Test
    public void testBetweenInCase() {
        String sql = "SELECT * FROM pm1.g1 WHERE e3 = CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 ELSE -1 END";
        this.helpResolve(sql);
    }

    @Test
    public void testOrderByUnrelated() {
        this.helpResolve("SELECT pm1.g1.e1, e2 as x, e3 as y FROM pm1.g1 ORDER BY e4");
    }

    @Test
    public void testOrderByUnrelated1() {
        this.helpResolveException("SELECT distinct pm1.g1.e1, e2 as x, e3 as y FROM pm1.g1 ORDER BY e4");
    }

    @Test
    public void testOrderByUnrelated2() {
        this.helpResolveException("SELECT max(e2) FROM pm1.g1 group by e1 ORDER BY e4");
    }

    @Test
    public void testOrderByExpression() {
        Query query = (Query)this.helpResolve("select pm1.g1.e1 from pm1.g1 order by e2 || e3 ");
        Assert.assertEquals((long)-1L, (long)query.getOrderBy().getExpressionPosition(0));
    }

    @Test
    public void testOrderByExpression1() {
        Query query = (Query)this.helpResolve("select pm1.g1.e1 || e2 from pm1.g1 order by pm1.g1.e1 || e2 ");
        Assert.assertEquals((long)0L, (long)query.getOrderBy().getExpressionPosition(0));
    }

    @Test
    public void testOrderByExpression2() {
        this.helpResolveException("select pm1.g1.e1 from pm1.g1 union select pm1.g2.e1 from pm1.g2 order by pm1.g1.e1 || 2", "ORDER BY expression '(pm1.g1.e1 || 2)' cannot be used with a set query.");
    }

    @Test
    public void testOrderByConstantFails() {
        this.helpResolveException("select pm1.g1.e1 from pm1.g1 order by 2");
    }

    @Test
    public void testCorrelatedNestedTableReference() {
        this.helpResolve("select pm1.g1.e1 from pm1.g1, table (exec pm1.sq2(pm1.g1.e2)) x");
        this.helpResolveException("select pm1.g1.e1 from pm1.g1, (exec pm1.sq2(pm1.g1.e2)) x");
    }

    @Test
    public void testCorrelatedTextTable() {
        Command command = this.helpResolve("select x.* from pm1.g1, texttable(e1 COLUMNS x string) x");
        Assert.assertEquals((long)1L, (long)command.getProjectedSymbols().size());
    }

    @Test
    public void testQueryString() throws Exception {
        this.helpResolveException("select querystring(xmlparse(document '<a/>'))");
    }

    @Test(expected=QueryResolverException.class)
    public void testCreateUpdateProcedure9() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "ROWS_UPDATED = Select pm1.g1.e1 from pm1.g1;\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr);
    }

    CreateUpdateProcedureCommand helpResolveUpdateProcedure(String procedure, String userUpdateStr) throws QueryParserException, QueryResolverException, TeiidComponentException, QueryMetadataException {
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        ProcedureContainer userCommand = (ProcedureContainer)QueryParser.getQueryParser().parseCommand(userUpdateStr);
        QueryResolver.resolveCommand((Command)userCommand, (QueryMetadataInterface)metadata);
        return (CreateUpdateProcedureCommand)QueryResolver.expandCommand((ProcedureContainer)userCommand, (QueryMetadataInterface)metadata, (AnalysisRecord)AnalysisRecord.createNonRecordingRecord());
    }

    @Test(expected=QueryResolverException.class)
    public void testCreateUpdateProcedure10() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1 = Select pm1.g1.e1 from pm1.g1;\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr);
    }

    @Test
    public void testParamOrder() {
        Query resolvedQuery = (Query)TestResolver.helpResolve("SELECT * FROM (exec pm4.spRetOut()) as a", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null);
        Assert.assertEquals((Object)"A.ret", (Object)((SingleElementSymbol)resolvedQuery.getProjectedSymbols().get(0)).getName());
    }

    @Test
    public void testWithDuplidateName() {
        this.helpResolveException("with x as (TABLE pm1.g1), x as (TABLE pm1.g2) SELECT * from x");
    }

    @Test
    public void testWithColumns() {
        this.helpResolveException("with x (a, b) as (TABLE pm1.g1) SELECT * from x");
    }

    @Test
    public void testWithNameMatchesFrom() {
        this.helpResolve("with x as (TABLE pm1.g1) SELECT * from (TABLE x) x");
    }
}

