/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.rewriter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.visitor.CorrelatedReferenceCollectorVisitor;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestQueryRewriter {
    private static final String TRUE_STR = "1 = 1";
    private static final String FALSE_STR = "1 = 0";

    private Criteria parseCriteria(String critStr, QueryMetadataInterface metadata) {
        try {
            Criteria crit = QueryParser.getQueryParser().parseCriteria(critStr);
            QueryResolver.resolveCriteria((Criteria)crit, (QueryMetadataInterface)metadata);
            return crit;
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
    }

    private Criteria helpTestRewriteCriteria(String original, String expected) {
        try {
            return this.helpTestRewriteCriteria(original, expected, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Criteria helpTestRewriteCriteria(String original, String expected, boolean rewrite) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        Criteria expectedCrit = this.parseCriteria(expected, (QueryMetadataInterface)metadata);
        if (rewrite) {
            QueryResolver.resolveCriteria((Criteria)expectedCrit, (QueryMetadataInterface)metadata);
            expectedCrit = QueryRewriter.rewriteCriteria((Criteria)expectedCrit, null, null, (QueryMetadataInterface)metadata);
        }
        return this.helpTestRewriteCriteria(original, expectedCrit, (QueryMetadataInterface)metadata);
    }

    private Criteria helpTestRewriteCriteria(String original, Criteria expectedCrit, QueryMetadataInterface metadata) {
        Criteria origCrit = this.parseCriteria(original, metadata);
        Criteria actual = null;
        try {
            actual = QueryRewriter.rewriteCriteria((Criteria)origCrit, null, null, (QueryMetadataInterface)metadata);
            Assert.assertEquals((String)"Did not rewrite correctly: ", (Object)expectedCrit, (Object)actual);
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
        return actual;
    }

    private Expression helpTestRewriteExpression(String original, String expected, QueryMetadataInterface metadata) throws TeiidComponentException, TeiidProcessingException {
        Expression actualExp = QueryParser.getQueryParser().parseExpression(original);
        ResolverVisitor.resolveLanguageObject((LanguageObject)actualExp, (QueryMetadataInterface)metadata);
        CommandContext context = new CommandContext();
        context.setBufferManager(BufferManagerFactory.getStandaloneBufferManager());
        actualExp = QueryRewriter.rewriteExpression((Expression)actualExp, null, (CommandContext)context, (QueryMetadataInterface)metadata);
        if (expected != null) {
            Expression expectedExp = QueryParser.getQueryParser().parseExpression(expected);
            ResolverVisitor.resolveLanguageObject((LanguageObject)expectedExp, (QueryMetadataInterface)metadata);
            Assert.assertEquals((Object)expectedExp, (Object)actualExp);
        }
        return actualExp;
    }

    private String getRewritenProcedure(String procedure, String userUpdateStr, String procedureType) throws TeiidComponentException, TeiidProcessingException {
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc(procedureType, procedure);
        return this.getRewritenProcedure(userUpdateStr, (QueryMetadataInterface)metadata);
    }

    private String getRewritenProcedure(String userUpdateStr, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException {
        ProcedureContainer userCommand = (ProcedureContainer)QueryParser.getQueryParser().parseCommand(userUpdateStr);
        QueryResolver.resolveCommand((Command)userCommand, (QueryMetadataInterface)metadata);
        CreateUpdateProcedureCommand proc = (CreateUpdateProcedureCommand)QueryResolver.expandCommand((ProcedureContainer)userCommand, (QueryMetadataInterface)metadata, null);
        QueryRewriter.rewrite((Command)userCommand, (QueryMetadataInterface)metadata, null);
        Command result = QueryRewriter.rewrite((Command)proc, (QueryMetadataInterface)metadata, null);
        return result.toString();
    }

    static Command helpTestRewriteCommand(String original, String expected) {
        try {
            return TestQueryRewriter.helpTestRewriteCommand(original, expected, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    static Command helpTestRewriteCommand(String original, String expected, QueryMetadataInterface metadata) throws TeiidException {
        Command command = QueryParser.getQueryParser().parseCommand(original);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        Command rewriteCommand = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)metadata, null);
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)expected, (Object)rewriteCommand.toString());
        return rewriteCommand;
    }

    @Test
    public void testRewriteUnknown() {
        this.helpTestRewriteCriteria("pm1.g1.e1 = '1' and '1' = convert(null, string)", FALSE_STR);
    }

    @Test
    public void testRewriteUnknown1() {
        this.helpTestRewriteCriteria("pm1.g1.e1 = '1' or '1' = convert(null, string)", "pm1.g1.e1 = '1'");
    }

    @Test
    public void testRewriteUnknown2() {
        this.helpTestRewriteCriteria("not('1' = convert(null, string))", "null <> null");
    }

    @Test
    public void testRewriteUnknown3() {
        this.helpTestRewriteCriteria("pm1.g1.e1 like convert(null, string))", "null <> null");
    }

    @Test
    public void testRewriteUnknown4() {
        this.helpTestRewriteCriteria("null in ('a', 'b', 'c')", "null <> null");
    }

    @Test
    public void testRewriteUnknown5() {
        this.helpTestRewriteCriteria("(null <> null) and 1 = 0", FALSE_STR);
    }

    @Test
    public void testRewriteUnknown6() {
        this.helpTestRewriteCriteria("not(pm1.g1.e1 = '1' and '1' = convert(null, string))", "pm1.g1.e1 <> '1'");
    }

    @Test
    public void testRewriteUnknown7() {
        this.helpTestRewriteCriteria("not(pm1.g1.e1 = '1' or '1' = convert(null, string))", FALSE_STR);
    }

    @Test
    public void testRewriteUnknown8() {
        this.helpTestRewriteCriteria("pm1.g1.e1 in (2, null)", "pm1.g1.e1 = '2'");
    }

    @Test
    public void testRewriteInCriteriaWithRepeats() {
        this.helpTestRewriteCriteria("pm1.g1.e1 in ('1', '1', '2')", "pm1.g1.e1 IN ('1', '2')");
    }

    @Test
    public void testRewriteInCriteriaWithSingleValue() {
        this.helpTestRewriteCriteria("pm1.g1.e1 in ('1')", "pm1.g1.e1 = '1'");
    }

    @Test
    public void testRewriteInCriteriaWithSingleValue1() {
        this.helpTestRewriteCriteria("pm1.g1.e1 not in ('1')", "pm1.g1.e1 != '1'");
    }

    @Test
    public void testRewriteInCriteriaWithConvert() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e2, string) not in ('x')", "pm1.g1.e2 IS NOT NULL");
    }

    @Test
    public void testRewriteInCriteriaWithNoValues() throws Exception {
        ElementSymbol e1 = new ElementSymbol("e1");
        e1.setGroupSymbol(new GroupSymbol("g1"));
        SetCriteria crit = new SetCriteria((Expression)e1, (Collection)Collections.EMPTY_LIST);
        Criteria actual = QueryRewriter.rewriteCriteria((Criteria)crit, null, null, null);
        IsNullCriteria inc = new IsNullCriteria((Expression)e1);
        inc.setNegated(true);
        Assert.assertEquals((Object)inc, (Object)actual);
    }

    @Test
    public void testRewriteBetweenCriteria1() {
        this.helpTestRewriteCriteria("pm1.g1.e1 BETWEEN 1000 AND 2000", "(pm1.g1.e1 >= '1000') AND (pm1.g1.e1 <= '2000')");
    }

    @Test
    public void testRewriteBetweenCriteria2() {
        this.helpTestRewriteCriteria("pm1.g1.e1 NOT BETWEEN 1000 AND 2000", "(pm1.g1.e1 < '1000') OR (pm1.g1.e1 > '2000')");
    }

    @Test
    public void testRewriteCrit1() {
        this.helpTestRewriteCriteria("concat('a','b') = 'ab'", TRUE_STR);
    }

    @Test
    public void testRewriteCrit2() {
        this.helpTestRewriteCriteria("'x' = pm1.g1.e1", "(pm1.g1.e1 = 'x')");
    }

    @Test
    public void testRewriteCrit3() {
        this.helpTestRewriteCriteria("pm1.g1.e1 = convert('a', string)", "pm1.g1.e1 = 'a'");
    }

    @Test
    public void testRewriteCrit4() {
        this.helpTestRewriteCriteria("pm1.g1.e1 = CONVERT('a', string)", "pm1.g1.e1 = 'a'");
    }

    @Test
    public void testRewriteCrit5() {
        this.helpTestRewriteCriteria("pm1.g1.e1 in ('a')", "pm1.g1.e1 = 'a'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit6() {
        this.helpTestRewriteCriteria("1 = convert(pm1.g1.e1,integer) + 10", "pm1.g1.e1 = '-9'");
    }

    @Test
    public void testRewriteCrit7() {
        this.helpTestRewriteCriteria("((pm1.g1.e1 = 1) and (pm1.g1.e1 = 1))", "pm1.g1.e1 = '1'");
    }

    @Test
    public void testRewriteMatchCritEscapeChar1() {
        this.helpTestRewriteCriteria("pm1.g1.e1 LIKE 'x_' ESCAPE '\\'", "pm1.g1.e1 LIKE 'x_'");
    }

    @Test
    public void testRewriteMatchCritEscapeChar2() {
        this.helpTestRewriteCriteria("pm1.g1.e1 LIKE '#%x' ESCAPE '#'", "pm1.g1.e1 LIKE '#%x' ESCAPE '#'");
    }

    @Test
    public void testRewriteMatchCritEscapeChar3() {
        this.helpTestRewriteCriteria("pm1.g1.e1 LIKE '#%x'", "pm1.g1.e1 LIKE '#%x'");
    }

    @Test
    public void testRewriteMatchCritEscapeChar4() {
        this.helpTestRewriteCriteria("pm1.g1.e1 LIKE pm1.g1.e1 ESCAPE '#'", "pm1.g1.e1 LIKE pm1.g1.e1 ESCAPE '#'");
    }

    @Test
    public void testRewriteMatchCritEscapeChar5() throws Exception {
        MatchCriteria mcrit = new MatchCriteria((Expression)new ElementSymbol("pm1.g1.e1"), (Expression)new Constant(null, DataTypeManager.DefaultDataClasses.STRING), '#');
        CompareCriteria expected = QueryRewriter.UNKNOWN_CRITERIA;
        Criteria actual = QueryRewriter.rewriteCriteria((Criteria)mcrit, null, null, null);
        Assert.assertEquals((String)"Did not get expected rewritten criteria", (Object)expected, (Object)actual);
    }

    @Test
    public void testRewriteMatchCrit1() {
        this.helpTestRewriteCriteria("pm1.g1.e1 LIKE 'x' ESCAPE '\\'", "pm1.g1.e1 = 'x'");
    }

    @Test
    public void testRewriteMatchCrit2() {
        this.helpTestRewriteCriteria("pm1.g1.e1 NOT LIKE 'x'", "pm1.g1.e1 <> 'x'");
    }

    @Test
    public void testRewriteMatchCrit3() {
        this.helpTestRewriteCriteria("pm1.g1.e1 NOT LIKE '%'", FALSE_STR);
    }

    @Test
    public void testRewriteCritTimestampCreate1() {
        this.helpTestRewriteCriteria("timestampCreate(pm3.g1.e2, pm3.g1.e3) = {ts'2004-11-23 09:25:00'}", "(pm3.g1.e2 = {d'2004-11-23'}) AND (pm3.g1.e3 = {t'09:25:00'})");
    }

    @Test
    public void testRewriteCritTimestampCreate2() {
        this.helpTestRewriteCriteria("{ts'2004-11-23 09:25:00'} = timestampCreate(pm3.g1.e2, pm3.g1.e3)", "(pm3.g1.e2 = {d'2004-11-23'}) AND (pm3.g1.e3 = {t'09:25:00'})");
    }

    @Test
    public void testRewriteCritSwap1() {
        this.helpTestRewriteCriteria("'x' = pm1.g1.e1", "pm1.g1.e1 = 'x'");
    }

    @Test
    public void testRewriteCritSwap2() {
        this.helpTestRewriteCriteria("'x' <> pm1.g1.e1", "pm1.g1.e1 <> 'x'");
    }

    @Test
    public void testRewriteCritSwap3() {
        this.helpTestRewriteCriteria("'x' < pm1.g1.e1", "pm1.g1.e1 > 'x'");
    }

    @Test
    public void testRewriteCritSwap4() {
        this.helpTestRewriteCriteria("'x' <= pm1.g1.e1", "pm1.g1.e1 >= 'x'");
    }

    @Test
    public void testRewriteCritSwap5() {
        this.helpTestRewriteCriteria("'x' > pm1.g1.e1", "pm1.g1.e1 < 'x'");
    }

    @Test
    public void testRewriteCritSwap6() {
        this.helpTestRewriteCriteria("'x' >= pm1.g1.e1", "pm1.g1.e1 <= 'x'");
    }

    @Test
    public void testRewriteCritExpr_op1() {
        this.helpTestRewriteCriteria("pm1.g1.e2 + 5 = 10", "pm1.g1.e2 = 5");
    }

    @Test
    public void testRewriteCritExpr_op2() {
        this.helpTestRewriteCriteria("pm1.g1.e2 - 5 = 10", "pm1.g1.e2 = 15");
    }

    @Test
    public void testRewriteCritExpr_op3() {
        this.helpTestRewriteCriteria("pm1.g1.e2 * 5 = 10", "pm1.g1.e2 = 2");
    }

    @Test
    public void testRewriteCritExpr_op4() {
        this.helpTestRewriteCriteria("pm1.g1.e2 / 5 = 10", "pm1.g1.e2 = 50");
    }

    @Test
    public void testRewriteCritExpr_signFlip1() {
        this.helpTestRewriteCriteria("pm1.g1.e2 * -5 > 10", "pm1.g1.e2 < -2");
    }

    @Test
    public void testRewriteCritExpr_signFlip2() {
        this.helpTestRewriteCriteria("pm1.g1.e2 * -5 >= 10", "pm1.g1.e2 <= -2");
    }

    @Test
    public void testRewriteCritExpr_signFlip3() {
        this.helpTestRewriteCriteria("pm1.g1.e2 * -5 < 10", "pm1.g1.e2 > -2");
    }

    @Test
    public void testRewriteCritExpr_signFlip4() {
        this.helpTestRewriteCriteria("pm1.g1.e2 * -5 <= 10", "pm1.g1.e2 >= -2");
    }

    @Test
    public void testRewriteCritExpr_backwards1() {
        this.helpTestRewriteCriteria("5 + pm1.g1.e2 <= 10", "pm1.g1.e2 <= 5");
    }

    @Test
    public void testRewriteCritExpr_backwards2() {
        this.helpTestRewriteCriteria("-5 * pm1.g1.e2 <= 10", "pm1.g1.e2 >= -2");
    }

    @Test
    public void testRewriteCritExpr_unhandled1() {
        this.helpTestRewriteCriteria("5 / pm1.g1.e2 <= 10", "5 / pm1.g1.e2 <= 10");
    }

    @Test
    public void testRewriteCritExpr_unhandled2() {
        this.helpTestRewriteCriteria("5 - pm1.g1.e2 <= 10", "5 - pm1.g1.e2 <= 10");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseDate() {
        this.helpTestRewriteCriteria("PARSEDATE(pm3.g1.e1, 'yyyyMMdd') = {d'2003-05-01'}", "pm3.g1.e1 = '20030501'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseDate1() {
        this.helpTestRewriteCriteria("PARSEDATE(pm3.g1.e1, 'yyyyMM') = {d'2003-05-01'}", "pm3.g1.e1 = '200305'");
    }

    @Ignore(value="we're no longer considering parsedate directly")
    @Test
    public void testRewriteCrit_parseDate2() {
        this.helpTestRewriteCriteria("PARSEDATE(pm3.g1.e1, 'yyyyMM') = {d'2003-05-02'}", FALSE_STR);
    }

    @Ignore(value="Should be moved to the validator")
    @Test
    public void testRewriteCrit_invalidParseDate() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        Criteria origCrit = this.parseCriteria("PARSEDATE(pm3.g1.e1, '''') = {d'2003-05-01'}", (QueryMetadataInterface)metadata);
        try {
            QueryRewriter.rewriteCriteria((Criteria)origCrit, null, null, null);
            Assert.fail((String)"Expected failure");
        }
        catch (TeiidException e) {
            Assert.assertEquals((Object)"Error Code:ERR.015.001.0003 Message:Error simplifying criteria: PARSEDATE(pm3.g1.e1, '''') = {d'2003-05-01'}", (Object)e.getMessage());
        }
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseTime() {
        this.helpTestRewriteCriteria("PARSETIME(pm3.g1.e1, 'HH mm ss') = {t'13:25:04'}", "pm3.g1.e1 = '13 25 04'");
    }

    @Test
    public void testRewriteCrit_parseTimestamp() {
        this.helpTestRewriteCriteria("PARSETimestamp(pm3.g1.e1, 'yyyy dd mm') = {ts'2003-05-01 13:25:04.5'}", FALSE_STR);
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseTimestamp1() {
        this.helpTestRewriteCriteria("PARSETimestamp(pm3.g1.e1, 'yyyy dd mm') = {ts'2003-01-01 00:25:00.0'}", "pm3.g1.e1 = '2003 01 25'");
    }

    @Test
    public void testRewriteCrit_parseTimestamp2() {
        this.helpTestRewriteCriteria("PARSETimestamp(CONVERT(pm3.g1.e2, string), 'yyyy-MM-dd') = {ts'2003-05-01 13:25:04.5'}", FALSE_STR);
    }

    @Test
    public void testRewriteCrit_parseTimestamp3() {
        this.helpTestRewriteCriteria("PARSETimestamp(pm3.g1.e1, 'yyyy dd mm') <> {ts'2003-05-01 13:25:04.5'}", "pm3.g1.e1 is not null");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseTimestamp4() {
        this.helpTestRewriteCriteria("PARSETimestamp(CONVERT(pm3.g1.e2, string), 'yyyy-MM-dd') = {ts'2003-05-01 00:00:00.0'}", "pm3.g1.e2 = {d'2003-05-01'}");
    }

    @Test
    public void testRewriteCrit_parseTimestamp_notEquality() {
        this.helpTestRewriteCriteria("PARSETimestamp(pm3.g1.e1, 'yyyy dd mm') > {ts'2003-05-01 13:25:04.5'}", "PARSETimestamp(pm3.g1.e1, 'yyyy dd mm') > {ts'2003-05-01 13:25:04.5'}");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseTimestamp_decompose() {
        this.helpTestRewriteCriteria("PARSETIMESTAMP(CONCAT(FORMATDATE(pm3.g1.e2, 'yyyyMMdd'), FORMATTIME(pm3.g1.e3, 'HHmmss')), 'yyyyMMddHHmmss') = PARSETIMESTAMP('19690920183045', 'yyyyMMddHHmmss')", "(pm3.g1.e2 = {d'1969-09-20'}) AND (pm3.g1.e3 = {t'18:30:45'})");
    }

    @Test
    public void testRewriteCrit_timestampCreate_decompose() {
        this.helpTestRewriteCriteria("timestampCreate(pm3.g1.e2, pm3.g1.e3) = PARSETIMESTAMP('19690920183045', 'yyyyMMddHHmmss')", "(pm3.g1.e2 = {d'1969-09-20'}) AND (pm3.g1.e3 = {t'18:30:45'})");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseInteger() {
        this.helpTestRewriteCriteria("parseInteger(pm1.g1.e1, '#,##0') = 1234", "pm1.g1.e1 = '1,234'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseLong() {
        this.helpTestRewriteCriteria("parseLong(pm1.g1.e1, '#,##0') = convert(1234, long)", "pm1.g1.e1 = '1,234'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseBigInteger() {
        this.helpTestRewriteCriteria("parseBigInteger(pm1.g1.e1, '#,##0') = convert(1234, biginteger)", "pm1.g1.e1 = '1,234'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseFloat() {
        this.helpTestRewriteCriteria("parseFloat(pm1.g1.e1, '#,##0.###') = convert(1234.123, float)", "pm1.g1.e1 = '1,234.123'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseDouble() {
        this.helpTestRewriteCriteria("parseDouble(pm1.g1.e1, '$#,##0.00') = convert(1234.5, double)", "pm1.g1.e1 = '$1,234.50'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseBigDecimal() {
        this.helpTestRewriteCriteria("parseBigDecimal(pm1.g1.e1, '#,##0.###') = convert(1234.1234, bigdecimal)", "pm1.g1.e1 = '1,234.123'");
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatDate() {
        this.helpTestRewriteCriteria("formatDate(pm3.g1.e2, 'yyyyMMdd') = '20030501'", "pm3.g1.e2 = {d'2003-05-01'}");
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatTime() {
        this.helpTestRewriteCriteria("formatTime(pm3.g1.e3, 'HH mm ss') = '13 25 04'", "pm3.g1.e3 = {t'13:25:04'}");
    }

    @Test
    public void testRewriteCrit_formatTimestamp() {
        this.helpTestRewriteCriteria("formatTimestamp(pm3.g1.e4, 'MM dd, yyyy - HH:mm:ss') = '05 01, 1974 - 07:00:00'", "formatTimestamp(pm3.g1.e4, 'MM dd, yyyy - HH:mm:ss') = '05 01, 1974 - 07:00:00'");
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatTimestamp1() {
        this.helpTestRewriteCriteria("formatTimestamp(pm3.g1.e4, 'MM dd, yyyy - HH:mm:ss.S') = '05 01, 1974 - 07:00:00.0'", "pm3.g1.e4 = {ts'1974-05-01 07:00:00.0'}");
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatInteger() {
        this.helpTestRewriteCriteria("formatInteger(pm1.g1.e2, '#,##0') = '1,234'", "pm1.g1.e2 = 1234");
    }

    @Test
    public void testRewriteCrit_formatInteger1() {
        this.helpTestRewriteCriteria("formatInteger(pm1.g1.e2, '#5') = '105'", "formatInteger(pm1.g1.e2, '#5') = '105'");
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatLong() {
        this.helpTestRewriteCriteria("formatLong(convert(pm1.g1.e2, long), '#,##0') = '1,234,567,890,123'", FALSE_STR);
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatLong1() {
        this.helpTestRewriteCriteria("formatLong(convert(pm1.g1.e2, long), '#,##0') = '1,234,567,890'", "pm1.g1.e2 = 1234567890");
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatTimestampInvert() {
        String original = "formatTimestamp(pm3.g1.e4, 'MM dd, yyyy - HH:mm:ss.S') = ?";
        String expected = "pm3.g1.e4 = parseTimestamp(?, 'MM dd, yyyy - HH:mm:ss.S')";
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteCrit_plusInvert() {
        String original = "pm1.g1.e2 + 1.1 = ?";
        String expected = "pm1.g1.e2 = ? - 1.1";
        this.helpTestRewriteCriteria(original, expected);
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatBigInteger() throws Exception {
        String original = "formatBigInteger(convert(pm1.g1.e2, biginteger), '#,##0') = '1,234,567,890'";
        String expected = "pm1.g1.e2 = 1234567890";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        Criteria origCrit = this.parseCriteria(original, (QueryMetadataInterface)metadata);
        Criteria expectedCrit = this.parseCriteria(expected, (QueryMetadataInterface)metadata);
        Criteria actual = QueryRewriter.rewriteCriteria((Criteria)origCrit, null, null, null);
        Assert.assertEquals((String)"Did not rewrite correctly: ", (Object)expectedCrit, (Object)actual);
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatFloat() throws Exception {
        String original = "formatFloat(convert(pm1.g1.e4, float), '#,##0.###') = '1,234.123'";
        String expected = "pm1.g1.e4 = 1234.123046875";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        Criteria origCrit = this.parseCriteria(original, (QueryMetadataInterface)metadata);
        Criteria actual = QueryRewriter.rewriteCriteria((Criteria)origCrit, null, null, null);
        Assert.assertEquals((String)"Did not rewrite correctly: ", (Object)expected, (Object)actual.toString());
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatDouble() throws Exception {
        String original = "formatDouble(convert(pm1.g1.e4, double), '$#,##0.00') = '$1,234.50'";
        String expected = "pm1.g1.e4 = '1234.5'";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        Criteria origCrit = this.parseCriteria(original, (QueryMetadataInterface)metadata);
        Criteria expectedCrit = this.parseCriteria(expected, (QueryMetadataInterface)metadata);
        ((CompareCriteria)expectedCrit).setRightExpression((Expression)new Constant((Object)new Double(1234.5)));
        Criteria actual = QueryRewriter.rewriteCriteria((Criteria)origCrit, null, null, null);
        Assert.assertEquals((String)"Did not rewrite correctly: ", (Object)expectedCrit, (Object)actual);
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatBigDecimal() throws Exception {
        String original = "formatBigDecimal(convert(pm1.g1.e4, bigdecimal), '#,##0.###') = '1,234.5'";
        String expected = "pm1.g1.e4 = 1234.5";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        Criteria origCrit = this.parseCriteria(original, (QueryMetadataInterface)metadata);
        Criteria expectedCrit = this.parseCriteria(expected, (QueryMetadataInterface)metadata);
        Criteria actual = QueryRewriter.rewriteCriteria((Criteria)origCrit, null, null, null);
        Assert.assertEquals((String)"Did not rewrite correctly: ", (Object)expectedCrit, (Object)actual);
    }

    @Test
    public void testRewriteCritTimestampDiffDate1() {
        this.helpTestRewriteCriteria("timestampdiff(SQL_TSI_DAY, {d'2003-05-15'}, {d'2003-05-17'} ) = 2", TRUE_STR);
    }

    @Test
    public void testRewriteCritTimestampDiffDate2() {
        this.helpTestRewriteCriteria("timestampdiff(SQL_TSI_DAY, {d'2003-06-02'}, {d'2003-05-17'} ) = -16", TRUE_STR);
    }

    @Test
    public void testRewriteCritTimestampDiffDate3() {
        this.helpTestRewriteCriteria("timestampdiff(SQL_TSI_QUARTER, {d'2002-01-25'}, {d'2003-06-01'} ) = 5", TRUE_STR);
    }

    @Test
    public void testRewriteCritTimestampDiffTime1() {
        this.helpTestRewriteCriteria("timestampdiff(SQL_TSI_HOUR, {t'03:04:45'}, {t'05:05:36'} ) = 2", TRUE_STR);
    }

    @Test
    public void testRewriteCritTimestampDiffTime1_ignorecase() {
        this.helpTestRewriteCriteria("timestampdiff(SQL_tsi_HOUR, {t'03:04:45'}, {t'05:05:36'} ) = 2", TRUE_STR);
    }

    @Test
    public void testRewriteOr1() {
        this.helpTestRewriteCriteria("(5 = 5) OR (0 = 1)", TRUE_STR);
    }

    @Test
    public void testRewriteOr2() {
        this.helpTestRewriteCriteria("(0 = 1) OR (5 = 5)", TRUE_STR);
    }

    @Test
    public void testRewriteOr3() {
        this.helpTestRewriteCriteria("(1 = 1) OR (5 = 5)", TRUE_STR);
    }

    @Test
    public void testRewriteOr4() {
        this.helpTestRewriteCriteria("(0 = 1) OR (4 = 5)", FALSE_STR);
    }

    @Test
    public void testRewriteOr5() {
        this.helpTestRewriteCriteria("(0 = 1) OR (4 = 5) OR (pm1.g1.e1 = 'x')", "(pm1.g1.e1 = 'x')");
    }

    @Test
    public void testRewriteOr6() {
        this.helpTestRewriteCriteria("(0 = 1) OR (4 = 5) OR (pm1.g1.e1 = 'x') OR (pm1.g1.e1 = 'y')", "(pm1.g1.e1 = 'x') OR (pm1.g1.e1 = 'y')");
    }

    @Test
    public void testRewriteOr7() {
        this.helpTestRewriteCriteria("(pm1.g1.e1 = 'x') OR (pm1.g1.e1 = 'y')", "(pm1.g1.e1 = 'x') OR (pm1.g1.e1 = 'y')");
    }

    @Test
    public void testRewriteAnd1() {
        this.helpTestRewriteCriteria("(5 = 5) AND (0 = 1)", FALSE_STR);
    }

    @Test
    public void testRewriteAnd2() {
        this.helpTestRewriteCriteria("(0 = 1) AND (5 = 5)", FALSE_STR);
    }

    @Test
    public void testRewriteAnd3() {
        this.helpTestRewriteCriteria("(1 = 1) AND (5 = 5)", TRUE_STR);
    }

    @Test
    public void testRewriteAnd4() {
        this.helpTestRewriteCriteria("(0 = 1) AND (4 = 5)", FALSE_STR);
    }

    @Test
    public void testRewriteAnd5() {
        this.helpTestRewriteCriteria("(1 = 1) AND (5 = 5) AND (pm1.g1.e1 = 'x')", "(pm1.g1.e1 = 'x')");
    }

    @Test
    public void testRewriteAnd6() {
        this.helpTestRewriteCriteria("(1 = 1) AND (5 = 5) AND (pm1.g1.e1 = 'x') and (pm1.g1.e1 = 'y')", "(pm1.g1.e1 = 'x') AND (pm1.g1.e1 = 'y')");
    }

    @Test
    public void testRewriteAnd7() {
        this.helpTestRewriteCriteria("(pm1.g1.e1 = 'x') AND (pm1.g1.e1 = 'y')", "(pm1.g1.e1 = 'x') AND (pm1.g1.e1 = 'y')");
    }

    @Test
    public void testRewriteMixed1() {
        this.helpTestRewriteCriteria("((1=1) AND (1=1)) OR ((1=1) AND (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed2() {
        this.helpTestRewriteCriteria("((1=2) AND (1=1)) OR ((1=1) AND (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed3() {
        this.helpTestRewriteCriteria("((1=1) AND (1=2)) OR ((1=1) AND (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed4() {
        this.helpTestRewriteCriteria("((1=1) AND (1=1)) OR ((1=2) AND (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed5() {
        this.helpTestRewriteCriteria("((1=1) AND (1=1)) OR ((1=1) AND (1=2))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed6() {
        this.helpTestRewriteCriteria("((1=2) AND (1=1)) OR ((1=2) AND (1=1))", FALSE_STR);
    }

    @Test
    public void testRewriteMixed7() {
        this.helpTestRewriteCriteria("((1=1) AND (1=2)) OR ((1=1) AND (1=2))", FALSE_STR);
    }

    @Test
    public void testRewriteMixed8() {
        this.helpTestRewriteCriteria("((1=2) AND (1=2)) OR ((1=2) AND (1=2))", FALSE_STR);
    }

    @Test
    public void testRewriteMixed9() {
        this.helpTestRewriteCriteria("((1=1) OR (1=1)) AND ((1=1) OR (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed10() {
        this.helpTestRewriteCriteria("((1=2) OR (1=1)) AND ((1=1) OR (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed11() {
        this.helpTestRewriteCriteria("((1=1) OR (1=2)) AND ((1=1) OR (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed12() {
        this.helpTestRewriteCriteria("((1=1) OR (1=1)) AND ((1=2) OR (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed13() {
        this.helpTestRewriteCriteria("((1=1) OR (1=1)) AND ((1=1) OR (1=2))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed14() {
        this.helpTestRewriteCriteria("((1=2) OR (1=1)) AND ((1=2) OR (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed15() {
        this.helpTestRewriteCriteria("((1=1) OR (1=2)) AND ((1=1) OR (1=2))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed16() {
        this.helpTestRewriteCriteria("((1=2) OR (1=2)) AND ((1=2) OR (1=2))", FALSE_STR);
    }

    @Test
    public void testRewriteNot1() {
        this.helpTestRewriteCriteria("NOT (1=1)", FALSE_STR);
    }

    @Test
    public void testRewriteNot2() {
        this.helpTestRewriteCriteria("NOT (1=2)", TRUE_STR);
    }

    @Test
    public void testRewriteNot3() {
        this.helpTestRewriteCriteria("NOT (pm1.g1.e1='x')", "pm1.g1.e1 <> 'x'");
    }

    @Test
    public void testRewriteDefect1() {
        this.helpTestRewriteCriteria("(('DE' = 'LN') AND (null > '2002-01-01')) OR (('DE' = 'DE') AND (pm1.g1.e1 > '9000000'))", "(pm1.g1.e1 > '9000000')");
    }

    @Test
    public void testRewriteQueryCriteriaAlwaysTrue() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM pm1.g1 WHERE 0 = 0", "SELECT e1 FROM pm1.g1");
    }

    @Test
    public void testSubquery1() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM (SELECT e1 FROM pm1.g1 WHERE (1 - 1) = (0 + 0)) AS x", "SELECT e1 FROM (SELECT e1 FROM pm1.g1) AS x");
    }

    @Test
    public void testExistsSubquery() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM pm1.g1 WHERE EXISTS (SELECT e1 FROM pm1.g2)", "SELECT e1 FROM pm1.g1 WHERE EXISTS (SELECT e1 FROM pm1.g2)");
    }

    @Test
    public void testCompareSubqueryANY() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM pm1.g1 WHERE '3' = ANY (SELECT e1 FROM pm1.g2)", "SELECT e1 FROM pm1.g1 WHERE '3' = SOME (SELECT e1 FROM pm1.g2)");
    }

    @Test
    public void testCompareSubquery() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM pm1.g1 WHERE '3' = SOME (SELECT e1 FROM pm1.g2)", "SELECT e1 FROM pm1.g1 WHERE '3' = SOME (SELECT e1 FROM pm1.g2)");
    }

    @Test
    public void testCompareSubqueryUnknown() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM pm1.g1 WHERE null = SOME (SELECT e1 FROM pm1.g2)", "SELECT e1 FROM pm1.g1 WHERE null <> null");
    }

    @Test
    public void testINClauseSubquery() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM pm1.g1 WHERE '3' IN (SELECT e1 FROM pm1.g2)", "SELECT e1 FROM pm1.g1 WHERE '3' IN (SELECT e1 FROM pm1.g2)");
    }

    @Test
    public void testRewriteXMLCriteria1() {
        this.helpTestRewriteCriteria("context(pm1.g1.e1, pm1.g1.e1) = convert(5, string)", "context(pm1.g1.e1, pm1.g1.e1) = '5'");
    }

    @Test
    public void testRewriteXMLCriteria2() {
        this.helpTestRewriteCriteria("context(pm1.g1.e1, convert(5, string)) = 2+3", "context(pm1.g1.e1, '5') = '5'");
    }

    @Test
    public void testRewriteProcedure1() throws Exception {
        String procedure = "CREATE PROCEDURE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "IF (HAS = CRITERIA ON (vm1.g1.e1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select vm1.g1.e1 from vm1.g1 where HAS = CRITERIA ON (vm1.g1.e1);\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userQuery = "Insert into vm1.g1 (e1, e2) values ('String', 1)";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "insertProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure2() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "IF (HAS = CRITERIA ON (vm1.g1.e1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select vm1.g1.e1 from vm1.g1 where HAS = CRITERIA ON (vm1.g1.e1);\n";
        procedure = procedure + "END\n";
        procedure = procedure + "ELSE \n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select vm1.g1.e1 from vm1.g1 where HAS = CRITERIA ON (vm1.g1.e1);\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userQuery = "Insert into vm1.g1 (e1, e2) values ('String', 1)";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "SELECT vm1.g1.e1 FROM vm1.g1 WHERE " + FALSE_STR + ";\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "insertProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure3() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "IF (HAS = CRITERIA ON (vm1.g1.e1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select vm1.g1.e1 from vm1.g1 where HAS = CRITERIA ON (vm1.g1.e1);\n";
        procedure = procedure + "END\n";
        procedure = procedure + "ELSE \n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select vm1.g1.e1 from vm1.g1 where HAS = CRITERIA ON (vm1.g1.e1);\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userQuery = "Insert into vm1.g1 (e1, e2) values ('String', 1)";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "SELECT vm1.g1.e1 FROM vm1.g1 WHERE " + FALSE_STR + ";\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "insertProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure4() throws Exception {
        String procedure = "CREATE PROCEDURE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "IF (INPUT.e2 = 1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select vm1.g1.e1 from vm1.g1 where HAS = CRITERIA ON (vm1.g1.e1);\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userQuery = "Insert into vm1.g1 (e1, e2) values ('String', 1)";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "SELECT vm1.g1.e1 FROM vm1.g1 WHERE " + FALSE_STR + ";\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "insertProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure5() throws Exception {
        String procedure = "CREATE PROCEDURE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "IF (CHANGING.e1 = 'false')\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select e1 from vm1.g1 where HAS = CRITERIA ON (vm1.g1.e2);\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userQuery = "Update vm1.g1 SET e1 = 'String', e2 =1 where e2 = 10";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure6() throws Exception {
        String procedure = "CREATE PROCEDURE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "IF (CHANGING.e1 = 'true')\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userQuery = "Update vm1.g1 SET e1 = 'String', e2 =1 where e2 = 10";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure7() throws Exception {
        String procedure = "CREATE PROCEDURE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "IF (CHANGING.e1 = 'true')\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select e2 from pm1.g1 where TRANSLATE = CRITERIA ON (vm1.g1.e2);\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userQuery = "Update vm1.g1 SET e1 = 'String', e2 =1 where e2 = 10";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "SELECT e2 FROM pm1.g1 WHERE pm1.g1.e2 = 10;\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure8() throws Exception {
        String procedure = "CREATE PROCEDURE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "IF (CHANGING.e1 = 'true')\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select e2 from pm1.g1 where TRANSLATE = CRITERIA ON (vm1.g1.e2) with (vm1.g1.e2 = convert(sqrt(pm1.g1.e2), integer));\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userQuery = "Update vm1.g1 SET e1 = 'String', e2 =1 where e2 = 10";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "SELECT e2 FROM pm1.g1 WHERE convert(sqrt(pm1.g1.e2), integer) = 10;\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure9() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Declare String var1;\n";
        procedure = procedure + "if(var1 = 'x' or var1 = 'y')\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2, Input.e2, CHANGING.e2, CHANGING.e1 from pm1.g1 order by CHANGING.e1 + 1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userQuery = "INSERT into vm1.g1 (e1) values('x')";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "DECLARE String var1;\n";
        rewritProc = rewritProc + "IF((var1 = 'x') OR (var1 = 'y'))\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "SELECT pm1.g1.e2, null, FALSE, TRUE FROM pm1.g1;\n";
        rewritProc = rewritProc + "END\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "insertProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure10() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1, pm1.g2 where TRANSLATE = CRITERIA ON (e2) WITH (e2 = pm1.g1.e2 + 20);\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g1 SET e1='x' where e2 = e2 + 50";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "DECLARE integer var1;\n";
        rewritProc = rewritProc + "SELECT pm1.g1.e2 FROM pm1.g1, pm1.g2 WHERE (pm1.g1.e2 + 20) = ((pm1.g1.e2 + 20) + 50);\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure11() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE string var1;\n";
        procedure = procedure + "var1 = INPUT.e1;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g1 SET e1=40";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "DECLARE string var1;\n";
        rewritProc = rewritProc + "var1 = '40';\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure12() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where TRANSLATE = CRITERIA WITH (x = CONCAT(e1 , 'z'));\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where x =CONCAT(x , 'y')";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "DECLARE integer var1;\n";
        rewritProc = rewritProc + "SELECT pm1.g1.e2 FROM pm1.g1 WHERE CONCAT(e1, 'z') = CONCAT(CONCAT(e1, 'z'), 'y');\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure13() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where TRANSLATE = CRITERIA WITH (x = CONCAT(e1 , 'z'), y = convert(CONCAT(e1 , 'k'), integer));\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where x =CONCAT(x , 'y') and y= 1";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "DECLARE integer var1;\n";
        rewritProc = rewritProc + "SELECT pm1.g1.e2 FROM pm1.g1 WHERE (CONCAT(e1, 'z') = CONCAT(CONCAT(e1, 'z'), 'y')) AND (convert(CONCAT(e1, 'k'), integer) = 1);\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure14() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where TRANSLATE = CRITERIA WITH (e4 = sqrt(e4));\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where e4= 1";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "DECLARE integer var1;\n";
        rewritProc = rewritProc + "SELECT pm1.g1.e2 FROM pm1.g1 WHERE sqrt(e4) = 1.0;\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure15() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where TRANSLATE = CRITERIA WITH (e4 = e4/50);\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y= 1";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "DECLARE integer var1;\n";
        rewritProc = rewritProc + "SELECT pm1.g1.e2 FROM pm1.g1 WHERE e2 = 0;\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure16() throws Exception {
        String procedure = this.exampleTranslateUpdate();
        String userQuery = "UPDATE vm1.g3 SET x='x' where e4= 1";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "DECLARE integer var1;\n";
        rewritProc = rewritProc + "UPDATE pm1.g1 SET e1 = 'x' WHERE e4 = 0.02;\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteNoUserCriteria() throws Exception {
        String procedure = this.exampleTranslateUpdate();
        String userQuery = "UPDATE vm1.g3 SET x='x'";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "DECLARE integer var1;\n";
        rewritProc = rewritProc + "UPDATE pm1.g1 SET e1 = 'x' WHERE 1 = 1;\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteOrUserCriteria() throws Exception {
        String procedure = this.exampleTranslateUpdate();
        String userQuery = "UPDATE vm1.g3 SET x='x' where x = '1' or x = '2'";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "DECLARE integer var1;\n";
        rewritProc = rewritProc + "UPDATE pm1.g1 SET e1 = 'x' WHERE (CONCAT(e1, 'm') = '1') OR (CONCAT(e1, 'm') = '2');\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    private String exampleTranslateUpdate() {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "update pm1.g1 set pm1.g1.e1 = inputs.x where TRANSLATE CRITERIA;\n";
        procedure = procedure + "END\n";
        return procedure;
    }

    @Test(expected=QueryValidatorException.class)
    public void testRewriteProcedure17() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where TRANSLATE LIKE CRITERIA WITH (e4 = e4/50);\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where e4= 1";
        this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testRewriteProcedure18() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select Input.E1, Input.e2, CHANGING.e2, CHANGING.E1 from pm1.g1;\n";
        procedure = procedure + "END\n";
        String userQuery = "INSERT into vm1.g1 (e1, E2) values('x', 1)";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "SELECT 'x', 1, TRUE, TRUE FROM pm1.g1;\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "insertProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure19() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "update pm1.g1 set e1=Input.E1, e2=Input.e2, e3=Input.e3;\n";
        procedure = procedure + "END\n";
        String userQuery = "INSERT into vm1.g1 (E2) values(1)";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "UPDATE pm1.g1 SET e1 = 'xyz', e2 = 1, e3 = TRUE;\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "insertProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test(expected=ExpressionEvaluationException.class)
    public void testRewriteProcedure21() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "update pm1.g1 set e1=convert(Input.E1, integer)+INPUT.E2, e2=Input.e2, e3=Input.e3;\n";
        procedure = procedure + "END\n";
        String userQuery = "INSERT into vm1.g1 (E3) values({b'true'})";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "UPDATE pm1.g1 SET e3 = TRUE;\n";
        rewritProc = rewritProc + "END";
        this.getRewritenProcedure(procedure, userQuery, "insertProcedure");
    }

    @Test
    public void testRewriteProcedure21a() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "update pm1.g1 set e1=convert(Input.E1, integer)+INPUT.E2, e2=Input.e2, e3=Input.e3;\n";
        procedure = procedure + "END\n";
        String userQuery = "INSERT into vm1.g1 (E1) values(1)";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "UPDATE pm1.g1 SET e1 = null, e2 = null, e3 = TRUE;\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "insertProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure22() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "update pm1.g1 set e1=convert(Input.E1, integer)+INPUT.E2, e2=Input.e2;\n";
        procedure = procedure + "END\n";
        String userQuery = "update vm1.g1 set E3 = {b'true'}";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure23() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "update pm1.g1 set e2=Input.e2, e3=Input.e3;\n";
        procedure = procedure + "END\n";
        String userQuery = "update vm1.g1 set E1 = 'x'";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure23a() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "update pm1.g1 set e2=Input.e2, e3=Input.e3;\n";
        procedure = procedure + "END\n";
        String userQuery = "INSERT into vm1.g1 (E1) values('x')";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "UPDATE pm1.g1 SET e2 = null, e3 = TRUE;\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "insertProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test(expected=QueryValidatorException.class)
    public void testRewriteProcedure24() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "UPDATE pm1.g1 SET e2=Input.e2 WHERE TRANSLATE LIKE CRITERIA ON (e1) WITH (e1=concat(pm1.g1.e1, '%'));\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g1 set E2=1 where e2 = 1 and e1 LIKE 'mnopxyz_'";
        this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testRewriteProcedure25() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "INSERT into pm1.g1 (e1,e2,e3,e4) values (Input.e1, Input.e2, Input.e3, Input.e4);";
        procedure = procedure + "END\n";
        String userQuery = "INSERT into vm1.g1 (E2) values (1)";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "INSERT INTO pm1.g1 (e1, e2, e3, e4) VALUES ('xyz', 1, TRUE, 123.456);\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "insertProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedure26() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1, pm1.g2 where TRANSLATE = CRITERIA ON (e2);\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g1 SET e1='x' where e2 = e2 + 50";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "DECLARE integer var1;\n";
        rewritProc = rewritProc + "SELECT pm1.g1.e2 FROM pm1.g1, pm1.g2 WHERE pm1.g1.e2 = (pm1.g1.e2 + 50);\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test(expected=QueryValidatorException.class)
    public void testRewriteProcedure27() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1, pm1.g2 where TRANSLATE = CRITERIA ON (e2);\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g1 SET e1='x' where e2 LIKE 'xyz'";
        this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testRewriteProcedure_9380() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "DECLARE integer var2;\n";
        procedure = procedure + "if((var1 + 1) < length(input.e1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "var2 = INPUT.e2;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g1 SET e2=30";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "DECLARE integer var1;\n";
        rewritProc = rewritProc + "DECLARE integer var2;\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "updateProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteLookupFunction1() {
        String criteria = "lookup('pm1.g1','e1', 'e2', 1) = 'ab'";
        CompareCriteria expected = (CompareCriteria)this.parseCriteria(criteria, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        this.helpTestRewriteCriteria(criteria, (Criteria)expected, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testRewriteLookupFunction1b() {
        this.helpTestRewriteCriteria("lookup('pm1.g1','e1', 'e2', pm1.g1.e2) = 'ab'", "lookup('pm1.g1','e1', 'e2', pm1.g1.e2) = 'ab'");
    }

    @Test
    public void testRewriteLookupFunctionCompoundCriteria() {
        String criteria = "LOOKUP('pm1.g1','e1', 'e2', 1) IS NULL AND pm1.g1.e1='1'";
        CompoundCriteria expected = (CompoundCriteria)this.parseCriteria(criteria, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        this.helpTestRewriteCriteria("LOOKUP('pm1.g1','e1', 'e2', 1) IS NULL AND pm1.g1.e1=1", (Criteria)expected, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testSelectWithNoFrom() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT 5", "SELECT 5");
    }

    @Test
    public void testStoredProcedure_9822() throws Exception {
        QueryParser parser = new QueryParser();
        Command command = parser.parseCommand("exec pm1.sp4(5)");
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        Command rewriteCommand = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)metadata, null);
        List parameters = ((StoredProcedure)rewriteCommand).getParameters();
        for (SPParameter param : parameters) {
            if (param.getParameterType() != 1 && param.getParameterType() != 3) continue;
            Assert.assertTrue((boolean)(param.getExpression() instanceof Constant));
        }
    }

    @Test
    public void testRewriteFunctionThrowsEvaluationError() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        Criteria origCrit = this.parseCriteria("5 / 0 = 5", (QueryMetadataInterface)metadata);
        try {
            QueryRewriter.rewriteCriteria((Criteria)origCrit, null, null, (QueryMetadataInterface)metadata);
            Assert.fail((String)"Expected QueryValidatorException due to divide by 0");
        }
        catch (TeiidException e) {
            Assert.assertEquals((Object)"Error Code:ERR.015.001.0003 Message:Unable to evaluate (5 / 0): Error Code:ERR.015.001.0003 Message:Error while evaluating function /", (Object)e.getMessage());
        }
    }

    @Test
    public void testRewriteConvertThrowsEvaluationError() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        Criteria origCrit = this.parseCriteria("convert('x', integer) = 0", (QueryMetadataInterface)metadata);
        try {
            QueryRewriter.rewriteCriteria((Criteria)origCrit, null, null, (QueryMetadataInterface)metadata);
            Assert.fail((String)"Expected QueryValidatorException due to invalid string");
        }
        catch (TeiidException e) {
            Assert.assertEquals((Object)"Error Code:ERR.015.001.0003 Message:Unable to evaluate convert('x', integer): Error Code:ERR.015.001.0003 Message:Error while evaluating function convert", (Object)e.getMessage());
        }
    }

    @Test
    public void testDefect13458() throws Exception {
        String procedure = "CREATE PROCEDURE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "IF (HAS = CRITERIA ON (vm1.g1.e1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select vm1.g1.e1 from vm1.g1 where HAS = CRITERIA ON (vm1.g1.e1);\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userQuery = "delete from vm1.g1 where e1='1'";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "SELECT vm1.g1.e1 FROM vm1.g1;\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "deleteProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteCase1954() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e2, string) = '3'", "pm1.g1.e2 = 3");
    }

    @Test
    public void testRewriteCase1954a() {
        this.helpTestRewriteCriteria("cast(pm1.g1.e2 as string) = '3'", "pm1.g1.e2 = 3");
    }

    @Test
    public void testRewriteCase1954b() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        CompareCriteria expected = new CompareCriteria();
        ElementSymbol leftElement = new ElementSymbol("pm1.g1.e4");
        Constant constant = new Constant((Object)new Double(3.0), DataTypeManager.DefaultDataClasses.DOUBLE);
        expected.setLeftExpression((Expression)leftElement);
        expected.setRightExpression((Expression)constant);
        QueryResolver.resolveCriteria((Criteria)expected, (QueryMetadataInterface)metadata);
        this.helpTestRewriteCriteria("convert(pm1.g1.e4, string) = '3.0'", (Criteria)expected, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteCase1954c() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e1, string) = 'x'", "pm1.g1.e1 = 'x'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCase1954d() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e1, timestamp) = {ts '2005-01-03 00:00:00.0'}", "pm1.g1.e1 = '2005-01-03 00:00:00.0'");
    }

    @Test
    public void testRewriteCase1954e() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e4, integer) = 2", "convert(pm1.g1.e4, integer) = 2");
    }

    @Test
    public void testRewriteCase1954f() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e2, string) = 'x'", FALSE_STR);
    }

    @Test
    public void testRewriteCase1954f1() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e2, string) != 'x'", "pm1.g1.e2 is not null");
    }

    @Test
    public void testRewriteCase1954Set() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e2, string) in ('2', '3')", "pm1.g1.e2 IN (2,3)");
    }

    @Test
    public void testRewriteCase1954SetA() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e2, string) in ('2', 'x')", "pm1.g1.e2 = 2");
    }

    @Test
    public void testRewriteCase1954SetB() {
        this.helpTestRewriteCriteria("cast(pm1.g1.e2 as string) in ('2', '3')", "pm1.g1.e2 IN (2,3)");
    }

    @Test
    public void testRewriteCase1954SetC() {
        this.helpTestRewriteCriteria("concat(pm1.g1.e2, 'string') in ('2', '3')", "concat(pm1.g1.e2, 'string') in ('2', '3')");
    }

    @Test
    public void testRewriteCase1954SetD() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e2, string) in ('2', pm1.g1.e1)", "convert(pm1.g1.e2, string) in ('2', pm1.g1.e1)");
    }

    @Test
    public void testRewriteCaseExpr1() {
        this.helpTestRewriteCriteria("case when 0=0 then 1 else 2 end = 1", TRUE_STR);
    }

    @Test
    public void testRewriteCaseExpr2() {
        this.helpTestRewriteCriteria("case when 0=1 then 1 else 2 end = 1", FALSE_STR);
    }

    @Test
    public void testRewriteCaseExpr3() {
        this.helpTestRewriteCriteria("case when 0 = pm1.g1.e2 then 1 else 2 end = 1", "CASE WHEN pm1.g1.e2 = 0 THEN 1 ELSE 2 END = 1");
    }

    @Test
    public void testRewriteCaseExpr4() {
        this.helpTestRewriteCriteria("lookup('pm1.g1', 'e2', 'e1', case when 1=1 then pm1.g1.e1 end) = 0", "lookup('pm1.g1', 'e2', 'e1', pm1.g1.e1) = 0");
    }

    @Test
    public void testRewriteCaseExpr5() {
        this.helpTestRewriteCriteria("case when 0=1 then 1 when 0 = pm1.g1.e2 then 2 else 3 end = 1", "CASE WHEN pm1.g1.e2 = 0 THEN 2 ELSE 3 END = 1");
    }

    @Test
    public void testRewriteCaseExprForCase5413aFrom502() {
        this.helpTestRewriteCriteria("pm1.g2.e1 = case when 0 = pm1.g1.e2 then 2 else 2 end", "pm1.g2.e1 = '2'");
    }

    @Test
    public void testRewriteCaseExprForCase5413bFrom502() {
        this.helpTestRewriteCriteria("case when 0 = pm1.g1.e2 then null else null end IS NULL", TRUE_STR);
    }

    @Test
    public void testRewriteCaseExprForCase5413a() {
        this.helpTestRewriteCriteria("pm1.g2.e1 = case when 0 = pm1.g1.e2 then 2 else 2 end", "pm1.g2.e1 = '2'");
    }

    @Test
    public void testRewriteCaseExprForCase5413b() {
        this.helpTestRewriteCriteria("case when 0 = pm1.g1.e2 then null else null end IS NULL", TRUE_STR);
    }

    @Test
    public void testRewriteSearchedCaseExpr1() {
        this.helpTestRewriteCriteria("case 0 when 0 then 1 else 2 end = 1", TRUE_STR);
    }

    @Test
    public void testRewriteSearchedCaseExpr2() {
        this.helpTestRewriteCriteria("case 0 when 1 then 1 else 2 end = 1", FALSE_STR);
    }

    @Test
    public void testRewriteSearchedCaseExpr3() {
        this.helpTestRewriteCriteria("case 0 when pm1.g1.e2 then 1 else 2 end = 1", "CASE WHEN pm1.g1.e2 = 0 THEN 1 ELSE 2 END = 1");
    }

    @Test
    public void testRewriteSearchedCaseExpr4() {
        String criteria = "lookup('pm1.g1', 'e2', 'e1', '2') = 0";
        CompareCriteria expected = (CompareCriteria)this.parseCriteria(criteria, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        this.helpTestRewriteCriteria("lookup('pm1.g1', 'e2', 'e1', case 0 when 1 then pm1.g1.e1 else 2 end) = 0", (Criteria)expected, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testRewriteSearchedCaseExpr5() {
        this.helpTestRewriteCriteria("case 0 when 1 then 1 when pm1.g1.e2 then 2 else 3 end = 1", "CASE WHEN pm1.g1.e2 = 0 THEN 2 ELSE 3 END = 1");
    }

    @Test
    public void testDefect16879_1() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT decodestring(e1, 'a, b') FROM pm1.g1", "SELECT CASE WHEN e1 = 'a' THEN 'b' ELSE e1 END FROM pm1.g1");
    }

    @Test
    public void testDefect16879_2() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT decodestring(e1, 'a, b, c, d') FROM pm1.g1", "SELECT CASE WHEN e1 = 'a' THEN 'b' WHEN e1 = 'c' THEN 'd' ELSE e1 END FROM pm1.g1");
    }

    @Test
    public void testDefect16879_3() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT decodeinteger(e1, 'a, b') FROM pm1.g1", "SELECT CASE WHEN e1 = 'a' THEN 'b' ELSE e1 END FROM pm1.g1");
    }

    @Test
    public void testDefect16879_4() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT decodeinteger(e1, 'a, b, c, d') FROM pm1.g1", "SELECT CASE WHEN e1 = 'a' THEN 'b' WHEN e1 = 'c' THEN 'd' ELSE e1 END FROM pm1.g1");
    }

    @Test
    public void testDefect16879_5() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT decodeinteger(e1, 'null, b, c, d') FROM pm1.g1", "SELECT CASE WHEN e1 IS NULL THEN 'b' WHEN e1 = 'c' THEN 'd' ELSE e1 END FROM pm1.g1");
    }

    @Test
    public void testDefect16879_6() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT decodeinteger(e1, 'a, b, null, d') FROM pm1.g1", "SELECT CASE WHEN e1 = 'a' THEN 'b' WHEN e1 IS NULL THEN 'd' ELSE e1 END FROM pm1.g1");
    }

    @Test
    public void testDefect16879_7() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT decodeinteger(e1, 'a, b, null, d, e') FROM pm1.g1", "SELECT CASE WHEN e1 = 'a' THEN 'b' WHEN e1 IS NULL THEN 'd' ELSE 'e' END FROM pm1.g1");
    }

    @Test
    public void testCaseExpressionThatResolvesToNull() {
        String sqlBefore = "SELECT CASE 'x' WHEN 'Old Inventory System' THEN NULL WHEN 'New Inventory System' THEN NULL END";
        String sqlAfter = "SELECT null";
        Command cmd = TestQueryRewriter.helpTestRewriteCommand(sqlBefore, sqlAfter);
        ExpressionSymbol es = (ExpressionSymbol)cmd.getProjectedSymbols().get(0);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.STRING, (Object)es.getType());
    }

    @Test
    public void testRewriteExecEnv() throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand("exec pm1.sq2(env('sessionid'))");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        CommandContext context = new CommandContext();
        Properties props = new Properties();
        props.setProperty("sessionid", "1");
        context.setEnvironmentProperties(props);
        Command rewriteCommand = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), (CommandContext)context);
        Assert.assertEquals((Object)"EXEC pm1.sq2('1')", (Object)rewriteCommand.toString());
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteNestedFunctions() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM pm1.g1 where convert(parsedate(e1, 'yyyy-MM-dd'), string) = '2006-07-01'", "SELECT e1 FROM pm1.g1 WHERE e1 = '2006-07-01'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteWithReference() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM pm1.g1 where parsetimestamp(e1, 'yyyy-MM-dd') != ?", "SELECT e1 FROM pm1.g1 WHERE e1 <> formattimestamp(?, 'yyyy-MM-dd')");
    }

    @Test
    public void testRewiteJoinCriteria() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT pm1.g1.e1 FROM pm1.g1 inner join pm1.g2 on (pm1.g1.e1 = null)", "SELECT pm1.g1.e1 FROM pm1.g1 INNER JOIN pm1.g2 ON 1 = 0");
    }

    @Test
    public void testRewiteCompoundCriteria() {
        this.helpTestRewriteCriteria("(pm1.g1.e1 = 1 and pm1.g1.e2 = 2) and (pm1.g1.e3 = 1 and pm1.g1.e4 = 2)", "(pm1.g1.e1 = '1') AND (pm1.g1.e2 = 2) AND (pm1.g1.e3 = TRUE) AND (pm1.g1.e4 = 2.0)");
    }

    @Test
    public void testRewriteWhile() throws Exception {
        String procedure = "CREATE PROCEDURE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "while (1 = 1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select vm1.g1.e1 from vm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userQuery = "Insert into vm1.g1 (e1, e2) values ('String', 1)";
        try {
            this.getRewritenProcedure(procedure, userQuery, "insertProcedure");
            Assert.fail((String)"exception expected");
        }
        catch (QueryValidatorException e) {
            Assert.assertEquals((Object)"Infinite loop detected, procedure will not be executed.", (Object)e.getMessage());
        }
    }

    @Test
    public void testRewriteWhile1() throws Exception {
        String procedure = "CREATE PROCEDURE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "while (1 = 0)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select vm1.g1.e1 from vm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userQuery = "Insert into vm1.g1 (e1, e2) values ('String', 1)";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "insertProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedureWithCount() throws Exception {
        String procedure = "CREATE PROCEDURE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select count(*) from pm1.g1;\n";
        procedure = procedure + "END\n";
        String userQuery = "Insert into vm1.g1 (e1, e2) values ('String', 1)";
        String rewritProc = "CREATE PROCEDURE\n";
        rewritProc = rewritProc + "BEGIN\n";
        rewritProc = rewritProc + "SELECT COUNT(*) FROM pm1.g1;\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, "insertProcedure");
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testVariableSubstitutionVisitor() throws Exception {
        String procedure1 = "CREATE PROCEDURE  ";
        procedure1 = procedure1 + "BEGIN\n";
        procedure1 = procedure1 + "DECLARE string var1 = INPUT.e1;\n";
        procedure1 = procedure1 + "ROWS_UPDATED = UPDATE vm1.g2 SET e1=var1;\n";
        procedure1 = procedure1 + "END";
        String procedure2 = "CREATE PROCEDURE ";
        procedure2 = procedure2 + "BEGIN\n";
        procedure2 = procedure2 + "DECLARE integer var1;\n";
        procedure2 = procedure2 + "IF (INPUT.e1 = 1)\n";
        procedure2 = procedure2 + "ROWS_UPDATED = 5;\n";
        procedure2 = procedure2 + "ELSE\n";
        procedure2 = procedure2 + "ROWS_UPDATED = 5;\n";
        procedure2 = procedure2 + "END";
        String userUpdateStr = "UPDATE vm1.g1 SET e1 = 'x' WHERE e2 = 5";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure1, procedure2);
        String rewriten = this.getRewritenProcedure(userUpdateStr, (QueryMetadataInterface)metadata);
        String expected = "CREATE PROCEDURE\nBEGIN\nDECLARE string var1 = 'x';\nUPDATE vm1.g2 SET e1 = var1;\nROWS_UPDATED = VARIABLES.ROWCOUNT;\nEND";
        Assert.assertEquals((Object)expected, (Object)rewriten);
    }

    @Test
    public void testRemoveEmptyLoop() {
        String procedure1 = "CREATE virtual PROCEDURE  ";
        procedure1 = procedure1 + "BEGIN\n";
        procedure1 = procedure1 + "loop on (select e1 from pm1.g1) as myCursor\n";
        procedure1 = procedure1 + "begin\n";
        procedure1 = procedure1 + "end\n";
        procedure1 = procedure1 + "select e1 from pm1.g1;\n";
        procedure1 = procedure1 + "END";
        String expected = "CREATE VIRTUAL PROCEDURE\nBEGIN\nSELECT e1 FROM pm1.g1;\nEND";
        TestQueryRewriter.helpTestRewriteCommand(procedure1, expected);
    }

    @Test
    public void testRewriteDeclare() {
        String procedure1 = "CREATE virtual PROCEDURE  ";
        procedure1 = procedure1 + "BEGIN\n";
        procedure1 = procedure1 + "declare integer x = 1 + 1;\n";
        procedure1 = procedure1 + "END";
        String expected = "CREATE VIRTUAL PROCEDURE\nBEGIN\nDECLARE integer x = 2;\nEND";
        TestQueryRewriter.helpTestRewriteCommand(procedure1, expected);
    }

    @Test
    public void testRewriteUnionJoin() {
        String sql = "select pm1.g1.e1 from pm1.g1 union join pm1.g2 where g1.e1 = 1";
        String expected = "SELECT pm1.g1.e1 FROM pm1.g1 FULL OUTER JOIN pm1.g2 ON 1 = 0 WHERE g1.e1 = '1'";
        TestQueryRewriter.helpTestRewriteCommand(sql, expected);
    }

    @Test
    public void testRewriteNonNullDependentFunction() {
        this.helpTestRewriteCriteria("pm1.g1.e1 = concat(null, pm1.g1.e2)", "null <> null");
    }

    @Test
    public void testRewriteInWithNull() {
        this.helpTestRewriteCriteria("convert(null, string) in (pm1.g1.e1, pm1.g1.e2)", "null <> null");
    }

    @Test
    public void testRewriteXMLCriteriaCases5630And5640() {
        TestQueryRewriter.helpTestRewriteCommand("select * from xmltest.doc1 where node1 = null", "SELECT * FROM xmltest.doc1 WHERE null <> null");
    }

    @Test
    public void testRewriteCorrelatedSubqueryInHaving() {
        String sql = "select pm1.g1.e1 from pm1.g1 group by pm1.g1.e1 having pm1.g1.e1 in (select pm1.g1.e1 from pm1.g2)";
        String expected = "SELECT pm1.g1.e1 FROM pm1.g1 GROUP BY pm1.g1.e1 HAVING pm1.g1.e1 IN (SELECT pm1.g1.e1 FROM pm1.g2)";
        Query query = (Query)TestQueryRewriter.helpTestRewriteCommand(sql, expected);
        LinkedList refs = new LinkedList();
        CorrelatedReferenceCollectorVisitor.collectReferences((LanguageObject)query, Arrays.asList(new GroupSymbol("pm1.g1")), refs);
        Assert.assertEquals((long)1L, (long)refs.size());
    }

    @Test
    public void testRewriteSelectInto() {
        String sql = "select distinct pm1.g1.e1 into #temp from pm1.g1";
        String expected = "INSERT INTO #temp (#TEMP.e1) SELECT DISTINCT pm1.g1.e1 FROM pm1.g1";
        TestQueryRewriter.helpTestRewriteCommand(sql, expected);
    }

    @Test
    public void testRewriteSelectInto1() {
        String sql = "select distinct e2, e2, e3, e4 into pm1.g1 from pm1.g2";
        String expected = "INSERT INTO pm1.g1 (pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4) SELECT PM1_G1_1.e2 AS e1, PM1_G1_1.E2_0 AS e2, PM1_G1_1.e3, PM1_G1_1.e4 FROM (SELECT DISTINCT e2, e2 AS E2_0, e3, e4 FROM pm1.g2) AS pm1_g1_1";
        TestQueryRewriter.helpTestRewriteCommand(sql, expected);
    }

    @Test
    public void testUnionQueryNullInOneBranch() throws Exception {
        this.verifyProjectedTypesOnUnionBranches("SELECT e1, e2 FROM pm1.g1 UNION ALL SELECT e1, null FROM pm1.g2", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER});
    }

    @Test
    public void testUnionQueryNullInOneBranch2() throws Exception {
        this.verifyProjectedTypesOnUnionBranches("SELECT e1, e2 FROM pm1.g1 UNION ALL SELECT e1, e2 FROM pm1.g2 UNION ALL SELECT e1, null FROM pm1.g2", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER});
    }

    @Test
    public void testUnionQueryNullInOneBranch3() throws Exception {
        this.verifyProjectedTypesOnUnionBranches("SELECT e1, null FROM pm1.g1 UNION ALL SELECT e1, null FROM pm1.g2 UNION ALL SELECT e1, e2 FROM pm1.g2", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER});
    }

    @Test
    public void testUnionQueryNullInAllBranches() throws Exception {
        this.verifyProjectedTypesOnUnionBranches("SELECT e1, null FROM pm1.g1 UNION ALL SELECT e1, null FROM pm1.g2 UNION ALL SELECT e1, null FROM pm1.g2", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.STRING});
    }

    @Test
    public void testUnionQueryWithTypeConversion() throws Exception {
        this.verifyProjectedTypesOnUnionBranches("SELECT e1 FROM pm1.g1 UNION ALL SELECT e2 FROM pm1.g2", new Class[]{DataTypeManager.DefaultDataClasses.STRING});
    }

    private void verifyProjectedTypesOnUnionBranches(String unionQuery, Class<?>[] types) throws TeiidComponentException, TeiidProcessingException {
        SetQuery union = (SetQuery)QueryParser.getQueryParser().parseCommand(unionQuery);
        QueryResolver.resolveCommand((Command)union, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        union = (SetQuery)QueryRewriter.rewrite((Command)union, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null);
        for (QueryCommand query : union.getQueryCommands()) {
            List projSymbols = query.getProjectedSymbols();
            for (int i = 0; i < projSymbols.size(); ++i) {
                Assert.assertEquals((String)("Found type mismatch at column " + i), types[i], (Object)((SingleElementSymbol)projSymbols.get(i)).getType());
            }
        }
    }

    @Test
    public void testSelectIntoWithOrderByAndTypeConversion() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "CREATE local temporary table temp (x string, y integer, z integer);\n";
        procedure = procedure + "Select pm1.g1.e2, 1 as x, 2 as x into temp from pm1.g1 order by pm1.g1.e2 limit 1;\n";
        procedure = procedure + "Select x from temp;\n";
        procedure = procedure + "END\n";
        TestQueryRewriter.helpTestRewriteCommand(procedure, "CREATE VIRTUAL PROCEDURE\nBEGIN\nCREATE LOCAL TEMPORARY TABLE temp (x string, y integer, z integer);\nINSERT INTO temp (TEMP.x, TEMP.y, TEMP.z) SELECT TEMP_1.e2 AS x, TEMP_1.x AS y, TEMP_1.X_0 AS z FROM (SELECT pm1.g1.e2, 1 AS x, 2 AS X_0 FROM pm1.g1 ORDER BY pm1.g1.e2 LIMIT 1) AS temp_1;\nSELECT x FROM temp;\nEND");
    }

    @Test
    public void testRewriteNot() {
        this.helpTestRewriteCriteria("not(not(pm1.g1.e1 = 1 + 1))", "pm1.g1.e1 = '2'");
    }

    @Test
    public void testRewriteQueryWithNoFrom() {
        String sql = "select 1 as a order by a";
        TestQueryRewriter.helpTestRewriteCommand(sql, "SELECT 1 AS a");
    }

    @Test
    public void testVirtualRightOuterJoinSwap() throws Exception {
        String sql = "SELECT sa.IntKey AS sa_IntKey, mb.IntKey AS mb_IntKey FROM (select * from BQT1.smalla) sa RIGHT OUTER JOIN (select BQT1.mediumb.intkey from BQT1.mediumb) mb ON sa.IntKey = mb.IntKey";
        TestQueryRewriter.helpTestRewriteCommand(sql, "SELECT sa.IntKey AS sa_IntKey, mb.IntKey AS mb_IntKey FROM (SELECT BQT1.mediumb.intkey FROM BQT1.mediumb) AS mb LEFT OUTER JOIN (SELECT * FROM BQT1.smalla) AS sa ON sa.IntKey = mb.IntKey", (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testVirtualRightOuterJoinSwap1() throws Exception {
        String sql = "SELECT sa.IntKey AS sa_IntKey, mb.IntKey AS mb_IntKey FROM ((select * from BQT1.smalla) sa inner join BQT1.smallb on sa.intkey = smallb.intkey) RIGHT OUTER JOIN (select BQT1.mediumb.intkey from BQT1.mediumb) mb ON sa.IntKey = mb.IntKey";
        TestQueryRewriter.helpTestRewriteCommand(sql, "SELECT sa.IntKey AS sa_IntKey, mb.IntKey AS mb_IntKey FROM (SELECT BQT1.mediumb.intkey FROM BQT1.mediumb) AS mb LEFT OUTER JOIN ((SELECT * FROM BQT1.smalla) AS sa INNER JOIN BQT1.smallb ON sa.intkey = smallb.intkey) ON sa.IntKey = mb.IntKey", (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testRewriteConcat2() {
        this.helpTestRewriteCriteria("concat2('a','b') = 'ab'", TRUE_STR);
    }

    @Test
    public void testRewriteConcat2_1() {
        this.helpTestRewriteCriteria("concat2(null, null) is null", TRUE_STR);
    }

    @Test
    public void testRewriteConcat2_2() throws Exception {
        this.helpTestRewriteCriteria("concat2(pm1.g1.e1, null) = 'xyz'", "CASE WHEN pm1.g1.e1 IS NULL THEN null ELSE concat(ifnull(pm1.g1.e1, ''), '') END = 'xyz'", true);
    }

    @Test
    public void testRewriteConcat2_3() throws Exception {
        this.helpTestRewriteCriteria("concat2(pm1.g1.e1, convert(pm1.g1.e2, string)) = 'xyz'", "CASE WHEN (pm1.g1.e1 IS NULL) AND (convert(pm1.g1.e2, string) IS NULL) THEN null ELSE concat(ifnull(pm1.g1.e1, ''), ifnull(convert(pm1.g1.e2, string), '')) END = 'xyz'", true);
    }

    @Test
    public void testRewriteConcat2_4() throws Exception {
        this.helpTestRewriteCriteria("concat2('a', pm1.g1.e1) = 'xyz'", "concat('a', ifnull(pm1.g1.e1, '')) = 'xyz'");
    }

    @Test
    public void testRewiteEvaluatableAggregate() {
        TestQueryRewriter.helpTestRewriteCommand("select pm1.g1.e1, max(1) from pm1.g1", "SELECT pm1.g1.e1, 1 FROM pm1.g1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRewriteFromUnixTime() throws Exception {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-06:00"));
        try {
            this.helpTestRewriteCriteria("from_unixtime(pm1.g1.e2) = '1992-12-01 07:00:00'", "timestampadd(SQL_TSI_SECOND, pm1.g1.e2, {ts'1969-12-31 18:00:00.0'}) = {ts'1992-12-01 07:00:00.0'}");
        }
        finally {
            TimestampWithTimezone.resetCalendar(null);
        }
    }

    @Test
    public void testRewriteNullIf() throws Exception {
        this.helpTestRewriteCriteria("nullif(pm1.g1.e2, pm1.g1.e4) = 1", "CASE WHEN pm1.g1.e2 = pm1.g1.e4 THEN convert(null, double) ELSE pm1.g1.e2 END = 1.0", true);
    }

    @Test
    public void testRewriteCoalesce() throws Exception {
        this.helpTestRewriteCriteria("coalesce(convert(pm1.g1.e2, double), pm1.g1.e4) = 1", "ifnull(convert(pm1.g1.e2, double), pm1.g1.e4) = 1", true);
    }

    @Test
    public void testAggregateWithBetweenInCaseInSelect() {
        List<String> aggregateCommands = Arrays.asList("SUM", "MAX", "MIN", "AVG", "COUNT");
        String sqlBefore = "SELECT ?AGGREGATE?(CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 ELSE -1 END) FROM pm1.g1";
        String sqlAfter = "SELECT ?AGGREGATE?(CASE WHEN (e2 >= 3) AND (e2 <= 5) THEN e2 ELSE -1 END) FROM pm1.g1";
        for (String aCmd : aggregateCommands) {
            String sql = sqlBefore.replace("?AGGREGATE?", aCmd);
            String exSql = sqlAfter.replace("?AGGREGATE?", aCmd);
            Command cmd = TestQueryRewriter.helpTestRewriteCommand(sql, exSql);
            CompoundCriteria ccrit = (CompoundCriteria)((SearchedCaseExpression)((ExpressionSymbol)cmd.getProjectedSymbols().get(0)).getExpression()).getWhen().get(0);
            Assert.assertEquals((Object)"e2 >= 3", (Object)ccrit.getCriteria(0).toString());
            Assert.assertEquals((Object)"e2 <= 5", (Object)ccrit.getCriteria(1).toString());
        }
    }

    @Test
    public void testBetweenInCaseInSelect() {
        String sqlBefore = "SELECT CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 ELSE -1 END FROM pm1.g1";
        String sqlAfter = "SELECT CASE WHEN (e2 >= 3) AND (e2 <= 5) THEN e2 ELSE -1 END FROM pm1.g1";
        Command cmd = TestQueryRewriter.helpTestRewriteCommand(sqlBefore, sqlAfter);
        CompoundCriteria ccrit = (CompoundCriteria)((SearchedCaseExpression)((ExpressionSymbol)cmd.getProjectedSymbols().get(0)).getExpression()).getWhen().get(0);
        Assert.assertEquals((Object)"e2 >= 3", (Object)ccrit.getCriteria(0).toString());
        Assert.assertEquals((Object)"e2 <= 5", (Object)ccrit.getCriteria(1).toString());
    }

    @Test
    public void testBetweenInCase() {
        String sqlBefore = "SELECT * FROM pm1.g1 WHERE e3 = CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 ELSE -1 END";
        String sqlAfter = "SELECT * FROM pm1.g1 WHERE e3 = CASE WHEN (e2 >= 3) AND (e2 <= 5) THEN e2 ELSE -1 END";
        Command cmd = TestQueryRewriter.helpTestRewriteCommand(sqlBefore, sqlAfter);
        CompoundCriteria ccrit = (CompoundCriteria)((SearchedCaseExpression)((CompareCriteria)((Query)cmd).getCriteria()).getRightExpression()).getWhen().get(0);
        Assert.assertEquals((Object)"e2 >= 3", (Object)ccrit.getCriteria(0).toString());
        Assert.assertEquals((Object)"e2 <= 5", (Object)ccrit.getCriteria(1).toString());
    }

    @Test
    public void testRewriteNullHandling() {
        String original = "pm1.g1.e1 like '%'";
        String expected = "pm1.g1.e1 is not null";
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteNullHandling1() {
        String original = "not(pm1.g1.e1 like '%' or pm1.g1.e1 = '1')";
        String expected = FALSE_STR;
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteNullHandling2() {
        String original = "not(pm1.g1.e1 like '%' and pm1.g1.e1 = '1')";
        String expected = "pm1.g1.e1 <> '1'";
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteNullHandling3() {
        String original = "pm1.g1.e1 like '%' or pm1.g1.e1 = '1'";
        String expected = "(pm1.g1.e1 IS NOT NULL) OR (pm1.g1.e1 = '1')";
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteNullHandling4() {
        String original = "not((pm1.g1.e1 like '%' or pm1.g1.e1 = '1') and pm1.g1.e2 < 5)";
        String expected = "(pm1.g1.e2 < 5) AND ((pm1.g1.e2 < 5) OR (pm1.g1.e1 <> '1'))";
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteNullHandling5() {
        String original = "not(pm1.g1.e1 not like '%' and pm1.g1.e3 = '1') or pm1.g1.e2 < 5";
        String expected = "(pm1.g1.e1 IS NOT NULL) OR (pm1.g1.e3 <> TRUE) OR (pm1.g1.e2 < 5)";
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteChar() {
        String original = "convert(pm1.g1.e1, char) = '100'";
        String expected = FALSE_STR;
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteBigDecimal() {
        String original = "convert(BQT1.SmallA.LongNum, bigdecimal) = '22.0'";
        CompareCriteria crit = new CompareCriteria((Expression)new ElementSymbol("BQT1.SmallA.LongNum"), 1, (Expression)new Constant((Object)new Long(22L)));
        this.helpTestRewriteCriteria(original, (Criteria)crit, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testRewriteWideningIn() {
        String original = "convert(BQT1.SmallA.TimestampValue, time) in ({t'10:00:00'}, {t'11:00:00'})";
        this.helpTestRewriteCriteria(original, this.parseCriteria("convert(BQT1.SmallA.TimestampValue, time) in ({t'10:00:00'}, {t'11:00:00'})", (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached()), (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testRewriteParseDate() {
        String original = "parsedate(BQT1.SmallA.stringkey, 'yymmdd') = {d'1970-01-01'}";
        TransformationMetadata metadata = FakeMetadataFactory.exampleBQTCached();
        this.helpTestRewriteCriteria(original, this.parseCriteria("convert(parsetimestamp(BQT1.SmallA.stringkey, 'yymmdd'), date) = {d'1970-01-01'}", (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteFormatTime() {
        String original = "formattime(BQT1.SmallA.timevalue, 'hh:mm') = '08:02'";
        TransformationMetadata metadata = FakeMetadataFactory.exampleBQTCached();
        this.helpTestRewriteCriteria(original, this.parseCriteria("formattimestamp(convert(BQT1.SmallA.timevalue, timestamp), 'hh:mm') = '08:02'", (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteTimestampAdd() {
        String original = "timestampadd(SQL_TSI_SECOND, 1, BQT1.SmallA.timevalue) = {t'08:02:00'}";
        TransformationMetadata metadata = FakeMetadataFactory.exampleBQTCached();
        this.helpTestRewriteCriteria(original, this.parseCriteria("convert(timestampadd(SQL_TSI_SECOND, 1, convert(BQT1.SmallA.timevalue, timestamp)), time) = {t'08:02:00'}", (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteXmlElement() throws Exception {
        String original = "xmlserialize(document xmlelement(name a, xmlattributes('b' as c)) as string)";
        TransformationMetadata metadata = FakeMetadataFactory.exampleBQTCached();
        this.helpTestRewriteExpression(original, "'<a c=\"b\"></a>'", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteXmlElement1() throws Exception {
        String original = "xmlelement(name a, xmlattributes(1+1 as c), BQT1.SmallA.timevalue)";
        TransformationMetadata metadata = FakeMetadataFactory.exampleBQTCached();
        this.helpTestRewriteExpression(original, "XMLELEMENT(NAME a, XMLATTRIBUTES(2 AS c), BQT1.SmallA.timevalue)", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteXmlSerialize() throws Exception {
        String original = "xmlserialize(document xmlelement(name a, xmlattributes('b' as c)) as string)";
        TransformationMetadata metadata = FakeMetadataFactory.exampleBQTCached();
        this.helpTestRewriteExpression(original, "'<a c=\"b\"></a>'", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteXmlTable() throws Exception {
        String original = "select * from xmltable('/' passing 1 + 1 as a columns x string default curdate()) as x";
        TransformationMetadata metadata = FakeMetadataFactory.exampleBQTCached();
        TestQueryRewriter.helpTestRewriteCommand(original, "SELECT * FROM XMLTABLE('/' PASSING 2 AS a COLUMNS x string DEFAULT curdate()) AS x", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteQueryString() throws Exception {
        String original = "querystring('path', 'value' as \"&x\", ' & ' as y, null as z)";
        TransformationMetadata metadata = FakeMetadataFactory.exampleBQTCached();
        this.helpTestRewriteExpression(original, "'path?%26x=value&y=%20%26%20'", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteExpressionCriteria() throws Exception {
        this.helpTestRewriteCriteria("pm1.g1.e3", "pm1.g1.e3 = true");
    }
}

