/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.TestBlock;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SelectSymbol;

public class TestLoopStatement
extends TestCase {
    public TestLoopStatement(String name) {
        super(name);
    }

    public static final Query query1() {
        Query q1 = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("x"));
        q1.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("g"));
        q1.setFrom(from);
        return q1;
    }

    public static final Query query2() {
        Query q1 = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("x2"));
        q1.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("g2"));
        q1.setFrom(from);
        return q1;
    }

    public static final LoopStatement sample1() {
        Block block = TestBlock.sample1();
        return new LoopStatement(block, (Command)TestLoopStatement.query1(), "cursor");
    }

    public static final LoopStatement sample2() {
        Block block = TestBlock.sample2();
        return new LoopStatement(block, (Command)TestLoopStatement.query2(), "cursor");
    }

    public void testGetBlock() {
        LoopStatement b1 = TestLoopStatement.sample1();
        TestLoopStatement.assertTrue((String)"Incorrect Block on statement", (boolean)b1.getBlock().equals((Object)TestBlock.sample1()));
    }

    public void testGetQuery() {
        LoopStatement b1 = TestLoopStatement.sample1();
        TestLoopStatement.assertTrue((String)"Incorrect Query on statement", (boolean)b1.getCommand().equals(TestLoopStatement.query1()));
    }

    public void testGetCursorName() {
        LoopStatement b1 = TestLoopStatement.sample1();
        LoopStatement b2 = TestLoopStatement.sample2();
        TestLoopStatement.assertEquals((String)b1.getCursorName(), (String)b2.getCursorName());
    }

    public void testSelfEquivalence() {
        LoopStatement s1 = TestLoopStatement.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1);
    }

    public void testEquivalence() {
        LoopStatement s1 = TestLoopStatement.sample1();
        LoopStatement s1a = TestLoopStatement.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1a);
    }

    public void testNonEquivalence() {
        LoopStatement s1 = TestLoopStatement.sample1();
        LoopStatement s2 = TestLoopStatement.sample2();
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
    }
}

