/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.ElementSymbolOptimizer;
import org.teiid.query.unittest.FakeMetadataFactory;

public class TestElementSymbolOptimizer
extends TestCase {
    public TestElementSymbolOptimizer(String name) {
        super(name);
    }

    public Command helpResolve(String sql, QueryMetadataInterface metadata, Map externalMetadata) throws QueryParserException, QueryResolverException, TeiidComponentException {
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        boolean USE_METADATA_COMMANDS = true;
        QueryResolver.resolveCommand((Command)command, (Map)externalMetadata, (QueryMetadataInterface)metadata, (AnalysisRecord)AnalysisRecord.createNonRecordingRecord());
        return command;
    }

    public void helpTestOptimize(String sql, QueryMetadataInterface metadata, String expected) throws QueryMetadataException, TeiidComponentException, QueryParserException, QueryResolverException {
        this.helpTestOptimize(sql, metadata, expected, Collections.EMPTY_MAP);
    }

    public void helpTestOptimize(String sql, QueryMetadataInterface metadata, String expected, Map externalMetadata) throws QueryMetadataException, TeiidComponentException, QueryParserException, QueryResolverException {
        Command command = this.helpResolve(sql, metadata, externalMetadata);
        ElementSymbolOptimizer.optimizeElements((Command)command, (QueryMetadataInterface)metadata);
        String actual = command.toString();
        TestElementSymbolOptimizer.assertEquals((String)"Expected different optimized string", (String)expected, (String)actual);
    }

    public void testOptimize1() throws Exception {
        this.helpTestOptimize("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT e1, e2 FROM pm1.g1");
    }

    public void testOptimize2() throws Exception {
        this.helpTestOptimize("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1, pm1.g2", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1, pm1.g2");
    }

    public void testOptimize3() throws Exception {
        this.helpTestOptimize("UPDATE pm1.g1 SET pm1.g1.e1 = 'e' WHERE pm1.g1.e2 = 3", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "UPDATE pm1.g1 SET e1 = 'e' WHERE e2 = 3");
    }

    public void testOptimize4() throws Exception {
        this.helpTestOptimize("INSERT INTO pm1.g1 (pm1.g1.e1, pm1.g1.e2) VALUES ('e', 3)", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "INSERT INTO pm1.g1 (e1, e2) VALUES ('e', 3)");
    }

    public void testOptimize5() throws Exception {
        this.helpTestOptimize("DELETE FROM pm1.g1 WHERE pm1.g1.e2 = 3", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "DELETE FROM pm1.g1 WHERE e2 = 3");
    }

    public void testOptimize6() throws Exception {
        this.helpTestOptimize("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1 WHERE e2 > (SELECT AVG(pm1.g2.e2) FROM pm1.g2 WHERE pm1.g1.e1 = pm1.g2.e1)", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT e1, e2 FROM pm1.g1 WHERE e2 > (SELECT AVG(pm1.g2.e2) FROM pm1.g2 WHERE pm1.g1.e1 = pm1.g2.e1)");
    }

    public void testOptimize7() throws Exception {
        this.helpTestOptimize("SELECT 'text' AS zz, pm1.g1.e2 FROM pm1.g1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT 'text' AS zz, e2 FROM pm1.g1");
    }

    public void testOptimize8() throws Exception {
        this.helpTestOptimize("SELECT 1, 'xyz'", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT 1, 'xyz'");
    }

    public void helpTestFullyQualify(String sql, QueryMetadataInterface metadata, String expected) throws QueryParserException, QueryResolverException, TeiidComponentException {
        Command command = this.helpResolve(sql, metadata, Collections.EMPTY_MAP);
        ElementSymbolOptimizer.fullyQualifyElements((Command)command);
        String actual = command.toString();
        TestElementSymbolOptimizer.assertEquals((String)"Expected different fully qualified string", (String)expected, (String)actual);
    }

    public void testFullyQualify1() throws Exception {
        this.helpTestFullyQualify("SELECT e1, e2 FROM pm1.g1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1");
    }

    public void testXMLQuery() throws Exception {
        this.helpTestOptimize("SELECT root.node1.node2.node3 FROM xmltest.doc1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT root.node1.node2.node3 FROM xmltest.doc1");
    }

    public void testVirtualStoredProcedure() throws Exception {
        this.helpTestOptimize("EXEC pm1.vsp7(5)", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "EXEC pm1.vsp7(5)");
    }

    public void testStoredQueryTransform() throws Exception {
        HashMap externalMetadata = new HashMap();
        GroupSymbol gs = new GroupSymbol("pm1.sq3");
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>(2);
        elements.add(new ElementSymbol("pm1.sq3.in"));
        elements.add(new ElementSymbol("pm1.sq3.in2"));
        externalMetadata.put(gs, elements);
        this.helpTestOptimize("SELECT pm1.g6.in, pm1.g6.in3 FROM pm1.g6 WHERE pm1.g6.in=pm1.sq3.in AND pm1.g6.in3=pm1.sq3.in2", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT pm1.g6.\"in\", in3 FROM pm1.g6 WHERE (pm1.g6.\"in\" = pm1.sq3.\"in\") AND (in3 = in2)", externalMetadata);
    }

    public void testStoredQueryTransform2() throws Exception {
        HashMap externalMetadata = new HashMap();
        GroupSymbol gs = new GroupSymbol("pm1.sq3");
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>(2);
        elements.add(new ElementSymbol("pm1.sq3.in"));
        elements.add(new ElementSymbol("pm1.sq3.in2"));
        externalMetadata.put(gs, elements);
        this.helpTestOptimize("EXEC pm1.sq2(pm1.sq3.in)", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "EXEC pm1.sq2(\"in\")", externalMetadata);
    }

    public void testStoredQuerySubquery() throws Exception {
        this.helpTestOptimize("select x.e1 from (EXEC pm1.sq1()) as x", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT e1 FROM (EXEC pm1.sq1()) AS x");
    }

    public void testStoredQuerySubquery2() throws Exception {
        this.helpTestOptimize("select x.e1 from (EXEC pm1.sq1()) as x WHERE x.e2 = 3", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT e1 FROM (EXEC pm1.sq1()) AS x WHERE e2 = 3");
    }

    public void testStoredQuerySubquery3() throws Exception {
        HashMap externalMetadata = new HashMap();
        GroupSymbol gs = new GroupSymbol("SYSTEM.DESCRIBE");
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>(2);
        elements.add(new ElementSymbol("SYSTEM.DESCRIBE.entity"));
        externalMetadata.put(gs, elements);
        this.helpTestOptimize("select nvl(entities.entityType, '') as Description from (SELECT 'Model' AS entityType, pm1.g1.e1 AS entityName FROM pm1.g1 UNION ALL SELECT 'Group', pm1.g2.e1 FROM pm1.g2) as entities WHERE ucase(entities.entityName) = ucase(SYSTEM.DESCRIBE.entity)", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT nvl(entityType, '') AS Description FROM (SELECT 'Model' AS entityType, e1 AS entityName FROM pm1.g1 UNION ALL SELECT 'Group', e1 FROM pm1.g2) AS entities WHERE ucase(entityName) = ucase(entity)", externalMetadata);
    }

    public void testOptimizeOrderBy() throws Exception {
        this.helpTestOptimize("SELECT pm1.g1.e1 FROM pm1.g1 order by pm1.g1.e1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT e1 FROM pm1.g1 ORDER BY e1");
    }

    public void testOptimizeOrderBy1() throws Exception {
        this.helpTestFullyQualify("SELECT e1 FROM pm1.g1 order by e1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT pm1.g1.e1 FROM pm1.g1 ORDER BY e1");
    }

    public void testOptimizeOrderByWithoutGroup() throws Exception {
        this.helpTestOptimize("SELECT pm1.g1.e1, count(*) as x FROM pm1.g1 order by x", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT e1, COUNT(*) AS x FROM pm1.g1 ORDER BY x");
    }
}

