/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.util;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.core.TeiidException;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.util.UpdateProcedureGenerator;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.unittest.FakeMetadataObject;
import org.teiid.query.unittest.FakeMetadataStore;

public class TestUpdateProcedureGenerator
extends TestCase {
    public TestUpdateProcedureGenerator(String name) {
        super(name);
    }

    private void helpTest(int procedureType, String vGroup, String sql, QueryMetadataInterface md, String expectedProc) {
        try {
            Command command = QueryParser.getQueryParser().parseCommand(sql);
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)md);
            CreateUpdateProcedureCommand actualProc = UpdateProcedureGenerator.createProcedure((int)procedureType, (String)vGroup, (Command)command, (QueryMetadataInterface)md);
            if (expectedProc == null) {
                TestUpdateProcedureGenerator.assertNull((Object)actualProc);
            } else {
                TestUpdateProcedureGenerator.assertNotNull((Object)actualProc);
                TestUpdateProcedureGenerator.assertEquals((String)"Didn't get expected generated procedure", (String)expectedProc, (String)actualProc.toString());
                QueryParser.getQueryParser().parseCommand(actualProc.toString());
            }
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
    }

    public static FakeMetadataFacade example1() {
        return TestUpdateProcedureGenerator.example1(true);
    }

    public static FakeMetadataFacade example1(boolean allUpdatable) {
        FakeMetadataObject pm1 = FakeMetadataFactory.createPhysicalModel("pm1");
        FakeMetadataObject vm1 = FakeMetadataFactory.createVirtualModel("vm1");
        FakeMetadataObject pm1g1 = FakeMetadataFactory.createPhysicalGroup("pm1.g1", pm1);
        FakeMetadataObject pm1g2 = FakeMetadataFactory.createPhysicalGroup("pm1.g2", pm1);
        FakeMetadataObject pm1g3 = FakeMetadataFactory.createPhysicalGroup("pm1.g3", pm1);
        List<FakeMetadataObject> pm1g1e = FakeMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        if (!allUpdatable) {
            pm1g1e.get(0).putProperty("supUpdate", Boolean.FALSE);
        }
        List<FakeMetadataObject> pm1g2e = FakeMetadataFactory.createElements(pm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g3e = FakeMetadataFactory.createElements(pm1g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        pm1g3e.get(0).putProperty("supNull", Boolean.FALSE);
        pm1g3e.get(0).putProperty("supDefaultvalue", null);
        pm1g3e.get(1).putProperty("supNull", Boolean.FALSE);
        pm1g3e.get(1).putProperty("supAutoIncrement", Boolean.TRUE);
        pm1g3e.get(1).putProperty("supDefaultvalue", null);
        pm1g3e.get(2).putProperty("supNull", Boolean.FALSE);
        pm1g3e.get(2).putProperty("supDefaultvalue", "xyz");
        QueryNode vm1g1n1 = new QueryNode("vm1.g1", "SELECT e1 as a, e2 FROM pm1.g1 WHERE e3 > 5");
        FakeMetadataObject vm1g1 = FakeMetadataFactory.createUpdatableVirtualGroup("vm1.g1", vm1, vm1g1n1);
        QueryNode vm1g2n1 = new QueryNode("vm1.g2", "SELECT e1, e2, e3, e4 FROM pm1.g2 WHERE e3 > 5");
        FakeMetadataObject vm1g2 = FakeMetadataFactory.createUpdatableVirtualGroup("vm1.g2", vm1, vm1g2n1);
        QueryNode vm1g3n1 = new QueryNode("vm1.g3", "SELECT e1, e3 FROM pm1.g3");
        FakeMetadataObject vm1g3 = FakeMetadataFactory.createUpdatableVirtualGroup("vm1.g3", vm1, vm1g3n1);
        QueryNode vm1g4n1 = new QueryNode("vm1.g4", "SELECT e1, e2 FROM pm1.g3");
        FakeMetadataObject vm1g4 = FakeMetadataFactory.createUpdatableVirtualGroup("vm1.g4", vm1, vm1g4n1);
        QueryNode vm1g5n1 = new QueryNode("vm1.g5", "SELECT e2, e3 FROM pm1.g3");
        FakeMetadataObject vm1g5 = FakeMetadataFactory.createUpdatableVirtualGroup("vm1.g5", vm1, vm1g5n1);
        List<FakeMetadataObject> vm1g1e = FakeMetadataFactory.createElements(vm1g1, new String[]{"a", "e2"}, new String[]{"string", "integer"});
        List<FakeMetadataObject> vm1g2e = FakeMetadataFactory.createElements(vm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g3e = FakeMetadataFactory.createElements(vm1g3, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        List<FakeMetadataObject> vm1g4e = FakeMetadataFactory.createElements(vm1g4, new String[]{"e1", "e3"}, new String[]{"string", "boolean"});
        List<FakeMetadataObject> vm1g5e = FakeMetadataFactory.createElements(vm1g5, new String[]{"e2", "e3"}, new String[]{"integer", "boolean"});
        FakeMetadataObject rs1 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject rs1p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs1);
        QueryNode sq1n1 = new QueryNode("pm1.sq1", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1; END");
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs1p1), sq1n1);
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(pm1);
        store.addObject(pm1g1);
        store.addObjects(pm1g1e);
        store.addObject(pm1g2);
        store.addObjects(pm1g2e);
        store.addObject(pm1g3);
        store.addObjects(pm1g3e);
        store.addObject(vm1);
        store.addObject(vm1g1);
        store.addObjects(vm1g1e);
        store.addObject(vm1g2);
        store.addObjects(vm1g2e);
        store.addObject(vm1g3);
        store.addObjects(vm1g3e);
        store.addObject(vm1g4);
        store.addObjects(vm1g4e);
        store.addObject(vm1g5);
        store.addObjects(vm1g5e);
        store.addObject(rs1);
        store.addObject(sq1);
        return new FakeMetadataFacade(store);
    }

    public void testCreateInsertCommand() {
        this.helpTest(1, "vm1.g1", "select e1 as a, e2 from pm1.g1 where e4 > 5", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), "CREATE PROCEDURE\nBEGIN\nINSERT INTO pm1.g1 (pm1.g1.e1, pm1.g1.e2) VALUES (INPUTS.a, INPUTS.e2);\nROWS_UPDATED = VARIABLES.ROWCOUNT;\nEND");
    }

    public void testCreateInsertCommand2() {
        this.helpTest(1, "vm1.g1", "select e1 as a, 5 from pm1.g1 where e4 > 5", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), "CREATE PROCEDURE\nBEGIN\nINSERT INTO pm1.g1 (pm1.g1.e1) VALUES (INPUTS.a);\nROWS_UPDATED = VARIABLES.ROWCOUNT;\nEND");
    }

    public void testCreateInsertCommand3() {
        this.helpTest(1, "vm1.g2", "select * from pm1.g2 where e4 > 5", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), "CREATE PROCEDURE\nBEGIN\nINSERT INTO pm1.g2 (pm1.g2.e1, pm1.g2.e2, pm1.g2.e3, pm1.g2.e4) VALUES (INPUTS.e1, INPUTS.e2, INPUTS.e3, INPUTS.e4);\nROWS_UPDATED = VARIABLES.ROWCOUNT;\nEND");
    }

    public void testCreateInsertCommand4() {
        this.helpTest(1, "vm1.g2", "select * from pm1.g2 as g_alias", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), "CREATE PROCEDURE\nBEGIN\nINSERT INTO pm1.g2 (pm1.g2.e1, pm1.g2.e2, pm1.g2.e3, pm1.g2.e4) VALUES (INPUTS.e1, INPUTS.e2, INPUTS.e3, INPUTS.e4);\nROWS_UPDATED = VARIABLES.ROWCOUNT;\nEND");
    }

    public void testCreateInsertCommand5() {
        this.helpTest(1, "vm1.g1", "select e1 as a, e2 from pm1.g1 as g_alias where e4 > 5", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), "CREATE PROCEDURE\nBEGIN\nINSERT INTO pm1.g1 (pm1.g1.e1, pm1.g1.e2) VALUES (INPUTS.a, INPUTS.e2);\nROWS_UPDATED = VARIABLES.ROWCOUNT;\nEND");
    }

    public void testCreateUpdateCommand() {
        this.helpTest(2, "vm1.g1", "select e1 as a, e2 from pm1.g1 where e4 > 5", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), "CREATE PROCEDURE\nBEGIN\nUPDATE pm1.g1 SET e1 = INPUTS.a, e2 = INPUTS.e2 WHERE TRANSLATE CRITERIA;\nROWS_UPDATED = VARIABLES.ROWCOUNT;\nEND");
    }

    public void testCreateDeleteCommand() {
        this.helpTest(3, "vm1.g1", "select e1 as a, e2 from pm1.g1 where e4 > 5", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), "CREATE PROCEDURE\nBEGIN\nDELETE FROM pm1.g1 WHERE TRANSLATE CRITERIA;\nROWS_UPDATED = VARIABLES.ROWCOUNT;\nEND");
    }

    public void testCreateInsertCommand1_fail() {
        this.helpTest(1, "vm1.g1", "SELECT pm1.g1.e1 FROM pm1.g1, pm1.g2", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), null);
    }

    public void testCreateInsertCommand2_fail() {
        this.helpTest(1, "vm1.g1", "SELECT CONCAT(pm1.g1.e1, convert(pm1.g2.e1, string)) as x FROM pm1.g1, pm1.g2", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), null);
    }

    public void testCreateInsertCommand3_fail() {
        this.helpTest(1, "vm1.g1", "SELECT e1 FROM pm1.g1 UNION SELECT e1 FROM pm1.g2", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), null);
    }

    public void testCreateInsertCommand4_fail() {
        this.helpTest(1, "vm1.g1", "SELECT COUNT(*) FROM pm1.g1", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), null);
    }

    public void testCreateInsertCommand5_fail() {
        this.helpTest(1, "vm1.g1", "SELECT * FROM pm1.g1 GROUP BY e1", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), null);
    }

    public void testCreateInsertCommand6_fail() {
        this.helpTest(1, "vm1.g1", "EXEC pm1.sq1()", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), null);
    }

    public void testCreateInsertCommand7_fail() {
        this.helpTest(1, "vm1.g1", "INSERT INTO pm1.g1 (e1) VALUES ('x')", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), null);
    }

    public void testCreateInsertCommand8_fail() {
        this.helpTest(1, "vm1.g1", "UPDATE pm1.g1 SET e1='x'", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), null);
    }

    public void testCreateInsertCommand9_fail() {
        this.helpTest(1, "vm1.g1", "DELETE FROM pm1.g1", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), null);
    }

    public void testCreateInsertCommand10_fail() {
        this.helpTest(1, "vm1.g1", "SELECT COUNT(*) FROM pm1.g1", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), null);
    }

    public void testCreateInsertCommand11_fail() {
        this.helpTest(1, "vm1.g1", "SELECT COUNT(e1) as x FROM pm1.g1", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), null);
    }

    public void testCreateInsertCommand12_fail() {
        this.helpTest(1, "vm1.g1", "SELECT * FROM (EXEC pm1.sq1()) AS a", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), null);
    }

    public void testCreateInsertCommand13_fail() {
        this.helpTest(1, "vm1.g1", "SELECT 1", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), null);
    }

    public void testRequiredElements1() {
        this.helpTest(1, "vm1.g3", "SELECT e1, e2 FROM pm1.g3", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), "CREATE PROCEDURE\nBEGIN\nINSERT INTO pm1.g3 (pm1.g3.e1, pm1.g3.e2) VALUES (INPUTS.e1, INPUTS.e2);\nROWS_UPDATED = VARIABLES.ROWCOUNT;\nEND");
    }

    public void testRequiredElements2() {
        this.helpTest(1, "vm1.g4", "SELECT e1, e3 FROM pm1.g3", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), "CREATE PROCEDURE\nBEGIN\nINSERT INTO pm1.g3 (pm1.g3.e1, pm1.g3.e3) VALUES (INPUTS.e1, INPUTS.e3);\nROWS_UPDATED = VARIABLES.ROWCOUNT;\nEND");
    }

    public void testRequiredElements3() {
        this.helpTest(1, "vm1.g5", "SELECT e2, e3 FROM pm1.g3", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(), null);
    }

    public void testNonUpdateableElements() {
        this.helpTest(2, "vm1.g1", "select e1 as a, e2 from pm1.g1 where e4 > 5", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(false), "CREATE PROCEDURE\nBEGIN\nUPDATE pm1.g1 SET e2 = INPUTS.e2 WHERE TRANSLATE CRITERIA;\nROWS_UPDATED = VARIABLES.ROWCOUNT;\nEND");
    }

    public void testNonUpdateableElements2() {
        this.helpTest(1, "vm1.g1", "SELECT e1, e2 FROM pm1.g1", (QueryMetadataInterface)TestUpdateProcedureGenerator.example1(false), "CREATE PROCEDURE\nBEGIN\nINSERT INTO pm1.g1 (pm1.g1.e2) VALUES (INPUTS.e2);\nROWS_UPDATED = VARIABLES.ROWCOUNT;\nEND");
    }
}

