/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;

public class TestAggregateSymbolCollectorVisitor
extends TestCase {
    public TestAggregateSymbolCollectorVisitor(String name) {
        super(name);
    }

    public void helpTestCollectAggregates(String sql, String[] aggs, String[] elems) throws QueryParserException {
        int i;
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        ArrayList foundAggs = new ArrayList();
        ArrayList foundElements = new ArrayList();
        AggregateSymbolCollectorVisitor.getAggregates((LanguageObject)command, foundAggs, foundElements);
        TestAggregateSymbolCollectorVisitor.assertEquals((String)("Incorrect number of aggregates: " + foundAggs), (int)aggs.length, (int)foundAggs.size());
        for (i = 0; i < aggs.length; ++i) {
            TestAggregateSymbolCollectorVisitor.assertEquals((String)("Incorrect agg match at " + i), (String)aggs[i], (String)((SingleElementSymbol)foundAggs.get(i)).toString());
        }
        TestAggregateSymbolCollectorVisitor.assertEquals((String)("Incorrect number of elements: " + foundElements), (int)elems.length, (int)foundElements.size());
        for (i = 0; i < elems.length; ++i) {
            TestAggregateSymbolCollectorVisitor.assertEquals((String)("Incorrect agg match at " + i), (String)elems[i], (String)((SingleElementSymbol)foundElements.get(i)).toString());
        }
    }

    public void testCollectAggs1() throws QueryParserException {
        this.helpTestCollectAggregates("SELECT COUNT(*) FROM pm1.g1", new String[]{"COUNT(*)"}, new String[0]);
    }

    public void testCollectAggs2() throws QueryParserException {
        this.helpTestCollectAggregates("SELECT * FROM pm1.g1 HAVING MAX(e2) > 0", new String[]{"MAX(e2)"}, new String[0]);
    }

    public void testCollectAggs3() throws QueryParserException {
        this.helpTestCollectAggregates("SELECT COUNT(e1), MAX(DISTINCT e1) FROM pm1.g1 GROUP BY e1 HAVING MAX(e2) > 0 AND NOT MIN(e2) < 100", new String[]{"COUNT(e1)", "MAX(DISTINCT e1)", "MAX(e2)", "MIN(e2)"}, new String[]{"e1"});
    }

    public void testCollectAggs4() throws QueryParserException {
        this.helpTestCollectAggregates("SELECT e1 FROM pm1.g1 GROUP BY e1 HAVING MAX(e2) > 0 AND NOT MIN(e2) < 100 AND e3 < 200", new String[]{"MAX(e2)", "MIN(e2)"}, new String[]{"e1", "e1", "e3"});
    }
}

