/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.client;

import java.sql.SQLException;
import java.sql.Statement;
import org.teiid.test.client.ExpectedResults;
import org.teiid.test.client.QuerySQL;
import org.teiid.test.client.QueryScenario;
import org.teiid.test.client.QueryTest;
import org.teiid.test.client.TestResultsSummary;
import org.teiid.test.client.results.TestResultStat;
import org.teiid.test.framework.TestLogger;
import org.teiid.test.framework.exception.QueryTestFailedException;
import org.teiid.test.framework.exception.TransactionRuntimeException;
import org.teiid.test.framework.query.AbstractQueryTransactionTest;

public class TestClientTransaction
extends AbstractQueryTransactionTest {
    private QueryScenario querySet = null;
    private ExpectedResults expectedResults = null;
    private QueryTest query = null;
    private long endTS = 0L;
    private long beginTS = 0L;
    private int testStatus = 0;
    private boolean errorExpected = false;
    private String sql = null;
    private boolean resultFromQuery = false;
    private TestResultsSummary testResultsSummary;

    public TestClientTransaction(QueryScenario querySet) {
        super(querySet.getQueryScenarioIdentifier());
        this.querySet = querySet;
    }

    public void init(TestResultsSummary testResultsSummary, ExpectedResults expectedResults, QueryTest query) {
        this.query = query;
        this.testResultsSummary = testResultsSummary;
        this.expectedResults = expectedResults;
        this.endTS = 0L;
        this.beginTS = 0L;
        this.testStatus = 0;
        this.errorExpected = false;
        this.resultFromQuery = false;
    }

    @Override
    public String getTestName() {
        return this.query.getQueryScenarioID() + ":" + (this.query.getQueryID() != null ? this.query.getQueryID() : "NA");
    }

    @Override
    public void before() {
        super.before();
        try {
            this.errorExpected = this.expectedResults.isExceptionExpected(this.query.getQueryID());
        }
        catch (QueryTestFailedException e) {
            throw new TransactionRuntimeException("ProgramError: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testCase() throws Exception {
        TestLogger.logDebug("expected error: " + this.errorExpected);
        TestLogger.logDebug("ID: " + this.query.geQuerySetID() + "-" + this.query.getQueryID());
        QuerySQL[] queries = this.query.getQueries();
        int l = queries.length;
        try {
            this.beginTS = System.currentTimeMillis();
            for (int i = 0; i < l; ++i) {
                QuerySQL qsql = queries[i];
                this.sql = qsql.getSql();
                this.resultFromQuery = this.execute(this.sql, qsql.getParms());
                if (qsql.getUpdateCnt() >= 0) {
                    this.assertUpdateCount(qsql.getUpdateCnt());
                    continue;
                }
                if (qsql.getRowCnt() < 0) continue;
                this.assertRowCount(qsql.getRowCnt());
            }
        }
        catch (Throwable t) {
            this.setApplicationException(t);
        }
        finally {
            this.endTS = System.currentTimeMillis();
        }
    }

    @Override
    public void after() {
        super.after();
        TestResultStat rs = null;
        Throwable resultException = null;
        Throwable throwable = resultException = this.getLastException() != null ? this.getLastException() : this.getApplicationException();
        if (resultException != null) {
            this.testStatus = this.exceptionExpected() ? 4 : 1;
        }
        rs = new TestResultStat(this.query.geQuerySetID(), this.query.getQueryID(), this.sql, this.testStatus, this.beginTS, this.endTS, resultException, null);
        System.out.println("ADD THE TEST RESULT");
        this.testResultsSummary.addTestResult(this.query.geQuerySetID(), rs);
        this.querySet.handleTestResult(rs, this.internalResultSet, this.updateCount, this.resultFromQuery, this.sql);
    }

    protected Statement createStatement() throws SQLException {
        return this.internalConnection.createStatement(1004, 1007);
    }

    @Override
    public boolean exceptionExpected() {
        return this.errorExpected;
    }

    @Override
    public void cleanup() {
    }
}

