/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.client.ctc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.JDOMException;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.test.client.ClassFactory;
import org.teiid.test.client.ExpectedResults;
import org.teiid.test.client.QueryScenario;
import org.teiid.test.client.QueryTest;
import org.teiid.test.client.ResultsGenerator;
import org.teiid.test.client.ctc.ListNestedSortComparator;
import org.teiid.test.client.ctc.ResultsHolder;
import org.teiid.test.client.ctc.XMLQueryVisitationStrategy;
import org.teiid.test.framework.ConfigPropertyLoader;
import org.teiid.test.framework.TestLogger;
import org.teiid.test.framework.exception.QueryTestFailedException;

public class XMLExpectedResults
implements ExpectedResults {
    protected Properties props;
    protected String resultMode = "none";
    protected String generateDir = null;
    protected String querySetIdentifier = null;
    protected String results_dir_loc = null;
    protected Map<String, ResultsHolder> loadedResults = new HashMap<String, ResultsHolder>();
    private static final int MISMATCH_OFFSET = 20;
    private static final int MAX_MESSAGE_SIZE = 50;

    public XMLExpectedResults(String querySetIdentifier, Properties properties) {
        this.props = properties;
        this.querySetIdentifier = querySetIdentifier;
        this.results_dir_loc = this.props.getProperty("results.loc", "");
        String expected_root_loc = this.props.getProperty("results.root.dir");
        if (expected_root_loc != null) {
            File dir = new File(expected_root_loc, this.results_dir_loc);
            this.results_dir_loc = dir.getAbsolutePath();
        }
        this.validateResultsMode(this.props);
        TestLogger.logInfo("Expected results loc: " + this.results_dir_loc);
    }

    protected void validateResultsMode(Properties props) {
        String resultModeStr = props.getProperty("resultmode", "");
        if (resultModeStr.equalsIgnoreCase("none") || resultModeStr.equalsIgnoreCase("compare") || resultModeStr.equalsIgnoreCase("generate")) {
            this.resultMode = resultModeStr;
        }
        TestLogger.log("\nResults mode: " + this.resultMode);
    }

    @Override
    public boolean isExceptionExpected(String queryidentifier) throws QueryTestFailedException {
        if (this.resultMode.equalsIgnoreCase("compare")) {
            ResultsHolder expectedResults = this.getResults(queryidentifier);
            return expectedResults.getExceptionMsg() != null;
        }
        return false;
    }

    @Override
    public String getQuerySetID() {
        return this.querySetIdentifier;
    }

    @Override
    public synchronized File getResultsFile(String queryidentifier) throws QueryTestFailedException {
        return this.findExpectedResultsFile(queryidentifier, this.querySetIdentifier);
    }

    private ResultsHolder getResults(String queryidentifier) throws QueryTestFailedException {
        ResultsHolder rh = null;
        rh = !this.loadedResults.containsKey(queryidentifier) ? this.loadExpectedResults(this.findExpectedResultsFile(queryidentifier, this.querySetIdentifier)) : this.loadedResults.get(queryidentifier);
        return rh;
    }

    @Override
    public Object compareResults(String queryIdentifier, String sql, ResultSet resultSet, Throwable actualException, int testStatus, boolean isOrdered, int batchSize, boolean resultFromQuery) throws QueryTestFailedException {
        String eMsg = "CompareResults Error: ";
        ResultsHolder expectedResults = this.getResults(queryIdentifier);
        switch (testStatus) {
            case 1: {
                throw new QueryTestFailedException("CompareResults Error: Test resulted in unexpected exception " + actualException.getMessage());
            }
            case 4: {
                if (!expectedResults.isException()) {
                    throw new QueryTestFailedException("CompareResults Error: The actual result was an exception, but the Expected results wasn't an exception.  Actual exception: '" + actualException.getMessage() + "'");
                }
                ResultsHolder actualResults = new ResultsHolder("exception");
                actualResults.setQueryID(expectedResults.getQueryID());
                actualResults = this.convertException(actualException, actualResults);
                this.compareExceptions(actualResults, expectedResults, "CompareResults Error: ");
                break;
            }
            default: {
                ResultsHolder actualResults = new ResultsHolder("queryResults");
                actualResults.setQueryID(expectedResults.getQueryID());
                if (expectedResults.getRows().size() > 0) {
                    this.convertResults(resultSet, batchSize, actualResults);
                    this.compareResults(actualResults, expectedResults, "CompareResults Error: ", isOrdered);
                    break;
                }
                if (actualResults.getRows() == null || actualResults.getRows().size() <= 0) break;
                throw new QueryTestFailedException("CompareResults Error: Expected results indicated no results, but actual shows " + actualResults.getRows().size() + " rows.");
            }
        }
        return null;
    }

    private ResultsHolder convertException(Throwable actualException, ResultsHolder actualResults) {
        actualResults.setExceptionClassName(actualException.getClass().getName());
        actualResults.setExceptionMsg(actualException.getMessage());
        return actualResults;
    }

    private final long convertResults(ResultSet results, int batchSize, ResultsHolder resultsHolder) throws QueryTestFailedException {
        int colCount;
        long firstBatchResponseTime = 0L;
        ArrayList records = new ArrayList();
        ArrayList<String> columnTypeNames = new ArrayList<String>();
        ArrayList<String> columnTypes = new ArrayList<String>();
        try {
            ResultSetMetaData rsMetadata = results.getMetaData();
            colCount = rsMetadata.getColumnCount();
            for (int col = 1; col <= colCount; ++col) {
                columnTypeNames.add(rsMetadata.getColumnName(col));
                columnTypes.add(rsMetadata.getColumnTypeName(col));
            }
        }
        catch (SQLException qre) {
            throw new QueryTestFailedException("Can't get results metadata: " + qre.getMessage());
        }
        try {
            int row = 0;
            while (results.next()) {
                ArrayList<Object> currentRecord = new ArrayList<Object>(colCount);
                for (int col = 1; col <= colCount; ++col) {
                    currentRecord.add(results.getObject(col));
                }
                records.add(currentRecord);
                if (row == batchSize) {
                    firstBatchResponseTime = System.currentTimeMillis();
                }
                ++row;
            }
        }
        catch (SQLException qre) {
            throw new QueryTestFailedException("Can't get results: " + qre.getMessage());
        }
        resultsHolder.setRows(records);
        resultsHolder.setIdentifiers(columnTypeNames);
        resultsHolder.setTypes(columnTypes);
        return firstBatchResponseTime;
    }

    protected void compareResults(ResultsHolder actualResults, ResultsHolder expectedResults, String eMsg, boolean isOrdered) throws QueryTestFailedException {
        if (!isOrdered && actualResults.hasRows() && expectedResults.hasRows()) {
            List actualRows = actualResults.getRows();
            XMLExpectedResults.sortRecords(actualRows, true);
            actualResults.setRows(actualRows);
            List expectedRows = expectedResults.getRows();
            XMLExpectedResults.sortRecords(expectedRows, true);
            expectedResults.setRows(expectedRows);
        }
        this.compareResultSets(actualResults.getRows(), actualResults.getTypes(), actualResults.getIdentifiers(), expectedResults.getRows(), expectedResults.getTypes(), expectedResults.getIdentifiers(), eMsg);
    }

    private static void sortRecords(List records, boolean ascending) {
        if (records.size() != 0) {
            int nFields = ((List)records.get(0)).size();
            for (int k = 0; k < nFields; ++k) {
                for (int m = k; m < nFields; ++m) {
                    int[] params = new int[m - k + 1];
                    int n = k;
                    int j = 0;
                    while (n <= m) {
                        params[j] = n++;
                        ++j;
                    }
                    Collections.sort(records, new ListNestedSortComparator(params, ascending));
                }
            }
        }
    }

    private void compareExceptions(ResultsHolder actualResults, ResultsHolder expectedResults, String eMsg) throws QueryTestFailedException {
        String expectedExceptionClass = expectedResults.getExceptionClassName();
        String expectedExceptionMsg = expectedResults.getExceptionMsg().toLowerCase();
        String actualExceptionClass = actualResults.getExceptionClassName();
        String actualExceptionMsg = actualResults.getExceptionMsg().toLowerCase();
        if (actualExceptionClass == null) {
            throw new QueryTestFailedException(eMsg + "Expected exception: " + expectedExceptionClass + " but got none.");
        }
        if (!expectedExceptionClass.equals(actualExceptionClass)) {
            throw new QueryTestFailedException(eMsg + "Got wrong exception, expected \"" + expectedExceptionClass + "\" but got \"" + actualExceptionClass + "\"");
        }
        if (!expectedExceptionMsg.equals(actualExceptionMsg) && !this.compareStrTokens(expectedExceptionMsg, actualExceptionMsg)) {
            throw new QueryTestFailedException(eMsg + "Got expected exception but with wrong message. Got " + actualExceptionMsg);
        }
    }

    private boolean compareStrTokens(String expectedStr, String gotStr) {
        String newline = System.getProperty("line.separator");
        List expectedTokens = StringUtil.split((String)expectedStr, (String)newline);
        List gotTokens = StringUtil.split((String)gotStr, (String)newline);
        for (int i = 0; i < expectedTokens.size(); ++i) {
            String got;
            String expected = (String)expectedTokens.get(i);
            if (expected.equals(got = (String)gotTokens.get(i))) continue;
            return false;
        }
        return true;
    }

    protected void compareResultSets(List actualResults, List actualDatatypes, List actualIdentifiers, List expectedResults, List expectedDatatypes, List expectedIdentifiers, String eMsg) throws QueryTestFailedException {
        this.compareIdentifiers(actualIdentifiers, expectedIdentifiers, actualDatatypes, expectedDatatypes);
        int actualRowCount = actualResults.size();
        int expectedRowCount = expectedResults.size();
        int actualColumnCount = actualIdentifiers.size();
        if (actualRowCount < expectedRowCount) {
            throw new QueryTestFailedException(eMsg + "Expected " + expectedRowCount + " records but received only " + actualRowCount);
        }
        if (actualRowCount > expectedRowCount) {
            throw new QueryTestFailedException(eMsg + "Expected " + expectedRowCount + " records but received " + actualRowCount);
        }
        for (int row = 0; row < actualRowCount; ++row) {
            List actualRecord = (List)actualResults.get(row);
            List expectedRecord = (List)expectedResults.get(row);
            for (int col = 0; col < actualColumnCount; ++col) {
                Object actualValue = actualRecord.get(col);
                Object expectedValue = expectedRecord.get(col);
                if (expectedValue == null && actualValue != null || actualValue == null && expectedValue != null) {
                    throw new QueryTestFailedException(eMsg + "Value mismatch at row " + (row + 1) + " and column " + (col + 1) + ": expected = [" + (expectedValue != null ? expectedValue : "null") + "], actual = [" + (actualValue != null ? actualValue : "null") + "]");
                }
                if (actualValue instanceof Blob || actualValue instanceof Clob || actualValue instanceof SQLXML) {
                    if (actualValue instanceof Clob) {
                        Clob c = (Clob)actualValue;
                        try {
                            actualValue = ObjectConverterUtil.convertToString((InputStream)c.getAsciiStream());
                        }
                        catch (Throwable e) {
                            throw new QueryTestFailedException(e);
                        }
                    }
                    if (actualValue instanceof Blob) {
                        Blob b = (Blob)actualValue;
                        try {
                            actualValue = ObjectConverterUtil.convertToString((InputStream)b.getBinaryStream());
                        }
                        catch (Throwable e) {
                            throw new QueryTestFailedException(e);
                        }
                    }
                    if (actualValue instanceof SQLXML) {
                        SQLXML s = (SQLXML)actualValue;
                        try {
                            actualValue = ObjectConverterUtil.convertToString((InputStream)s.getBinaryStream());
                        }
                        catch (Throwable e) {
                            throw new QueryTestFailedException(e);
                        }
                    }
                    if (!(expectedValue instanceof String)) {
                        expectedValue = expectedValue.toString();
                    }
                }
                if (expectedValue.equals(actualValue)) continue;
                if (expectedValue instanceof String) {
                    String expectedString = (String)expectedValue;
                    if (!(actualValue instanceof String)) {
                        throw new QueryTestFailedException(eMsg + "Value mismatch at row " + (row + 1) + " and column " + (col + 1) + ": expected = [" + expectedValue + "], actual = [" + actualValue + "]");
                    }
                    if (expectedString.length() <= 0) continue;
                    this.assertStringsMatch(expectedString, (String)actualValue, row + 1, col + 1, eMsg);
                    continue;
                }
                throw new QueryTestFailedException(eMsg + "Value mismatch at row " + (row + 1) + " and column " + (col + 1) + ": expected = [" + expectedValue + "], actual = [" + actualValue + "]");
            }
        }
    }

    protected void compareIdentifiers(List actualIdentifiers, List expectedIdentifiers, List actualDataTypes, List expectedDatatypes) throws QueryTestFailedException {
        if (expectedIdentifiers.size() != actualIdentifiers.size()) {
            throw new QueryTestFailedException("Got incorrect number of columns, expected = " + expectedIdentifiers.size() + ", actual = " + actualIdentifiers.size());
        }
        for (int i = 0; i < actualIdentifiers.size(); ++i) {
            String actualIdent = (String)actualIdentifiers.get(i);
            String expectedIdent = (String)expectedIdentifiers.get(i);
            String actualType = (String)actualDataTypes.get(i);
            String expectedType = (String)expectedDatatypes.get(i);
            String actualShort = this.getShortName(actualIdent);
            String expectedShort = this.getShortName(expectedIdent);
            if (!expectedShort.equalsIgnoreCase(actualShort)) {
                throw new QueryTestFailedException("Got incorrect column name at column " + i + ", expected = " + expectedShort + " but got = " + actualShort);
            }
            if (actualType.equalsIgnoreCase("xml")) {
                actualType = "string";
            }
            if (actualType.equalsIgnoreCase("clob")) {
                actualType = "string";
            }
            if (expectedType.equalsIgnoreCase(actualType)) continue;
            throw new QueryTestFailedException("Got incorrect column type at column " + i + ", expected = " + expectedType + " but got = " + actualType);
        }
    }

    protected String getShortName(String ident) {
        int index = ident.lastIndexOf(".");
        if (index >= 0) {
            return ident.substring(index + 1);
        }
        return ident;
    }

    protected void assertStringsMatch(String expectedStr, String actualStr, int row, int col, String eMsg) throws QueryTestFailedException {
        String expected = this.stripCR(expectedStr).trim();
        String actual = this.stripCR(actualStr).trim();
        String locationText = "";
        int mismatchIndex = -1;
        boolean isequal = Arrays.equals(expected.toCharArray(), actual.toCharArray());
        if (!isequal) {
            if (expected != null && actual != null) {
                int shortestStringLength = expected.length();
                if (actual.length() < expected.length()) {
                    shortestStringLength = actual.length();
                }
                for (int i = 0; i < shortestStringLength; ++i) {
                    if (expected.charAt(i) == actual.charAt(i)) continue;
                    locationText = "  Strings do not match at character: " + (i + 1) + ". Expected [" + expected.charAt(i) + "] but got [" + actual.charAt(i) + "]";
                    mismatchIndex = i;
                    break;
                }
            }
            String expectedPartOfMessage = expected;
            String actualPartOfMessage = actual;
            if (expected.length() + actual.length() > 50) {
                expectedPartOfMessage = this.safeSubString(expected, mismatchIndex - 20, mismatchIndex + 20);
                actualPartOfMessage = this.safeSubString(actual, mismatchIndex - 20, mismatchIndex + 20);
            }
            String message = eMsg + "Value mismatch at row " + row + " and column " + col + ". Expected: {0} but was: {1}" + locationText;
            message = MessageFormat.format(message, expectedPartOfMessage, actualPartOfMessage);
            throw new QueryTestFailedException(message);
        }
    }

    private String safeSubString(String text, int startIndex, int endIndex) {
        int actualEndIndex;
        String prefix = "...'";
        String suffix = "'...";
        int actualStartIndex = startIndex;
        if (actualStartIndex < 0) {
            actualStartIndex = 0;
            prefix = "'";
        }
        if ((actualEndIndex = endIndex) > text.length() - 1 && (actualEndIndex = text.length() - 1) < 0) {
            actualEndIndex = 0;
        }
        if (actualEndIndex == text.length() - 1 || text.length() == 0) {
            suffix = "'";
        }
        return prefix + text.substring(actualStartIndex, actualEndIndex) + suffix;
    }

    private String stripCR(String text) {
        if (text.indexOf(13) >= 0) {
            StringBuffer stripped = new StringBuffer(text.length());
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                char current = text.charAt(i);
                if (current == '\r') continue;
                stripped.append(current);
            }
            return stripped.toString();
        }
        return text;
    }

    @Override
    public Object getMetaData(String queryidentifier) {
        return null;
    }

    private ResultsHolder loadExpectedResults(File resultsFile) throws QueryTestFailedException {
        ResultsHolder expectedResult;
        XMLQueryVisitationStrategy jstrat = new XMLQueryVisitationStrategy();
        try {
            expectedResult = jstrat.parseXMLResultsFile(resultsFile);
        }
        catch (IOException e) {
            throw new QueryTestFailedException("Unable to load expected results: " + e.getMessage());
        }
        catch (JDOMException e) {
            throw new QueryTestFailedException("Unable to load expected results: " + e.getMessage());
        }
        return expectedResult;
    }

    private File findExpectedResultsFile(String queryIdentifier, String querySetIdentifier) throws QueryTestFailedException {
        String resultFileName = queryIdentifier + ".xml";
        File file = new File(this.results_dir_loc + "/" + querySetIdentifier, resultFileName);
        if (!file.exists()) {
            throw new QueryTestFailedException("Query results file " + file.getAbsolutePath() + " cannot be found");
        }
        return file;
    }

    public static void main(String[] args) {
        System.setProperty("config", "ctc-bqt-test.properties");
        ConfigPropertyLoader _instance = ConfigPropertyLoader.getInstance();
        Properties p = _instance.getProperties();
        if (p == null || p.isEmpty()) {
            throw new RuntimeException("Failed to load config properties file");
        }
        QueryScenario set = ClassFactory.createQueryScenario("testscenario");
        _instance.setProperty("queryfiles.root.dir", new File("src/main/resources/").getAbsolutePath());
        try {
            for (String querySetID : set.getQuerySetIDs()) {
                List<QueryTest> queries = set.getQueries(querySetID);
                if ((long)queries.size() == 0L) {
                    System.out.println("Failed, didn't load any queries ");
                }
                ExpectedResults er = set.getExpectedResults(querySetID);
                ResultsGenerator gr = set.getResultsGenerator();
                for (QueryTest q : queries) {
                    File resultsFile = er.getResultsFile(q.getQueryID());
                    if (resultsFile != null) continue;
                    System.out.println("Failed to get results file for queryID " + q.getQueryID());
                }
            }
            System.out.println("Completed Test");
        }
        catch (QueryTestFailedException e) {
            e.printStackTrace();
        }
    }

    private long compareResults(ResultsHolder expectedResults, ResultSet results, int testStatus, Throwable actualException, boolean isOrdered, int batchSize) throws QueryTestFailedException {
        long firstBatchResponseTime = 0L;
        String eMsg = "CompareResults Error: ";
        switch (testStatus) {
            case 1: {
                throw new QueryTestFailedException("CompareResults Error: TestResult indicates test exception occured, the process should not have passed it in for comparison.");
            }
            case 4: {
                if (!expectedResults.isException()) {
                    throw new QueryTestFailedException("CompareResults Error: The actual result was an exception, but the Expected results wasn't an exception.  Actual exception: '" + actualException.getMessage() + "'");
                }
                ResultsHolder actualResults = new ResultsHolder("exception");
                actualResults.setQueryID(expectedResults.getQueryID());
                actualResults = this.convertException(actualException, actualResults);
                this.compareExceptions(actualResults, expectedResults, "CompareResults Error: ");
                return firstBatchResponseTime;
            }
        }
        if (expectedResults.isException()) {
            throw new QueryTestFailedException("CompareResults Error: Expected exception " + expectedResults.getExceptionMsg() + " but got results");
        }
        ResultsHolder actualResults = new ResultsHolder("queryResults");
        actualResults.setQueryID(expectedResults.getQueryID());
        firstBatchResponseTime = this.convertResults(results, batchSize, actualResults);
        this.compareResults(actualResults, expectedResults, "CompareResults Error: ", isOrdered);
        return firstBatchResponseTime;
    }
}

