/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.progress.VerificationMode;
import org.teiid.client.DQP;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.StatementImpl;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.jdbc.TestResultSet;
import org.teiid.query.unittest.TimestampUtil;

public class TestAllResultsImpl {
    private static final long REQUEST_ID = 0L;
    private static final int TYPE_FORWARD_ONLY = 1003;
    private static final int TYPE_SCROLL_SENSITIVE = 1005;
    private StatementImpl statement;

    @Before
    public void setUp() throws Exception {
        this.statement = TestResultSet.createMockStatement(1005);
    }

    @Test
    public void testHasNext1() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg1(), this.statement);
        while (rs.next()) {
        }
        boolean actual = rs.hasNext();
        boolean expected = false;
        Assert.assertEquals((Object)expected, (Object)actual);
        rs.close();
    }

    @Test
    public void testHasNext2() throws Exception {
        List<Object>[] results = TestAllResultsImpl.exampleResults1(5);
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg1(), this.statement);
        for (int i = 1; i < results.length; ++i) {
            rs.next();
        }
        boolean actual = rs.hasNext();
        boolean expected = true;
        Assert.assertEquals((Object)expected, (Object)actual);
        rs.close();
    }

    @Test
    public void testNext1() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg1(), this.statement);
        boolean actual = rs.next();
        boolean expected = true;
        Assert.assertEquals((String)" Actual doesn't match with expected. ", (Object)expected, (Object)actual);
        rs.close();
    }

    @Test
    public void testNext2() throws Exception {
        List<Object>[] results = TestAllResultsImpl.exampleResults1(5);
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg1(), this.statement);
        int i = 0;
        while (rs.next()) {
            List actual = rs.getCurrentRecord();
            List<Object> expected = results[i];
            Assert.assertEquals(expected, (Object)actual);
            ++i;
        }
        rs.close();
    }

    @Test
    public void testNext3() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg1(), this.statement);
        Assert.assertEquals((Object)new Integer(0), (Object)new Integer(rs.getRow()));
        rs.close();
    }

    @Test
    public void testNext4() throws Exception {
        List<Object>[] results = TestAllResultsImpl.exampleResults1(5);
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg1(), this.statement);
        for (int i = 0; i < results.length - 1; ++i) {
            rs.next();
            List actual = rs.getCurrentRecord();
            List<Object> expected = results[i];
            Assert.assertEquals(expected, (Object)actual);
        }
        rs.close();
    }

    @Test
    public void testNext5() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg1(), this.statement);
        while (rs.next()) {
        }
        boolean actual = rs.hasNext();
        boolean expected = false;
        Assert.assertEquals((Object)expected, (Object)actual);
        rs.close();
    }

    @Test
    public void testGetObject1() throws Exception {
        List[] results = this.exampleResults2();
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2a(), this.statement);
        String actual = null;
        String expected = "a3";
        for (int i = 0; i < results.length - 2; ++i) {
            rs.next();
        }
        if (rs.next()) {
            actual = (String)rs.getObject(2);
        }
        Assert.assertEquals((Object)expected, actual);
        rs.close();
    }

    @Test
    public void testGetObject2() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2a(), this.statement);
        if (rs.next()) {
            try {
                rs.getObject(6);
            }
            catch (Exception e) {
                if (e instanceof IllegalArgumentException) {
                    // empty if block
                }
            }
        }
        rs.close();
    }

    @Test
    public void testGetRow() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2(), this.statement);
        int expected = 0;
        Assert.assertEquals((long)expected, (long)rs.getRow());
        if (rs.next()) {
            expected = 1;
            Assert.assertEquals((long)expected, (long)rs.getRow());
        }
        rs.close();
    }

    @Test
    public void testPrevious() throws Exception {
        List<Object>[] results = TestAllResultsImpl.exampleResults1(5);
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg1(), this.statement);
        while (rs.next()) {
        }
        int i = results.length - 1;
        while (rs.previous()) {
            ArrayList<Integer> expected = new ArrayList<Integer>();
            expected.add(new Integer(i + 1));
            Assert.assertEquals(expected, (Object)rs.getCurrentRecord());
            --i;
        }
        rs.close();
    }

    @Test
    public void testGetCurrentRecord() throws Exception {
        List[] results = this.exampleResults2();
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2(), this.statement);
        rs.next();
        List actual = rs.getCurrentRecord();
        Assert.assertEquals((Object)results[0], (Object)actual);
        rs.close();
    }

    @Test
    public void testGetMetaData() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2a(), this.statement);
        ResultSetMetaData rmetadata = rs.getMetaData();
        Assert.assertEquals((long)2L, (long)rmetadata.getColumnCount());
        String[] columnNames = this.columnNames();
        String[] dataTypes = this.dataTypes();
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((Object)columnNames[i], (Object)rmetadata.getColumnName(i + 1));
            Assert.assertEquals((Object)dataTypes[i], (Object)rmetadata.getColumnTypeName(i + 1));
        }
        rs.close();
    }

    @Test
    public void testResultsWarnings() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2(), this.statement);
        rs.close();
    }

    @Test
    public void testClose() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2(), this.statement);
        rs.close();
        ((StatementImpl)Mockito.verify((Object)this.statement, (VerificationMode)Mockito.times((int)0))).close();
    }

    @Test
    public void testGetFetchSize() throws Exception {
        StatementImpl s = (StatementImpl)Mockito.mock(StatementImpl.class);
        Mockito.stub((Object)s.getFetchSize()).toReturn((Object)500);
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2(), s);
        Assert.assertEquals((long)500L, (long)rs.getFetchSize());
        rs.setFetchSize(100);
        Assert.assertEquals((long)100L, (long)rs.getFetchSize());
    }

    @Test(expected=SQLException.class)
    public void testIsAfterLast1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        rs.last();
    }

    @Test(expected=SQLException.class)
    public void testAfterLast1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        rs.afterLast();
    }

    @Test
    public void testIsBeforeFirst1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        boolean actual = rs.isBeforeFirst();
        Assert.assertEquals((Object)true, (Object)actual);
        rs.close();
    }

    @Test
    public void testIsBeforeFirst2() throws Exception {
        ResultSetImpl rs = this.helpGetNoResults(1003);
        boolean actual = rs.isBeforeFirst();
        Assert.assertEquals((Object)false, (Object)actual);
        rs.close();
    }

    @Test(expected=SQLException.class)
    public void testBeforeFirst1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        rs.next();
        rs.beforeFirst();
    }

    @Test
    public void testIsFirst1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        rs.next();
        boolean actual = rs.isFirst();
        Assert.assertEquals((Object)true, (Object)actual);
        rs.close();
    }

    @Test
    public void testIsFirst2() throws Exception {
        ResultSetImpl rs = this.helpGetNoResults(1003);
        rs.next();
        boolean actual = rs.isFirst();
        Assert.assertEquals((Object)false, (Object)actual);
        rs.close();
    }

    @Test(expected=SQLException.class)
    public void testFirst1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        rs.next();
        rs.first();
    }

    @Test(expected=SQLException.class)
    public void testFirst2() throws Exception {
        ResultSetImpl rs = this.helpGetNoResults(1003);
        rs.next();
        rs.first();
    }

    @Test
    public void testFindColumn() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2a(), this.statement);
        Assert.assertEquals((long)1L, (long)rs.findColumn("IntNum"));
        rs.close();
    }

    @Test
    public void testIsLast1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        boolean actual = rs.isLast();
        Assert.assertEquals((Object)false, (Object)actual);
    }

    @Test
    public void testIsLast2() throws Exception {
        ResultSetImpl rs = this.helpGetNoResults(1003);
        boolean actual = rs.isLast();
        Assert.assertEquals((Object)false, (Object)actual);
    }

    @Test(expected=SQLException.class)
    public void testLast1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        rs.last();
    }

    @Test
    public void testRelative1() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2(), this.statement);
        rs.next();
        boolean actual = rs.relative(1);
        Assert.assertEquals((Object)true, (Object)actual);
        Assert.assertEquals((long)2L, (long)rs.getRow());
        actual = rs.relative(-1);
        Assert.assertEquals((Object)true, (Object)actual);
        Assert.assertEquals((long)1L, (long)rs.getRow());
        rs.close();
    }

    @Test(expected=SQLException.class)
    public void testAbsolute1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        rs.absolute(1);
    }

    @Test
    public void testAfterLast1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        rs.afterLast();
        Assert.assertEquals((long)0L, (long)rs.getRow());
        rs.close();
    }

    @Test
    public void testIsAfterLast1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        rs.last();
        boolean actual = rs.isAfterLast();
        Assert.assertEquals((Object)false, (Object)actual);
        rs.next();
        actual = rs.isAfterLast();
        Assert.assertEquals((Object)true, (Object)actual);
        rs.close();
    }

    @Test
    public void testIsBeforeFirst1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        boolean actual = rs.isBeforeFirst();
        Assert.assertEquals((Object)true, (Object)actual);
        rs.close();
    }

    @Test
    public void testBeforeFirst1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        rs.next();
        rs.next();
        rs.beforeFirst();
        Assert.assertEquals((long)0L, (long)rs.getRow());
        rs.close();
    }

    @Test
    public void testIsFirst1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        rs.next();
        boolean actual = rs.isFirst();
        Assert.assertEquals((Object)true, (Object)actual);
        Assert.assertEquals((long)1L, (long)rs.getRow());
        rs.close();
    }

    @Test
    public void testFirst1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        boolean actual = rs.first();
        Assert.assertEquals((Object)true, (Object)actual);
        Assert.assertEquals((long)1L, (long)rs.getRow());
        rs.afterLast();
        actual = rs.first();
        Assert.assertEquals((Object)true, (Object)actual);
        Assert.assertEquals((long)1L, (long)rs.getRow());
        rs.absolute(3);
        actual = rs.first();
        Assert.assertEquals((Object)true, (Object)actual);
        Assert.assertEquals((long)1L, (long)rs.getRow());
        rs.close();
    }

    @Test
    public void testIsLast1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        rs.last();
        boolean actual = rs.isLast();
        Assert.assertEquals((Object)true, (Object)actual);
        Assert.assertEquals((long)5L, (long)rs.getRow());
        rs.close();
    }

    @Test
    public void testLast1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        boolean actual = rs.last();
        Assert.assertEquals((Object)true, (Object)actual);
        Assert.assertEquals((long)5L, (long)rs.getRow());
        rs.close();
    }

    @Test
    public void testRelative1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        rs.next();
        boolean actual = rs.relative(1);
        Assert.assertEquals((Object)true, (Object)actual);
        Assert.assertEquals((long)2L, (long)rs.getRow());
        actual = rs.relative(-1);
        Assert.assertEquals((Object)true, (Object)actual);
        Assert.assertEquals((long)1L, (long)rs.getRow());
        rs.close();
    }

    @Test
    public void testRelative1b() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        rs.next();
        boolean actual = rs.relative(1);
        actual = rs.relative(-1);
        actual = rs.relative(-3);
        Assert.assertEquals((Object)false, (Object)actual);
        Assert.assertEquals((long)0L, (long)rs.getRow());
        rs.beforeFirst();
        rs.next();
        actual = rs.relative(7);
        Assert.assertEquals((Object)false, (Object)actual);
        Assert.assertEquals((long)0L, (long)rs.getRow());
        rs.close();
    }

    @Test
    public void testRelative1c() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        try {
            rs.relative(-2);
            Assert.fail((String)"relative move from an invalid row should fail");
        }
        catch (SQLException e) {
            // empty catch block
        }
        Assert.assertEquals((String)" Should still be before the first row ", (Object)true, (Object)rs.isBeforeFirst());
        Assert.assertEquals((long)0L, (long)rs.getRow());
        try {
            rs.relative(2);
            Assert.fail((String)"relative move from an invalid row should fail");
        }
        catch (SQLException e) {
            // empty catch block
        }
        Assert.assertEquals((String)" Should still be before the first row ", (Object)true, (Object)rs.isBeforeFirst());
        Assert.assertEquals((long)0L, (long)rs.getRow());
        rs.afterLast();
        try {
            rs.relative(2);
            Assert.fail((String)"relative move from an invalid row should fail");
        }
        catch (SQLException e) {
            // empty catch block
        }
        Assert.assertEquals((String)" Should still be after the last row. ", (Object)true, (Object)rs.isAfterLast());
        Assert.assertEquals((long)0L, (long)rs.getRow());
        try {
            rs.relative(-2);
            Assert.fail((String)"relative move from an invalid row should fail");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertEquals((String)" Should still be after the last row. ", (Object)true, (Object)rs.isAfterLast());
        Assert.assertEquals((long)0L, (long)rs.getRow());
        rs.close();
    }

    @Test
    public void testAbsolute1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        boolean actual = rs.absolute(1);
        Assert.assertEquals((Object)true, (Object)actual);
        Assert.assertEquals((long)1L, (long)rs.getRow());
        actual = rs.absolute(12);
        Assert.assertEquals((Object)false, (Object)actual);
        Assert.assertEquals((long)0L, (long)rs.getRow());
        rs.afterLast();
        actual = rs.absolute(-1);
        Assert.assertEquals((Object)true, (Object)actual);
        Assert.assertEquals((long)5L, (long)rs.getRow());
        actual = rs.absolute(-2);
        Assert.assertEquals((Object)true, (Object)actual);
        Assert.assertEquals((long)4L, (long)rs.getRow());
        rs.close();
    }

    @Test
    public void testAbsolute2a() throws Exception {
        ResultSetImpl rs = this.helpGetNoResults(1005);
        Assert.assertEquals((Object)false, (Object)rs.absolute(1));
        Assert.assertEquals((long)0L, (long)rs.getRow());
        rs.afterLast();
        Assert.assertEquals((Object)false, (Object)rs.absolute(-1));
        Assert.assertEquals((long)0L, (long)rs.getRow());
        rs.close();
    }

    @Test
    public void testMoreResults() throws Exception {
        int fetchSize = 5;
        int batchLength = 4;
        int totalLength = 10;
        ResultSetImpl rs = TestAllResultsImpl.helpTestBatching(this.statement, fetchSize, batchLength, totalLength);
        Assert.assertTrue((boolean)rs.absolute(6));
        Assert.assertTrue((boolean)rs.absolute(-1));
        Assert.assertFalse((boolean)rs.next());
        for (int i = 0; i < totalLength; ++i) {
            Assert.assertTrue((boolean)rs.previous());
        }
    }

    @Test(expected=TeiidSQLException.class)
    public void testResultsMessageException() throws Exception {
        ResultsMessage resultsMsg = this.exampleMessage(TestAllResultsImpl.exampleResults1(1), new String[]{"IntNum"}, new String[]{"integer"});
        resultsMsg.setFinalRow(-1);
        ResultsMessage next = new ResultsMessage();
        next.setException(new Throwable());
        ResultsFuture rf = new ResultsFuture();
        rf.getResultsReceiver().receiveResults((Object)next);
        Mockito.stub((Object)this.statement.getDQP().processCursorRequest(0L, 2, 0)).toReturn((Object)rf);
        ResultSetImpl cs = new ResultSetImpl(resultsMsg, this.statement, null, 2);
        cs.next();
        cs.next();
    }

    static ResultSetImpl helpTestBatching(StatementImpl statement, int fetchSize, int batchLength, int totalLength) throws InterruptedException, ExecutionException, TeiidProcessingException, SQLException, TimeoutException {
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        Mockito.stub((Object)statement.getDQP()).toReturn((Object)dqp);
        Mockito.stub((Object)statement.getFetchSize()).toReturn((Object)fetchSize);
        for (int i = batchLength; i < totalLength; i += batchLength) {
            ResultsFuture nextBatch = (ResultsFuture)Mockito.mock(ResultsFuture.class);
            Mockito.stub((Object)nextBatch.get(Matchers.anyLong(), (TimeUnit)((Object)Matchers.anyObject()))).toReturn((Object)TestAllResultsImpl.exampleResultsMsg4(i + 1, Math.min(batchLength, totalLength - i), fetchSize, i + batchLength >= totalLength));
            Mockito.stub((Object)dqp.processCursorRequest(0L, i + 1, fetchSize)).toReturn((Object)nextBatch);
            if (i + batchLength >= totalLength) continue;
            ResultsFuture previousBatch = (ResultsFuture)Mockito.mock(ResultsFuture.class);
            Mockito.stub((Object)previousBatch.get(Matchers.anyLong(), (TimeUnit)((Object)Matchers.anyObject()))).toReturn((Object)TestAllResultsImpl.exampleResultsMsg4(i - batchLength + 1, i, fetchSize, false));
            Mockito.stub((Object)dqp.processCursorRequest(0L, i, fetchSize)).toReturn((Object)previousBatch);
        }
        ResultsMessage msg = TestAllResultsImpl.exampleResultsMsg4(1, batchLength, fetchSize, batchLength == totalLength);
        return new ResultSetImpl(msg, statement);
    }

    static List<Object>[] exampleResults1(int length) {
        return TestAllResultsImpl.exampleResults1(length, 1);
    }

    static List<Object>[] exampleResults1(int length, int begin) {
        List[] results = new List[length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = new ArrayList();
            results[i].add(new Integer(begin + i));
        }
        return results;
    }

    private List[] exampleResults2() {
        List[] results = new List[5];
        for (int i = 0; i < results.length; ++i) {
            results[i] = new ArrayList();
            results[i].add(new Integer(i));
            results[i].add(new String("a" + i));
        }
        return results;
    }

    private String[] columnNames() {
        String[] names = new String[]{new String("IntNum"), new String("StringNum")};
        return names;
    }

    private String[] dataTypes() {
        String[] types = new String[]{"integer", "string"};
        return types;
    }

    private ResultSetImpl helpGetResultSetImpl(int type) throws SQLException {
        ResultsMessage rsMsg = this.exampleResultsMsg2();
        this.statement = TestResultSet.createMockStatement(type);
        ResultSetImpl rs = new ResultSetImpl(rsMsg, this.statement);
        return rs;
    }

    private ResultSetImpl helpGetNoResults(int type) throws SQLException {
        ResultsMessage rsMsg = this.exampleResultsMsg3();
        this.statement = TestResultSet.createMockStatement(type);
        ResultSetImpl rs = new ResultSetImpl(rsMsg, this.statement);
        return rs;
    }

    private ResultsMessage exampleResultsMsg1() {
        return this.exampleMessage(TestAllResultsImpl.exampleResults1(5), new String[]{"IntNum"}, new String[]{"integer"});
    }

    private ResultsMessage exampleMessage(List<Object>[] results, String[] columnNames, String[] datatypes) {
        RequestMessage request = new RequestMessage();
        request.setExecutionId(0L);
        ResultsMessage resultsMsg = new ResultsMessage(request);
        resultsMsg.setResults((List[])results);
        resultsMsg.setColumnNames(columnNames);
        resultsMsg.setDataTypes(datatypes);
        resultsMsg.setFinalRow(results.length);
        resultsMsg.setLastRow(results.length);
        resultsMsg.setFirstRow(1);
        return resultsMsg;
    }

    private ResultsMessage exampleResultsMsg2() {
        return this.exampleMessage(this.exampleResults2(), new String[]{"IntNum", "StringNum"}, new String[]{"integer", "string"});
    }

    private ResultsMessage exampleResultsMsg2a() {
        ResultsMessage resultsMsg = this.exampleResultsMsg2();
        List[] results = this.exampleResults2();
        resultsMsg.setDataTypes(this.dataTypes());
        resultsMsg.setColumnNames(this.columnNames());
        resultsMsg.setResults(results);
        resultsMsg.setFinalRow(results.length);
        resultsMsg.setLastRow(results.length);
        resultsMsg.setFirstRow(1);
        return resultsMsg;
    }

    private ResultsMessage exampleResultsMsg3() {
        return this.exampleMessage(new List[0], new String[]{"IntNum", "StringNum"}, new String[]{"integer", "string"});
    }

    private static ResultsMessage exampleResultsMsg4(int begin, int length, int fetchSize, boolean lastBatch) {
        RequestMessage request = new RequestMessage();
        request.setExecutionId(0L);
        ResultsMessage resultsMsg = new ResultsMessage(request);
        List[] results = TestAllResultsImpl.exampleResults1(length, begin);
        resultsMsg.setResults(results);
        resultsMsg.setColumnNames(new String[]{"IntKey"});
        resultsMsg.setDataTypes(new String[]{"integer"});
        resultsMsg.setFirstRow(begin);
        if (lastBatch) {
            resultsMsg.setFinalRow(begin + results.length - 1);
        }
        resultsMsg.setLastRow(begin + results.length - 1);
        return resultsMsg;
    }

    @Test
    public void testNotCallingNext() throws SQLException {
        ResultSetImpl cs = new ResultSetImpl(this.exampleResultsMsg2a(), this.statement);
        try {
            cs.getObject(1);
            Assert.fail((String)"Exception expected");
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)"The cursor is not on a valid row.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDateType() throws SQLException {
        RequestMessage request = new RequestMessage();
        request.setExecutionId(0L);
        ResultsMessage resultsMsg = new ResultsMessage(request);
        resultsMsg.setResults(new List[]{Arrays.asList(new Timestamp(0L))});
        resultsMsg.setColumnNames(new String[]{"TS"});
        resultsMsg.setDataTypes(new String[]{"timestamp"});
        resultsMsg.setFirstRow(1);
        resultsMsg.setFinalRow(1);
        resultsMsg.setLastRow(1);
        ResultSetImpl rs = new ResultSetImpl(resultsMsg, this.statement);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)new Timestamp(3600000L), (Object)rs.getObject(1));
        Assert.assertEquals((Object)new Timestamp(0L), (Object)rs.getTimestamp(1, Calendar.getInstance(TimeZone.getTimeZone("GMT-05:00"))));
    }

    @Test
    public void testWasNull() throws SQLException {
        ResultsMessage message = this.exampleMessage(new List[]{Arrays.asList(new String[]{null}), Arrays.asList("1")}, new String[]{"string"}, new String[]{"string"});
        ResultSetImpl rs = new ResultSetImpl(message, this.statement);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)0L, (long)rs.getShort(1));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((double)0.0, (double)rs.getFloat(1), (double)0.0);
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((double)0.0, (double)rs.getDouble(1), (double)0.0);
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertNull((Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getShort(1));
        Assert.assertFalse((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testGetters() throws SQLException {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-05:00"));
        ResultsMessage message = this.exampleMessage(new List[]{Arrays.asList(1, TimestampUtil.createTime((int)0, (int)0, (int)0), TimestampUtil.createDate((int)1, (int)1, (int)1), TimestampUtil.createTimestamp((int)1, (int)1, (int)1, (int)1, (int)1, (int)1, (int)1), "<root/>")}, new String[]{"int", "time", "date", "timestamp", "sqlxml"}, new String[]{"integer", "time", "date", "timestamp", "string"});
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-06:00"));
        ResultSetImpl rs = new ResultSetImpl(message, this.statement);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)rs.getBoolean(1));
        Assert.assertEquals((long)1L, (long)rs.getShort(1));
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)1L, (long)rs.getLong(1));
        Assert.assertEquals((double)1.0, (double)rs.getFloat(1), (double)0.0);
        Assert.assertEquals((double)1.0, (double)rs.getDouble(1), (double)0.0);
        Assert.assertEquals((Object)"1", (Object)rs.getString(1));
        Assert.assertEquals((Object)1, (Object)rs.getObject(1));
        Assert.assertEquals((Object)TimestampUtil.createTime((int)0, (int)0, (int)0), (Object)rs.getTime(2));
        Assert.assertEquals((Object)TimestampUtil.createDate((int)1, (int)1, (int)1), (Object)rs.getDate(3));
        Assert.assertEquals((Object)TimestampUtil.createTimestamp((int)1, (int)1, (int)1, (int)1, (int)1, (int)1, (int)1), (Object)rs.getTimestamp(4));
        Assert.assertEquals((Object)"<root/>", (Object)rs.getSQLXML(5).getString());
        try {
            rs.getSQLXML(1);
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)"Unable to transform the column value 1 to a SQLXML.", (Object)e.getMessage());
        }
        Assert.assertFalse((boolean)rs.next());
        TimestampWithTimezone.resetCalendar(null);
    }
}

