/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.jdbc.EmbeddedProfile;

public class TestEmbeddedProfile {
    @Test
    public void testAcceptsURL() {
        Assert.assertFalse((boolean)EmbeddedProfile.acceptsURL((String)"jdbc:teiid:BQT@classpath:/dqp.properties;partialResultsMode=true"));
        Assert.assertFalse((boolean)EmbeddedProfile.acceptsURL((String)"jdbc:teiid:BQT@mm://host:7001;version=1"));
        Assert.assertFalse((boolean)EmbeddedProfile.acceptsURL((String)"jdbc:teiid:BQT@mms://host:7001;version=1"));
        Assert.assertTrue((boolean)EmbeddedProfile.acceptsURL((String)"jdbc:teiid:BQT"));
        Assert.assertFalse((boolean)EmbeddedProfile.acceptsURL((String)"jdbc:teiid:BQT!/path/foo.properties"));
        Assert.assertTrue((boolean)EmbeddedProfile.acceptsURL((String)"jdbc:teiid:BQT;"));
        Assert.assertTrue((boolean)EmbeddedProfile.acceptsURL((String)"jdbc:teiid:BQT;version=1;logFile=foo.txt"));
        Assert.assertTrue((boolean)EmbeddedProfile.acceptsURL((String)"jdbc:teiid:BQT.1;version=1;logFile=foo.txt"));
    }

    @Test
    public void testParseURL() throws SQLException {
        Properties p = new Properties();
        EmbeddedProfile.parseURL((String)"jdbc:teiid:BQT", (Properties)p);
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assert.assertEquals((long)2L, (long)p.size());
    }

    @Test
    public void testParseURL2() throws SQLException {
        Properties p = new Properties();
        EmbeddedProfile.parseURL((String)"jdbc:teiid:BQT;version=3", (Properties)p);
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("3"));
        Assert.assertTrue((boolean)p.getProperty("version").equals("3"));
        Assert.assertEquals((long)4L, (long)p.size());
    }

    @Test
    public void testParseURL3() throws SQLException {
        Properties p = new Properties();
        EmbeddedProfile.parseURL((String)"jdbc:teiid:BQT@/metamatrix/dqp/dqp.properties;version=4;autoCommitTxn=ON;partialResultsMode=YES;", (Properties)p);
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("4"));
        Assert.assertTrue((boolean)p.getProperty("version").equals("4"));
        Assert.assertTrue((boolean)p.getProperty("autoCommitTxn").equals("ON"));
        Assert.assertTrue((boolean)p.getProperty("partialResultsMode").equals("YES"));
        Assert.assertEquals((long)6L, (long)p.size());
    }

    @Test
    public void testParseURL4() throws SQLException {
        Properties p = new Properties();
        EmbeddedProfile.parseURL((String)"jdbc:teiid:BQT;partialResultsMode=true", (Properties)p);
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assert.assertTrue((boolean)p.getProperty("partialResultsMode").equals("true"));
        Assert.assertEquals((long)3L, (long)p.size());
    }

    @Test
    public void testParseURL5() throws SQLException {
        Properties p = new Properties();
        EmbeddedProfile.parseURL((String)"jdbc:teiid:BQT", (Properties)p);
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
    }

    @Test
    public void testParseURL55() throws SQLException {
        Properties p = new Properties();
        EmbeddedProfile.parseURL((String)"jdbc:teiid:BQT;", (Properties)p);
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
    }

    @Test
    public void testParseURL6() throws SQLException {
        Properties p = new Properties();
        EmbeddedProfile.parseURL((String)"jdbc:teiid:BQT;partialResultsMode=true;version=1", (Properties)p);
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assert.assertTrue((boolean)p.getProperty("partialResultsMode").equals("true"));
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("1"));
        Assert.assertEquals((long)5L, (long)p.size());
    }

    @Test
    public void test() throws Exception {
        try {
            Class.forName("org.teiid.jdbc.TeiidDriver");
            DriverManager.getConnection("jdbc:teiid:Parts@invalidConfig.properties;version=1");
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

