/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.teiid.client.BatchSerializer;
import org.teiid.client.RequestMessage;
import org.teiid.client.metadata.ParameterInfo;
import org.teiid.client.plan.Annotation;
import org.teiid.client.plan.PlanNode;
import org.teiid.client.util.ExceptionHolder;
import org.teiid.core.TeiidException;
import org.teiid.core.util.ExternalizeUtil;

public class ResultsMessage
implements Externalizable {
    static final long serialVersionUID = 3546924172976187793L;
    private List[] results = null;
    private String[] columnNames = null;
    private String[] dataTypes = null;
    private PlanNode planDescription;
    private TeiidException exception;
    private List<Throwable> warnings;
    private int firstRow = 0;
    private int lastRow;
    private int finalRow = -1;
    private List<ParameterInfo> parameters;
    private String debugLog;
    private Collection<Annotation> annotations;
    private boolean isUpdateResult;

    public ResultsMessage() {
    }

    public ResultsMessage(RequestMessage requestMsg) {
        this.results = new ArrayList[0];
    }

    public ResultsMessage(RequestMessage requestMsg, List[] results, String[] columnNames, String[] dataTypes) {
        this(requestMsg);
        this.setResults(results);
        this.setFirstRow(1);
        this.setLastRow(results.length);
        this.columnNames = columnNames;
        this.dataTypes = dataTypes;
    }

    public List[] getResults() {
        return this.results;
    }

    public void setResults(List[] results) {
        this.results = results;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getDataTypes() {
        return this.dataTypes;
    }

    public TeiidException getException() {
        return this.exception;
    }

    public int getFinalRow() {
        return this.finalRow;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public PlanNode getPlanDescription() {
        return this.planDescription;
    }

    public List getWarnings() {
        return this.warnings;
    }

    public void setException(Throwable e) {
        this.exception = e instanceof TeiidException ? (TeiidException)e : new TeiidException(e, e.getMessage());
    }

    public void setFinalRow(int i) {
        this.finalRow = i;
    }

    public void setFirstRow(int i) {
        this.firstRow = i;
    }

    public void setLastRow(int i) {
        this.lastRow = i;
    }

    public void setPlanDescription(PlanNode object) {
        this.planDescription = object;
    }

    public void setWarnings(List<Throwable> list) {
        this.warnings = list;
    }

    public List getParameters() {
        return this.parameters;
    }

    public void setParameters(List list) {
        this.parameters = list;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public void setDataTypes(String[] dataTypes) {
        this.dataTypes = dataTypes;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        List holderList;
        this.columnNames = ExternalizeUtil.readStringArray((ObjectInput)in);
        this.dataTypes = ExternalizeUtil.readStringArray((ObjectInput)in);
        this.results = BatchSerializer.readBatch(in, this.dataTypes);
        this.planDescription = (PlanNode)in.readObject();
        ExceptionHolder holder = (ExceptionHolder)in.readObject();
        if (holder != null) {
            this.exception = (TeiidException)holder.getException();
        }
        if ((holderList = (List)in.readObject()) != null) {
            this.warnings = ExceptionHolder.toThrowables(holderList);
        }
        this.firstRow = in.readInt();
        this.lastRow = in.readInt();
        this.finalRow = in.readInt();
        this.parameters = ExternalizeUtil.readList((ObjectInput)in, ParameterInfo.class);
        this.debugLog = (String)in.readObject();
        this.annotations = ExternalizeUtil.readList((ObjectInput)in, Annotation.class);
        this.isUpdateResult = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizeUtil.writeArray((ObjectOutput)out, (Object[])this.columnNames);
        ExternalizeUtil.writeArray((ObjectOutput)out, (Object[])this.dataTypes);
        BatchSerializer.writeBatch(out, this.dataTypes, this.results);
        out.writeObject(this.planDescription);
        if (this.exception != null) {
            out.writeObject(new ExceptionHolder(this.exception));
        } else {
            out.writeObject((Object)this.exception);
        }
        if (this.warnings != null) {
            out.writeObject(ExceptionHolder.toExceptionHolders(this.warnings));
        } else {
            out.writeObject(this.warnings);
        }
        out.writeInt(this.firstRow);
        out.writeInt(this.lastRow);
        out.writeInt(this.finalRow);
        ExternalizeUtil.writeList((ObjectOutput)out, this.parameters);
        out.writeObject(this.debugLog);
        ExternalizeUtil.writeCollection((ObjectOutput)out, this.annotations);
        out.writeBoolean(this.isUpdateResult);
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotations;
    }

    public String getDebugLog() {
        return this.debugLog;
    }

    public void setAnnotations(Collection<Annotation> collection) {
        this.annotations = collection;
    }

    public void setDebugLog(String string) {
        this.debugLog = string;
    }

    public String toString() {
        return new StringBuffer("ResultsMessage rowCount=").append(this.results == null ? 0 : this.results.length).append(" finalRow=").append(this.finalRow).toString();
    }

    public void setUpdateResult(boolean isUpdateResult) {
        this.isUpdateResult = isUpdateResult;
    }

    public boolean isUpdateResult() {
        return this.isUpdateResult;
    }
}

