/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.JDBCURL;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.ServerConnection;

final class EmbeddedProfile {
    static final String BASE_PATTERN = "jdbc:teiid:([\\w-\\.]+)(;.*)?";
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    static Pattern basePattern = Pattern.compile("jdbc:teiid:([\\w-\\.]+)(;.*)?");

    EmbeddedProfile() {
    }

    public static Connection connect(String url, Properties info) throws SQLException {
        info = info == null ? new Properties() : PropertiesUtils.clone((Properties)info);
        EmbeddedProfile.parseURL(url, info);
        ConnectionImpl conn = EmbeddedProfile.createConnection(url, info);
        logger.fine(JDBCPlugin.Util.getString("JDBCDriver.Connection_sucess"));
        return conn;
    }

    static ConnectionImpl createConnection(String url, Properties info) throws SQLException {
        EmbeddedProfile.validateProperties(info);
        try {
            ServerConnection sc = (ServerConnection)ReflectionHelper.create((String)"org.teiid.transport.LocalServerConnection", Arrays.asList(info), (ClassLoader)Thread.currentThread().getContextClassLoader());
            return new ConnectionImpl(sc, info, url);
        }
        catch (TeiidRuntimeException e) {
            throw TeiidSQLException.create(e);
        }
        catch (ConnectionException e) {
            throw TeiidSQLException.create((Throwable)((Object)e));
        }
        catch (CommunicationException e) {
            throw TeiidSQLException.create((Throwable)((Object)e));
        }
        catch (TeiidException e) {
            throw TeiidSQLException.create(e);
        }
    }

    static void parseURL(String url, Properties info) throws SQLException {
        if (url == null || url.trim().length() == 0) {
            String logMsg = JDBCPlugin.Util.getString("EmbeddedDriver.URL_must_be_specified");
            throw new SQLException(logMsg);
        }
        try {
            JDBCURL jdbcURL = new JDBCURL(url);
            info.setProperty("VirtualDatabaseName", jdbcURL.getVDBName());
            Properties optionalParams = jdbcURL.getProperties();
            JDBCURL.normalizeProperties(info);
            Enumeration<Object> keys = optionalParams.keys();
            while (keys.hasMoreElements()) {
                String propName = (String)keys.nextElement();
                if (info.containsKey(propName)) continue;
                info.setProperty(propName, optionalParams.getProperty(propName));
            }
            if (!info.containsKey("VirtualDatabaseVersion") && jdbcURL.getVDBVersion() != null) {
                info.setProperty("VirtualDatabaseVersion", jdbcURL.getVDBVersion());
            }
            if (!info.containsKey("ApplicationName")) {
                info.setProperty("ApplicationName", "JDBC");
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    static void validateProperties(Properties info) throws SQLException {
        String value = null;
        value = info.getProperty("VirtualDatabaseName");
        if (value == null || value.trim().length() == 0) {
            String logMsg = JDBCPlugin.Util.getString("MMDataSource.Virtual_database_name_must_be_specified");
            throw new SQLException(logMsg);
        }
    }

    public static boolean acceptsURL(String url) {
        Matcher m = basePattern.matcher(url);
        boolean matched = m.matches();
        return matched;
    }
}

