/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.teiid.core.util.ApplicationInfo;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.jdbc.EmbeddedProfile;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.JDBCURL;
import org.teiid.jdbc.SocketProfile;

public class TeiidDriver
implements Driver {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    static final String DRIVER_NAME = "Teiid JDBC Driver";
    private static TeiidDriver INSTANCE = new TeiidDriver();

    public static TeiidDriver getInstance() {
        return INSTANCE;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (EmbeddedProfile.acceptsURL(url)) {
            return EmbeddedProfile.connect(url, info);
        }
        if (SocketProfile.acceptsURL(url)) {
            return SocketProfile.connect(url, info);
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return EmbeddedProfile.acceptsURL(url) || SocketProfile.acceptsURL(url);
    }

    @Override
    public int getMajorVersion() {
        return ApplicationInfo.getInstance().getMajorReleaseVersion();
    }

    @Override
    public int getMinorVersion() {
        return ApplicationInfo.getInstance().getMinorReleaseVersion();
    }

    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        info = info == null ? new Properties() : PropertiesUtils.clone((Properties)info);
        LinkedList<DriverPropertyInfo> driverProps = new LinkedList<DriverPropertyInfo>();
        if (EmbeddedProfile.acceptsURL(url)) {
            EmbeddedProfile.parseURL(url, info);
        } else if (SocketProfile.acceptsURL(url)) {
            SocketProfile.parseURL(url, info);
        }
        for (String property : JDBCURL.KNOWN_PROPERTIES) {
            DriverPropertyInfo dpi = new DriverPropertyInfo(property, info.getProperty(property));
            if (property.equals("VirtualDatabaseName")) {
                dpi.required = true;
            }
            driverProps.add(dpi);
        }
        DriverPropertyInfo[] propInfo = new DriverPropertyInfo[driverProps.size()];
        return driverProps.toArray(propInfo);
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMDriver.Err_registering", new Object[]{e.getMessage()});
            logger.log(Level.SEVERE, logMsg);
        }
    }
}

