/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.net.socket;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.net.CommunicationException;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.net.socket.ObjectChannelFactory;
import org.teiid.net.socket.SocketUtil;
import org.teiid.netty.handler.codec.serialization.ObjectDecoderInputStream;
import org.teiid.netty.handler.codec.serialization.ObjectEncoderOutputStream;

public final class OioOjbectChannelFactory
implements ObjectChannelFactory {
    private static final int STREAM_BUFFER_SIZE = 32768;
    private static final int MAX_OBJECT_SIZE = 0x2000000;
    private static Logger log = Logger.getLogger("org.teiid.client.sockets");
    private Properties props;
    private int receiveBufferSize = 0;
    private int sendBufferSize = 0;
    private boolean conserveBandwidth;
    private int soTimeout = 3000;
    private volatile SocketUtil.SSLSocketFactory sslSocketFactory;

    public OioOjbectChannelFactory(Properties props) {
        this.props = props;
        PropertiesUtils.setBeanProperties((Object)this, (Properties)props, (String)"org.teiid.sockets");
    }

    @Override
    public ObjectChannel createObjectChannel(SocketAddress address, boolean ssl) throws IOException, CommunicationException {
        Socket socket;
        if (ssl) {
            if (this.sslSocketFactory == null) {
                try {
                    this.sslSocketFactory = SocketUtil.getSSLSocketFactory(this.props);
                }
                catch (GeneralSecurityException e) {
                    throw new CommunicationException(e);
                }
            }
            socket = this.sslSocketFactory.getSocket();
        } else {
            socket = new Socket();
        }
        if (this.receiveBufferSize > 0) {
            socket.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.sendBufferSize > 0) {
            socket.setSendBufferSize(this.sendBufferSize);
        }
        socket.setTcpNoDelay(!this.conserveBandwidth);
        socket.connect(address);
        socket.setSoTimeout(this.soTimeout);
        return new OioObjectChannel(socket);
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public boolean isConserveBandwidth() {
        return this.conserveBandwidth;
    }

    public void setConserveBandwidth(boolean conserveBandwidth) {
        this.conserveBandwidth = conserveBandwidth;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    static final class OioObjectChannel
    implements ObjectChannel {
        private final Socket socket;
        private ObjectOutputStream outputStream;
        private ObjectInputStream inputStream;
        private Object readLock = new Object();

        private OioObjectChannel(Socket socket) throws IOException {
            log.fine("creating new OioObjectChannel");
            this.socket = socket;
            BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream(), 32768);
            this.outputStream = new ObjectEncoderOutputStream(new DataOutputStream(bos), 512);
            this.outputStream.flush();
            ClassLoader cl = this.getClass().getClassLoader();
            BufferedInputStream bis = new BufferedInputStream(socket.getInputStream(), 32768);
            this.inputStream = new ObjectDecoderInputStream(new DataInputStream(bis), cl, 0x2000000);
        }

        @Override
        public void close() {
            log.finer("closing socket");
            try {
                this.outputStream.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public SocketAddress getRemoteAddress() {
            return this.socket.getRemoteSocketAddress();
        }

        @Override
        public boolean isOpen() {
            return !this.socket.isClosed();
        }

        @Override
        public Object read() throws IOException, ClassNotFoundException {
            log.finer("reading message from socket");
            Object object = this.readLock;
            synchronized (object) {
                try {
                    return this.inputStream.readObject();
                }
                catch (SocketTimeoutException e) {
                    throw e;
                }
                catch (IOException e) {
                    this.close();
                    throw e;
                }
            }
        }

        @Override
        public synchronized Future<?> write(Object msg) {
            log.finer("writing message to socket");
            ResultsFuture result = new ResultsFuture();
            try {
                this.outputStream.writeObject(msg);
                this.outputStream.flush();
                this.outputStream.reset();
                result.getResultsReceiver().receiveResults(null);
            }
            catch (IOException e) {
                this.close();
                result.getResultsReceiver().exceptionOccurred(e);
            }
            return result;
        }
    }
}

