/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.Serializable;
import java.util.ArrayList;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.cache.Cachable;
import org.teiid.cache.Cache;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.ElementSymbol;

public class CachedResults
implements Serializable,
Cachable {
    private static final long serialVersionUID = -5603182134635082207L;
    private transient Command command;
    private transient TupleBuffer results;
    private AnalysisRecord analysisRecord;
    private String[] types;
    private CacheHint hint;
    private int batchSize;
    private String uuid;
    private int rowCount;
    private boolean hasLobs;

    public String getId() {
        return this.uuid;
    }

    public AnalysisRecord getAnalysisRecord() {
        return this.analysisRecord;
    }

    public void setAnalysisRecord(AnalysisRecord analysisRecord) {
        this.analysisRecord = analysisRecord;
    }

    public TupleBuffer getResults() {
        return this.results;
    }

    public void setResults(TupleBuffer results) {
        this.results = results;
        this.batchSize = results.getBatchSize();
        this.types = TupleBuffer.getTypeNames(results.getSchema());
        this.rowCount = results.getRowCount();
        this.uuid = results.getId();
        this.hasLobs = results.isLobs();
    }

    public void setCommand(Command command) {
        this.command = command;
        this.hint = command.getCacheHint();
    }

    public void setHint(CacheHint hint) {
        this.hint = hint;
    }

    public CacheHint getHint() {
        return this.hint;
    }

    public synchronized Command getCommand(String sql, QueryMetadataInterface metadata, ParseInfo info) throws QueryParserException, QueryResolverException, TeiidComponentException {
        if (this.command == null) {
            this.command = QueryParser.getQueryParser().parseCommand(sql, info);
        }
        QueryResolver.resolveCommand(this.command, metadata);
        return this.command;
    }

    @Override
    public boolean prepare(Cache cache, BufferManager bufferManager) {
        Assertion.assertTrue((!this.results.isForwardOnly() ? 1 : 0) != 0);
        bufferManager.addTupleBuffer(this.results);
        return true;
    }

    @Override
    public synchronized boolean restore(Cache cache, BufferManager bufferManager) {
        try {
            if (this.results == null) {
                if (this.hasLobs) {
                    return false;
                }
                ArrayList<ElementSymbol> schema = new ArrayList<ElementSymbol>(this.types.length);
                for (String type : this.types) {
                    ElementSymbol es = new ElementSymbol("x");
                    es.setType(DataTypeManager.getDataTypeClass((String)type));
                    schema.add(es);
                }
                TupleBuffer buffer = bufferManager.createTupleBuffer(schema, "cached", BufferManager.TupleSourceType.FINAL);
                buffer.setBatchSize(this.batchSize);
                if (this.hint != null) {
                    buffer.setPrefersMemory(this.hint.getPrefersMemory());
                }
                for (int row = 1; row <= this.rowCount; row += this.batchSize) {
                    TupleBatch batch = (TupleBatch)cache.get(this.uuid + "," + row);
                    if (batch == null) continue;
                    buffer.addTupleBatch(batch, true);
                }
                this.results = buffer;
                bufferManager.addTupleBuffer(this.results);
            }
            return true;
        }
        catch (TeiidComponentException e) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{QueryPlugin.Util.getString("not_found_cache")});
            return false;
        }
    }
}

