/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.logging.LogManager;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleCopyCriteria
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, TeiidComponentException {
        List<PlanNode> critNodes = NodeEditor.findAllNodes(plan, 20);
        boolean shouldRun = false;
        for (PlanNode critNode : critNodes) {
            if (critNode.hasBooleanProperty(NodeConstants.Info.IS_COPIED)) continue;
            shouldRun = true;
            break;
        }
        if (!shouldRun) {
            return plan;
        }
        if (this.tryToCopy(plan, new Set[2], metadata)) {
            rules.push(RuleConstants.COPY_CRITERIA);
            rules.push(RuleConstants.PUSH_NON_JOIN_CRITERIA);
        }
        for (PlanNode critNode : critNodes) {
            critNode.setProperty(NodeConstants.Info.IS_COPIED, Boolean.TRUE);
        }
        return plan;
    }

    private boolean copyCriteria(Criteria crit, Map<Expression, Expression> tgtMap, List<Criteria> joinCriteria, Set<Criteria> combinedCriteria, boolean checkForGroupReduction, QueryMetadataInterface metadata) {
        int startGroups = GroupsUsedByElementsVisitor.getGroups(crit).size();
        Criteria tgtCrit = (Criteria)crit.clone();
        try {
            tgtCrit = FrameUtil.convertCriteria(tgtCrit, tgtMap, metadata, true);
        }
        catch (QueryPlannerException err) {
            LogManager.logDetail((String)"org.teiid.PLANNER", (Throwable)((Object)err), (Object[])new Object[]{"Could not remap target criteria in RuleCopyCriteria"});
            return false;
        }
        int endGroups = GroupsUsedByElementsVisitor.getGroups(tgtCrit).size();
        if (checkForGroupReduction ? endGroups >= startGroups : endGroups > startGroups) {
            return false;
        }
        if (combinedCriteria.add(tgtCrit)) {
            joinCriteria.add(tgtCrit);
            return true;
        }
        return checkForGroupReduction;
    }

    private boolean tryToCopy(PlanNode node, Set<Criteria>[] criteriaInfo, QueryMetadataInterface metadata) {
        boolean changedTree = false;
        if (node == null) {
            return false;
        }
        if (node.getType() == 4) {
            JoinType jt = (JoinType)node.getProperty(NodeConstants.Info.JOIN_TYPE);
            if (jt == JoinType.JOIN_FULL_OUTER) {
                return this.visitChildern(node, criteriaInfo, changedTree, metadata);
            }
            Set[] leftChildCriteria = new Set[2];
            Set[] rightChildCriteria = new Set[2];
            changedTree |= this.tryToCopy(node.getFirstChild(), leftChildCriteria, metadata);
            changedTree |= this.tryToCopy(node.getLastChild(), rightChildCriteria, metadata);
            List joinCrits = (List)node.getProperty(NodeConstants.Info.JOIN_CRITERIA);
            HashSet<Criteria> combinedCriteria = null;
            if (joinCrits != null) {
                combinedCriteria = new HashSet<Criteria>(joinCrits);
                combinedCriteria.addAll(leftChildCriteria[1]);
                combinedCriteria.addAll(rightChildCriteria[1]);
            }
            leftChildCriteria[0].addAll(rightChildCriteria[0]);
            leftChildCriteria[1].addAll(rightChildCriteria[1]);
            criteriaInfo[0] = leftChildCriteria[0];
            criteriaInfo[1] = leftChildCriteria[1];
            if (jt == JoinType.JOIN_CROSS) {
                return changedTree;
            }
            Set<Criteria> toCopy = criteriaInfo[0];
            Set<Criteria> allCriteria = criteriaInfo[1];
            if (!toCopy.isEmpty()) {
                Map<Expression, Expression> srcToTgt = this.buildElementMap(joinCrits);
                LinkedList<Criteria> newJoinCrits = new LinkedList<Criteria>();
                changedTree |= this.createCriteria(false, toCopy, combinedCriteria, srcToTgt, newJoinCrits, metadata);
                srcToTgt = this.buildElementMap(allCriteria);
                changedTree |= this.createCriteria(true, joinCrits, combinedCriteria, srcToTgt, newJoinCrits, metadata);
                joinCrits.addAll(newJoinCrits);
            }
            if (jt == JoinType.JOIN_RIGHT_OUTER) {
                criteriaInfo[0].removeAll(leftChildCriteria[0]);
                criteriaInfo[1].removeAll(leftChildCriteria[1]);
            } else if (jt == JoinType.JOIN_LEFT_OUTER) {
                criteriaInfo[0].removeAll(rightChildCriteria[0]);
                criteriaInfo[1].removeAll(rightChildCriteria[1]);
            } else if (node.getSubqueryContainers().isEmpty()) {
                if (!node.hasBooleanProperty(NodeConstants.Info.IS_COPIED)) {
                    toCopy.addAll(joinCrits);
                }
                allCriteria.addAll(joinCrits);
            }
            return changedTree;
        }
        changedTree = this.visitChildern(node, criteriaInfo, changedTree, metadata);
        switch (node.getType()) {
            case 16: {
                if (criteriaInfo[0] == null) break;
                this.visitSelectNode(node, criteriaInfo[0], criteriaInfo[1]);
                break;
            }
            case 8: 
            case 64: 
            case 128: 
            case 256: 
            case 512: {
                if (criteriaInfo[0] == null) {
                    criteriaInfo[0] = new HashSet<Criteria>();
                    criteriaInfo[1] = new HashSet<Criteria>();
                    break;
                }
                criteriaInfo[0].clear();
                criteriaInfo[1].clear();
            }
        }
        return changedTree;
    }

    private boolean createCriteria(boolean copyingJoinCriteria, Collection<Criteria> toCopy, Set<Criteria> combinedCriteria, Map<Expression, Expression> srcToTgt, List<Criteria> newJoinCrits, QueryMetadataInterface metadata) {
        boolean changedTree = false;
        if (srcToTgt.size() == 0) {
            return changedTree;
        }
        Iterator<Criteria> i = toCopy.iterator();
        while (i.hasNext()) {
            Criteria crit = i.next();
            if (!this.copyCriteria(crit, srcToTgt, newJoinCrits, combinedCriteria, copyingJoinCriteria, metadata)) continue;
            changedTree = true;
            if (!copyingJoinCriteria) {
                crit = newJoinCrits.get(newJoinCrits.size() - 1);
            }
            if (crit instanceof CompareCriteria) {
                CompareCriteria cc = (CompareCriteria)crit;
                cc.setOptional(copyingJoinCriteria ? null : Boolean.valueOf(true));
                continue;
            }
            if (!copyingJoinCriteria) continue;
            i.remove();
        }
        return changedTree;
    }

    private void visitSelectNode(PlanNode node, Set<Criteria> toCopy, Set<Criteria> allCriteria) {
        Criteria crit = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        if (node.getGroups().size() == 1) {
            List<Criteria> crits = Criteria.separateCriteriaByAnd(crit);
            if (!node.hasBooleanProperty(NodeConstants.Info.IS_HAVING) && node.getSubqueryContainers().isEmpty()) {
                if (!node.hasBooleanProperty(NodeConstants.Info.IS_COPIED)) {
                    toCopy.addAll(crits);
                }
                allCriteria.addAll(crits);
            }
        }
    }

    private boolean visitChildern(PlanNode node, Set<Criteria>[] criteriaInfo, boolean changedTree, QueryMetadataInterface metadata) {
        if (node.getChildCount() > 0) {
            List<PlanNode> children = node.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                PlanNode childNode = children.get(i);
                changedTree |= this.tryToCopy(childNode, i == 0 ? criteriaInfo : new Set[2], metadata);
            }
        }
        return changedTree;
    }

    Map<Expression, Expression> buildElementMap(Collection<Criteria> crits) {
        HashMap<Expression, Expression> srcToTgt = null;
        for (Criteria theCrit : crits) {
            CompareCriteria crit;
            if (theCrit instanceof IsNullCriteria) {
                IsNullCriteria isNull = (IsNullCriteria)theCrit;
                if (isNull.isNegated() || !(isNull.getExpression() instanceof ElementSymbol)) continue;
                if (srcToTgt == null) {
                    srcToTgt = new HashMap<Expression, Expression>();
                }
                srcToTgt.put(isNull.getExpression(), new Constant(null, isNull.getExpression().getType()));
                continue;
            }
            if (!(theCrit instanceof CompareCriteria) || (crit = (CompareCriteria)theCrit).getOperator() != 1) continue;
            if (srcToTgt == null) {
                srcToTgt = new HashMap();
            }
            srcToTgt.put(crit.getLeftExpression(), crit.getRightExpression());
            srcToTgt.put(crit.getRightExpression(), crit.getLeftExpression());
        }
        if (srcToTgt == null) {
            return Collections.emptyMap();
        }
        return srcToTgt;
    }

    public String toString() {
        return "CopyCriteria";
    }
}

