/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.process.Request;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.proc.CreateCursorResultSetInstruction;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.proc.Program;
import org.teiid.query.processor.proc.ProgramInstruction;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolveVirtualGroupCriteriaVisitor;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.util.CommandContext;
import org.teiid.query.validator.ValidationVisitor;

public class ExecDynamicSqlInstruction
extends ProgramInstruction {
    private DynamicCommand dynamicCommand;
    IDGenerator idGenerator;
    CapabilitiesFinder capFinder;
    private QueryMetadataInterface metadata;
    CreateUpdateProcedureCommand parentProcCommand;
    private Program dynamicProgram;

    public ExecDynamicSqlInstruction(CreateUpdateProcedureCommand parentProcCommand, DynamicCommand command, QueryMetadataInterface metadata, IDGenerator idGenerator, CapabilitiesFinder capFinder) {
        this.parentProcCommand = parentProcCommand;
        this.dynamicCommand = command;
        this.metadata = metadata;
        this.capFinder = capFinder;
        this.idGenerator = idGenerator;
    }

    @Override
    public void process(ProcedurePlan procEnv) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        VariableContext localContext = procEnv.getCurrentVariableContext();
        try {
            Object value = procEnv.evaluateExpression(this.dynamicCommand.getSql());
            if (value == null) {
                throw new QueryProcessingException(QueryPlugin.Util.getString("ExecDynamicSqlInstruction.0"));
            }
            LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Executing dynamic sql ", value});
            Command command = QueryParser.getQueryParser().parseCommand(value.toString());
            command.setExternalGroupContexts(this.dynamicCommand.getExternalGroupContexts());
            command.setTemporaryMetadata(this.dynamicCommand.getTemporaryMetadata());
            this.updateContextWithUsingValues(procEnv, localContext);
            Map tempMetadata = command.getTemporaryMetadata();
            TempMetadataStore metadataStore = new TempMetadataStore(tempMetadata);
            if (this.dynamicCommand.getUsing() != null && !this.dynamicCommand.getUsing().isEmpty()) {
                metadataStore.addTempGroup("USING", new LinkedList<ElementSymbol>(this.dynamicCommand.getUsing().getClauseMap().keySet()));
                GroupSymbol using = new GroupSymbol("USING");
                using.setMetadataID(metadataStore.getTempGroupID("USING"));
                command.addExternalGroupToContext(using);
                metadataStore.addTempGroup("DVARS", new LinkedList<ElementSymbol>(this.dynamicCommand.getUsing().getClauseMap().keySet()));
                using = new GroupSymbol("DVARS");
                using.setMetadataID(metadataStore.getTempGroupID("DVARS"));
                command.addExternalGroupToContext(using);
            }
            if (this.parentProcCommand.isUpdateProcedure()) {
                ResolveVirtualGroupCriteriaVisitor.resolveCriteria(command, this.parentProcCommand.getVirtualGroup(), this.metadata);
            }
            QueryResolver.resolveCommand(command, this.metadata);
            this.validateDynamicCommand(procEnv, command);
            Map nameValueMap = this.createVariableValuesMap(localContext);
            nameValueMap.putAll(QueryResolver.getVariableValues(this.parentProcCommand.getUserCommand(), false, this.metadata));
            ValidationVisitor visitor = new ValidationVisitor();
            visitor.setUpdateProc(this.parentProcCommand);
            Request.validateWithVisitor(visitor, this.metadata, command);
            if (this.dynamicCommand.getAsColumns() != null && !this.dynamicCommand.getAsColumns().isEmpty()) {
                command = QueryRewriter.createInlineViewQuery(new GroupSymbol("X"), command, this.metadata, this.dynamicCommand.getAsColumns());
                if (this.dynamicCommand.getIntoGroup() != null) {
                    Insert insert = new Insert(this.dynamicCommand.getIntoGroup(), this.dynamicCommand.getAsColumns(), Collections.emptyList());
                    insert.setQueryExpression((Query)command);
                    command = insert;
                }
            }
            command = QueryRewriter.rewrite(command, this.parentProcCommand, this.metadata, procEnv.getContext(), nameValueMap, this.parentProcCommand.getUserCommand().getType());
            ProcessorPlan commandPlan = QueryOptimizer.optimizePlan(command, this.metadata, this.idGenerator, this.capFinder, AnalysisRecord.createNonRecordingRecord(), procEnv.getContext());
            CreateCursorResultSetInstruction inst = new CreateCursorResultSetInstruction("EXECSQL_INSTRUCTION", commandPlan, this.dynamicCommand.getIntoGroup() != null){

                @Override
                public void process(ProcedurePlan procEnv) throws BlockedException, TeiidComponentException, TeiidProcessingException {
                    super.process(procEnv);
                    procEnv.getContext().popCall();
                }
            };
            this.dynamicProgram = new Program();
            this.dynamicProgram.addInstruction(inst);
            if (this.dynamicCommand.getIntoGroup() != null) {
                String groupName = this.dynamicCommand.getIntoGroup().getCanonicalName();
                if (!procEnv.getTempTableStore().getAllTempTables().contains(groupName)) {
                    procEnv.getTempContext().add(groupName);
                }
            }
            procEnv.push(this.dynamicProgram);
        }
        catch (TeiidProcessingException e) {
            Object[] params = new Object[]{this.dynamicCommand, this.dynamicCommand.getSql(), e.getMessage()};
            throw new QueryProcessingException(e, QueryPlugin.Util.getString("ExecDynamicSqlInstruction.couldnt_execute", params));
        }
    }

    private void updateContextWithUsingValues(ProcedurePlan procEnv, VariableContext localContext) throws TeiidComponentException, TeiidProcessingException {
        if (this.dynamicCommand.getUsing() != null && !this.dynamicCommand.getUsing().isEmpty()) {
            for (SetClause setClause : this.dynamicCommand.getUsing().getClauses()) {
                Object assignment = procEnv.evaluateExpression(setClause.getValue());
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{this, " The using variable ", setClause.getSymbol(), " has value :", assignment});
                localContext.setValue(setClause.getSymbol(), assignment);
                localContext.setValue(new ElementSymbol("USING." + setClause.getSymbol().getShortName()), assignment);
            }
        }
    }

    private Map createVariableValuesMap(VariableContext localContext) {
        HashMap variableMap = new HashMap();
        localContext.getFlattenedContextMap(variableMap);
        HashMap<String, Constant> nameValueMap = new HashMap<String, Constant>(variableMap.size());
        for (Map.Entry entry : variableMap.entrySet()) {
            nameValueMap.put(((ElementSymbol)entry.getKey()).getCanonicalName(), new Constant(entry.getValue()));
        }
        return nameValueMap;
    }

    private void validateDynamicCommand(ProcedurePlan procEnv, Command command) throws TeiidComponentException, QueryProcessingException {
        List dynamicExpectedColumns = this.dynamicCommand.getAsColumns();
        List<SingleElementSymbol> sourceProjectedSymbolList = command.getProjectedSymbols();
        if (dynamicExpectedColumns != null && !dynamicExpectedColumns.isEmpty()) {
            if (dynamicExpectedColumns.size() != sourceProjectedSymbolList.size()) {
                throw new QueryProcessingException(QueryPlugin.Util.getString("ExecDynamicSqlInstruction.4"));
            }
            Iterator dynamicIter = dynamicExpectedColumns.iterator();
            Iterator<SingleElementSymbol> sourceIter = sourceProjectedSymbolList.iterator();
            while (dynamicIter.hasNext()) {
                String sourceTypeName;
                SingleElementSymbol dynamicSymbol = (SingleElementSymbol)dynamicIter.next();
                Class sourceSymbolDatatype = sourceIter.next().getType();
                Class dynamicType = dynamicSymbol.getType();
                String dynamicTypeName = DataTypeManager.getDataTypeName((Class)dynamicType);
                if (dynamicTypeName.equals(sourceTypeName = DataTypeManager.getDataTypeName((Class)sourceSymbolDatatype)) || DataTypeManager.isImplicitConversion((String)sourceTypeName, (String)dynamicTypeName)) continue;
                Object[] params = new Object[]{sourceTypeName, dynamicSymbol.getShortCanonicalName(), dynamicTypeName};
                throw new QueryProcessingException(QueryPlugin.Util.getString("ExecDynamicSqlInstruction.6", params));
            }
        }
        CommandContext context = procEnv.getContext();
        context.pushCall(this.parentProcCommand.getVirtualGroup().getCanonicalName());
    }

    @Override
    public ExecDynamicSqlInstruction clone() {
        ExecDynamicSqlInstruction clone = new ExecDynamicSqlInstruction(this.parentProcCommand, this.dynamicCommand, this.metadata, this.idGenerator, this.capFinder);
        return clone;
    }

    public String toString() {
        return "ExecDynamicSqlInstruction";
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("ExecDynamicSqlInstruction");
        props.addProperty("Query", this.dynamicCommand.toString());
        return props;
    }
}

