/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.visitor.EvaluatableVisitor;

public class RelationalNodeUtil {
    private RelationalNodeUtil() {
    }

    private static boolean evaluateCriteria(Criteria criteria) throws TeiidComponentException, ExpressionEvaluationException {
        if (criteria == null) {
            return true;
        }
        return Evaluator.evaluate(criteria);
    }

    public static boolean shouldExecute(Command command, boolean simplifyCriteria) throws TeiidComponentException, ExpressionEvaluationException {
        int cmdType = command.getType();
        Criteria criteria = null;
        switch (cmdType) {
            case 1: {
                Constant rowLimit;
                QueryCommand queryCommand = (QueryCommand)command;
                Limit limit = queryCommand.getLimit();
                if (limit != null && limit.getRowLimit() instanceof Constant && new Integer(0).equals((rowLimit = (Constant)limit.getRowLimit()).getValue())) {
                    return false;
                }
                if (queryCommand instanceof SetQuery) {
                    SetQuery union = (SetQuery)queryCommand;
                    boolean shouldExecute = false;
                    for (QueryCommand innerQuery : union.getQueryCommands()) {
                        boolean shouldInner = RelationalNodeUtil.shouldExecute(innerQuery, simplifyCriteria);
                        if (!shouldInner) continue;
                        shouldExecute = true;
                        break;
                    }
                    return shouldExecute;
                }
                Query query = (Query)queryCommand;
                criteria = query.getCriteria();
                if (criteria == null) {
                    return true;
                }
                if (!EvaluatableVisitor.isFullyEvaluatable(criteria, false)) {
                    return true;
                }
                if (!RelationalNodeUtil.evaluateCriteria(criteria)) break;
                if (simplifyCriteria) {
                    query.setCriteria(null);
                }
                return true;
            }
            case 2: {
                Insert insert = (Insert)command;
                QueryCommand expr = insert.getQueryExpression();
                if (expr != null) {
                    return RelationalNodeUtil.shouldExecute(expr, simplifyCriteria);
                }
                return true;
            }
            case 3: {
                Update update = (Update)command;
                if (update.getChangeList().isEmpty()) {
                    return false;
                }
                criteria = update.getCriteria();
                if (criteria == null) {
                    return true;
                }
                if (!EvaluatableVisitor.isFullyEvaluatable(criteria, false)) {
                    return true;
                }
                if (!RelationalNodeUtil.evaluateCriteria(criteria)) break;
                if (simplifyCriteria) {
                    update.setCriteria(null);
                }
                return true;
            }
            case 4: {
                Delete delete = (Delete)command;
                criteria = delete.getCriteria();
                if (criteria == null) {
                    return true;
                }
                if (!EvaluatableVisitor.isFullyEvaluatable(criteria, false)) {
                    return true;
                }
                if (!RelationalNodeUtil.evaluateCriteria(criteria)) break;
                if (simplifyCriteria) {
                    delete.setCriteria(null);
                }
                return true;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    public static boolean isUpdate(Command command) {
        int commandType = command.getType();
        return commandType == 2 || commandType == 3 || commandType == 4;
    }
}

