/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.logging.LogManager;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.processor.xml.PlanExecutor;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;

public class ExecSqlInstruction
extends ProcessorInstruction {
    private String resultSetName;
    ResultSetInfo info;

    public ExecSqlInstruction(String resultSetName, ResultSetInfo info) {
        this.resultSetName = resultSetName;
        this.info = info;
    }

    @Override
    public XMLContext process(XMLProcessorEnvironment env, XMLContext context) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"SQL: Result set DOESN'T exist:", this.resultSetName});
        PlanExecutor executor = context.getResultExecutor(this.resultSetName);
        if (executor == null) {
            executor = env.createResultExecutor(this.resultSetName, this.info);
            context.setResultExecutor(this.resultSetName, executor);
        }
        executor.execute(context.getReferenceValues());
        context.removeResultExecutor(this.resultSetName);
        context.setResultSet(this.resultSetName, executor);
        env.incrementCurrentProgramCounter();
        return context;
    }

    public String toString() {
        return "SQL  " + this.resultSetName;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("EXECUTE SQL");
        props.addProperty("Result Set", this.resultSetName);
        props.addProperty("Query", this.info.getPlan().getDescriptionProperties());
        return props;
    }
}

