/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.command.SimpleQueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.SingleElementSymbol;

public class SetQueryResolver
implements CommandResolver {
    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        SetQuery setQuery = (SetQuery)command;
        SimpleQueryResolver.resolveWith(metadata, setQuery);
        QueryCommand firstCommand = setQuery.getLeftQuery();
        QueryResolver.setChildMetadata(firstCommand, setQuery);
        QueryResolver.resolveCommand(firstCommand, metadata.getMetadata(), false);
        List<SingleElementSymbol> firstProject = firstCommand.getProjectedSymbols();
        ArrayList firstProjectTypes = new ArrayList();
        for (SingleElementSymbol symbol : firstProject) {
            firstProjectTypes.add(symbol.getType());
        }
        QueryCommand rightCommand = setQuery.getRightQuery();
        QueryResolver.setChildMetadata(rightCommand, setQuery);
        QueryResolver.resolveCommand(rightCommand, metadata.getMetadata(), false);
        if (firstProject.size() != rightCommand.getProjectedSymbols().size()) {
            throw new QueryResolverException(QueryPlugin.Util.getString("ERR.015.012.0035", new Object[]{setQuery.getOperation()}));
        }
        SetQueryResolver.checkSymbolTypes(firstProjectTypes, rightCommand.getProjectedSymbols());
        if (resolveNullLiterals) {
            for (int i = 0; i < firstProjectTypes.size(); ++i) {
                Class clazz = (Class)firstProjectTypes.get(i);
                if (clazz != null && !clazz.equals(DataTypeManager.DefaultDataClasses.NULL)) continue;
                firstProjectTypes.set(i, DataTypeManager.DefaultDataClasses.STRING);
            }
        }
        setQuery.setProjectedTypes(firstProjectTypes, metadata.getMetadata());
        if (setQuery.getOrderBy() != null) {
            ResolverUtil.resolveOrderBy(setQuery.getOrderBy(), setQuery, metadata);
        }
        this.setProjectedTypes(setQuery, firstProjectTypes, metadata.getMetadata());
        if (setQuery.getLimit() != null) {
            ResolverUtil.resolveLimit(setQuery.getLimit());
        }
        setQuery.setTemporaryMetadata(new HashMap(firstCommand.getTemporaryMetadata()));
    }

    private void setProjectedTypes(SetQuery setQuery, List<Class<?>> firstProjectTypes, QueryMetadataInterface metadata) throws QueryResolverException {
        for (QueryCommand subCommand : setQuery.getQueryCommands()) {
            if (!(subCommand instanceof SetQuery)) continue;
            SetQuery child = (SetQuery)subCommand;
            List projectedSymbols = child.getProjectedSymbols();
            if (child.getOrderBy() != null) {
                for (int j = 0; j < projectedSymbols.size(); ++j) {
                    SingleElementSymbol ses = (SingleElementSymbol)projectedSymbols.get(j);
                    Class<?> targetType = firstProjectTypes.get(j);
                    if (ses.getType() == targetType || !SetQueryResolver.orderByContainsVariable(child.getOrderBy(), ses, j)) continue;
                    String sourceTypeName = DataTypeManager.getDataTypeName((Class)ses.getType());
                    String targetTypeName = DataTypeManager.getDataTypeName(targetType);
                    throw new QueryResolverException(QueryPlugin.Util.getString("UnionQueryResolver.type_conversion", new Object[]{ses, sourceTypeName, targetTypeName}));
                }
            }
            child.setProjectedTypes(firstProjectTypes, metadata);
            this.setProjectedTypes(child, firstProjectTypes, metadata);
        }
    }

    public static boolean orderByContainsVariable(OrderBy orderBy, SingleElementSymbol ses, int position) {
        for (OrderByItem item : orderBy.getOrderByItems()) {
            if (item.getExpressionPosition() != position) continue;
            return true;
        }
        return false;
    }

    static void checkSymbolTypes(List firstProjectTypes, List projSymbols) {
        for (int j = 0; j < projSymbols.size(); ++j) {
            SingleElementSymbol projSymbol;
            Class projType;
            Class firstProjType = (Class)firstProjectTypes.get(j);
            if (firstProjType.equals(projType = (projSymbol = (SingleElementSymbol)projSymbols.get(j)).getType())) continue;
            String sourceType = DataTypeManager.getDataTypeName((Class)firstProjType);
            String targetType = DataTypeManager.getDataTypeName((Class)projType);
            String commonType = ResolverUtil.getCommonType(new String[]{sourceType, targetType});
            if (commonType == null) {
                commonType = "object";
            }
            firstProjectTypes.set(j, DataTypeManager.getDataTypeClass((String)commonType));
        }
    }
}

