/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.CommandCollectorVisitor;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public abstract class Command
implements LanguageObject {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_QUERY = 1;
    public static final int TYPE_INSERT = 2;
    public static final int TYPE_UPDATE = 3;
    public static final int TYPE_DELETE = 4;
    public static final int TYPE_SQL = 5;
    public static final int TYPE_STORED_PROCEDURE = 6;
    public static final int TYPE_UPDATE_PROCEDURE = 7;
    public static final int TYPE_BATCHED_UPDATE = 9;
    public static final int TYPE_DYNAMIC = 10;
    public static final int TYPE_CREATE = 11;
    public static final int TYPE_DROP = 12;
    public static final int TYPE_TRIGGER_ACTION = 13;
    private static List<SingleElementSymbol> updateCommandSymbol;
    protected Map tempGroupIDs;
    private transient GroupContext externalGroups;
    private boolean isResolved;
    private Option option;
    private ProcessorPlan plan;
    private SymbolMap correlatedReferences;
    private CacheHint cacheHint;

    public abstract int getType();

    public SymbolMap getCorrelatedReferences() {
        return this.correlatedReferences;
    }

    public void setCorrelatedReferences(SymbolMap correlatedReferences) {
        this.correlatedReferences = correlatedReferences;
    }

    public List<Command> getSubCommands() {
        return CommandCollectorVisitor.getCommands(this);
    }

    public void setTemporaryMetadata(Map metadata) {
        this.tempGroupIDs = metadata;
    }

    public Map getTemporaryMetadata() {
        return this.tempGroupIDs;
    }

    public void addExternalGroupToContext(GroupSymbol group) {
        this.getExternalGroupContexts().addGroup(group);
    }

    public void addExternalGroupsToContext(Collection<GroupSymbol> groups) {
        this.getExternalGroupContexts().getGroups().addAll(groups);
    }

    public void setExternalGroupContexts(GroupContext root) {
        this.externalGroups = root == null ? null : (GroupContext)root.clone();
    }

    public void pushNewResolvingContext(Collection<GroupSymbol> groups) {
        this.externalGroups = new GroupContext(this.externalGroups, new LinkedList<GroupSymbol>(groups));
    }

    public GroupContext getExternalGroupContexts() {
        if (this.externalGroups == null) {
            this.externalGroups = new GroupContext();
        }
        return this.externalGroups;
    }

    public List<GroupSymbol> getAllExternalGroups() {
        if (this.externalGroups == null) {
            return Collections.emptyList();
        }
        return this.externalGroups.getAllGroups();
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public void setIsResolved(boolean isResolved) {
        this.isResolved = isResolved;
    }

    @Override
    public abstract Object clone();

    protected void copyMetadataState(Command copy) {
        if (this.getExternalGroupContexts() != null) {
            copy.externalGroups = (GroupContext)this.externalGroups.clone();
        }
        if (this.tempGroupIDs != null) {
            copy.setTemporaryMetadata(new HashMap(this.tempGroupIDs));
        }
        copy.setIsResolved(this.isResolved());
        copy.plan = this.plan;
        if (this.correlatedReferences != null) {
            copy.correlatedReferences = this.correlatedReferences.clone();
        }
        if (this.getOption() != null) {
            copy.setOption((Option)this.getOption().clone());
        }
        copy.cacheHint = this.cacheHint;
    }

    public String printCommandTree() {
        StringBuffer str = new StringBuffer();
        this.printCommandTree(str, 0);
        return str.toString();
    }

    protected void printCommandTree(StringBuffer str, int tabLevel) {
        for (int i = 0; i < tabLevel; ++i) {
            str.append("\t");
        }
        str.append(this.toString());
        str.append("\n");
        ++tabLevel;
        for (Command subCommand : this.getSubCommands()) {
            subCommand.printCommandTree(str, tabLevel);
        }
    }

    public Option getOption() {
        return this.option;
    }

    public void setOption(Option option) {
        this.option = option;
    }

    public abstract List<SingleElementSymbol> getProjectedSymbols();

    public abstract boolean areResultsCachable();

    public static List<SingleElementSymbol> getUpdateCommandSymbol() {
        if (updateCommandSymbol == null) {
            ElementSymbol symbol = new ElementSymbol("Count");
            symbol.setType(DataTypeManager.DefaultDataClasses.INTEGER);
            updateCommandSymbol = Arrays.asList(symbol);
        }
        return updateCommandSymbol;
    }

    public ProcessorPlan getProcessorPlan() {
        return this.plan;
    }

    public void setProcessorPlan(ProcessorPlan plan) {
        this.plan = plan;
    }

    public CacheHint getCacheHint() {
        return this.cacheHint;
    }

    public void setCacheHint(CacheHint cacheHint) {
        this.cacheHint = cacheHint;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    protected boolean sameOptionAndHint(Command cmd) {
        return EquivalenceUtil.areEqual((Object)this.cacheHint, (Object)cmd.cacheHint) && EquivalenceUtil.areEqual((Object)this.option, (Object)cmd.option);
    }

    public boolean returnsResultSet() {
        return false;
    }
}

