/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.AbstractCompareCriteria;
import org.teiid.query.sql.lang.PredicateCriteria;
import org.teiid.query.sql.symbol.Expression;

public class CompareCriteria
extends AbstractCompareCriteria
implements PredicateCriteria.Negatable {
    private Expression rightExpression;
    private Boolean isOptional = Boolean.FALSE;

    public CompareCriteria() {
    }

    public CompareCriteria(Expression leftExpression, int operator, Expression rightExpression) {
        this.set(leftExpression, operator, rightExpression);
    }

    public void setRightExpression(Expression expression) {
        this.rightExpression = expression;
    }

    @Override
    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public void set(Expression leftExpression, int operator, Expression rightExpression) {
        this.setLeftExpression(leftExpression);
        this.setOperator(operator);
        this.setRightExpression(rightExpression);
    }

    public void setOptional(Boolean isOptional) {
        this.isOptional = isOptional;
    }

    public boolean isOptional() {
        return this.isOptional == null || this.isOptional != false;
    }

    public Boolean getIsOptional() {
        return this.isOptional;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode((int)hc, (int)this.getOperator());
        hc = HashCodeUtil.hashCode((int)hc, (Object[])new Object[]{this.getLeftExpression()});
        hc = HashCodeUtil.hashCode((int)hc, (Object[])new Object[]{this.getRightExpression()});
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompareCriteria)) {
            return false;
        }
        CompareCriteria cc = (CompareCriteria)obj;
        return this.getOperator() == cc.getOperator() && EquivalenceUtil.areEqual((Object)this.getLeftExpression(), (Object)cc.getLeftExpression()) && EquivalenceUtil.areEqual((Object)this.getRightExpression(), (Object)cc.getRightExpression());
    }

    @Override
    public Object clone() {
        Expression leftCopy = null;
        if (this.getLeftExpression() != null) {
            leftCopy = (Expression)this.getLeftExpression().clone();
        }
        Expression rightCopy = null;
        if (this.getRightExpression() != null) {
            rightCopy = (Expression)this.getRightExpression().clone();
        }
        CompareCriteria result = new CompareCriteria(leftCopy, this.getOperator(), rightCopy);
        result.isOptional = this.isOptional;
        return result;
    }

    @Override
    public void negate() {
        this.setOperator(CompareCriteria.getInverseOperator(this.getOperator()));
    }

    public static int getInverseOperator(int op) {
        switch (op) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 3;
            }
        }
        return -1;
    }
}

