/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import junit.framework.Assert;

public class UnitTestUtil {
    public static final String PATH_SEPARATOR = "/";
    private static final String DEFAULT_TESTDATA_PATH = "src/test/resources";
    private static final String DEFAULT_TEMP_DIR = "target/scratch";

    public static void helpTestEquivalence(int correctCompareToResult, Object obj1, Object obj2) {
        if (obj1 != null) {
            boolean equal;
            if (obj2 != null) {
                UnitTestUtil.helpTestEquals(obj1);
                UnitTestUtil.helpTestEqualsTransitivity(obj1, obj2);
            }
            if (equal = obj1.equals(obj2)) {
                if (correctCompareToResult != 0) {
                    Assert.fail((String)"obj1.equals(obj2) returned true but was expected to return false");
                }
            } else if (correctCompareToResult == 0) {
                Assert.fail((String)"obj1.equals(obj2) returned false but was expected to return true");
            }
            UnitTestUtil.helpTestHashCode(equal, obj1, obj2);
        }
        if (obj2 != null) {
            UnitTestUtil.helpTestEquals(obj2);
        }
        if (obj1 instanceof Comparable || obj2 instanceof Comparable) {
            Comparable comp1 = (Comparable)obj1;
            Comparable comp2 = (Comparable)obj2;
            UnitTestUtil.helpTestCompareTo(correctCompareToResult, comp1, comp2);
            UnitTestUtil.helpTestReflexiveCompareTo(comp1);
            UnitTestUtil.helpTestReflexiveCompareTo(comp2);
        }
    }

    protected static void helpTestCompareTo(int correctCompareToResult, Comparable obj1, Comparable obj2) {
        if (obj1 != null) {
            if (obj2 != null) {
                int result2;
                int result1 = obj1.compareTo(obj2);
                if (result1 != (result2 = obj2.compareTo(obj1))) {
                    if (result1 < 0) {
                        if (correctCompareToResult >= 0) {
                            Assert.fail((String)("obj1.compareTo(obj2) returned <0 (actual=" + result1 + ") and did not match the expected result (" + correctCompareToResult + ")"));
                        }
                        if (result2 <= 0) {
                            Assert.fail((String)("The compareTo call was not commutative: obj1.compareTo(obj2) returned <0 (actual=" + result1 + ") but obj2.compareTo(obj2) did not return >0 (actual=" + result2 + ") "));
                        }
                    } else if (result1 > 0) {
                        if (correctCompareToResult <= 0) {
                            Assert.fail((String)("obj1.compareTo(obj2) returned >0 (actual=" + result1 + ") and did not match the expected result (" + correctCompareToResult + ")"));
                        }
                        if (result2 >= 0) {
                            Assert.fail((String)("The compareTo call was not commutative: obj1.compareTo(obj2) returned >0 (actual=" + result1 + ") but obj2.compareTo(obj2) did not return <0 (actual=" + result2 + ") "));
                        }
                    } else {
                        if (correctCompareToResult != 0) {
                            Assert.fail((String)("obj1.compareTo(obj2) returned 0 but did not match the expected result (" + correctCompareToResult + ") and the second compareTo call didn't match the first"));
                        }
                        Assert.fail((String)("The compareTo call was not commutative: obj1.compareTo(obj2) returned 0 while obj2.compareTo(obj2) returned " + result2));
                    }
                } else if (correctCompareToResult != 0) {
                    Assert.fail((String)("obj1.compareTo(obj2) and obj2.compareTo(obj1) both returned " + result1 + " but did not match the expected result (" + correctCompareToResult + ")"));
                }
            } else {
                int result = 0;
                try {
                    result = obj1.compareTo(obj2);
                    Assert.fail((String)("The second comparable object was null but no IllegalArgumentException was thrown in " + obj1.getClass().getName() + ".compareTo(Object)"));
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                if (correctCompareToResult <= 0) {
                    Assert.fail((String)("obj1.compareTo(null) returned " + result + " but did not match the expected result (" + correctCompareToResult + ")"));
                }
            }
        } else if (obj2 != null) {
            int result = 0;
            try {
                result = obj2.compareTo(obj1);
                Assert.fail((String)("The first comparable object was null but no IllegalArgumentException was thrown in " + obj2.getClass().getName() + ".compareTo(Object)"));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (correctCompareToResult >= 0) {
                Assert.fail((String)("obj2.compareTo(null) returned " + result + " but did not match the expected result (" + correctCompareToResult + ")"));
            }
        } else if (correctCompareToResult != 0) {
            Assert.fail((String)"The expected result was not 0 even though both references were null");
        }
    }

    protected static void helpTestEquals(Object obj) {
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((String)("The equals method of Object " + obj + " (Class " + obj.getClass().getName() + ") does not return false for null parameter"), (!obj.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)("The equals method of Object " + obj + " (Class " + obj.getClass().getName() + ") is not reflexive."), (boolean)obj.equals(obj));
    }

    protected static void helpTestEqualsTransitivity(Object test, Object control) {
        Assert.assertNotNull((Object)test);
        Assert.assertNotNull((Object)control);
        Assert.assertEquals((String)("Equals methods of test Object and control Object are not symmetric: " + test + ", " + control), (boolean)test.equals(control), (boolean)control.equals(test));
    }

    protected static void helpTestHashCode(boolean shouldBeEqual, Object obj1, Object obj2) {
        if (obj1 != null && obj2 != null) {
            int hash1 = obj1.hashCode();
            int hash2 = obj2.hashCode();
            if (shouldBeEqual) {
                Assert.assertTrue((String)("The two objects are supposed to be equal but do not have the same hash code value; obj1.hashCode()=" + hash1 + "; obj2.hashCode()=" + hash2), (hash1 == hash2 ? 1 : 0) != 0);
            }
        }
    }

    protected static void helpTestReflexiveCompareTo(Comparable obj) {
        if (obj != null && obj.compareTo(obj) != 0) {
            Assert.fail((String)"The compareTo method is not reflexive; obj.compareTo(obj) does not equal 0");
        }
    }

    protected UnitTestUtil() {
    }

    public static File getTestDataFile(String fileName) {
        return new File(UnitTestUtil.getTestDataPath(), fileName);
    }

    public static File getTestScratchFile(String fileName) {
        String path = UnitTestUtil.getTestScratchPath();
        File file = new File(path, fileName);
        return file;
    }

    public static final String getTestDataPath() {
        return DEFAULT_TESTDATA_PATH;
    }

    public static final String getTestScratchPath() {
        File scratchDirectory;
        String filePath = DEFAULT_TEMP_DIR;
        File scratch = new File(filePath);
        if (!scratch.exists() && !scratch.mkdirs() && (filePath = System.getProperty("java.io.tmpdir")) == null) {
            filePath = ".";
        }
        if (!(scratchDirectory = new File(filePath)).exists()) {
            scratchDirectory.mkdir();
        }
        return filePath;
    }

    public static final <T extends Serializable> T helpSerialize(T object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        return (T)((Serializable)ois.readObject());
    }
}

